/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs.modelchecker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverity;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.ModelSpecLogger;
import org.eclipse.emf.common.util.URI;

public class ModelDescription {
    protected ModelSpecLogger logger = new ModelSpecLogger();
    protected final List<ModelSpec> specs = new ArrayList<ModelSpec>();
    protected String name;
    private EntrySeverity failSeverity = EntrySeverity.of(EntrySeverityLevel.ERROR);

    public static ModelDescription builder() {
        return new ModelDescription();
    }

    public static ModelDescription builder(ModelSpecLogger logger) {
        return ModelDescription.builder(logger, null);
    }

    public static ModelDescription builder(String name) {
        return ModelDescription.builder(null, name);
    }

    public static ModelDescription builder(ModelSpecLogger logger, String name) {
        ModelDescription modelDesc = new ModelDescription();
        if (logger != null) {
            modelDesc.logger = logger;
        }
        if (name != null) {
            modelDesc.name = name;
        }
        return modelDesc;
    }

    public boolean checkModel(URI uri) {
        UniversalHandler.getInstance().dropCache();
        UniversalHandler.getInstance().readModels(uri, true);
        return this.checkModel(uri.toPlatformString(true), UniversalHandler.getInstance().getCentralModel());
    }

    public boolean checkModel(String resource, Amalthea model) {
        boolean checkOk = true;
        for (ModelSpec spec : this.specs) {
            EntrySeverity severtiy;
            try {
                severtiy = spec.checkSpec(resource, model);
                checkOk &= severtiy.compareTo(this.failSeverity) < 0;
            }
            catch (Exception e) {
                spec.log("Unable to check spec \"" + spec.getName() + "\" because a " + e.toString() + " was encountered.");
                severtiy = EntrySeverity.of(spec.getSeverityLevel());
                checkOk &= severtiy.compareTo(this.failSeverity) < 0;
            }
        }
        return checkOk;
    }

    public boolean checkModel(Amalthea model) {
        return this.checkModel("", model);
    }

    public void logToView() {
        this.logger.logToView();
    }

    public void openMessageBox() {
        this.logger.openMessageBox();
    }

    public ModelDescription addSpec(ModelSpec spec) {
        this.specs.add(spec);
        spec.setLogger(this.logger);
        return this;
    }

    public void logToConsole(ConsoleOutputHandler con) {
        if (this.name == null) {
            con.appendln(" +- Model Checker Error/Warning log.");
        } else {
            con.appendln(" +- Model Checker (" + this.name + ") Error/Warning log.");
        }
        this.logger.logToConsole(con);
        con.appendln(" +- Log Finish");
    }

    public void printLog() {
        if (this.name == null) {
            System.out.println(" +- Model Checker Error/Warning log.");
        } else {
            System.out.println(" +- Model Checker (" + this.name + ") Error/Warning log.");
        }
        this.logger.printLog();
        System.out.println(" +- Log Finish");
    }

    public ModelDescription setFailSeverityLevel(EntrySeverityLevel severity) {
        this.failSeverity = EntrySeverity.of(severity);
        return this;
    }

    public ModelDescription setLogger(ModelSpecLogger logger) {
        this.logger = logger;
        for (ModelSpec spec : this.specs) {
            spec.setLogger(logger);
        }
        return this;
    }

    public ModelDescription concatLog(ModelDescription modelDesc) {
        this.setLogger(modelDesc.logger);
        return this;
    }
}

