/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs.modelchecker.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpecModelType;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecHasModelType
extends ModelSpec {
    private final ModelSpecModelType type;
    private boolean hasModel;
    private String objectName;

    public ModelSpecHasModelType(ModelSpecModelType type) {
        this.type = type;
        this.severity = EntrySeverityLevel.ERROR;
        this.specType = "Has model type";
    }

    private boolean parseElements(Amalthea model) {
        switch (this.type) {
            case HW_MODEL: {
                this.objectName = "Hardware Model";
                this.hasModel = model.getHwModel() != null;
                break;
            }
            case SW_MODEL: {
                this.objectName = "Software Model";
                this.hasModel = model.getSwModel() != null;
                break;
            }
            case CONSTRAINTS_MODEL: {
                this.objectName = "Constraints Model";
                this.hasModel = model.getConstraintsModel() != null;
                break;
            }
            case STIMULI_MODEL: {
                this.objectName = "Stimuli Model";
                this.hasModel = model.getStimuliModel() != null;
                break;
            }
            case COMMON_ELEMENTS: {
                this.objectName = "Common Elements";
                this.hasModel = model.getCommonElements() != null;
                break;
            }
            case MAPPING_MODEL: {
                this.objectName = "Mapping Model";
                this.hasModel = model.getMappingModel() != null;
                break;
            }
            case OS_MODEL: {
                this.objectName = "Common Elements";
                this.hasModel = model.getOsModel() != null;
                break;
            }
            case PROPERTY_CONTRAINTS_MODEL: {
                this.objectName = "Common Elements";
                this.hasModel = model.getPropertyConstraintsModel() != null;
                break;
            }
            default: {
                this.objectName = "(Wrong Model Type)";
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkSpec(Amalthea model) throws Exception {
        this.parseElements(model);
        if (!this.hasModel) {
            this.log("Missing " + this.objectName);
        }
        return this.hasModel;
    }

    public ModelSpecHasModelType setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

