/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.amalthea.converters090.utils.HelperUtils_083_090;
import org.jdom2.Document;
import org.jdom2.Element;

public class HWCacheBuilder
implements ICache {
    private final Map<File, Map<String, Object>> map = new HashMap<File, Map<String, Object>>();
    private final HelperUtils_083_090 helper = HelperUtils_083_090.getInstance();
    private final HWTransformationCache cache = new HWTransformationCache();
    public static final String cache_key = "PeriodicStimulus_Containing_Clock";

    public void buildCache(Map<File, Document> fileName_documentsMap) {
        for (File targetFile : fileName_documentsMap.keySet()) {
            Element oldHWModelElement;
            Document document1 = fileName_documentsMap.get(targetFile);
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            if (rootElement != null && (oldHWModelElement = rootElement.getChild("hwModel")) != null) {
                Object attributeValue;
                Element oldHWSystem = oldHWModelElement.getChild("system");
                if (oldHWSystem != null) {
                    List oldHWQuartzes = oldHWSystem.getChildren("quartzes");
                    for (Element oldHWQuartz : oldHWQuartzes) {
                        attributeValue = oldHWQuartz.getAttributeValue("name");
                        if (attributeValue == null) continue;
                        this.cache.old_hwQuartzs_Map.put((String)attributeValue, oldHWQuartz);
                    }
                    List oldHWECUs = oldHWSystem.getChildren("ecus");
                    for (Element oldHWECU : oldHWECUs) {
                        List oldHWMicroControllers = oldHWECU.getChildren("microcontrollers");
                        for (Element oldHWMicroController : oldHWMicroControllers) {
                            List oldHWCores = oldHWMicroController.getChildren("cores");
                            for (Element oldHWCore : oldHWCores) {
                                String attributeValue2 = oldHWCore.getAttributeValue("name");
                                if (attributeValue2 == null) continue;
                                this.cache.old_cores_Map.put(attributeValue2, oldHWCore);
                            }
                        }
                    }
                }
                List oldHWMemoryTypes = oldHWModelElement.getChildren("memoryTypes");
                for (Element oldHWMemoryType : oldHWMemoryTypes) {
                    attributeValue = oldHWMemoryType.getAttributeValue("name");
                    if (attributeValue == null) continue;
                    this.cache.old_memory_Types_Definition_Map.put((String)attributeValue, oldHWMemoryType);
                }
            }
            HashMap<String, HWTransformationCache> hashMap = new HashMap<String, HWTransformationCache>();
            hashMap.put("globalCache", this.cache);
            this.getCacheMap().put(targetFile, hashMap);
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

