/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractAttributeRefCacheBuilder;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters111.utils.CacheEnum;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class LabelValueProviderRefsCacheBuilder
extends AbstractAttributeRefCacheBuilder {
    public LabelValueProviderRefsCacheBuilder() {
        this.helper = HelperUtils_110_111.getInstance();
    }

    public void buildCache(Map<File, Document> fileName_documentsMap) {
        for (File targetFile : fileName_documentsMap.keySet()) {
            this.getCacheMap().put(targetFile, new HashMap());
            Document rootDocument = fileName_documentsMap.get(targetFile);
            this.populate_All_UUID_Elements(targetFile, rootDocument, ".//swModel/labels|/sw:SWModel/labels", CacheEnum.UUID_ELEMENT.name(), new Namespace[]{this.helper.getNS_110("sw")});
            Map<String, List<Attribute>> uriFragment_elementRefAttribsMap = this.getAllElementRefAttributes_containing_URIFragments(rootDocument);
            ((Map)this.getCacheMap().get(targetFile)).put(CacheEnum.URIFRAGMENT_ELEMENT_REFS_ATRIBUTES.name(), uriFragment_elementRefAttribsMap);
            Map<String, Element> uriFragment_ElementMap = this.getAllElements_referred_by_URIFragments(targetFile, rootDocument);
            ((Map)this.getCacheMap().get(targetFile)).put(CacheEnum.URIFRAGMENT_ELEMENT.name(), uriFragment_ElementMap);
            this.populateAllHREFAttributes_having_legacy_URI_refs(targetFile, rootDocument);
            this.populate_AllElements_referred_by_hrefURIFragments(targetFile, rootDocument, fileName_documentsMap);
        }
    }

    public void updateURIFragments_in_Cache(Map<File, Document> fileName_documentsMap) {
        for (File targetFile : fileName_documentsMap.keySet()) {
            Map cache_file_specific_Map = (Map)this.getCacheMap().get(targetFile);
            BiMap biMap_urifragments_new_old = (BiMap)cache_file_specific_Map.get(CacheEnum.ELEMENT_URI_FRAGMENT_NEW_OLD.name());
            if (biMap_urifragments_new_old == null) {
                biMap_urifragments_new_old = HashBiMap.create();
                cache_file_specific_Map.put(CacheEnum.ELEMENT_URI_FRAGMENT_NEW_OLD.name(), biMap_urifragments_new_old);
            }
            biMap_urifragments_new_old.clear();
            Map urifragment_element_map = (Map)cache_file_specific_Map.get(CacheEnum.URIFRAGMENT_ELEMENT.name());
            for (String old_uriFragment : urifragment_element_map.keySet()) {
                Element element = (Element)urifragment_element_map.get(old_uriFragment);
                String updated_uriFragment = this.helper.getURIFragment(element, ModelVersion._111);
                biMap_urifragments_new_old.put((Object)updated_uriFragment, (Object)old_uriFragment);
            }
            Map hrefurifragment_element_map = (Map)cache_file_specific_Map.get(CacheEnum.HREF_URIFRAGMENT_ELEMENT.name());
            for (String old_href_uriFragment : hrefurifragment_element_map.keySet()) {
                Element element = (Element)hrefurifragment_element_map.get(old_href_uriFragment);
                String updated_uriFragment_part2 = this.helper.getURIFragment(element, ModelVersion._111);
                String[] split = old_href_uriFragment.split("#");
                biMap_urifragments_new_old.put((Object)(String.valueOf(split[0]) + "#" + updated_uriFragment_part2), (Object)old_href_uriFragment);
            }
        }
    }

    private void populate_AllElements_referred_by_hrefURIFragments(File targetFile, Document rootDocument, Map<File, Document> fileName_documentsMap) {
        this.populate_AllElements_referred_by_hrefURIFragments(targetFile, rootDocument, fileName_documentsMap, CacheEnum.HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES.name(), CacheEnum.HREF_URIFRAGMENT_ELEMENT.name());
    }

    private void populateAllHREFAttributes_having_legacy_URI_refs(File targetFile, Document rootDocument) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//entries/valueProvider[(@xsi:type=\"sw:Label\")]/@href[contains(., \"/\")])");
        xpathBuffer.append("|");
        xpathBuffer.append("(.//graphEntries[(@xsi:type=\"sw:LabelSwitch\")]/label/@href[contains(., \"/\")])");
        this.populateAllHREF_ElementAttributes_having_legacy_URI_refs(targetFile, rootDocument, xpathBuffer.toString(), CacheEnum.HREF_URIFRAGMENT_ELEMENT_REFS_ATRIBUTES.name(), new Namespace[]{this.helper.getNS_110("sw"), this.helper.getNS_110("stimuli"), this.helper.getGenericNS("xsi")});
    }

    private Map<String, List<Attribute>> getAllElementRefAttributes_containing_URIFragments(Document rootDocument) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//entries/@valueProvider[contains(., \"/\")])");
        xpathBuffer.append("|");
        xpathBuffer.append("(.//graphEntries[(@xsi:type=\"sw:LabelSwitch\")]/@label[contains(., \"/\")])");
        return this.getAllAttributes_containing_URIFragments(rootDocument, xpathBuffer.toString(), new Namespace[]{this.helper.getNS_110("sw"), this.helper.getNS_110("stimuli"), this.helper.getGenericNS("xsi")});
    }

    private Map<String, Element> getAllElements_referred_by_URIFragments(File targetFile, Document rootDocument) {
        return this.getAllElements_referred_by_URIFragments(targetFile, rootDocument, CacheEnum.URIFRAGMENT_ELEMENT_REFS_ATRIBUTES.name());
    }
}

