/**
 * *******************************************************************************
 *  Copyright (c) 2017 Robert Bosch GmbH and others.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.app4mc.amalthea.model.util.AmaltheaAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AmaltheaItemProviderAdapterFactory extends AmaltheaAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AmaltheaItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Amalthea} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AmaltheaItemProvider amaltheaItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Amalthea}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAmaltheaAdapter() {
		if (amaltheaItemProvider == null) {
			amaltheaItemProvider = new AmaltheaItemProvider(this);
		}

		return amaltheaItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CommonElements} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommonElementsItemProvider commonElementsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CommonElements}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommonElementsAdapter() {
		if (commonElementsItemProvider == null) {
			commonElementsItemProvider = new CommonElementsItemProvider(this);
		}

		return commonElementsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Tag} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TagItemProvider tagItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Tag}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTagAdapter() {
		if (tagItemProvider == null) {
			tagItemProvider = new TagItemProvider(this);
		}

		return tagItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CoreClassifier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoreClassifierItemProvider coreClassifierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CoreClassifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoreClassifierAdapter() {
		if (coreClassifierItemProvider == null) {
			coreClassifierItemProvider = new CoreClassifierItemProvider(this);
		}

		return coreClassifierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MemoryClassifier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryClassifierItemProvider memoryClassifierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MemoryClassifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryClassifierAdapter() {
		if (memoryClassifierItemProvider == null) {
			memoryClassifierItemProvider = new MemoryClassifierItemProvider(this);
		}

		return memoryClassifierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransmissionPolicyItemProvider transmissionPolicyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TransmissionPolicy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransmissionPolicyAdapter() {
		if (transmissionPolicyItemProvider == null) {
			transmissionPolicyItemProvider = new TransmissionPolicyItemProvider(this);
		}

		return transmissionPolicyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InstructionsDeviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstructionsDeviationItemProvider instructionsDeviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InstructionsDeviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstructionsDeviationAdapter() {
		if (instructionsDeviationItemProvider == null) {
			instructionsDeviationItemProvider = new InstructionsDeviationItemProvider(this);
		}

		return instructionsDeviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InstructionsConstant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstructionsConstantItemProvider instructionsConstantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InstructionsConstant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstructionsConstantAdapter() {
		if (instructionsConstantItemProvider == null) {
			instructionsConstantItemProvider = new InstructionsConstantItemProvider(this);
		}

		return instructionsConstantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.NeedDeviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NeedDeviationItemProvider needDeviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.NeedDeviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNeedDeviationAdapter() {
		if (needDeviationItemProvider == null) {
			needDeviationItemProvider = new NeedDeviationItemProvider(this);
		}

		return needDeviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.NeedConstant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NeedConstantItemProvider needConstantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.NeedConstant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNeedConstantAdapter() {
		if (needConstantItemProvider == null) {
			needConstantItemProvider = new NeedConstantItemProvider(this);
		}

		return needConstantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Time} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeItemProvider timeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Time}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeAdapter() {
		if (timeItemProvider == null) {
			timeItemProvider = new TimeItemProvider(this);
		}

		return timeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Frequency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FrequencyItemProvider frequencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Frequency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFrequencyAdapter() {
		if (frequencyItemProvider == null) {
			frequencyItemProvider = new FrequencyItemProvider(this);
		}

		return frequencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Voltage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VoltageItemProvider voltageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Voltage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVoltageAdapter() {
		if (voltageItemProvider == null) {
			voltageItemProvider = new VoltageItemProvider(this);
		}

		return voltageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataSize} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSizeItemProvider dataSizeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataSize}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataSizeAdapter() {
		if (dataSizeItemProvider == null) {
			dataSizeItemProvider = new DataSizeItemProvider(this);
		}

		return dataSizeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataRate} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataRateItemProvider dataRateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataRate}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataRateAdapter() {
		if (dataRateItemProvider == null) {
			dataRateItemProvider = new DataRateItemProvider(this);
		}

		return dataRateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomPropertyItemProvider customPropertyItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomPropertyAdapter() {
		if (customPropertyItemProvider == null) {
			customPropertyItemProvider = new CustomPropertyItemProvider(this);
		}

		return customPropertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ListObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListObjectItemProvider listObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ListObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createListObjectAdapter() {
		if (listObjectItemProvider == null) {
			listObjectItemProvider = new ListObjectItemProvider(this);
		}

		return listObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StringObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringObjectItemProvider stringObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StringObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringObjectAdapter() {
		if (stringObjectItemProvider == null) {
			stringObjectItemProvider = new StringObjectItemProvider(this);
		}

		return stringObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BigIntegerObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BigIntegerObjectItemProvider bigIntegerObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BigIntegerObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBigIntegerObjectAdapter() {
		if (bigIntegerObjectItemProvider == null) {
			bigIntegerObjectItemProvider = new BigIntegerObjectItemProvider(this);
		}

		return bigIntegerObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ReferenceObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceObjectItemProvider referenceObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ReferenceObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceObjectAdapter() {
		if (referenceObjectItemProvider == null) {
			referenceObjectItemProvider = new ReferenceObjectItemProvider(this);
		}

		return referenceObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.IntegerObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerObjectItemProvider integerObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.IntegerObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerObjectAdapter() {
		if (integerObjectItemProvider == null) {
			integerObjectItemProvider = new IntegerObjectItemProvider(this);
		}

		return integerObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LongObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LongObjectItemProvider longObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LongObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLongObjectAdapter() {
		if (longObjectItemProvider == null) {
			longObjectItemProvider = new LongObjectItemProvider(this);
		}

		return longObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FloatObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatObjectItemProvider floatObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FloatObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatObjectAdapter() {
		if (floatObjectItemProvider == null) {
			floatObjectItemProvider = new FloatObjectItemProvider(this);
		}

		return floatObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DoubleObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleObjectItemProvider doubleObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DoubleObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoubleObjectAdapter() {
		if (doubleObjectItemProvider == null) {
			doubleObjectItemProvider = new DoubleObjectItemProvider(this);
		}

		return doubleObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BooleanObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanObjectItemProvider booleanObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BooleanObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanObjectAdapter() {
		if (booleanObjectItemProvider == null) {
			booleanObjectItemProvider = new BooleanObjectItemProvider(this);
		}

		return booleanObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TimeObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeObjectItemProvider timeObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TimeObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeObjectAdapter() {
		if (timeObjectItemProvider == null) {
			timeObjectItemProvider = new TimeObjectItemProvider(this);
		}

		return timeObjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Deviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeviationItemProvider deviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Deviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeviationAdapter() {
		if (deviationItemProvider == null) {
			deviationItemProvider = new DeviationItemProvider(this);
		}

		return deviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.WeibullParameters} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WeibullParametersItemProvider weibullParametersItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.WeibullParameters}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeibullParametersAdapter() {
		if (weibullParametersItemProvider == null) {
			weibullParametersItemProvider = new WeibullParametersItemProvider(this);
		}

		return weibullParametersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.WeibullEstimators} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WeibullEstimatorsItemProvider weibullEstimatorsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.WeibullEstimators}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWeibullEstimatorsAdapter() {
		if (weibullEstimatorsItemProvider == null) {
			weibullEstimatorsItemProvider = new WeibullEstimatorsItemProvider(this);
		}

		return weibullEstimatorsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.UniformDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UniformDistributionItemProvider uniformDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.UniformDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUniformDistributionAdapter() {
		if (uniformDistributionItemProvider == null) {
			uniformDistributionItemProvider = new UniformDistributionItemProvider(this);
		}

		return uniformDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Boundaries} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BoundariesItemProvider boundariesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Boundaries}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBoundariesAdapter() {
		if (boundariesItemProvider == null) {
			boundariesItemProvider = new BoundariesItemProvider(this);
		}

		return boundariesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.GaussDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GaussDistributionItemProvider gaussDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.GaussDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGaussDistributionAdapter() {
		if (gaussDistributionItemProvider == null) {
			gaussDistributionItemProvider = new GaussDistributionItemProvider(this);
		}

		return gaussDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BetaDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BetaDistributionItemProvider betaDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BetaDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBetaDistributionAdapter() {
		if (betaDistributionItemProvider == null) {
			betaDistributionItemProvider = new BetaDistributionItemProvider(this);
		}

		return betaDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MinAvgMaxStatisticItemProvider minAvgMaxStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMinAvgMaxStatisticAdapter() {
		if (minAvgMaxStatisticItemProvider == null) {
			minAvgMaxStatisticItemProvider = new MinAvgMaxStatisticItemProvider(this);
		}

		return minAvgMaxStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SingleValueStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleValueStatisticItemProvider singleValueStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SingleValueStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleValueStatisticAdapter() {
		if (singleValueStatisticItemProvider == null) {
			singleValueStatisticItemProvider = new SingleValueStatisticItemProvider(this);
		}

		return singleValueStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Mode} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeItemProvider modeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Mode}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeAdapter() {
		if (modeItemProvider == null) {
			modeItemProvider = new ModeItemProvider(this);
		}

		return modeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeLiteralItemProvider modeLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeLiteralAdapter() {
		if (modeLiteralItemProvider == null) {
			modeLiteralItemProvider = new ModeLiteralItemProvider(this);
		}

		return modeLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentsModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentsModelItemProvider componentsModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentsModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentsModelAdapter() {
		if (componentsModelItemProvider == null) {
			componentsModelItemProvider = new ComponentsModelItemProvider(this);
		}

		return componentsModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Component} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentItemProvider componentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Component}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentAdapter() {
		if (componentItemProvider == null) {
			componentItemProvider = new ComponentItemProvider(this);
		}

		return componentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Composite} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeItemProvider compositeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Composite}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositeAdapter() {
		if (compositeItemProvider == null) {
			compositeItemProvider = new CompositeItemProvider(this);
		}

		return compositeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.System} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SystemItemProvider systemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.System}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSystemAdapter() {
		if (systemItemProvider == null) {
			systemItemProvider = new SystemItemProvider(this);
		}

		return systemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentInstanceItemProvider componentInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentInstanceAdapter() {
		if (componentInstanceItemProvider == null) {
			componentInstanceItemProvider = new ComponentInstanceItemProvider(this);
		}

		return componentInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Connector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorItemProvider connectorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Connector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectorAdapter() {
		if (connectorItemProvider == null) {
			connectorItemProvider = new ConnectorItemProvider(this);
		}

		return connectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.QualifiedPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QualifiedPortItemProvider qualifiedPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.QualifiedPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQualifiedPortAdapter() {
		if (qualifiedPortItemProvider == null) {
			qualifiedPortItemProvider = new QualifiedPortItemProvider(this);
		}

		return qualifiedPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterfacePort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfacePortItemProvider interfacePortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterfacePort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfacePortAdapter() {
		if (interfacePortItemProvider == null) {
			interfacePortItemProvider = new InterfacePortItemProvider(this);
		}

		return interfacePortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConfigModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigModelItemProvider configModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConfigModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigModelAdapter() {
		if (configModelItemProvider == null) {
			configModelItemProvider = new ConfigModelItemProvider(this);
		}

		return configModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventConfig} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventConfigItemProvider eventConfigItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventConfig}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventConfigAdapter() {
		if (eventConfigItemProvider == null) {
			eventConfigItemProvider = new EventConfigItemProvider(this);
		}

		return eventConfigItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConstraintsModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstraintsModelItemProvider constraintsModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConstraintsModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstraintsModelAdapter() {
		if (constraintsModelItemProvider == null) {
			constraintsModelItemProvider = new ConstraintsModelItemProvider(this);
		}

		return constraintsModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableSequencingConstraintItemProvider runnableSequencingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableSequencingConstraintAdapter() {
		if (runnableSequencingConstraintItemProvider == null) {
			runnableSequencingConstraintItemProvider = new RunnableSequencingConstraintItemProvider(this);
		}

		return runnableSequencingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableSeparationConstraintItemProvider runnableSeparationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableSeparationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableSeparationConstraintAdapter() {
		if (runnableSeparationConstraintItemProvider == null) {
			runnableSeparationConstraintItemProvider = new RunnableSeparationConstraintItemProvider(this);
		}

		return runnableSeparationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessSeparationConstraintItemProvider processSeparationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessSeparationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessSeparationConstraintAdapter() {
		if (processSeparationConstraintItemProvider == null) {
			processSeparationConstraintItemProvider = new ProcessSeparationConstraintItemProvider(this);
		}

		return processSeparationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataSeparationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSeparationConstraintItemProvider dataSeparationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataSeparationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataSeparationConstraintAdapter() {
		if (dataSeparationConstraintItemProvider == null) {
			dataSeparationConstraintItemProvider = new DataSeparationConstraintItemProvider(this);
		}

		return dataSeparationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnablePairingConstraintItemProvider runnablePairingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnablePairingConstraintAdapter() {
		if (runnablePairingConstraintItemProvider == null) {
			runnablePairingConstraintItemProvider = new RunnablePairingConstraintItemProvider(this);
		}

		return runnablePairingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPairingConstraintItemProvider processPairingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessPairingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessPairingConstraintAdapter() {
		if (processPairingConstraintItemProvider == null) {
			processPairingConstraintItemProvider = new ProcessPairingConstraintItemProvider(this);
		}

		return processPairingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataPairingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataPairingConstraintItemProvider dataPairingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataPairingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataPairingConstraintAdapter() {
		if (dataPairingConstraintItemProvider == null) {
			dataPairingConstraintItemProvider = new DataPairingConstraintItemProvider(this);
		}

		return dataPairingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TargetMemory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetMemoryItemProvider targetMemoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TargetMemory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetMemoryAdapter() {
		if (targetMemoryItemProvider == null) {
			targetMemoryItemProvider = new TargetMemoryItemProvider(this);
		}

		return targetMemoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TargetCore} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetCoreItemProvider targetCoreItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TargetCore}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetCoreAdapter() {
		if (targetCoreItemProvider == null) {
			targetCoreItemProvider = new TargetCoreItemProvider(this);
		}

		return targetCoreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TargetScheduler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetSchedulerItemProvider targetSchedulerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TargetScheduler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetSchedulerAdapter() {
		if (targetSchedulerItemProvider == null) {
			targetSchedulerItemProvider = new TargetSchedulerItemProvider(this);
		}

		return targetSchedulerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelEntityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelEntityGroupItemProvider labelEntityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelEntityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelEntityGroupAdapter() {
		if (labelEntityGroupItemProvider == null) {
			labelEntityGroupItemProvider = new LabelEntityGroupItemProvider(this);
		}

		return labelEntityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableEntityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableEntityGroupItemProvider runnableEntityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableEntityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableEntityGroupAdapter() {
		if (runnableEntityGroupItemProvider == null) {
			runnableEntityGroupItemProvider = new RunnableEntityGroupItemProvider(this);
		}

		return runnableEntityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessEntityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessEntityGroupItemProvider processEntityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessEntityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessEntityGroupAdapter() {
		if (processEntityGroupItemProvider == null) {
			processEntityGroupItemProvider = new ProcessEntityGroupItemProvider(this);
		}

		return processEntityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TagGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TagGroupItemProvider tagGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TagGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTagGroupAdapter() {
		if (tagGroupItemProvider == null) {
			tagGroupItemProvider = new TagGroupItemProvider(this);
		}

		return tagGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainItemProvider eventChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainAdapter() {
		if (eventChainItemProvider == null) {
			eventChainItemProvider = new EventChainItemProvider(this);
		}

		return eventChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SubEventChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubEventChainItemProvider subEventChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SubEventChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubEventChainAdapter() {
		if (subEventChainItemProvider == null) {
			subEventChainItemProvider = new SubEventChainItemProvider(this);
		}

		return subEventChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainReferenceItemProvider eventChainReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainReferenceAdapter() {
		if (eventChainReferenceItemProvider == null) {
			eventChainReferenceItemProvider = new EventChainReferenceItemProvider(this);
		}

		return eventChainReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainContainerItemProvider eventChainContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainContainerAdapter() {
		if (eventChainContainerItemProvider == null) {
			eventChainContainerItemProvider = new EventChainContainerItemProvider(this);
		}

		return eventChainContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PhysicalSectionConstraintItemProvider physicalSectionConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPhysicalSectionConstraintAdapter() {
		if (physicalSectionConstraintItemProvider == null) {
			physicalSectionConstraintItemProvider = new PhysicalSectionConstraintItemProvider(this);
		}

		return physicalSectionConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventSynchronizationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventSynchronizationConstraintItemProvider eventSynchronizationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventSynchronizationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventSynchronizationConstraintAdapter() {
		if (eventSynchronizationConstraintItemProvider == null) {
			eventSynchronizationConstraintItemProvider = new EventSynchronizationConstraintItemProvider(this);
		}

		return eventSynchronizationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainSynchronizationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainSynchronizationConstraintItemProvider eventChainSynchronizationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainSynchronizationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainSynchronizationConstraintAdapter() {
		if (eventChainSynchronizationConstraintItemProvider == null) {
			eventChainSynchronizationConstraintItemProvider = new EventChainSynchronizationConstraintItemProvider(this);
		}

		return eventChainSynchronizationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DelayConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DelayConstraintItemProvider delayConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DelayConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDelayConstraintAdapter() {
		if (delayConstraintItemProvider == null) {
			delayConstraintItemProvider = new DelayConstraintItemProvider(this);
		}

		return delayConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainLatencyConstraintItemProvider eventChainLatencyConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainLatencyConstraintAdapter() {
		if (eventChainLatencyConstraintItemProvider == null) {
			eventChainLatencyConstraintItemProvider = new EventChainLatencyConstraintItemProvider(this);
		}

		return eventChainLatencyConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RepetitionConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RepetitionConstraintItemProvider repetitionConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RepetitionConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRepetitionConstraintAdapter() {
		if (repetitionConstraintItemProvider == null) {
			repetitionConstraintItemProvider = new RepetitionConstraintItemProvider(this);
		}

		return repetitionConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataAgeConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataAgeConstraintItemProvider dataAgeConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataAgeConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAgeConstraintAdapter() {
		if (dataAgeConstraintItemProvider == null) {
			dataAgeConstraintItemProvider = new DataAgeConstraintItemProvider(this);
		}

		return dataAgeConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataAgeCycle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataAgeCycleItemProvider dataAgeCycleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataAgeCycle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAgeCycleAdapter() {
		if (dataAgeCycleItemProvider == null) {
			dataAgeCycleItemProvider = new DataAgeCycleItemProvider(this);
		}

		return dataAgeCycleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataAgeTime} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataAgeTimeItemProvider dataAgeTimeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataAgeTime}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataAgeTimeAdapter() {
		if (dataAgeTimeItemProvider == null) {
			dataAgeTimeItemProvider = new DataAgeTimeItemProvider(this);
		}

		return dataAgeTimeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessRequirementItemProvider processRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessRequirementAdapter() {
		if (processRequirementItemProvider == null) {
			processRequirementItemProvider = new ProcessRequirementItemProvider(this);
		}

		return processRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableRequirementItemProvider runnableRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableRequirementAdapter() {
		if (runnableRequirementItemProvider == null) {
			runnableRequirementItemProvider = new RunnableRequirementItemProvider(this);
		}

		return runnableRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ArchitectureRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArchitectureRequirementItemProvider architectureRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ArchitectureRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArchitectureRequirementAdapter() {
		if (architectureRequirementItemProvider == null) {
			architectureRequirementItemProvider = new ArchitectureRequirementItemProvider(this);
		}

		return architectureRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessChainRequirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessChainRequirementItemProvider processChainRequirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessChainRequirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessChainRequirementAdapter() {
		if (processChainRequirementItemProvider == null) {
			processChainRequirementItemProvider = new ProcessChainRequirementItemProvider(this);
		}

		return processChainRequirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CPUPercentageRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CPUPercentageRequirementLimitItemProvider cpuPercentageRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CPUPercentageRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCPUPercentageRequirementLimitAdapter() {
		if (cpuPercentageRequirementLimitItemProvider == null) {
			cpuPercentageRequirementLimitItemProvider = new CPUPercentageRequirementLimitItemProvider(this);
		}

		return cpuPercentageRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FrequencyRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FrequencyRequirementLimitItemProvider frequencyRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FrequencyRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFrequencyRequirementLimitAdapter() {
		if (frequencyRequirementLimitItemProvider == null) {
			frequencyRequirementLimitItemProvider = new FrequencyRequirementLimitItemProvider(this);
		}

		return frequencyRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PercentageRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PercentageRequirementLimitItemProvider percentageRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PercentageRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPercentageRequirementLimitAdapter() {
		if (percentageRequirementLimitItemProvider == null) {
			percentageRequirementLimitItemProvider = new PercentageRequirementLimitItemProvider(this);
		}

		return percentageRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CountRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CountRequirementLimitItemProvider countRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CountRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCountRequirementLimitAdapter() {
		if (countRequirementLimitItemProvider == null) {
			countRequirementLimitItemProvider = new CountRequirementLimitItemProvider(this);
		}

		return countRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TimeRequirementLimit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TimeRequirementLimitItemProvider timeRequirementLimitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TimeRequirementLimit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTimeRequirementLimitAdapter() {
		if (timeRequirementLimitItemProvider == null) {
			timeRequirementLimitItemProvider = new TimeRequirementLimitItemProvider(this);
		}

		return timeRequirementLimitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataCoherencyGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataCoherencyGroupItemProvider dataCoherencyGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataCoherencyGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataCoherencyGroupAdapter() {
		if (dataCoherencyGroupItemProvider == null) {
			dataCoherencyGroupItemProvider = new DataCoherencyGroupItemProvider(this);
		}

		return dataCoherencyGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataStabilityGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataStabilityGroupItemProvider dataStabilityGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataStabilityGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataStabilityGroupAdapter() {
		if (dataStabilityGroupItemProvider == null) {
			dataStabilityGroupItemProvider = new DataStabilityGroupItemProvider(this);
		}

		return dataStabilityGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessScope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessScopeItemProvider processScopeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessScope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessScopeAdapter() {
		if (processScopeItemProvider == null) {
			processScopeItemProvider = new ProcessScopeItemProvider(this);
		}

		return processScopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableScope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableScopeItemProvider runnableScopeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableScope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableScopeAdapter() {
		if (runnableScopeItemProvider == null) {
			runnableScopeItemProvider = new RunnableScopeItemProvider(this);
		}

		return runnableScopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentScope} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentScopeItemProvider componentScopeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentScope}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentScopeAdapter() {
		if (componentScopeItemProvider == null) {
			componentScopeItemProvider = new ComponentScopeItemProvider(this);
		}

		return componentScopeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventModelItemProvider eventModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventModelAdapter() {
		if (eventModelItemProvider == null) {
			eventModelItemProvider = new EventModelItemProvider(this);
		}

		return eventModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventSetItemProvider eventSetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventSetAdapter() {
		if (eventSetItemProvider == null) {
			eventSetItemProvider = new EventSetItemProvider(this);
		}

		return eventSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomEventItemProvider customEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomEventAdapter() {
		if (customEventItemProvider == null) {
			customEventItemProvider = new CustomEventItemProvider(this);
		}

		return customEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StimulusEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StimulusEventItemProvider stimulusEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StimulusEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStimulusEventAdapter() {
		if (stimulusEventItemProvider == null) {
			stimulusEventItemProvider = new StimulusEventItemProvider(this);
		}

		return stimulusEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessEventItemProvider processEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessEventAdapter() {
		if (processEventItemProvider == null) {
			processEventItemProvider = new ProcessEventItemProvider(this);
		}

		return processEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessChainEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessChainEventItemProvider processChainEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessChainEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessChainEventAdapter() {
		if (processChainEventItemProvider == null) {
			processChainEventItemProvider = new ProcessChainEventItemProvider(this);
		}

		return processChainEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableEventItemProvider runnableEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableEventAdapter() {
		if (runnableEventItemProvider == null) {
			runnableEventItemProvider = new RunnableEventItemProvider(this);
		}

		return runnableEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelEventItemProvider labelEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelEventAdapter() {
		if (labelEventItemProvider == null) {
			labelEventItemProvider = new LabelEventItemProvider(this);
		}

		return labelEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChannelEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelEventItemProvider channelEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChannelEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelEventAdapter() {
		if (channelEventItemProvider == null) {
			channelEventItemProvider = new ChannelEventItemProvider(this);
		}

		return channelEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SemaphoreEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SemaphoreEventItemProvider semaphoreEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SemaphoreEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSemaphoreEventAdapter() {
		if (semaphoreEventItemProvider == null) {
			semaphoreEventItemProvider = new SemaphoreEventItemProvider(this);
		}

		return semaphoreEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ComponentEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentEventItemProvider componentEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ComponentEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentEventAdapter() {
		if (componentEventItemProvider == null) {
			componentEventItemProvider = new ComponentEventItemProvider(this);
		}

		return componentEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HWModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HWModelItemProvider hwModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HWModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHWModelAdapter() {
		if (hwModelItemProvider == null) {
			hwModelItemProvider = new HWModelItemProvider(this);
		}

		return hwModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwStructure} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwStructureItemProvider hwStructureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwStructure}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwStructureAdapter() {
		if (hwStructureItemProvider == null) {
			hwStructureItemProvider = new HwStructureItemProvider(this);
		}

		return hwStructureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FrequencyDomain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FrequencyDomainItemProvider frequencyDomainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FrequencyDomain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFrequencyDomainAdapter() {
		if (frequencyDomainItemProvider == null) {
			frequencyDomainItemProvider = new FrequencyDomainItemProvider(this);
		}

		return frequencyDomainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PowerDomain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PowerDomainItemProvider powerDomainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PowerDomain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPowerDomainAdapter() {
		if (powerDomainItemProvider == null) {
			powerDomainItemProvider = new PowerDomainItemProvider(this);
		}

		return powerDomainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessingUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessingUnitItemProvider processingUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessingUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessingUnitAdapter() {
		if (processingUnitItemProvider == null) {
			processingUnitItemProvider = new ProcessingUnitItemProvider(this);
		}

		return processingUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Memory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryItemProvider memoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Memory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryAdapter() {
		if (memoryItemProvider == null) {
			memoryItemProvider = new MemoryItemProvider(this);
		}

		return memoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Cache} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CacheItemProvider cacheItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Cache}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCacheAdapter() {
		if (cacheItemProvider == null) {
			cacheItemProvider = new CacheItemProvider(this);
		}

		return cacheItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwFeatureCategory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwFeatureCategoryItemProvider hwFeatureCategoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwFeatureCategory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwFeatureCategoryAdapter() {
		if (hwFeatureCategoryItemProvider == null) {
			hwFeatureCategoryItemProvider = new HwFeatureCategoryItemProvider(this);
		}

		return hwFeatureCategoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwFeature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwFeatureItemProvider hwFeatureItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwFeature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwFeatureAdapter() {
		if (hwFeatureItemProvider == null) {
			hwFeatureItemProvider = new HwFeatureItemProvider(this);
		}

		return hwFeatureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwPortItemProvider hwPortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwPortAdapter() {
		if (hwPortItemProvider == null) {
			hwPortItemProvider = new HwPortItemProvider(this);
		}

		return hwPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConnectionHandler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectionHandlerItemProvider connectionHandlerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConnectionHandler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectionHandlerAdapter() {
		if (connectionHandlerItemProvider == null) {
			connectionHandlerItemProvider = new ConnectionHandlerItemProvider(this);
		}

		return connectionHandlerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwConnection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwConnectionItemProvider hwConnectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwConnection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwConnectionAdapter() {
		if (hwConnectionItemProvider == null) {
			hwConnectionItemProvider = new HwConnectionItemProvider(this);
		}

		return hwConnectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwAccessElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwAccessElementItemProvider hwAccessElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwAccessElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwAccessElementAdapter() {
		if (hwAccessElementItemProvider == null) {
			hwAccessElementItemProvider = new HwAccessElementItemProvider(this);
		}

		return hwAccessElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LatencyConstant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LatencyConstantItemProvider latencyConstantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LatencyConstant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLatencyConstantAdapter() {
		if (latencyConstantItemProvider == null) {
			latencyConstantItemProvider = new LatencyConstantItemProvider(this);
		}

		return latencyConstantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LatencyDeviation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LatencyDeviationItemProvider latencyDeviationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LatencyDeviation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLatencyDeviationAdapter() {
		if (latencyDeviationItemProvider == null) {
			latencyDeviationItemProvider = new LatencyDeviationItemProvider(this);
		}

		return latencyDeviationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessingUnitDefinitionItemProvider processingUnitDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessingUnitDefinitionAdapter() {
		if (processingUnitDefinitionItemProvider == null) {
			processingUnitDefinitionItemProvider = new ProcessingUnitDefinitionItemProvider(this);
		}

		return processingUnitDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConnectionHandlerDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectionHandlerDefinitionItemProvider connectionHandlerDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConnectionHandlerDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectionHandlerDefinitionAdapter() {
		if (connectionHandlerDefinitionItemProvider == null) {
			connectionHandlerDefinitionItemProvider = new ConnectionHandlerDefinitionItemProvider(this);
		}

		return connectionHandlerDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MemoryDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryDefinitionItemProvider memoryDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MemoryDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryDefinitionAdapter() {
		if (memoryDefinitionItemProvider == null) {
			memoryDefinitionItemProvider = new MemoryDefinitionItemProvider(this);
		}

		return memoryDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CacheDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CacheDefinitionItemProvider cacheDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CacheDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCacheDefinitionAdapter() {
		if (cacheDefinitionItemProvider == null) {
			cacheDefinitionItemProvider = new CacheDefinitionItemProvider(this);
		}

		return cacheDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.HwAccessPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwAccessPathItemProvider hwAccessPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.HwAccessPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHwAccessPathAdapter() {
		if (hwAccessPathItemProvider == null) {
			hwAccessPathItemProvider = new HwAccessPathItemProvider(this);
		}

		return hwAccessPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MappingModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MappingModelItemProvider mappingModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MappingModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMappingModelAdapter() {
		if (mappingModelItemProvider == null) {
			mappingModelItemProvider = new MappingModelItemProvider(this);
		}

		return mappingModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulerAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulerAllocationItemProvider schedulerAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulerAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulerAllocationAdapter() {
		if (schedulerAllocationItemProvider == null) {
			schedulerAllocationItemProvider = new SchedulerAllocationItemProvider(this);
		}

		return schedulerAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskAllocationItemProvider taskAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskAllocationAdapter() {
		if (taskAllocationItemProvider == null) {
			taskAllocationItemProvider = new TaskAllocationItemProvider(this);
		}

		return taskAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ISRAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISRAllocationItemProvider isrAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ISRAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISRAllocationAdapter() {
		if (isrAllocationItemProvider == null) {
			isrAllocationItemProvider = new ISRAllocationItemProvider(this);
		}

		return isrAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableAllocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableAllocationItemProvider runnableAllocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableAllocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableAllocationAdapter() {
		if (runnableAllocationItemProvider == null) {
			runnableAllocationItemProvider = new RunnableAllocationItemProvider(this);
		}

		return runnableAllocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MemoryMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryMappingItemProvider memoryMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MemoryMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryMappingAdapter() {
		if (memoryMappingItemProvider == null) {
			memoryMappingItemProvider = new MemoryMappingItemProvider(this);
		}

		return memoryMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PhysicalSectionMappingItemProvider physicalSectionMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PhysicalSectionMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPhysicalSectionMappingAdapter() {
		if (physicalSectionMappingItemProvider == null) {
			physicalSectionMappingItemProvider = new PhysicalSectionMappingItemProvider(this);
		}

		return physicalSectionMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OSModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OSModelItemProvider osModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OSModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOSModelAdapter() {
		if (osModelItemProvider == null) {
			osModelItemProvider = new OSModelItemProvider(this);
		}

		return osModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsDataConsistency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsDataConsistencyItemProvider osDataConsistencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsDataConsistency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsDataConsistencyAdapter() {
		if (osDataConsistencyItemProvider == null) {
			osDataConsistencyItemProvider = new OsDataConsistencyItemProvider(this);
		}

		return osDataConsistencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataStability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataStabilityItemProvider dataStabilityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataStability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataStabilityAdapter() {
		if (dataStabilityItemProvider == null) {
			dataStabilityItemProvider = new DataStabilityItemProvider(this);
		}

		return dataStabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.NonAtomicDataCoherency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NonAtomicDataCoherencyItemProvider nonAtomicDataCoherencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.NonAtomicDataCoherency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNonAtomicDataCoherencyAdapter() {
		if (nonAtomicDataCoherencyItemProvider == null) {
			nonAtomicDataCoherencyItemProvider = new NonAtomicDataCoherencyItemProvider(this);
		}

		return nonAtomicDataCoherencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Semaphore} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SemaphoreItemProvider semaphoreItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Semaphore}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSemaphoreAdapter() {
		if (semaphoreItemProvider == null) {
			semaphoreItemProvider = new SemaphoreItemProvider(this);
		}

		return semaphoreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskScheduler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskSchedulerItemProvider taskSchedulerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskScheduler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskSchedulerAdapter() {
		if (taskSchedulerItemProvider == null) {
			taskSchedulerItemProvider = new TaskSchedulerItemProvider(this);
		}

		return taskSchedulerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulerAssociation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulerAssociationItemProvider schedulerAssociationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulerAssociation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulerAssociationAdapter() {
		if (schedulerAssociationItemProvider == null) {
			schedulerAssociationItemProvider = new SchedulerAssociationItemProvider(this);
		}

		return schedulerAssociationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterruptController} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterruptControllerItemProvider interruptControllerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterruptController}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterruptControllerAdapter() {
		if (interruptControllerItemProvider == null) {
			interruptControllerItemProvider = new InterruptControllerItemProvider(this);
		}

		return interruptControllerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulingParameters} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulingParametersItemProvider schedulingParametersItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulingParameters}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulingParametersAdapter() {
		if (schedulingParametersItemProvider == null) {
			schedulingParametersItemProvider = new SchedulingParametersItemProvider(this);
		}

		return schedulingParametersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterExtensionItemProvider parameterExtensionItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterExtensionAdapter() {
		if (parameterExtensionItemProvider == null) {
			parameterExtensionItemProvider = new ParameterExtensionItemProvider(this);
		}

		return parameterExtensionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FixedPriorityPreemptive} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FixedPriorityPreemptiveItemProvider fixedPriorityPreemptiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FixedPriorityPreemptive}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFixedPriorityPreemptiveAdapter() {
		if (fixedPriorityPreemptiveItemProvider == null) {
			fixedPriorityPreemptiveItemProvider = new FixedPriorityPreemptiveItemProvider(this);
		}

		return fixedPriorityPreemptiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.FixedPriorityPreemptiveWithBudgetEnforcement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FixedPriorityPreemptiveWithBudgetEnforcementItemProvider fixedPriorityPreemptiveWithBudgetEnforcementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.FixedPriorityPreemptiveWithBudgetEnforcement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFixedPriorityPreemptiveWithBudgetEnforcementAdapter() {
		if (fixedPriorityPreemptiveWithBudgetEnforcementItemProvider == null) {
			fixedPriorityPreemptiveWithBudgetEnforcementItemProvider = new FixedPriorityPreemptiveWithBudgetEnforcementItemProvider(this);
		}

		return fixedPriorityPreemptiveWithBudgetEnforcementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OSEK} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OSEKItemProvider osekItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OSEK}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOSEKAdapter() {
		if (osekItemProvider == null) {
			osekItemProvider = new OSEKItemProvider(this);
		}

		return osekItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DeadlineMonotonic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeadlineMonotonicItemProvider deadlineMonotonicItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DeadlineMonotonic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeadlineMonotonicAdapter() {
		if (deadlineMonotonicItemProvider == null) {
			deadlineMonotonicItemProvider = new DeadlineMonotonicItemProvider(this);
		}

		return deadlineMonotonicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RateMonotonic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RateMonotonicItemProvider rateMonotonicItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RateMonotonic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRateMonotonicAdapter() {
		if (rateMonotonicItemProvider == null) {
			rateMonotonicItemProvider = new RateMonotonicItemProvider(this);
		}

		return rateMonotonicItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PfairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PfairPD2ItemProvider pfairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PfairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPfairPD2Adapter() {
		if (pfairPD2ItemProvider == null) {
			pfairPD2ItemProvider = new PfairPD2ItemProvider(this);
		}

		return pfairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PartlyPFairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartlyPFairPD2ItemProvider partlyPFairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PartlyPFairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartlyPFairPD2Adapter() {
		if (partlyPFairPD2ItemProvider == null) {
			partlyPFairPD2ItemProvider = new PartlyPFairPD2ItemProvider(this);
		}

		return partlyPFairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EarlyReleaseFairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EarlyReleaseFairPD2ItemProvider earlyReleaseFairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EarlyReleaseFairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEarlyReleaseFairPD2Adapter() {
		if (earlyReleaseFairPD2ItemProvider == null) {
			earlyReleaseFairPD2ItemProvider = new EarlyReleaseFairPD2ItemProvider(this);
		}

		return earlyReleaseFairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PartlyEarlyReleaseFairPD2} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PartlyEarlyReleaseFairPD2ItemProvider partlyEarlyReleaseFairPD2ItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PartlyEarlyReleaseFairPD2}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPartlyEarlyReleaseFairPD2Adapter() {
		if (partlyEarlyReleaseFairPD2ItemProvider == null) {
			partlyEarlyReleaseFairPD2ItemProvider = new PartlyEarlyReleaseFairPD2ItemProvider(this);
		}

		return partlyEarlyReleaseFairPD2ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LeastLocalRemainingExecutionTimeFirst} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LeastLocalRemainingExecutionTimeFirstItemProvider leastLocalRemainingExecutionTimeFirstItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LeastLocalRemainingExecutionTimeFirst}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLeastLocalRemainingExecutionTimeFirstAdapter() {
		if (leastLocalRemainingExecutionTimeFirstItemProvider == null) {
			leastLocalRemainingExecutionTimeFirstItemProvider = new LeastLocalRemainingExecutionTimeFirstItemProvider(this);
		}

		return leastLocalRemainingExecutionTimeFirstItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EarliestDeadlineFirstItemProvider earliestDeadlineFirstItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEarliestDeadlineFirstAdapter() {
		if (earliestDeadlineFirstItemProvider == null) {
			earliestDeadlineFirstItemProvider = new EarliestDeadlineFirstItemProvider(this);
		}

		return earliestDeadlineFirstItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PriorityBasedRoundRobin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PriorityBasedRoundRobinItemProvider priorityBasedRoundRobinItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PriorityBasedRoundRobin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPriorityBasedRoundRobinAdapter() {
		if (priorityBasedRoundRobinItemProvider == null) {
			priorityBasedRoundRobinItemProvider = new PriorityBasedRoundRobinItemProvider(this);
		}

		return priorityBasedRoundRobinItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DeferrableServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeferrableServerItemProvider deferrableServerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DeferrableServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeferrableServerAdapter() {
		if (deferrableServerItemProvider == null) {
			deferrableServerItemProvider = new DeferrableServerItemProvider(this);
		}

		return deferrableServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PollingPeriodicServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PollingPeriodicServerItemProvider pollingPeriodicServerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PollingPeriodicServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPollingPeriodicServerAdapter() {
		if (pollingPeriodicServerItemProvider == null) {
			pollingPeriodicServerItemProvider = new PollingPeriodicServerItemProvider(this);
		}

		return pollingPeriodicServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SporadicServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SporadicServerItemProvider sporadicServerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SporadicServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSporadicServerAdapter() {
		if (sporadicServerItemProvider == null) {
			sporadicServerItemProvider = new SporadicServerItemProvider(this);
		}

		return sporadicServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConstantBandwidthServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantBandwidthServerItemProvider constantBandwidthServerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConstantBandwidthServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantBandwidthServerAdapter() {
		if (constantBandwidthServerItemProvider == null) {
			constantBandwidthServerItemProvider = new ConstantBandwidthServerItemProvider(this);
		}

		return constantBandwidthServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ConstantBandwidthServerWithCASH} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstantBandwidthServerWithCASHItemProvider constantBandwidthServerWithCASHItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ConstantBandwidthServerWithCASH}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstantBandwidthServerWithCASHAdapter() {
		if (constantBandwidthServerWithCASHItemProvider == null) {
			constantBandwidthServerWithCASHItemProvider = new ConstantBandwidthServerWithCASHItemProvider(this);
		}

		return constantBandwidthServerWithCASHItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Grouping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GroupingItemProvider groupingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Grouping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGroupingAdapter() {
		if (groupingItemProvider == null) {
			groupingItemProvider = new GroupingItemProvider(this);
		}

		return groupingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.UserSpecificSchedulingAlgorithm} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UserSpecificSchedulingAlgorithmItemProvider userSpecificSchedulingAlgorithmItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.UserSpecificSchedulingAlgorithm}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUserSpecificSchedulingAlgorithmAdapter() {
		if (userSpecificSchedulingAlgorithmItemProvider == null) {
			userSpecificSchedulingAlgorithmItemProvider = new UserSpecificSchedulingAlgorithmItemProvider(this);
		}

		return userSpecificSchedulingAlgorithmItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PriorityBased} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PriorityBasedItemProvider priorityBasedItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PriorityBased}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPriorityBasedAdapter() {
		if (priorityBasedItemProvider == null) {
			priorityBasedItemProvider = new PriorityBasedItemProvider(this);
		}

		return priorityBasedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OperatingSystem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperatingSystemItemProvider operatingSystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OperatingSystem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperatingSystemAdapter() {
		if (operatingSystemItemProvider == null) {
			operatingSystemItemProvider = new OperatingSystemItemProvider(this);
		}

		return operatingSystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.VendorOperatingSystem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VendorOperatingSystemItemProvider vendorOperatingSystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.VendorOperatingSystem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVendorOperatingSystemAdapter() {
		if (vendorOperatingSystemItemProvider == null) {
			vendorOperatingSystemItemProvider = new VendorOperatingSystemItemProvider(this);
		}

		return vendorOperatingSystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsInstructionsItemProvider osInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsInstructionsAdapter() {
		if (osInstructionsItemProvider == null) {
			osInstructionsItemProvider = new OsInstructionsItemProvider(this);
		}

		return osInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsAPIInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsAPIInstructionsItemProvider osAPIInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsAPIInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsAPIInstructionsAdapter() {
		if (osAPIInstructionsItemProvider == null) {
			osAPIInstructionsItemProvider = new OsAPIInstructionsItemProvider(this);
		}

		return osAPIInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsISRInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsISRInstructionsItemProvider osISRInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsISRInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsISRInstructionsAdapter() {
		if (osISRInstructionsItemProvider == null) {
			osISRInstructionsItemProvider = new OsISRInstructionsItemProvider(this);
		}

		return osISRInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyConstraintsModelItemProvider propertyConstraintsModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyConstraintsModelAdapter() {
		if (propertyConstraintsModelItemProvider == null) {
			propertyConstraintsModelItemProvider = new PropertyConstraintsModelItemProvider(this);
		}

		return propertyConstraintsModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessAllocationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessAllocationConstraintItemProvider processAllocationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessAllocationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessAllocationConstraintAdapter() {
		if (processAllocationConstraintItemProvider == null) {
			processAllocationConstraintItemProvider = new ProcessAllocationConstraintItemProvider(this);
		}

		return processAllocationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessPrototypeAllocationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPrototypeAllocationConstraintItemProvider processPrototypeAllocationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessPrototypeAllocationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessPrototypeAllocationConstraintAdapter() {
		if (processPrototypeAllocationConstraintItemProvider == null) {
			processPrototypeAllocationConstraintItemProvider = new ProcessPrototypeAllocationConstraintItemProvider(this);
		}

		return processPrototypeAllocationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableAllocationConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableAllocationConstraintItemProvider runnableAllocationConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableAllocationConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableAllocationConstraintAdapter() {
		if (runnableAllocationConstraintItemProvider == null) {
			runnableAllocationConstraintItemProvider = new RunnableAllocationConstraintItemProvider(this);
		}

		return runnableAllocationConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AbstractElementMappingConstraint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractElementMappingConstraintItemProvider abstractElementMappingConstraintItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AbstractElementMappingConstraint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstractElementMappingConstraintAdapter() {
		if (abstractElementMappingConstraintItemProvider == null) {
			abstractElementMappingConstraintItemProvider = new AbstractElementMappingConstraintItemProvider(this);
		}

		return abstractElementMappingConstraintItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CoreClassification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CoreClassificationItemProvider coreClassificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CoreClassification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCoreClassificationAdapter() {
		if (coreClassificationItemProvider == null) {
			coreClassificationItemProvider = new CoreClassificationItemProvider(this);
		}

		return coreClassificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MemoryClassification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryClassificationItemProvider memoryClassificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MemoryClassification}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryClassificationAdapter() {
		if (memoryClassificationItemProvider == null) {
			memoryClassificationItemProvider = new MemoryClassificationItemProvider(this);
		}

		return memoryClassificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StimuliModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StimuliModelItemProvider stimuliModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StimuliModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStimuliModelAdapter() {
		if (stimuliModelItemProvider == null) {
			stimuliModelItemProvider = new StimuliModelItemProvider(this);
		}

		return stimuliModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeValueList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueListItemProvider modeValueListItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeValueList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueListAdapter() {
		if (modeValueListItemProvider == null) {
			modeValueListItemProvider = new ModeValueListItemProvider(this);
		}

		return modeValueListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueMapEntryItemProvider modeValueMapEntryItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueMapEntryAdapter() {
		if (modeValueMapEntryItemProvider == null) {
			modeValueMapEntryItemProvider = new ModeValueMapEntryItemProvider(this);
		}

		return modeValueMapEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeValueDisjunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueDisjunctionItemProvider modeValueDisjunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeValueDisjunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueDisjunctionAdapter() {
		if (modeValueDisjunctionItemProvider == null) {
			modeValueDisjunctionItemProvider = new ModeValueDisjunctionItemProvider(this);
		}

		return modeValueDisjunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueItemProvider modeValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueAdapter() {
		if (modeValueItemProvider == null) {
			modeValueItemProvider = new ModeValueItemProvider(this);
		}

		return modeValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeValueConjunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeValueConjunctionItemProvider modeValueConjunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeValueConjunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeValueConjunctionAdapter() {
		if (modeValueConjunctionItemProvider == null) {
			modeValueConjunctionItemProvider = new ModeValueConjunctionItemProvider(this);
		}

		return modeValueConjunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PeriodicStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicStimulusItemProvider periodicStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PeriodicStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicStimulusAdapter() {
		if (periodicStimulusItemProvider == null) {
			periodicStimulusItemProvider = new PeriodicStimulusItemProvider(this);
		}

		return periodicStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelativePeriodicStimulusItemProvider relativePeriodicStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelativePeriodicStimulusAdapter() {
		if (relativePeriodicStimulusItemProvider == null) {
			relativePeriodicStimulusItemProvider = new RelativePeriodicStimulusItemProvider(this);
		}

		return relativePeriodicStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.VariableRateStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableRateStimulusItemProvider variableRateStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.VariableRateStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableRateStimulusAdapter() {
		if (variableRateStimulusItemProvider == null) {
			variableRateStimulusItemProvider = new VariableRateStimulusItemProvider(this);
		}

		return variableRateStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Scenario} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScenarioItemProvider scenarioItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Scenario}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createScenarioAdapter() {
		if (scenarioItemProvider == null) {
			scenarioItemProvider = new ScenarioItemProvider(this);
		}

		return scenarioItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicSyntheticStimulusItemProvider periodicSyntheticStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicSyntheticStimulusAdapter() {
		if (periodicSyntheticStimulusItemProvider == null) {
			periodicSyntheticStimulusItemProvider = new PeriodicSyntheticStimulusItemProvider(this);
		}

		return periodicSyntheticStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomStimulusItemProvider customStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomStimulusAdapter() {
		if (customStimulusItemProvider == null) {
			customStimulusItemProvider = new CustomStimulusItemProvider(this);
		}

		return customStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SingleStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleStimulusItemProvider singleStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SingleStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleStimulusAdapter() {
		if (singleStimulusItemProvider == null) {
			singleStimulusItemProvider = new SingleStimulusItemProvider(this);
		}

		return singleStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterProcessStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterProcessStimulusItemProvider interProcessStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterProcessStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterProcessStimulusAdapter() {
		if (interProcessStimulusItemProvider == null) {
			interProcessStimulusItemProvider = new InterProcessStimulusItemProvider(this);
		}

		return interProcessStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PeriodicBurstStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicBurstStimulusItemProvider periodicBurstStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PeriodicBurstStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicBurstStimulusAdapter() {
		if (periodicBurstStimulusItemProvider == null) {
			periodicBurstStimulusItemProvider = new PeriodicBurstStimulusItemProvider(this);
		}

		return periodicBurstStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventStimulusItemProvider eventStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventStimulusAdapter() {
		if (eventStimulusItemProvider == null) {
			eventStimulusItemProvider = new EventStimulusItemProvider(this);
		}

		return eventStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ArrivalCurveStimulus} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrivalCurveStimulusItemProvider arrivalCurveStimulusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ArrivalCurveStimulus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrivalCurveStimulusAdapter() {
		if (arrivalCurveStimulusItemProvider == null) {
			arrivalCurveStimulusItemProvider = new ArrivalCurveStimulusItemProvider(this);
		}

		return arrivalCurveStimulusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrivalCurveEntryItemProvider arrivalCurveEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrivalCurveEntryAdapter() {
		if (arrivalCurveEntryItemProvider == null) {
			arrivalCurveEntryItemProvider = new ArrivalCurveEntryItemProvider(this);
		}

		return arrivalCurveEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockTriangleFunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockTriangleFunctionItemProvider clockTriangleFunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockTriangleFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockTriangleFunctionAdapter() {
		if (clockTriangleFunctionItemProvider == null) {
			clockTriangleFunctionItemProvider = new ClockTriangleFunctionItemProvider(this);
		}

		return clockTriangleFunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockSinusFunction} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockSinusFunctionItemProvider clockSinusFunctionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockSinusFunction}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockSinusFunctionAdapter() {
		if (clockSinusFunctionItemProvider == null) {
			clockSinusFunctionItemProvider = new ClockSinusFunctionItemProvider(this);
		}

		return clockSinusFunctionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockMultiplierListItemProvider clockMultiplierListItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockMultiplierListAdapter() {
		if (clockMultiplierListItemProvider == null) {
			clockMultiplierListItemProvider = new ClockMultiplierListItemProvider(this);
		}

		return clockMultiplierListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClockMultiplierListEntryItemProvider clockMultiplierListEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClockMultiplierListEntryAdapter() {
		if (clockMultiplierListEntryItemProvider == null) {
			clockMultiplierListEntryItemProvider = new ClockMultiplierListEntryItemProvider(this);
		}

		return clockMultiplierListEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SWModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SWModelItemProvider swModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SWModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSWModelAdapter() {
		if (swModelItemProvider == null) {
			swModelItemProvider = new SWModelItemProvider(this);
		}

		return swModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomEntity} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomEntityItemProvider customEntityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomEntity}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomEntityAdapter() {
		if (customEntityItemProvider == null) {
			customEntityItemProvider = new CustomEntityItemProvider(this);
		}

		return customEntityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessChain} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessChainItemProvider processChainItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessChain}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessChainAdapter() {
		if (processChainItemProvider == null) {
			processChainItemProvider = new ProcessChainItemProvider(this);
		}

		return processChainItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CallGraph} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallGraphItemProvider callGraphItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CallGraph}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallGraphAdapter() {
		if (callGraphItemProvider == null) {
			callGraphItemProvider = new CallGraphItemProvider(this);
		}

		return callGraphItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CallSequence} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallSequenceItemProvider callSequenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CallSequence}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCallSequenceAdapter() {
		if (callSequenceItemProvider == null) {
			callSequenceItemProvider = new CallSequenceItemProvider(this);
		}

		return callSequenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeSwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeSwitchItemProvider modeSwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeSwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeSwitchAdapter() {
		if (modeSwitchItemProvider == null) {
			modeSwitchItemProvider = new ModeSwitchItemProvider(this);
		}

		return modeSwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeSwitchEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeSwitchEntryItemProvider modeSwitchEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeSwitchEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeSwitchEntryAdapter() {
		if (modeSwitchEntryItemProvider == null) {
			modeSwitchEntryItemProvider = new ModeSwitchEntryItemProvider(this);
		}

		return modeSwitchEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeSwitchDefault} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeSwitchDefaultItemProvider modeSwitchDefaultItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeSwitchDefault}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeSwitchDefaultAdapter() {
		if (modeSwitchDefaultItemProvider == null) {
			modeSwitchDefaultItemProvider = new ModeSwitchDefaultItemProvider(this);
		}

		return modeSwitchDefaultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProbabilitySwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbabilitySwitchItemProvider probabilitySwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProbabilitySwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProbabilitySwitchAdapter() {
		if (probabilitySwitchItemProvider == null) {
			probabilitySwitchItemProvider = new ProbabilitySwitchItemProvider(this);
		}

		return probabilitySwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbabilitySwitchEntryItemProvider probabilitySwitchEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProbabilitySwitchEntryAdapter() {
		if (probabilitySwitchEntryItemProvider == null) {
			probabilitySwitchEntryItemProvider = new ProbabilitySwitchEntryItemProvider(this);
		}

		return probabilitySwitchEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Counter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CounterItemProvider counterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Counter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCounterAdapter() {
		if (counterItemProvider == null) {
			counterItemProvider = new CounterItemProvider(this);
		}

		return counterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.WaitEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WaitEventItemProvider waitEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.WaitEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWaitEventAdapter() {
		if (waitEventItemProvider == null) {
			waitEventItemProvider = new WaitEventItemProvider(this);
		}

		return waitEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SetEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetEventItemProvider setEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SetEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetEventAdapter() {
		if (setEventItemProvider == null) {
			setEventItemProvider = new SetEventItemProvider(this);
		}

		return setEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ClearEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClearEventItemProvider clearEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ClearEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClearEventAdapter() {
		if (clearEventItemProvider == null) {
			clearEventItemProvider = new ClearEventItemProvider(this);
		}

		return clearEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventMask} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventMaskItemProvider eventMaskItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventMask}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventMaskAdapter() {
		if (eventMaskItemProvider == null) {
			eventMaskItemProvider = new EventMaskItemProvider(this);
		}

		return eventMaskItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OsEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OsEventItemProvider osEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OsEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOsEventAdapter() {
		if (osEventItemProvider == null) {
			osEventItemProvider = new OsEventItemProvider(this);
		}

		return osEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InterProcessTrigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterProcessTriggerItemProvider interProcessTriggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InterProcessTrigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterProcessTriggerAdapter() {
		if (interProcessTriggerItemProvider == null) {
			interProcessTriggerItemProvider = new InterProcessTriggerItemProvider(this);
		}

		return interProcessTriggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EnforcedMigration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnforcedMigrationItemProvider enforcedMigrationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EnforcedMigration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnforcedMigrationAdapter() {
		if (enforcedMigrationItemProvider == null) {
			enforcedMigrationItemProvider = new EnforcedMigrationItemProvider(this);
		}

		return enforcedMigrationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskRunnableCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskRunnableCallItemProvider taskRunnableCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskRunnableCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskRunnableCallAdapter() {
		if (taskRunnableCallItemProvider == null) {
			taskRunnableCallItemProvider = new TaskRunnableCallItemProvider(this);
		}

		return taskRunnableCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SchedulePoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchedulePointItemProvider schedulePointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SchedulePoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchedulePointAdapter() {
		if (schedulePointItemProvider == null) {
			schedulePointItemProvider = new SchedulePointItemProvider(this);
		}

		return schedulePointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TerminateProcess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TerminateProcessItemProvider terminateProcessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TerminateProcess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTerminateProcessAdapter() {
		if (terminateProcessItemProvider == null) {
			terminateProcessItemProvider = new TerminateProcessItemProvider(this);
		}

		return terminateProcessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Task} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskItemProvider taskItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Task}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskAdapter() {
		if (taskItemProvider == null) {
			taskItemProvider = new TaskItemProvider(this);
		}

		return taskItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ISR} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ISRItemProvider isrItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ISR}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createISRAdapter() {
		if (isrItemProvider == null) {
			isrItemProvider = new ISRItemProvider(this);
		}

		return isrItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ProcessPrototype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessPrototypeItemProvider processPrototypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ProcessPrototype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessPrototypeAdapter() {
		if (processPrototypeItemProvider == null) {
			processPrototypeItemProvider = new ProcessPrototypeItemProvider(this);
		}

		return processPrototypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChainedProcessPrototype} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChainedProcessPrototypeItemProvider chainedProcessPrototypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChainedProcessPrototype}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChainedProcessPrototypeAdapter() {
		if (chainedProcessPrototypeItemProvider == null) {
			chainedProcessPrototypeItemProvider = new ChainedProcessPrototypeItemProvider(this);
		}

		return chainedProcessPrototypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccessPrecedenceSpecItemProvider accessPrecedenceSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAccessPrecedenceSpecAdapter() {
		if (accessPrecedenceSpecItemProvider == null) {
			accessPrecedenceSpecItemProvider = new AccessPrecedenceSpecItemProvider(this);
		}

		return accessPrecedenceSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderPrecedenceSpecItemProvider orderPrecedenceSpecItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrderPrecedenceSpecAdapter() {
		if (orderPrecedenceSpecItemProvider == null) {
			orderPrecedenceSpecItemProvider = new OrderPrecedenceSpecItemProvider(this);
		}

		return orderPrecedenceSpecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Runnable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableItemProvider runnableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Runnable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableAdapter() {
		if (runnableItemProvider == null) {
			runnableItemProvider = new RunnableItemProvider(this);
		}

		return runnableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Label} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelItemProvider labelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Label}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAdapter() {
		if (labelItemProvider == null) {
			labelItemProvider = new LabelItemProvider(this);
		}

		return labelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Channel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelItemProvider channelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Channel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelAdapter() {
		if (channelItemProvider == null) {
			channelItemProvider = new ChannelItemProvider(this);
		}

		return channelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeLabel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeLabelItemProvider modeLabelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeLabel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeLabelAdapter() {
		if (modeLabelItemProvider == null) {
			modeLabelItemProvider = new ModeLabelItemProvider(this);
		}

		return modeLabelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Section} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SectionItemProvider sectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Section}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSectionAdapter() {
		if (sectionItemProvider == null) {
			sectionItemProvider = new SectionItemProvider(this);
		}

		return sectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ExecutionNeed} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionNeedItemProvider executionNeedItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ExecutionNeed}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionNeedAdapter() {
		if (executionNeedItemProvider == null) {
			executionNeedItemProvider = new ExecutionNeedItemProvider(this);
		}

		return executionNeedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionNeedExtendedItemProvider executionNeedExtendedItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionNeedExtendedAdapter() {
		if (executionNeedExtendedItemProvider == null) {
			executionNeedExtendedItemProvider = new ExecutionNeedExtendedItemProvider(this);
		}

		return executionNeedExtendedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NeedEntryItemProvider needEntryItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNeedEntryAdapter() {
		if (needEntryItemProvider == null) {
			needEntryItemProvider = new NeedEntryItemProvider(this);
		}

		return needEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ModeLabelAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModeLabelAccessItemProvider modeLabelAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ModeLabelAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModeLabelAccessAdapter() {
		if (modeLabelAccessItemProvider == null) {
			modeLabelAccessItemProvider = new ModeLabelAccessItemProvider(this);
		}

		return modeLabelAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableModeSwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableModeSwitchItemProvider runnableModeSwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableModeSwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableModeSwitchAdapter() {
		if (runnableModeSwitchItemProvider == null) {
			runnableModeSwitchItemProvider = new RunnableModeSwitchItemProvider(this);
		}

		return runnableModeSwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelAccessItemProvider labelAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAccessAdapter() {
		if (labelAccessItemProvider == null) {
			labelAccessItemProvider = new LabelAccessItemProvider(this);
		}

		return labelAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChannelSend} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelSendItemProvider channelSendItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChannelSend}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelSendAdapter() {
		if (channelSendItemProvider == null) {
			channelSendItemProvider = new ChannelSendItemProvider(this);
		}

		return channelSendItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.ChannelReceive} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChannelReceiveItemProvider channelReceiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.ChannelReceive}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChannelReceiveAdapter() {
		if (channelReceiveItemProvider == null) {
			channelReceiveItemProvider = new ChannelReceiveItemProvider(this);
		}

		return channelReceiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SemaphoreAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SemaphoreAccessItemProvider semaphoreAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SemaphoreAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSemaphoreAccessAdapter() {
		if (semaphoreAccessItemProvider == null) {
			semaphoreAccessItemProvider = new SemaphoreAccessItemProvider(this);
		}

		return semaphoreAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SenderReceiverRead} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SenderReceiverReadItemProvider senderReceiverReadItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SenderReceiverRead}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSenderReceiverReadAdapter() {
		if (senderReceiverReadItemProvider == null) {
			senderReceiverReadItemProvider = new SenderReceiverReadItemProvider(this);
		}

		return senderReceiverReadItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SenderReceiverWrite} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SenderReceiverWriteItemProvider senderReceiverWriteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SenderReceiverWrite}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSenderReceiverWriteAdapter() {
		if (senderReceiverWriteItemProvider == null) {
			senderReceiverWriteItemProvider = new SenderReceiverWriteItemProvider(this);
		}

		return senderReceiverWriteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SynchronousServerCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynchronousServerCallItemProvider synchronousServerCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SynchronousServerCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynchronousServerCallAdapter() {
		if (synchronousServerCallItemProvider == null) {
			synchronousServerCallItemProvider = new SynchronousServerCallItemProvider(this);
		}

		return synchronousServerCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.AsynchronousServerCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AsynchronousServerCallItemProvider asynchronousServerCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.AsynchronousServerCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAsynchronousServerCallAdapter() {
		if (asynchronousServerCallItemProvider == null) {
			asynchronousServerCallItemProvider = new AsynchronousServerCallItemProvider(this);
		}

		return asynchronousServerCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.GetResultServerCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GetResultServerCallItemProvider getResultServerCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.GetResultServerCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGetResultServerCallAdapter() {
		if (getResultServerCallItemProvider == null) {
			getResultServerCallItemProvider = new GetResultServerCallItemProvider(this);
		}

		return getResultServerCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableProbabilitySwitchItemProvider runnableProbabilitySwitchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableProbabilitySwitchAdapter() {
		if (runnableProbabilitySwitchItemProvider == null) {
			runnableProbabilitySwitchItemProvider = new RunnableProbabilitySwitchItemProvider(this);
		}

		return runnableProbabilitySwitchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Group} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GroupItemProvider groupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Group}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGroupAdapter() {
		if (groupItemProvider == null) {
			groupItemProvider = new GroupItemProvider(this);
		}

		return groupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableCallItemProvider runnableCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableCallAdapter() {
		if (runnableCallItemProvider == null) {
			runnableCallItemProvider = new RunnableCallItemProvider(this);
		}

		return runnableCallItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomEventTrigger} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomEventTriggerItemProvider customEventTriggerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomEventTrigger}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomEventTriggerAdapter() {
		if (customEventTriggerItemProvider == null) {
			customEventTriggerItemProvider = new CustomEventTriggerItemProvider(this);
		}

		return customEventTriggerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Struct} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructItemProvider structItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Struct}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructAdapter() {
		if (structItemProvider == null) {
			structItemProvider = new StructItemProvider(this);
		}

		return structItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.StructEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StructEntryItemProvider structEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.StructEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStructEntryAdapter() {
		if (structEntryItemProvider == null) {
			structEntryItemProvider = new StructEntryItemProvider(this);
		}

		return structEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Array} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayItemProvider arrayItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Array}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayAdapter() {
		if (arrayItemProvider == null) {
			arrayItemProvider = new ArrayItemProvider(this);
		}

		return arrayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.Pointer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PointerItemProvider pointerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.Pointer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPointerAdapter() {
		if (pointerItemProvider == null) {
			pointerItemProvider = new PointerItemProvider(this);
		}

		return pointerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TypeRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeRefItemProvider typeRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TypeRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeRefAdapter() {
		if (typeRefItemProvider == null) {
			typeRefItemProvider = new TypeRefItemProvider(this);
		}

		return typeRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataPlatformMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataPlatformMappingItemProvider dataPlatformMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataPlatformMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataPlatformMappingAdapter() {
		if (dataPlatformMappingItemProvider == null) {
			dataPlatformMappingItemProvider = new DataPlatformMappingItemProvider(this);
		}

		return dataPlatformMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.DataTypeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataTypeDefinitionItemProvider dataTypeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.DataTypeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataTypeDefinitionAdapter() {
		if (dataTypeDefinitionItemProvider == null) {
			dataTypeDefinitionItemProvider = new DataTypeDefinitionItemProvider(this);
		}

		return dataTypeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.BaseTypeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BaseTypeDefinitionItemProvider baseTypeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.BaseTypeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBaseTypeDefinitionAdapter() {
		if (baseTypeDefinitionItemProvider == null) {
			baseTypeDefinitionItemProvider = new BaseTypeDefinitionItemProvider(this);
		}

		return baseTypeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.PeriodicActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PeriodicActivationItemProvider periodicActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.PeriodicActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPeriodicActivationAdapter() {
		if (periodicActivationItemProvider == null) {
			periodicActivationItemProvider = new PeriodicActivationItemProvider(this);
		}

		return periodicActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.VariableRateActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableRateActivationItemProvider variableRateActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.VariableRateActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableRateActivationAdapter() {
		if (variableRateActivationItemProvider == null) {
			variableRateActivationItemProvider = new VariableRateActivationItemProvider(this);
		}

		return variableRateActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SporadicActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SporadicActivationItemProvider sporadicActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SporadicActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSporadicActivationAdapter() {
		if (sporadicActivationItemProvider == null) {
			sporadicActivationItemProvider = new SporadicActivationItemProvider(this);
		}

		return sporadicActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.SingleActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleActivationItemProvider singleActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.SingleActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleActivationAdapter() {
		if (singleActivationItemProvider == null) {
			singleActivationItemProvider = new SingleActivationItemProvider(this);
		}

		return singleActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventActivationItemProvider eventActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventActivationAdapter() {
		if (eventActivationItemProvider == null) {
			eventActivationItemProvider = new EventActivationItemProvider(this);
		}

		return eventActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.CustomActivation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomActivationItemProvider customActivationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.CustomActivation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomActivationAdapter() {
		if (customActivationItemProvider == null) {
			customActivationItemProvider = new CustomActivationItemProvider(this);
		}

		return customActivationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.LabelAccessStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelAccessStatisticItemProvider labelAccessStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.LabelAccessStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelAccessStatisticAdapter() {
		if (labelAccessStatisticItemProvider == null) {
			labelAccessStatisticItemProvider = new LabelAccessStatisticItemProvider(this);
		}

		return labelAccessStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.InstructionFetch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstructionFetchItemProvider instructionFetchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.InstructionFetch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstructionFetchAdapter() {
		if (instructionFetchItemProvider == null) {
			instructionFetchItemProvider = new InstructionFetchItemProvider(this);
		}

		return instructionFetchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunEntityCallStatistic} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunEntityCallStatisticItemProvider runEntityCallStatisticItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunEntityCallStatistic}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunEntityCallStatisticAdapter() {
		if (runEntityCallStatisticItemProvider == null) {
			runEntityCallStatisticItemProvider = new RunEntityCallStatisticItemProvider(this);
		}

		return runEntityCallStatisticItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.MeasurementModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MeasurementModelItemProvider measurementModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.MeasurementModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMeasurementModelAdapter() {
		if (measurementModelItemProvider == null) {
			measurementModelItemProvider = new MeasurementModelItemProvider(this);
		}

		return measurementModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.EventChainMeasurement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventChainMeasurementItemProvider eventChainMeasurementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.EventChainMeasurement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventChainMeasurementAdapter() {
		if (eventChainMeasurementItemProvider == null) {
			eventChainMeasurementItemProvider = new EventChainMeasurementItemProvider(this);
		}

		return eventChainMeasurementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.TaskMeasurement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TaskMeasurementItemProvider taskMeasurementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.TaskMeasurement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTaskMeasurementAdapter() {
		if (taskMeasurementItemProvider == null) {
			taskMeasurementItemProvider = new TaskMeasurementItemProvider(this);
		}

		return taskMeasurementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.amalthea.model.RunnableMeasurement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RunnableMeasurementItemProvider runnableMeasurementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.amalthea.model.RunnableMeasurement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRunnableMeasurementAdapter() {
		if (runnableMeasurementItemProvider == null) {
			runnableMeasurementItemProvider = new RunnableMeasurementItemProvider(this);
		}

		return runnableMeasurementItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (amaltheaItemProvider != null) amaltheaItemProvider.dispose();
		if (commonElementsItemProvider != null) commonElementsItemProvider.dispose();
		if (tagItemProvider != null) tagItemProvider.dispose();
		if (coreClassifierItemProvider != null) coreClassifierItemProvider.dispose();
		if (memoryClassifierItemProvider != null) memoryClassifierItemProvider.dispose();
		if (transmissionPolicyItemProvider != null) transmissionPolicyItemProvider.dispose();
		if (instructionsDeviationItemProvider != null) instructionsDeviationItemProvider.dispose();
		if (instructionsConstantItemProvider != null) instructionsConstantItemProvider.dispose();
		if (needDeviationItemProvider != null) needDeviationItemProvider.dispose();
		if (needConstantItemProvider != null) needConstantItemProvider.dispose();
		if (timeItemProvider != null) timeItemProvider.dispose();
		if (frequencyItemProvider != null) frequencyItemProvider.dispose();
		if (voltageItemProvider != null) voltageItemProvider.dispose();
		if (dataSizeItemProvider != null) dataSizeItemProvider.dispose();
		if (dataRateItemProvider != null) dataRateItemProvider.dispose();
		if (customPropertyItemProvider != null) customPropertyItemProvider.dispose();
		if (listObjectItemProvider != null) listObjectItemProvider.dispose();
		if (stringObjectItemProvider != null) stringObjectItemProvider.dispose();
		if (bigIntegerObjectItemProvider != null) bigIntegerObjectItemProvider.dispose();
		if (referenceObjectItemProvider != null) referenceObjectItemProvider.dispose();
		if (integerObjectItemProvider != null) integerObjectItemProvider.dispose();
		if (longObjectItemProvider != null) longObjectItemProvider.dispose();
		if (floatObjectItemProvider != null) floatObjectItemProvider.dispose();
		if (doubleObjectItemProvider != null) doubleObjectItemProvider.dispose();
		if (booleanObjectItemProvider != null) booleanObjectItemProvider.dispose();
		if (timeObjectItemProvider != null) timeObjectItemProvider.dispose();
		if (deviationItemProvider != null) deviationItemProvider.dispose();
		if (weibullParametersItemProvider != null) weibullParametersItemProvider.dispose();
		if (weibullEstimatorsItemProvider != null) weibullEstimatorsItemProvider.dispose();
		if (uniformDistributionItemProvider != null) uniformDistributionItemProvider.dispose();
		if (boundariesItemProvider != null) boundariesItemProvider.dispose();
		if (gaussDistributionItemProvider != null) gaussDistributionItemProvider.dispose();
		if (betaDistributionItemProvider != null) betaDistributionItemProvider.dispose();
		if (minAvgMaxStatisticItemProvider != null) minAvgMaxStatisticItemProvider.dispose();
		if (singleValueStatisticItemProvider != null) singleValueStatisticItemProvider.dispose();
		if (modeItemProvider != null) modeItemProvider.dispose();
		if (modeLiteralItemProvider != null) modeLiteralItemProvider.dispose();
		if (componentsModelItemProvider != null) componentsModelItemProvider.dispose();
		if (componentItemProvider != null) componentItemProvider.dispose();
		if (compositeItemProvider != null) compositeItemProvider.dispose();
		if (systemItemProvider != null) systemItemProvider.dispose();
		if (componentInstanceItemProvider != null) componentInstanceItemProvider.dispose();
		if (connectorItemProvider != null) connectorItemProvider.dispose();
		if (qualifiedPortItemProvider != null) qualifiedPortItemProvider.dispose();
		if (interfacePortItemProvider != null) interfacePortItemProvider.dispose();
		if (configModelItemProvider != null) configModelItemProvider.dispose();
		if (eventConfigItemProvider != null) eventConfigItemProvider.dispose();
		if (constraintsModelItemProvider != null) constraintsModelItemProvider.dispose();
		if (runnableSequencingConstraintItemProvider != null) runnableSequencingConstraintItemProvider.dispose();
		if (runnableSeparationConstraintItemProvider != null) runnableSeparationConstraintItemProvider.dispose();
		if (processSeparationConstraintItemProvider != null) processSeparationConstraintItemProvider.dispose();
		if (dataSeparationConstraintItemProvider != null) dataSeparationConstraintItemProvider.dispose();
		if (runnablePairingConstraintItemProvider != null) runnablePairingConstraintItemProvider.dispose();
		if (processPairingConstraintItemProvider != null) processPairingConstraintItemProvider.dispose();
		if (dataPairingConstraintItemProvider != null) dataPairingConstraintItemProvider.dispose();
		if (targetMemoryItemProvider != null) targetMemoryItemProvider.dispose();
		if (targetCoreItemProvider != null) targetCoreItemProvider.dispose();
		if (targetSchedulerItemProvider != null) targetSchedulerItemProvider.dispose();
		if (labelEntityGroupItemProvider != null) labelEntityGroupItemProvider.dispose();
		if (runnableEntityGroupItemProvider != null) runnableEntityGroupItemProvider.dispose();
		if (processEntityGroupItemProvider != null) processEntityGroupItemProvider.dispose();
		if (tagGroupItemProvider != null) tagGroupItemProvider.dispose();
		if (eventChainItemProvider != null) eventChainItemProvider.dispose();
		if (subEventChainItemProvider != null) subEventChainItemProvider.dispose();
		if (eventChainReferenceItemProvider != null) eventChainReferenceItemProvider.dispose();
		if (eventChainContainerItemProvider != null) eventChainContainerItemProvider.dispose();
		if (physicalSectionConstraintItemProvider != null) physicalSectionConstraintItemProvider.dispose();
		if (eventSynchronizationConstraintItemProvider != null) eventSynchronizationConstraintItemProvider.dispose();
		if (eventChainSynchronizationConstraintItemProvider != null) eventChainSynchronizationConstraintItemProvider.dispose();
		if (delayConstraintItemProvider != null) delayConstraintItemProvider.dispose();
		if (eventChainLatencyConstraintItemProvider != null) eventChainLatencyConstraintItemProvider.dispose();
		if (repetitionConstraintItemProvider != null) repetitionConstraintItemProvider.dispose();
		if (dataAgeConstraintItemProvider != null) dataAgeConstraintItemProvider.dispose();
		if (dataAgeCycleItemProvider != null) dataAgeCycleItemProvider.dispose();
		if (dataAgeTimeItemProvider != null) dataAgeTimeItemProvider.dispose();
		if (processRequirementItemProvider != null) processRequirementItemProvider.dispose();
		if (runnableRequirementItemProvider != null) runnableRequirementItemProvider.dispose();
		if (architectureRequirementItemProvider != null) architectureRequirementItemProvider.dispose();
		if (processChainRequirementItemProvider != null) processChainRequirementItemProvider.dispose();
		if (cpuPercentageRequirementLimitItemProvider != null) cpuPercentageRequirementLimitItemProvider.dispose();
		if (frequencyRequirementLimitItemProvider != null) frequencyRequirementLimitItemProvider.dispose();
		if (percentageRequirementLimitItemProvider != null) percentageRequirementLimitItemProvider.dispose();
		if (countRequirementLimitItemProvider != null) countRequirementLimitItemProvider.dispose();
		if (timeRequirementLimitItemProvider != null) timeRequirementLimitItemProvider.dispose();
		if (dataCoherencyGroupItemProvider != null) dataCoherencyGroupItemProvider.dispose();
		if (dataStabilityGroupItemProvider != null) dataStabilityGroupItemProvider.dispose();
		if (processScopeItemProvider != null) processScopeItemProvider.dispose();
		if (runnableScopeItemProvider != null) runnableScopeItemProvider.dispose();
		if (componentScopeItemProvider != null) componentScopeItemProvider.dispose();
		if (eventModelItemProvider != null) eventModelItemProvider.dispose();
		if (eventSetItemProvider != null) eventSetItemProvider.dispose();
		if (customEventItemProvider != null) customEventItemProvider.dispose();
		if (stimulusEventItemProvider != null) stimulusEventItemProvider.dispose();
		if (processEventItemProvider != null) processEventItemProvider.dispose();
		if (processChainEventItemProvider != null) processChainEventItemProvider.dispose();
		if (runnableEventItemProvider != null) runnableEventItemProvider.dispose();
		if (labelEventItemProvider != null) labelEventItemProvider.dispose();
		if (channelEventItemProvider != null) channelEventItemProvider.dispose();
		if (semaphoreEventItemProvider != null) semaphoreEventItemProvider.dispose();
		if (componentEventItemProvider != null) componentEventItemProvider.dispose();
		if (hwModelItemProvider != null) hwModelItemProvider.dispose();
		if (hwStructureItemProvider != null) hwStructureItemProvider.dispose();
		if (frequencyDomainItemProvider != null) frequencyDomainItemProvider.dispose();
		if (powerDomainItemProvider != null) powerDomainItemProvider.dispose();
		if (processingUnitItemProvider != null) processingUnitItemProvider.dispose();
		if (memoryItemProvider != null) memoryItemProvider.dispose();
		if (cacheItemProvider != null) cacheItemProvider.dispose();
		if (hwFeatureCategoryItemProvider != null) hwFeatureCategoryItemProvider.dispose();
		if (hwFeatureItemProvider != null) hwFeatureItemProvider.dispose();
		if (hwPortItemProvider != null) hwPortItemProvider.dispose();
		if (connectionHandlerItemProvider != null) connectionHandlerItemProvider.dispose();
		if (hwConnectionItemProvider != null) hwConnectionItemProvider.dispose();
		if (hwAccessElementItemProvider != null) hwAccessElementItemProvider.dispose();
		if (latencyConstantItemProvider != null) latencyConstantItemProvider.dispose();
		if (latencyDeviationItemProvider != null) latencyDeviationItemProvider.dispose();
		if (processingUnitDefinitionItemProvider != null) processingUnitDefinitionItemProvider.dispose();
		if (connectionHandlerDefinitionItemProvider != null) connectionHandlerDefinitionItemProvider.dispose();
		if (memoryDefinitionItemProvider != null) memoryDefinitionItemProvider.dispose();
		if (cacheDefinitionItemProvider != null) cacheDefinitionItemProvider.dispose();
		if (hwAccessPathItemProvider != null) hwAccessPathItemProvider.dispose();
		if (mappingModelItemProvider != null) mappingModelItemProvider.dispose();
		if (schedulerAllocationItemProvider != null) schedulerAllocationItemProvider.dispose();
		if (taskAllocationItemProvider != null) taskAllocationItemProvider.dispose();
		if (isrAllocationItemProvider != null) isrAllocationItemProvider.dispose();
		if (runnableAllocationItemProvider != null) runnableAllocationItemProvider.dispose();
		if (memoryMappingItemProvider != null) memoryMappingItemProvider.dispose();
		if (physicalSectionMappingItemProvider != null) physicalSectionMappingItemProvider.dispose();
		if (osModelItemProvider != null) osModelItemProvider.dispose();
		if (osDataConsistencyItemProvider != null) osDataConsistencyItemProvider.dispose();
		if (dataStabilityItemProvider != null) dataStabilityItemProvider.dispose();
		if (nonAtomicDataCoherencyItemProvider != null) nonAtomicDataCoherencyItemProvider.dispose();
		if (semaphoreItemProvider != null) semaphoreItemProvider.dispose();
		if (taskSchedulerItemProvider != null) taskSchedulerItemProvider.dispose();
		if (schedulerAssociationItemProvider != null) schedulerAssociationItemProvider.dispose();
		if (interruptControllerItemProvider != null) interruptControllerItemProvider.dispose();
		if (schedulingParametersItemProvider != null) schedulingParametersItemProvider.dispose();
		if (parameterExtensionItemProvider != null) parameterExtensionItemProvider.dispose();
		if (fixedPriorityPreemptiveItemProvider != null) fixedPriorityPreemptiveItemProvider.dispose();
		if (fixedPriorityPreemptiveWithBudgetEnforcementItemProvider != null) fixedPriorityPreemptiveWithBudgetEnforcementItemProvider.dispose();
		if (osekItemProvider != null) osekItemProvider.dispose();
		if (deadlineMonotonicItemProvider != null) deadlineMonotonicItemProvider.dispose();
		if (rateMonotonicItemProvider != null) rateMonotonicItemProvider.dispose();
		if (pfairPD2ItemProvider != null) pfairPD2ItemProvider.dispose();
		if (partlyPFairPD2ItemProvider != null) partlyPFairPD2ItemProvider.dispose();
		if (earlyReleaseFairPD2ItemProvider != null) earlyReleaseFairPD2ItemProvider.dispose();
		if (partlyEarlyReleaseFairPD2ItemProvider != null) partlyEarlyReleaseFairPD2ItemProvider.dispose();
		if (leastLocalRemainingExecutionTimeFirstItemProvider != null) leastLocalRemainingExecutionTimeFirstItemProvider.dispose();
		if (earliestDeadlineFirstItemProvider != null) earliestDeadlineFirstItemProvider.dispose();
		if (priorityBasedRoundRobinItemProvider != null) priorityBasedRoundRobinItemProvider.dispose();
		if (deferrableServerItemProvider != null) deferrableServerItemProvider.dispose();
		if (pollingPeriodicServerItemProvider != null) pollingPeriodicServerItemProvider.dispose();
		if (sporadicServerItemProvider != null) sporadicServerItemProvider.dispose();
		if (constantBandwidthServerItemProvider != null) constantBandwidthServerItemProvider.dispose();
		if (constantBandwidthServerWithCASHItemProvider != null) constantBandwidthServerWithCASHItemProvider.dispose();
		if (groupingItemProvider != null) groupingItemProvider.dispose();
		if (userSpecificSchedulingAlgorithmItemProvider != null) userSpecificSchedulingAlgorithmItemProvider.dispose();
		if (priorityBasedItemProvider != null) priorityBasedItemProvider.dispose();
		if (operatingSystemItemProvider != null) operatingSystemItemProvider.dispose();
		if (vendorOperatingSystemItemProvider != null) vendorOperatingSystemItemProvider.dispose();
		if (osInstructionsItemProvider != null) osInstructionsItemProvider.dispose();
		if (osAPIInstructionsItemProvider != null) osAPIInstructionsItemProvider.dispose();
		if (osISRInstructionsItemProvider != null) osISRInstructionsItemProvider.dispose();
		if (propertyConstraintsModelItemProvider != null) propertyConstraintsModelItemProvider.dispose();
		if (processAllocationConstraintItemProvider != null) processAllocationConstraintItemProvider.dispose();
		if (processPrototypeAllocationConstraintItemProvider != null) processPrototypeAllocationConstraintItemProvider.dispose();
		if (runnableAllocationConstraintItemProvider != null) runnableAllocationConstraintItemProvider.dispose();
		if (abstractElementMappingConstraintItemProvider != null) abstractElementMappingConstraintItemProvider.dispose();
		if (coreClassificationItemProvider != null) coreClassificationItemProvider.dispose();
		if (memoryClassificationItemProvider != null) memoryClassificationItemProvider.dispose();
		if (stimuliModelItemProvider != null) stimuliModelItemProvider.dispose();
		if (modeValueListItemProvider != null) modeValueListItemProvider.dispose();
		if (modeValueMapEntryItemProvider != null) modeValueMapEntryItemProvider.dispose();
		if (modeValueDisjunctionItemProvider != null) modeValueDisjunctionItemProvider.dispose();
		if (modeValueItemProvider != null) modeValueItemProvider.dispose();
		if (modeValueConjunctionItemProvider != null) modeValueConjunctionItemProvider.dispose();
		if (periodicStimulusItemProvider != null) periodicStimulusItemProvider.dispose();
		if (relativePeriodicStimulusItemProvider != null) relativePeriodicStimulusItemProvider.dispose();
		if (variableRateStimulusItemProvider != null) variableRateStimulusItemProvider.dispose();
		if (scenarioItemProvider != null) scenarioItemProvider.dispose();
		if (periodicSyntheticStimulusItemProvider != null) periodicSyntheticStimulusItemProvider.dispose();
		if (customStimulusItemProvider != null) customStimulusItemProvider.dispose();
		if (singleStimulusItemProvider != null) singleStimulusItemProvider.dispose();
		if (interProcessStimulusItemProvider != null) interProcessStimulusItemProvider.dispose();
		if (periodicBurstStimulusItemProvider != null) periodicBurstStimulusItemProvider.dispose();
		if (eventStimulusItemProvider != null) eventStimulusItemProvider.dispose();
		if (arrivalCurveStimulusItemProvider != null) arrivalCurveStimulusItemProvider.dispose();
		if (arrivalCurveEntryItemProvider != null) arrivalCurveEntryItemProvider.dispose();
		if (clockTriangleFunctionItemProvider != null) clockTriangleFunctionItemProvider.dispose();
		if (clockSinusFunctionItemProvider != null) clockSinusFunctionItemProvider.dispose();
		if (clockMultiplierListItemProvider != null) clockMultiplierListItemProvider.dispose();
		if (clockMultiplierListEntryItemProvider != null) clockMultiplierListEntryItemProvider.dispose();
		if (swModelItemProvider != null) swModelItemProvider.dispose();
		if (customEntityItemProvider != null) customEntityItemProvider.dispose();
		if (processChainItemProvider != null) processChainItemProvider.dispose();
		if (callGraphItemProvider != null) callGraphItemProvider.dispose();
		if (callSequenceItemProvider != null) callSequenceItemProvider.dispose();
		if (modeSwitchItemProvider != null) modeSwitchItemProvider.dispose();
		if (modeSwitchEntryItemProvider != null) modeSwitchEntryItemProvider.dispose();
		if (modeSwitchDefaultItemProvider != null) modeSwitchDefaultItemProvider.dispose();
		if (probabilitySwitchItemProvider != null) probabilitySwitchItemProvider.dispose();
		if (probabilitySwitchEntryItemProvider != null) probabilitySwitchEntryItemProvider.dispose();
		if (counterItemProvider != null) counterItemProvider.dispose();
		if (waitEventItemProvider != null) waitEventItemProvider.dispose();
		if (setEventItemProvider != null) setEventItemProvider.dispose();
		if (clearEventItemProvider != null) clearEventItemProvider.dispose();
		if (eventMaskItemProvider != null) eventMaskItemProvider.dispose();
		if (osEventItemProvider != null) osEventItemProvider.dispose();
		if (interProcessTriggerItemProvider != null) interProcessTriggerItemProvider.dispose();
		if (enforcedMigrationItemProvider != null) enforcedMigrationItemProvider.dispose();
		if (taskRunnableCallItemProvider != null) taskRunnableCallItemProvider.dispose();
		if (schedulePointItemProvider != null) schedulePointItemProvider.dispose();
		if (terminateProcessItemProvider != null) terminateProcessItemProvider.dispose();
		if (taskItemProvider != null) taskItemProvider.dispose();
		if (isrItemProvider != null) isrItemProvider.dispose();
		if (processPrototypeItemProvider != null) processPrototypeItemProvider.dispose();
		if (chainedProcessPrototypeItemProvider != null) chainedProcessPrototypeItemProvider.dispose();
		if (accessPrecedenceSpecItemProvider != null) accessPrecedenceSpecItemProvider.dispose();
		if (orderPrecedenceSpecItemProvider != null) orderPrecedenceSpecItemProvider.dispose();
		if (runnableItemProvider != null) runnableItemProvider.dispose();
		if (labelItemProvider != null) labelItemProvider.dispose();
		if (channelItemProvider != null) channelItemProvider.dispose();
		if (modeLabelItemProvider != null) modeLabelItemProvider.dispose();
		if (sectionItemProvider != null) sectionItemProvider.dispose();
		if (executionNeedItemProvider != null) executionNeedItemProvider.dispose();
		if (executionNeedExtendedItemProvider != null) executionNeedExtendedItemProvider.dispose();
		if (needEntryItemProvider != null) needEntryItemProvider.dispose();
		if (modeLabelAccessItemProvider != null) modeLabelAccessItemProvider.dispose();
		if (runnableModeSwitchItemProvider != null) runnableModeSwitchItemProvider.dispose();
		if (labelAccessItemProvider != null) labelAccessItemProvider.dispose();
		if (channelSendItemProvider != null) channelSendItemProvider.dispose();
		if (channelReceiveItemProvider != null) channelReceiveItemProvider.dispose();
		if (semaphoreAccessItemProvider != null) semaphoreAccessItemProvider.dispose();
		if (senderReceiverReadItemProvider != null) senderReceiverReadItemProvider.dispose();
		if (senderReceiverWriteItemProvider != null) senderReceiverWriteItemProvider.dispose();
		if (synchronousServerCallItemProvider != null) synchronousServerCallItemProvider.dispose();
		if (asynchronousServerCallItemProvider != null) asynchronousServerCallItemProvider.dispose();
		if (getResultServerCallItemProvider != null) getResultServerCallItemProvider.dispose();
		if (runnableProbabilitySwitchItemProvider != null) runnableProbabilitySwitchItemProvider.dispose();
		if (groupItemProvider != null) groupItemProvider.dispose();
		if (runnableCallItemProvider != null) runnableCallItemProvider.dispose();
		if (customEventTriggerItemProvider != null) customEventTriggerItemProvider.dispose();
		if (structItemProvider != null) structItemProvider.dispose();
		if (structEntryItemProvider != null) structEntryItemProvider.dispose();
		if (arrayItemProvider != null) arrayItemProvider.dispose();
		if (pointerItemProvider != null) pointerItemProvider.dispose();
		if (typeRefItemProvider != null) typeRefItemProvider.dispose();
		if (dataPlatformMappingItemProvider != null) dataPlatformMappingItemProvider.dispose();
		if (dataTypeDefinitionItemProvider != null) dataTypeDefinitionItemProvider.dispose();
		if (baseTypeDefinitionItemProvider != null) baseTypeDefinitionItemProvider.dispose();
		if (periodicActivationItemProvider != null) periodicActivationItemProvider.dispose();
		if (variableRateActivationItemProvider != null) variableRateActivationItemProvider.dispose();
		if (sporadicActivationItemProvider != null) sporadicActivationItemProvider.dispose();
		if (singleActivationItemProvider != null) singleActivationItemProvider.dispose();
		if (eventActivationItemProvider != null) eventActivationItemProvider.dispose();
		if (customActivationItemProvider != null) customActivationItemProvider.dispose();
		if (labelAccessStatisticItemProvider != null) labelAccessStatisticItemProvider.dispose();
		if (instructionFetchItemProvider != null) instructionFetchItemProvider.dispose();
		if (runEntityCallStatisticItemProvider != null) runEntityCallStatisticItemProvider.dispose();
		if (measurementModelItemProvider != null) measurementModelItemProvider.dispose();
		if (eventChainMeasurementItemProvider != null) eventChainMeasurementItemProvider.dispose();
		if (taskMeasurementItemProvider != null) taskMeasurementItemProvider.dispose();
		if (runnableMeasurementItemProvider != null) runnableMeasurementItemProvider.dispose();
	}

}
