/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import com.google.common.base.Objects;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.model.AbstractElementMappingConstraint;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.AbstractTime;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceType;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ArchitectureRequirement;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry;
import org.eclipse.app4mc.amalthea.model.AsynchronousServerCall;
import org.eclipse.app4mc.amalthea.model.BaseTypeDefinition;
import org.eclipse.app4mc.amalthea.model.BigIntegerObject;
import org.eclipse.app4mc.amalthea.model.BlockingType;
import org.eclipse.app4mc.amalthea.model.BooleanObject;
import org.eclipse.app4mc.amalthea.model.CPUPercentageMetric;
import org.eclipse.app4mc.amalthea.model.CPUPercentageRequirementLimit;
import org.eclipse.app4mc.amalthea.model.ChainedProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Channel;
import org.eclipse.app4mc.amalthea.model.ChannelAccess;
import org.eclipse.app4mc.amalthea.model.ChannelReceive;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.CoherencyDirection;
import org.eclipse.app4mc.amalthea.model.Component;
import org.eclipse.app4mc.amalthea.model.ComponentInstance;
import org.eclipse.app4mc.amalthea.model.ComponentScope;
import org.eclipse.app4mc.amalthea.model.Condition;
import org.eclipse.app4mc.amalthea.model.Connector;
import org.eclipse.app4mc.amalthea.model.CoreClassification;
import org.eclipse.app4mc.amalthea.model.CountMetric;
import org.eclipse.app4mc.amalthea.model.CountRequirementLimit;
import org.eclipse.app4mc.amalthea.model.CustomEvent;
import org.eclipse.app4mc.amalthea.model.CustomEventTrigger;
import org.eclipse.app4mc.amalthea.model.DataAgeCycle;
import org.eclipse.app4mc.amalthea.model.DataAgeTime;
import org.eclipse.app4mc.amalthea.model.DataCoherencyGroup;
import org.eclipse.app4mc.amalthea.model.DataGroupScope;
import org.eclipse.app4mc.amalthea.model.DataPlatformMapping;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.DataRateUnit;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.DataStability;
import org.eclipse.app4mc.amalthea.model.DataTypeDefinition;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.DoubleObject;
import org.eclipse.app4mc.amalthea.model.EntityEvent;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainContainer;
import org.eclipse.app4mc.amalthea.model.EventChainMeasurement;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.EventConfig;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.FloatObject;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyMetric;
import org.eclipse.app4mc.amalthea.model.FrequencyRequirementLimit;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.GetResultServerCall;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.GroupingType;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.IntegerObject;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.InterfaceKind;
import org.eclipse.app4mc.amalthea.model.InterfacePort;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LatencyConstant;
import org.eclipse.app4mc.amalthea.model.LatencyDeviation;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryClassification;
import org.eclipse.app4mc.amalthea.model.MemoryMapping;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.ModeValueConjunction;
import org.eclipse.app4mc.amalthea.model.ModeValueDisjunction;
import org.eclipse.app4mc.amalthea.model.ModeValueList;
import org.eclipse.app4mc.amalthea.model.Need;
import org.eclipse.app4mc.amalthea.model.NeedConstant;
import org.eclipse.app4mc.amalthea.model.NeedDeviation;
import org.eclipse.app4mc.amalthea.model.NonAtomicDataCoherency;
import org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.OrderType;
import org.eclipse.app4mc.amalthea.model.OsAPIInstructions;
import org.eclipse.app4mc.amalthea.model.OsDataConsistency;
import org.eclipse.app4mc.amalthea.model.OsDataConsistencyMode;
import org.eclipse.app4mc.amalthea.model.OsISRInstructions;
import org.eclipse.app4mc.amalthea.model.OsInstructions;
import org.eclipse.app4mc.amalthea.model.PercentageMetric;
import org.eclipse.app4mc.amalthea.model.PercentageRequirementLimit;
import org.eclipse.app4mc.amalthea.model.PhysicalSectionConstraint;
import org.eclipse.app4mc.amalthea.model.PhysicalSectionMapping;
import org.eclipse.app4mc.amalthea.model.Port;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessAllocationConstraint;
import org.eclipse.app4mc.amalthea.model.ProcessChain;
import org.eclipse.app4mc.amalthea.model.ProcessChainRequirement;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessPrototypeAllocationConstraint;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.ProcessScope;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.QualifiedPort;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableAllocation;
import org.eclipse.app4mc.amalthea.model.RunnableAllocationConstraint;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableMeasurement;
import org.eclipse.app4mc.amalthea.model.RunnableModeSwitch;
import org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.RunnableRequirement;
import org.eclipse.app4mc.amalthea.model.RunnableScope;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.SchedulingParameters;
import org.eclipse.app4mc.amalthea.model.Section;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.SemaphoreAccess;
import org.eclipse.app4mc.amalthea.model.SemaphoreAccessEnum;
import org.eclipse.app4mc.amalthea.model.SenderReceiverRead;
import org.eclipse.app4mc.amalthea.model.SenderReceiverWrite;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.StructureType;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.model.SynchronousServerCall;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.TagGroup;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskMeasurement;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeObject;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TransmissionPolicy;
import org.eclipse.app4mc.amalthea.model.TypeDefinition;
import org.eclipse.app4mc.amalthea.model.TypeRef;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.WaitingBehaviour;
import org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl;
import org.eclipse.app4mc.amalthea.model.impl.ExecutionNeedExtendedImpl;
import org.eclipse.app4mc.amalthea.model.impl.ModeValueImpl;
import org.eclipse.app4mc.amalthea.model.impl.NeedEntryImpl;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class CustomItemProviderService {
    private static String getContainingFeatureName(EObject object, String defaultText, String separator) {
        EStructuralFeature _eContainingFeature = null;
        if (object != null) {
            _eContainingFeature = object.eContainingFeature();
        }
        EStructuralFeature feature = _eContainingFeature;
        String _xifexpression = null;
        if (feature == null) {
            _xifexpression = defaultText;
        } else {
            String _name = feature.getName();
            _xifexpression = String.valueOf(_name) + separator;
        }
        String name = _xifexpression;
        return name;
    }

    private static String getContainingFeatureName(EObject object) {
        return CustomItemProviderService.getContainingFeatureName(object, "", ": ");
    }

    private static String getLabelProviderText(Object object, AdapterFactory rootAF) {
        Object plainAdapter;
        if (object != null && rootAF.isFactoryForType(object) && (plainAdapter = rootAF.adapt(object, IItemLabelProvider.class)) instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)plainAdapter).getText(object);
        }
        return "";
    }

    private static String ppCamelCase(String s) {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)s), (String)" ");
    }

    private static String ppName(String name) {
        return CustomItemProviderService.ppName(name, "???");
    }

    private static String ppName(String name, String surrogate) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
        if (_isNullOrEmpty) {
            return surrogate;
        }
        return name;
    }

    public static String getAmaltheaItemProviderText(Object object, String defaultText) {
        if (object instanceof Amalthea) {
            String _version = ((Amalthea)object).getVersion();
            String _plus = "AMALTHEA model (version " + _version;
            return String.valueOf(_plus) + ")";
        }
        return defaultText;
    }

    private static String getFrequencyText(Frequency frequency) {
        if (frequency == null) {
            return "<frequency>";
        }
        String value = Double.toString(frequency.getValue());
        String _xifexpression = null;
        FrequencyUnit _unit = frequency.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)FrequencyUnit._UNDEFINED_);
        _xifexpression = _equals ? "<unit>" : frequency.getUnit().getLiteral();
        String unit = _xifexpression;
        return String.valueOf(value) + " " + unit;
    }

    private static String getTimeText(AbstractTime time) {
        if (time == null) {
            return "<time>";
        }
        String _xifexpression = null;
        BigInteger _value = time.getValue();
        boolean _tripleEquals = _value == null;
        _xifexpression = _tripleEquals ? "???" : time.getValue().toString();
        String value = _xifexpression;
        String _xifexpression_1 = null;
        TimeUnit _unit = time.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)TimeUnit._UNDEFINED_);
        _xifexpression_1 = _equals ? "<unit>" : time.getUnit().getLiteral();
        String unit = _xifexpression_1;
        return String.valueOf(value) + " " + unit;
    }

    private static String getDataSizeText(DataSize size) {
        if (size == null) {
            return "<data size>";
        }
        String _xifexpression = null;
        BigInteger _value = size.getValue();
        boolean _tripleEquals = _value == null;
        _xifexpression = _tripleEquals ? "???" : size.getValue().toString();
        String value = _xifexpression;
        String _xifexpression_1 = null;
        DataSizeUnit _unit = size.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)DataSizeUnit._UNDEFINED_);
        _xifexpression_1 = _equals ? "<unit>" : size.getUnit().getLiteral();
        String unit = _xifexpression_1;
        return String.valueOf(value) + " " + unit;
    }

    private static String getDataRateText(DataRate rate) {
        if (rate == null) {
            return "<data rate>";
        }
        String _xifexpression = null;
        BigInteger _value = rate.getValue();
        boolean _tripleEquals = _value == null;
        _xifexpression = _tripleEquals ? "???" : rate.getValue().toString();
        String value = _xifexpression;
        String _xifexpression_1 = null;
        DataRateUnit _unit = rate.getUnit();
        boolean _equals = Objects.equal((Object)_unit, (Object)DataRateUnit._UNDEFINED_);
        _xifexpression_1 = _equals ? "<unit>" : rate.getUnit().getLiteral();
        String unit = _xifexpression_1;
        String _replace = unit.replace("PerSecond", "/s");
        return String.valueOf(value) + " " + _replace;
    }

    private static String trimDistName(String name) {
        if (name == null) {
            return "";
        }
        return name.replace("Distribution", "").replace("Estimators", "").replace("Parameters", "");
    }

    private static String getInstructionsText(Instructions instr) {
        String _switchResult = null;
        boolean _matched = false;
        if (instr instanceof InstructionsConstant) {
            _matched = true;
            _switchResult = CustomItemProviderService.getInstructionsConstantItemProviderText(instr, null);
        }
        if (!_matched && instr instanceof InstructionsDeviation) {
            _matched = true;
            _switchResult = CustomItemProviderService.getInstructionsDeviationItemProviderText(instr, null);
        }
        return _switchResult;
    }

    private static String getNeedText(Need need) {
        String _switchResult = null;
        boolean _matched = false;
        if (need instanceof NeedConstant) {
            _matched = true;
            _switchResult = CustomItemProviderService.getNeedConstantItemProviderText(need, null);
        }
        if (!_matched && need instanceof NeedDeviation) {
            _matched = true;
            _switchResult = CustomItemProviderService.getNeedDeviationItemProviderText(need, null);
        }
        return _switchResult;
    }

    public static String getCustomPropertyItemProviderText(Object object, String defaultText) {
        if (object instanceof CustomPropertyImpl) {
            String _key = null;
            if ((CustomPropertyImpl)object != null) {
                _key = ((CustomPropertyImpl)object).getKey();
            }
            String key = _key;
            Value _value = null;
            if ((CustomPropertyImpl)object != null) {
                _value = ((CustomPropertyImpl)object).getValue();
            }
            Value value = _value;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)key);
            _xifexpression = _isNullOrEmpty ? "<key>" : "\"" + key + "\"";
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = value == null ? "null" : value;
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + " -> " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getCustomPropertyItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getBooleanObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof BooleanObject) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + object;
        }
        return defaultText;
    }

    public static String getDoubleObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof DoubleObject) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + object;
        }
        return defaultText;
    }

    public static String getFloatObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof FloatObject) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + object;
        }
        return defaultText;
    }

    public static String getIntegerObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof IntegerObject) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + object;
        }
        return defaultText;
    }

    public static String getLongObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof LongObject) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + object;
        }
        return defaultText;
    }

    public static String getTimeObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeObject) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _timeText = CustomItemProviderService.getTimeText((AbstractTime)object);
            return String.valueOf(_containingFeatureName) + _timeText;
        }
        return defaultText;
    }

    public static String getStringObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof StringObject) {
            boolean _tripleEquals;
            String s1 = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _xifexpression = null;
            String _value = null;
            if ((StringObject)object != null) {
                _value = ((StringObject)object).getValue();
            }
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                _xifexpression = "null";
            } else {
                String _value_1 = ((StringObject)object).getValue();
                String _plus = "\"" + _value_1;
                _xifexpression = String.valueOf(_plus) + "\"";
            }
            String s2 = _xifexpression;
            return String.valueOf(s1) + s2;
        }
        return defaultText;
    }

    public static String getBigIntegerObjectItemProviderText(Object object, String defaultText) {
        if (object instanceof BigIntegerObject) {
            boolean _tripleEquals;
            String s1 = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _xifexpression = null;
            BigInteger _value = null;
            if ((BigIntegerObject)object != null) {
                _value = ((BigIntegerObject)object).getValue();
            }
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                _xifexpression = "null";
            } else {
                BigInteger _value_1 = ((BigIntegerObject)object).getValue();
                String _plus = "\"" + _value_1;
                _xifexpression = String.valueOf(_plus) + "\"";
            }
            String s2 = _xifexpression;
            return String.valueOf(s1) + s2;
        }
        return defaultText;
    }

    public static String getBoundariesItemProviderText(Object object, String defaultText) {
        return "Dist: Boundaries";
    }

    public static String getBetaDistributionItemProviderText(Object object, String defaultText) {
        return "Dist: Beta";
    }

    public static String getGaussDistributionItemProviderText(Object object, String defaultText) {
        return "Dist: Gauss";
    }

    public static String getUniformDistributionItemProviderText(Object object, String defaultText) {
        return "Dist: Uniform";
    }

    public static String getWeibullEstimatorsItemProviderText(Object object, String defaultText) {
        return "Dist: Weibull Estimators";
    }

    public static String getWeibullParametersItemProviderText(Object object, String defaultText) {
        return "Dist: Weibull Parameters";
    }

    public static String getFrequencyItemProviderText(Object object, String defaultText) {
        if (object instanceof Frequency) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _frequencyText = CustomItemProviderService.getFrequencyText((Frequency)object);
            return String.valueOf(_containingFeatureName) + _frequencyText;
        }
        return defaultText;
    }

    public static String getDataSizeItemProviderText(Object object, String defaultText) {
        if (object instanceof DataSize) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _dataSizeText = CustomItemProviderService.getDataSizeText((DataSize)object);
            return String.valueOf(_containingFeatureName) + _dataSizeText;
        }
        return defaultText;
    }

    public static String getDataRateItemProviderText(Object object, String defaultText) {
        if (object instanceof DataRate) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _dataRateText = CustomItemProviderService.getDataRateText((DataRate)object);
            return String.valueOf(_containingFeatureName) + _dataRateText;
        }
        return defaultText;
    }

    public static String getDeviationItemProviderText(Object object, String defaultText) {
        if (object instanceof Deviation) {
            Distribution _distribution = null;
            if ((Deviation)object != null) {
                _distribution = ((Deviation)object).getDistribution();
            }
            EClass _eClass = null;
            if (_distribution != null) {
                _eClass = _distribution.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String distName = _name;
            Object _lowerBound = null;
            if ((Deviation)object != null) {
                _lowerBound = ((Deviation)object).getLowerBound();
            }
            Object lower = _lowerBound;
            Object _upperBound = null;
            if ((Deviation)object != null) {
                _upperBound = ((Deviation)object).getUpperBound();
            }
            Object upper = _upperBound;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)distName);
            if (_isNullOrEmpty) {
                _xifexpression = "Dist: ???";
            } else {
                String _trimDistName = CustomItemProviderService.trimDistName(distName);
                _xifexpression = "Dist: " + _trimDistName;
            }
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = lower == null ? "" : " lowerBound: " + lower;
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            _xifexpression_2 = upper == null ? "" : " upperBound: " + upper;
            String s3 = _xifexpression_2;
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _plus = String.valueOf(_containingFeatureName) + "(";
            String _plus_1 = String.valueOf(_plus) + s1;
            String _plus_2 = String.valueOf(_plus_1) + ")";
            String _plus_3 = String.valueOf(_plus_2) + s2;
            return String.valueOf(_plus_3) + s3;
        }
        return null;
    }

    public static ViewerNotification getDeviationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Deviation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getMinAvgMaxStatisticItemProviderText(Object object, String defaultText) {
        if (object instanceof MinAvgMaxStatistic) {
            String s1 = CustomItemProviderService.getContainingFeatureName((EObject)object);
            int _min = ((MinAvgMaxStatistic)object).getMin();
            String _plus = String.valueOf(s1) + Integer.valueOf(_min);
            String _plus_1 = String.valueOf(_plus) + " : ";
            float _avg = ((MinAvgMaxStatistic)object).getAvg();
            String _plus_2 = String.valueOf(_plus_1) + Float.valueOf(_avg);
            String _plus_3 = String.valueOf(_plus_2) + " : ";
            int _max = ((MinAvgMaxStatistic)object).getMax();
            return String.valueOf(_plus_3) + Integer.valueOf(_max);
        }
        return defaultText;
    }

    public static String getSingleValueStatisticItemProviderText(Object object, String defaultText) {
        if (object instanceof SingleValueStatistic) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            float _value = ((SingleValueStatistic)object).getValue();
            return String.valueOf(_containingFeatureName) + Float.valueOf(_value);
        }
        return defaultText;
    }

    public static String getTimeItemProviderText(Object object, String defaultText) {
        if (object instanceof Time) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _timeText = CustomItemProviderService.getTimeText((AbstractTime)object);
            return String.valueOf(_containingFeatureName) + _timeText;
        }
        return defaultText;
    }

    public static String getInstructionsConstantItemProviderText(Object object, String defaultText) {
        if (object instanceof InstructionsConstant) {
            String feature = CustomItemProviderService.getContainingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)feature, (Object)"value");
            _xifexpression = _equals ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            String s2 = Long.toString(((InstructionsConstant)object).getValue());
            return String.valueOf(s1) + "instructions (constant): " + s2;
        }
        return defaultText;
    }

    public static String getInstructionsDeviationItemProviderText(Object object, String defaultText) {
        if (object instanceof InstructionsDeviation) {
            String feature = CustomItemProviderService.getContainingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)feature, (Object)"value");
            _xifexpression = _equals ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            Deviation _deviation = null;
            if ((InstructionsDeviation)object != null) {
                _deviation = ((InstructionsDeviation)object).getDeviation();
            }
            Distribution _distribution = null;
            if (_deviation != null) {
                _distribution = _deviation.getDistribution();
            }
            EClass _eClass = null;
            if (_distribution != null) {
                _eClass = _distribution.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String distName = _name;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)distName);
            _xifexpression_1 = _isNullOrEmpty ? "<distribution>" : CustomItemProviderService.trimDistName(distName);
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + "instructions (deviation): " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getInstructionsDeviationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(InstructionsDeviation.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getNeedConstantItemProviderText(Object object, String defaultText) {
        if (object instanceof NeedConstant) {
            String feature = CustomItemProviderService.getContainingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)feature, (Object)"value");
            _xifexpression = _equals ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            String s2 = Long.toString(((NeedConstant)object).getValue());
            return String.valueOf(s1) + "need (constant): " + s2;
        }
        return defaultText;
    }

    public static String getNeedDeviationItemProviderText(Object object, String defaultText) {
        if (object instanceof NeedDeviation) {
            String feature = CustomItemProviderService.getContainingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)feature, (Object)"value");
            _xifexpression = _equals ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            Deviation _deviation = null;
            if ((NeedDeviation)object != null) {
                _deviation = ((NeedDeviation)object).getDeviation();
            }
            Distribution _distribution = null;
            if (_deviation != null) {
                _distribution = _deviation.getDistribution();
            }
            EClass _eClass = null;
            if (_distribution != null) {
                _eClass = _distribution.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String distName = _name;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)distName);
            _xifexpression_1 = _isNullOrEmpty ? "<distribution>" : CustomItemProviderService.trimDistName(distName);
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + "need (deviation): " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getNeedDeviationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(NeedDeviation.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getTransmissionPolicyItemProviderText(Object object, String defaultText) {
        if (object instanceof TransmissionPolicy) {
            DataSize size = ((TransmissionPolicy)object).getChunkSize();
            int instr = ((TransmissionPolicy)object).getChunkProcessingInstructions();
            double ratio = ((TransmissionPolicy)object).getTransmitRatio();
            String _dataSizeText = CustomItemProviderService.getDataSizeText(size);
            String _plus = "transmission (chunk size: " + _dataSizeText;
            String _plus_1 = String.valueOf(_plus) + " instructions: ";
            String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(instr);
            String _plus_3 = String.valueOf(_plus_2) + " ratio: ";
            String _plus_4 = String.valueOf(_plus_3) + Double.valueOf(ratio);
            return String.valueOf(_plus_4) + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getTransmissionPolicyItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TransmissionPolicy.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getComponentInstanceItemProviderText(Object object, String defaultText) {
        if (object instanceof ComponentInstance) {
            String _name = null;
            if ((ComponentInstance)object != null) {
                _name = ((ComponentInstance)object).getName();
            }
            String name = _name;
            Component _type = null;
            if ((ComponentInstance)object != null) {
                _type = ((ComponentInstance)object).getType();
            }
            String _name_1 = null;
            if (_type != null) {
                _name_1 = _type.getName();
            }
            String typeName = _name_1;
            String s1 = CustomItemProviderService.ppName(name, "<component instance>");
            String s2 = CustomItemProviderService.ppName(typeName);
            return String.valueOf(s1) + " (type: " + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getComponentInstanceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ComponentInstance.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getConnectorItemProviderText(Object object, String defaultText) {
        if (object instanceof Connector) {
            String _name = null;
            if ((Connector)object != null) {
                _name = ((Connector)object).getName();
            }
            String name = _name;
            String s1 = CustomItemProviderService.ppName(name, "<connector>");
            return s1;
        }
        return defaultText;
    }

    public static String getInterfacePortItemProviderText(Object object, String defaultText) {
        if (object instanceof InterfacePort) {
            Component _containingComponent = null;
            if ((InterfacePort)object != null) {
                _containingComponent = ((InterfacePort)object).getContainingComponent();
            }
            String cName = _containingComponent.getName();
            InterfaceKind _kind = null;
            if ((InterfacePort)object != null) {
                _kind = ((InterfacePort)object).getKind();
            }
            InterfaceKind kind = _kind;
            String _name = null;
            if ((InterfacePort)object != null) {
                _name = ((InterfacePort)object).getName();
            }
            String name = _name;
            String s1 = CustomItemProviderService.ppName(cName, "<component>");
            String _xifexpression = null;
            _xifexpression = kind == null || Objects.equal((Object)kind, (Object)InterfaceKind._UNDEFINED_) ? "<kind>" : kind.getLiteral();
            String s2 = _xifexpression;
            String s3 = CustomItemProviderService.ppName(name, "<port>");
            return String.valueOf(s1) + " " + s2 + " " + s3;
        }
        return defaultText;
    }

    public static String getQualifiedPortItemProviderText(Object object, String defaultText) {
        if (object instanceof QualifiedPort) {
            boolean _tripleEquals;
            ComponentInstance _instance = null;
            if ((QualifiedPort)object != null) {
                _instance = ((QualifiedPort)object).getInstance();
            }
            String _name = null;
            if (_instance != null) {
                _name = _instance.getName();
            }
            String instName = _name;
            Port _port = null;
            if ((QualifiedPort)object != null) {
                _port = ((QualifiedPort)object).getPort();
            }
            String _name_1 = null;
            if (_port != null) {
                _name_1 = _port.getName();
            }
            String portName = _name_1;
            String s2 = "";
            String s4 = "";
            ComponentInstance _instance_1 = null;
            if ((QualifiedPort)object != null) {
                _instance_1 = ((QualifiedPort)object).getInstance();
            }
            boolean bl = _tripleEquals = _instance_1 == null;
            if (_tripleEquals) {
                s4 = " (enclosing composite)";
            } else {
                String _xifexpression = null;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)instName);
                _xifexpression = _isNullOrEmpty ? "??? / " : String.valueOf(instName) + " / ";
                s2 = _xifexpression;
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)portName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<port>" : portName;
            String s3 = _xifexpression_1;
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _plus = String.valueOf(_containingFeatureName) + s2;
            String _plus_1 = String.valueOf(_plus) + s3;
            return String.valueOf(_plus_1) + s4;
        }
        return defaultText;
    }

    public static ViewerNotification getQualifiedPortItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(QualifiedPort.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getEventConfigItemProviderText(Object object, String defaultText, AdapterFactory rootAF) {
        if (object instanceof EventConfig) {
            String _name = null;
            if ((EventConfig)object != null) {
                _name = ((EventConfig)object).getName();
            }
            String name = _name;
            EntityEvent _event = null;
            if ((EventConfig)object != null) {
                _event = ((EventConfig)object).getEvent();
            }
            EntityEvent event = _event;
            String s1 = CustomItemProviderService.ppName(name);
            String _xifexpression = null;
            _xifexpression = event == null ? "<event>" : CustomItemProviderService.getLabelProviderText(event, rootAF);
            String s2 = _xifexpression;
            return "Config " + s1 + " -> trace " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getEventConfigItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(EventConfig.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    private static String getLimitTypeText(LimitType limitType) {
        String _switchResult = null;
        if (limitType != null) {
            switch (limitType) {
                case UPPER_LIMIT: {
                    _switchResult = " <= ";
                    break;
                }
                case LOWER_LIMIT: {
                    _switchResult = " >= ";
                    break;
                }
                default: {
                    _switchResult = " ? ";
                    break;
                }
            }
        } else {
            _switchResult = " ? ";
        }
        return _switchResult;
    }

    public static String getComponentScopeItemProviderText(Object object, String defaultText) {
        if (object instanceof ComponentScope) {
            Component _component = null;
            if ((ComponentScope)object != null) {
                _component = ((ComponentScope)object).getComponent();
            }
            String _name = null;
            if (_component != null) {
                _name = _component.getName();
            }
            String compName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)compName);
            _xifexpression = _isNullOrEmpty ? "<component>" : "Component " + compName;
            String s1 = _xifexpression;
            return "Scope: " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getComponentScopeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ComponentScope.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getProcessScopeItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessScope) {
            boolean _isNullOrEmpty;
            AbstractProcess _process = null;
            if ((ProcessScope)object != null) {
                _process = ((ProcessScope)object).getProcess();
            }
            AbstractProcess proc = _process;
            String _xifexpression = null;
            String _name = null;
            if (proc != null) {
                _name = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<process>";
            } else {
                String _name_1 = proc.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "Scope: " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessScopeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessScope.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableScopeItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableScope) {
            Runnable _runnable = null;
            if ((RunnableScope)object != null) {
                _runnable = ((RunnableScope)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)runName);
            _xifexpression = _isNullOrEmpty ? "<runnable>" : "Runnable " + runName;
            String s1 = _xifexpression;
            return "Scope: " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableScopeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableScope.class);
        if (Objects.equal((Object)_featureID, (Object)0)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getArchitectureRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof ArchitectureRequirement) {
            String _name = null;
            if ((ArchitectureRequirement)object != null) {
                _name = ((ArchitectureRequirement)object).getName();
            }
            String reqName = _name;
            Component _component = null;
            if ((ArchitectureRequirement)object != null) {
                _component = ((ArchitectureRequirement)object).getComponent();
            }
            String _name_1 = null;
            if (_component != null) {
                _name_1 = _component.getName();
            }
            String compName = _name_1;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)compName);
            _xifexpression = _isNullOrEmpty ? "<component>" : "Component " + compName;
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getArchitectureRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ArchitectureRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getCountRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof CountRequirementLimit) {
            CountMetric _metric = null;
            if ((CountRequirementLimit)object != null) {
                _metric = ((CountRequirementLimit)object).getMetric();
            }
            CountMetric metric = _metric;
            LimitType _limitType = null;
            if ((CountRequirementLimit)object != null) {
                _limitType = ((CountRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            int _xifexpression = 0;
            _xifexpression = object == null ? 0 : ((CountRequirementLimit)object).getLimitValue();
            int limitValue = _xifexpression;
            String _xifexpression_1 = null;
            if (metric == null || Objects.equal((Object)metric, (Object)CountMetric._UNDEFINED_)) {
                _xifexpression_1 = "<count metric>";
            } else {
                String _literal = metric.getLiteral();
                _xifexpression_1 = String.valueOf(_literal) + " count";
            }
            String s1 = _xifexpression_1;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String s3 = Double.toString(limitValue);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static String getCPUPercentageRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof CPUPercentageRequirementLimit) {
            CPUPercentageMetric _metric = null;
            if ((CPUPercentageRequirementLimit)object != null) {
                _metric = ((CPUPercentageRequirementLimit)object).getMetric();
            }
            CPUPercentageMetric metric = _metric;
            ProcessingUnit _hardwareContext = null;
            if ((CPUPercentageRequirementLimit)object != null) {
                _hardwareContext = ((CPUPercentageRequirementLimit)object).getHardwareContext();
            }
            String _name = null;
            if (_hardwareContext != null) {
                _name = _hardwareContext.getName();
            }
            String hwContext = _name;
            LimitType _limitType = null;
            if ((CPUPercentageRequirementLimit)object != null) {
                _limitType = ((CPUPercentageRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            double _xifexpression = 0.0;
            _xifexpression = object == null ? 0.0 : ((CPUPercentageRequirementLimit)object).getLimitValue();
            double limitValue = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = metric == null || Objects.equal((Object)metric, (Object)CPUPercentageMetric._UNDEFINED_) ? "<CPU % metric>" : metric.getLiteral();
            String s1 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)hwContext);
            _xifexpression_2 = _isNullOrEmpty ? "" : " on " + hwContext;
            String s2 = _xifexpression_2;
            String s3 = CustomItemProviderService.getLimitTypeText(limitType);
            String _string = Double.toString(limitValue);
            String s4 = String.valueOf(_string) + " %";
            return String.valueOf(s1) + s2 + s3 + s4;
        }
        return defaultText;
    }

    public static String getFrequencyRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof FrequencyRequirementLimit) {
            FrequencyMetric _metric = null;
            if ((FrequencyRequirementLimit)object != null) {
                _metric = ((FrequencyRequirementLimit)object).getMetric();
            }
            FrequencyMetric metric = _metric;
            LimitType _limitType = null;
            if ((FrequencyRequirementLimit)object != null) {
                _limitType = ((FrequencyRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            Frequency _limitValue = null;
            if ((FrequencyRequirementLimit)object != null) {
                _limitValue = ((FrequencyRequirementLimit)object).getLimitValue();
            }
            Frequency limitValue = _limitValue;
            String _xifexpression = null;
            _xifexpression = metric == null || Objects.equal((Object)metric, (Object)FrequencyMetric._UNDEFINED_) ? "<frequency metric>" : metric.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String s3 = CustomItemProviderService.getFrequencyText(limitValue);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getFrequencyRequirementLimitItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(FrequencyRequirementLimit.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getPercentageRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof PercentageRequirementLimit) {
            PercentageMetric _metric = null;
            if ((PercentageRequirementLimit)object != null) {
                _metric = ((PercentageRequirementLimit)object).getMetric();
            }
            PercentageMetric metric = _metric;
            LimitType _limitType = null;
            if ((PercentageRequirementLimit)object != null) {
                _limitType = ((PercentageRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            double _xifexpression = 0.0;
            _xifexpression = object == null ? 0.0 : ((PercentageRequirementLimit)object).getLimitValue();
            double limitValue = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = metric == null || Objects.equal((Object)metric, (Object)PercentageMetric._UNDEFINED_) ? "<% metric>" : metric.getLiteral();
            String s1 = _xifexpression_1;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String _string = Double.toString(limitValue);
            String s3 = String.valueOf(_string) + " %";
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static String getTimeRequirementLimitItemProviderText(Object object, String defaultText) {
        if (object instanceof TimeRequirementLimit) {
            TimeMetric _metric = null;
            if ((TimeRequirementLimit)object != null) {
                _metric = ((TimeRequirementLimit)object).getMetric();
            }
            TimeMetric metric = _metric;
            LimitType _limitType = null;
            if ((TimeRequirementLimit)object != null) {
                _limitType = ((TimeRequirementLimit)object).getLimitType();
            }
            LimitType limitType = _limitType;
            Time _limitValue = null;
            if ((TimeRequirementLimit)object != null) {
                _limitValue = ((TimeRequirementLimit)object).getLimitValue();
            }
            Time limitValue = _limitValue;
            String _xifexpression = null;
            _xifexpression = metric == null || Objects.equal((Object)metric, (Object)TimeMetric._UNDEFINED_) ? "<time metric>" : metric.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.getLimitTypeText(limitType);
            String s3 = CustomItemProviderService.getTimeText((AbstractTime)limitValue);
            return String.valueOf(s1) + s2 + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getTimeRequirementLimitItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TimeRequirementLimit.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getProcessRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessRequirement) {
            boolean _isNullOrEmpty;
            String _name = null;
            if ((ProcessRequirement)object != null) {
                _name = ((ProcessRequirement)object).getName();
            }
            String reqName = _name;
            AbstractProcess _process = null;
            if ((ProcessRequirement)object != null) {
                _process = ((ProcessRequirement)object).getProcess();
            }
            AbstractProcess proc = _process;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            String _name_1 = null;
            if (proc != null) {
                _name_1 = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name_1)) {
                _xifexpression = "<process>";
            } else {
                String _name_2 = proc.eClass().getName();
                String _plus = String.valueOf(_name_2) + " ";
                String _name_3 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_3;
            }
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableRequirement) {
            String _name = null;
            if ((RunnableRequirement)object != null) {
                _name = ((RunnableRequirement)object).getName();
            }
            String reqName = _name;
            Runnable _runnable = null;
            if ((RunnableRequirement)object != null) {
                _runnable = ((RunnableRequirement)object).getRunnable();
            }
            String _name_1 = null;
            if (_runnable != null) {
                _name_1 = _runnable.getName();
            }
            String runName = _name_1;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)runName);
            _xifexpression = _isNullOrEmpty ? "<runnable>" : "Runnable " + runName;
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getProcessChainRequirementItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessChainRequirement) {
            String _name = null;
            if ((ProcessChainRequirement)object != null) {
                _name = ((ProcessChainRequirement)object).getName();
            }
            String reqName = _name;
            ProcessChain _processChain = null;
            if ((ProcessChainRequirement)object != null) {
                _processChain = ((ProcessChainRequirement)object).getProcessChain();
            }
            String _name_1 = null;
            if (_processChain != null) {
                _name_1 = _processChain.getName();
            }
            String pcName = _name_1;
            String s1 = CustomItemProviderService.ppName(reqName);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)pcName);
            _xifexpression = _isNullOrEmpty ? "<process chain>" : "Process Chain " + pcName;
            String s2 = _xifexpression;
            return "Req " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessChainRequirementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessChainRequirement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getDataAgeCycleItemProviderText(Object object, String defaultText) {
        if (object instanceof DataAgeCycle) {
            int _minimumCycle = ((DataAgeCycle)object).getMinimumCycle();
            String _plus = "Age cycles c: " + Integer.valueOf(_minimumCycle);
            String _plus_1 = String.valueOf(_plus) + " <= c <= ";
            int _maximumCycle = ((DataAgeCycle)object).getMaximumCycle();
            return String.valueOf(_plus_1) + Integer.valueOf(_maximumCycle);
        }
        return defaultText;
    }

    public static String getDataAgeTimeItemProviderText(Object object, String defaultText) {
        if (object instanceof DataAgeTime) {
            Time _minimumTime = null;
            if ((DataAgeTime)object != null) {
                _minimumTime = ((DataAgeTime)object).getMinimumTime();
            }
            Time minTime = _minimumTime;
            Time _maximumTime = null;
            if ((DataAgeTime)object != null) {
                _maximumTime = ((DataAgeTime)object).getMaximumTime();
            }
            Time maxTime = _maximumTime;
            String _timeText = CustomItemProviderService.getTimeText((AbstractTime)minTime);
            String _plus = "Age time t: " + _timeText;
            String _plus_1 = String.valueOf(_plus) + " <= t <= ";
            String _timeText_1 = CustomItemProviderService.getTimeText((AbstractTime)maxTime);
            return String.valueOf(_plus_1) + _timeText_1;
        }
        return defaultText;
    }

    public static ViewerNotification getDataAgeTimeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(DataAgeTime.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getDataCoherencyGroupItemProviderText(Object object, String defaultText) {
        if (object instanceof DataCoherencyGroup) {
            String _name_2;
            boolean _isNullOrEmpty;
            String _name_1;
            String _xifexpression_1;
            String _name = null;
            if ((DataCoherencyGroup)object != null) {
                _name = ((DataCoherencyGroup)object).getName();
            }
            String name = _name;
            CoherencyDirection _direction = null;
            if ((DataCoherencyGroup)object != null) {
                _direction = ((DataCoherencyGroup)object).getDirection();
            }
            CoherencyDirection direction = _direction;
            DataGroupScope _scope = null;
            if ((DataCoherencyGroup)object != null) {
                _scope = ((DataCoherencyGroup)object).getScope();
            }
            DataGroupScope scope = _scope;
            String s1 = CustomItemProviderService.ppName(name, "<group>");
            String _xifexpression = null;
            _xifexpression = direction == null || Objects.equal((Object)direction, (Object)CoherencyDirection._UNDEFINED_) ? "<direction>" : direction.getLiteral();
            String s2 = _xifexpression;
            String _switchResult = null;
            boolean _matched = false;
            if (scope instanceof RunnableScope) {
                _matched = true;
                _xifexpression_1 = null;
                Runnable _runnable = ((RunnableScope)scope).getRunnable();
                _name_1 = null;
                if (_runnable != null) {
                    _name_1 = _runnable.getName();
                }
                if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name_1)) {
                    _xifexpression_1 = "<runnable>";
                } else {
                    _name_2 = ((RunnableScope)scope).getRunnable().getName();
                    _xifexpression_1 = "Runnable " + _name_2;
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched && scope instanceof ProcessScope) {
                _matched = true;
                _xifexpression_1 = null;
                AbstractProcess _process = ((ProcessScope)scope).getProcess();
                _name_1 = null;
                if (_process != null) {
                    _name_1 = _process.getName();
                }
                if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_name_1)) {
                    _xifexpression_1 = "<process>";
                } else {
                    _name_2 = ((ProcessScope)scope).getProcess().eClass().getName();
                    String _plus = String.valueOf(_name_2) + " ";
                    String _name_3 = ((ProcessScope)scope).getProcess().getName();
                    _xifexpression_1 = String.valueOf(_plus) + _name_3;
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched && scope instanceof ComponentScope) {
                _matched = true;
                _xifexpression_1 = null;
                Component _component = ((ComponentScope)scope).getComponent();
                _name_1 = null;
                if (_component != null) {
                    _name_1 = _component.getName();
                }
                if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_name_1)) {
                    _xifexpression_1 = "<component>";
                } else {
                    _name_2 = ((ComponentScope)scope).getComponent().getName();
                    _xifexpression_1 = "Component " + _name_2;
                }
                _switchResult = _xifexpression_1;
            }
            if (!_matched) {
                _switchResult = "?";
            }
            String s3 = _switchResult;
            return "CoherencyGroup " + s1 + " " + s2 + " (Scope: " + s3 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getDataCoherencyGroupItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(DataCoherencyGroup.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getEventChainReferenceItemProviderText(Object object, String defaultText) {
        if (object instanceof EventChainReference) {
            EventChain _eventChain = null;
            if ((EventChainReference)object != null) {
                _eventChain = ((EventChainReference)object).getEventChain();
            }
            String _name = null;
            if (_eventChain != null) {
                _name = _eventChain.getName();
            }
            String chainName = _name;
            String s1 = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)chainName);
            _xifexpression = _isNullOrEmpty ? "<chain ref>" : "(Chain Ref) " + chainName;
            String s2 = _xifexpression;
            return String.valueOf(s1) + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getEventChainReferenceItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(EventChainReference.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getEventChainContainerItemProviderText(Object object, String defaultText) {
        if (object instanceof EventChainContainer) {
            SubEventChain _eventChain = null;
            if ((EventChainContainer)object != null) {
                _eventChain = ((EventChainContainer)object).getEventChain();
            }
            SubEventChain chain = _eventChain;
            String s1 = CustomItemProviderService.getContainingFeatureName((EObject)object);
            String _xifexpression = null;
            if (chain == null) {
                _xifexpression = "<sub chain>";
            } else {
                String _xifexpression_1 = null;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)chain.getName());
                if (_isNullOrEmpty) {
                    _xifexpression_1 = "Sub Chain";
                } else {
                    String _name = chain.getName();
                    _xifexpression_1 = "(Sub Chain) " + _name;
                }
                _xifexpression = _xifexpression_1;
            }
            String s2 = _xifexpression;
            return String.valueOf(s1) + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getEventChainContainerItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SubEventChain.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getTagGroupItemProviderText(Object object, String defaultText) {
        if (object instanceof TagGroup) {
            Tag _tag = null;
            if ((TagGroup)object != null) {
                _tag = ((TagGroup)object).getTag();
            }
            String _name = null;
            if (_tag != null) {
                _name = _tag.getName();
            }
            String tagName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)tagName);
            _xifexpression = _isNullOrEmpty ? "<tag>" : "\"" + tagName + "\"";
            String s1 = _xifexpression;
            return "Items with tag " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getTagGroupItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TagGroup.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getPhysicalSectionConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof PhysicalSectionConstraint) {
            boolean _isNullOrEmpty_3;
            boolean _not;
            boolean _isNullOrEmpty;
            Section _section = null;
            if ((PhysicalSectionConstraint)object != null) {
                _section = ((PhysicalSectionConstraint)object).getSection();
            }
            Section section = _section;
            EList _memories = null;
            if ((PhysicalSectionConstraint)object != null) {
                _memories = ((PhysicalSectionConstraint)object).getMemories();
            }
            EList memories = _memories;
            String _xifexpression = null;
            String _name = null;
            if (section != null) {
                _name = section.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<section>";
            } else {
                String _name_1 = section.getName();
                _xifexpression = "Section :  " + _name_1;
            }
            String sectionString = _xifexpression;
            ArrayList memoryNames = new ArrayList();
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)memories);
            boolean bl = _not = !_isNullOrEmpty_1;
            if (_not) {
                Consumer<Memory> _function = it -> {
                    boolean _isNullOrEmpty_2;
                    String _xifexpression_1 = null;
                    String _name_2 = null;
                    if (it != null) {
                        _name_2 = it.getName();
                    }
                    _xifexpression_1 = (_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(_name_2)) ? "???" : it.getName();
                    String st = _xifexpression_1;
                    memoryNames.add(st);
                };
                memories.forEach(_function);
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(memoryNames);
            if (_isNullOrEmpty_2) {
                _xifexpression_1 = "<memories>";
            } else {
                boolean _greaterThan;
                String _xifexpression_2 = null;
                int _size = memoryNames.size();
                boolean bl2 = _greaterThan = _size > 10;
                if (_greaterThan) {
                    String _join = IterableExtensions.join(memoryNames.subList(0, 10), (CharSequence)", ");
                    String _plus = " Memories : " + _join;
                    _xifexpression_2 = String.valueOf(_plus) + ", ...";
                } else {
                    String _join_1 = IterableExtensions.join(memoryNames, (CharSequence)", ");
                    _xifexpression_2 = " Memories : " + _join_1;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            String memoriesString = _xifexpression_1;
            String _xifexpression_3 = null;
            String _name_2 = null;
            if ((PhysicalSectionConstraint)object != null) {
                _name_2 = ((PhysicalSectionConstraint)object).getName();
            }
            _xifexpression_3 = (_isNullOrEmpty_3 = StringExtensions.isNullOrEmpty(_name_2)) ? "<name>" : ((PhysicalSectionConstraint)object).getName();
            String s0 = _xifexpression_3;
            return String.valueOf(s0) + " : (" + sectionString + ")" + " --> (" + memoriesString + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getPhysicalSectionConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(PhysicalSectionConstraint.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, false);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
            Object _notifier_2 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_2, true, true);
        }
        return null;
    }

    public static String getHwStructureItemProviderImageName(Object object, String defaultName) {
        if (object instanceof HwStructure) {
            StructureType _structureType = ((HwStructure)object).getStructureType();
            if (_structureType != null) {
                switch (_structureType) {
                    case SYSTEM: {
                        return "HwStructure_System";
                    }
                    case ECU: {
                        return "HwStructure_ECU";
                    }
                    case MICROCONTROLLER: {
                        return "HwStructure_Microcontroller";
                    }
                }
                return "HwStructure";
            }
            return "HwStructure";
        }
        return defaultName;
    }

    public static ViewerNotification getHwFeatureCategoryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwFeatureCategory.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getHwFeatureItemProviderText(Object object, String defaultText) {
        if (object instanceof HwFeature) {
            return ((HwFeature)object).toString();
        }
        return defaultText;
    }

    public static String getHwPortItemProviderText(Object object, String defaultText) {
        if (object instanceof HwPort) {
            String name = ((HwPort)object).getName();
            EObject _eContainer = ((HwPort)object).eContainer();
            String cName = ((INamed)_eContainer).getName();
            String _xifexpression = null;
            EObject _eContainer_1 = ((HwPort)object).eContainer();
            _xifexpression = _eContainer_1 instanceof HwStructure ? "<structure>" : "<module>";
            String cType = _xifexpression;
            String s1 = CustomItemProviderService.ppName(cName, cType);
            String s2 = CustomItemProviderService.ppName(name, "<port>");
            return String.valueOf(s1) + "_" + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getHwPortItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwPort.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getHwAccessElementItemProviderText(Object object, String defaultText) {
        if (object instanceof HwAccessElement) {
            String s1 = CustomItemProviderService.ppName(((HwAccessElement)object).getName(), "???");
            ProcessingUnit _source = ((HwAccessElement)object).getSource();
            String _name = null;
            if (_source != null) {
                _name = _source.getName();
            }
            String s2 = CustomItemProviderService.ppName(_name, "<source>");
            HwDestination _destination = ((HwAccessElement)object).getDestination();
            String _name_1 = null;
            if (_destination != null) {
                _name_1 = _destination.getName();
            }
            String s3 = CustomItemProviderService.ppName(_name_1, "<destination>");
            return String.valueOf(s1) + ": " + s2 + " --> " + s3;
        }
        return null;
    }

    public static ViewerNotification getHwAccessElementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwAccessElement.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)5)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)6)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)4)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getHwAccessPathItemProviderText(Object object, String defaultText) {
        if (object instanceof HwAccessPath) {
            return ((HwAccessPath)object).getName();
        }
        return null;
    }

    public static String getHwConnectionItemProviderText(Object object, String defaultText) {
        if (object instanceof HwConnection) {
            HwPort _port1 = ((HwConnection)object).getPort1();
            EObject _eContainer = null;
            if (_port1 != null) {
                _eContainer = _port1.eContainer();
            }
            String _name = null;
            if ((INamed)_eContainer != null) {
                _name = ((INamed)_eContainer).getName();
            }
            String cName1 = _name;
            HwPort _port2 = ((HwConnection)object).getPort2();
            EObject _eContainer_1 = null;
            if (_port2 != null) {
                _eContainer_1 = _port2.eContainer();
            }
            String _name_1 = null;
            if ((INamed)_eContainer_1 != null) {
                _name_1 = ((INamed)_eContainer_1).getName();
            }
            String cName2 = _name_1;
            String s1 = CustomItemProviderService.ppName(((HwConnection)object).getName(), "???");
            String s2 = CustomItemProviderService.ppName(cName1, "<module1>");
            HwPort _port1_1 = ((HwConnection)object).getPort1();
            String _name_2 = null;
            if (_port1_1 != null) {
                _name_2 = _port1_1.getName();
            }
            String s3 = CustomItemProviderService.ppName(_name_2, "<port1>");
            String s4 = CustomItemProviderService.ppName(cName2, "<module2>");
            HwPort _port2_1 = ((HwConnection)object).getPort2();
            String _name_3 = null;
            if (_port2_1 != null) {
                _name_3 = _port2_1.getName();
            }
            String s5 = CustomItemProviderService.ppName(_name_3, "<port2>");
            return String.valueOf(s1) + ": " + s2 + "_" + s3 + " --> " + s4 + "_" + s5;
        }
        return null;
    }

    public static ViewerNotification getHwConnectionItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(HwConnection.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getLatencyConstantItemProviderText(Object object, String defaultText) {
        if (object instanceof LatencyConstant) {
            String feature = CustomItemProviderService.getContainingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)feature, (Object)"value");
            _xifexpression = _equals ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            String s2 = Long.toString(((LatencyConstant)object).getCycles());
            return String.valueOf(s1) + "cycles (constant): " + s2;
        }
        return defaultText;
    }

    public static String getLatencyDeviationItemProviderText(Object object, String defaultText) {
        if (object instanceof LatencyDeviation) {
            String feature = CustomItemProviderService.getContainingFeatureName((EObject)object, "", "");
            String _xifexpression = null;
            boolean _equals = Objects.equal((Object)feature, (Object)"value");
            _xifexpression = _equals ? "" : String.valueOf(feature) + " -- ";
            String s1 = _xifexpression;
            Deviation _cycles = ((LatencyDeviation)object).getCycles();
            Distribution _distribution = null;
            if (_cycles != null) {
                _distribution = _cycles.getDistribution();
            }
            EClass _eClass = null;
            if (_distribution != null) {
                _eClass = _distribution.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String distName = _name;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)distName);
            _xifexpression_1 = _isNullOrEmpty ? "<distribution>" : CustomItemProviderService.trimDistName(distName);
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + "cycles (deviation): " + s2;
        }
        return defaultText;
    }

    public static String getMappingModelItemProviderText(Object object, String defaultText) {
        return "Mapping";
    }

    public static String getSchedulerAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof SchedulerAllocation) {
            Scheduler _scheduler = null;
            if ((SchedulerAllocation)object != null) {
                _scheduler = ((SchedulerAllocation)object).getScheduler();
            }
            String _name = null;
            if (_scheduler != null) {
                _name = _scheduler.getName();
            }
            String schedName = _name;
            EList _responsibility = null;
            if ((SchedulerAllocation)object != null) {
                _responsibility = ((SchedulerAllocation)object).getResponsibility();
            }
            EList cores = _responsibility;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)schedName);
            _xifexpression = _isNullOrEmpty ? "<scheduler>" : "Scheduler " + schedName;
            String s1 = _xifexpression;
            Functions.Function1 _function = e -> {
                String _name_1 = null;
                if (e != null) {
                    _name_1 = e.getName();
                }
                return CustomItemProviderService.ppName(_name_1);
            };
            String s2 = IterableExtensions.join((Iterable)ListExtensions.map((List)cores, (Functions.Function1)_function), (CharSequence)", ");
            return "Allocation: " + s1 + " -- Cores ( " + s2 + " )";
        }
        return defaultText;
    }

    public static ViewerNotification getSchedulerAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SchedulerAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getISRAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof ISRAllocation) {
            InterruptController _controller = null;
            if ((ISRAllocation)object != null) {
                _controller = ((ISRAllocation)object).getController();
            }
            String _name = null;
            if (_controller != null) {
                _name = _controller.getName();
            }
            String ctrlName = _name;
            ISR _isr = null;
            if ((ISRAllocation)object != null) {
                _isr = ((ISRAllocation)object).getIsr();
            }
            String _name_1 = null;
            if (_isr != null) {
                _name_1 = _isr.getName();
            }
            String isrName = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)ctrlName);
            _xifexpression = _isNullOrEmpty ? "<controller>" : "Controller " + ctrlName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)isrName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<isr>" : "ISR " + isrName;
            String s2 = _xifexpression_1;
            return "Allocation: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getISRAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ISRAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableAllocation) {
            Scheduler _scheduler = null;
            if ((RunnableAllocation)object != null) {
                _scheduler = ((RunnableAllocation)object).getScheduler();
            }
            String _name = null;
            if (_scheduler != null) {
                _name = _scheduler.getName();
            }
            String schedName = _name;
            Runnable _entity = null;
            if ((RunnableAllocation)object != null) {
                _entity = ((RunnableAllocation)object).getEntity();
            }
            String _name_1 = null;
            if (_entity != null) {
                _name_1 = _entity.getName();
            }
            String entityName = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)schedName);
            _xifexpression = _isNullOrEmpty ? "<scheduler>" : "Scheduler " + schedName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)entityName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<runnable>" : "Runnable " + entityName;
            String s2 = _xifexpression_1;
            return "Allocation: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getTaskAllocationItemProviderText(Object object, String defaultText) {
        if (object instanceof TaskAllocation) {
            TaskScheduler _scheduler = null;
            if ((TaskAllocation)object != null) {
                _scheduler = ((TaskAllocation)object).getScheduler();
            }
            String _name = null;
            if (_scheduler != null) {
                _name = _scheduler.getName();
            }
            String schedName = _name;
            Task _task = null;
            if ((TaskAllocation)object != null) {
                _task = ((TaskAllocation)object).getTask();
            }
            String _name_1 = null;
            if (_task != null) {
                _name_1 = _task.getName();
            }
            String taskName = _name_1;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)schedName);
            _xifexpression = _isNullOrEmpty ? "<scheduler>" : "Scheduler " + schedName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)taskName);
            _xifexpression_1 = _isNullOrEmpty_1 ? "<task>" : "Task " + taskName;
            String s2 = _xifexpression_1;
            return "Allocation: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getTaskAllocationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TaskAllocation.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)4)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)5)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, false);
            }
        }
        return null;
    }

    public static String getMemoryMappingItemProviderText(Object object, String defaultText) {
        if (object instanceof MemoryMapping) {
            boolean _isNullOrEmpty_1;
            Memory _memory = null;
            if ((MemoryMapping)object != null) {
                _memory = ((MemoryMapping)object).getMemory();
            }
            String _name = null;
            if (_memory != null) {
                _name = _memory.getName();
            }
            String memName = _name;
            AbstractMemoryElement _abstractElement = null;
            if ((MemoryMapping)object != null) {
                _abstractElement = ((MemoryMapping)object).getAbstractElement();
            }
            AbstractMemoryElement elem = _abstractElement;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)memName);
            _xifexpression = _isNullOrEmpty ? "<memory>" : "Memory " + memName;
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            String _name_1 = null;
            if (elem != null) {
                _name_1 = elem.getName();
            }
            if (_isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(_name_1)) {
                _xifexpression_1 = "<element>";
            } else {
                String _name_2 = elem.eClass().getName();
                String _plus = String.valueOf(_name_2) + " ";
                String _name_3 = elem.getName();
                _xifexpression_1 = String.valueOf(_plus) + _name_3;
            }
            String s2 = _xifexpression_1;
            return "Mapping: " + s1 + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getMemoryMappingItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(MemoryMapping.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getPhysicalSectionMappingItemProviderText(Object object, String defaultText) {
        if (object instanceof PhysicalSectionMapping) {
            boolean _not;
            boolean _isNullOrEmpty;
            Memory _memory = null;
            if ((PhysicalSectionMapping)object != null) {
                _memory = ((PhysicalSectionMapping)object).getMemory();
            }
            Memory memory = _memory;
            EList _origin = null;
            if ((PhysicalSectionMapping)object != null) {
                _origin = ((PhysicalSectionMapping)object).getOrigin();
            }
            EList sections = _origin;
            String _xifexpression = null;
            String _name = null;
            if (memory != null) {
                _name = memory.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<memory>";
            } else {
                String _name_1 = memory.getName();
                _xifexpression = "Memory :  " + _name_1;
            }
            String memoryString = _xifexpression;
            ArrayList sectionNames = new ArrayList();
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)sections);
            boolean bl = _not = !_isNullOrEmpty_1;
            if (_not) {
                Consumer<Section> _function = it -> {
                    boolean _isNullOrEmpty_2;
                    String _xifexpression_1 = null;
                    String _name_2 = null;
                    if (it != null) {
                        _name_2 = it.getName();
                    }
                    _xifexpression_1 = (_isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(_name_2)) ? "???" : it.getName();
                    String st = _xifexpression_1;
                    sectionNames.add(st);
                };
                sections.forEach(_function);
            }
            String _xifexpression_1 = null;
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty(sectionNames);
            if (_isNullOrEmpty_2) {
                _xifexpression_1 = "<sections>";
            } else {
                boolean _greaterThan;
                String _xifexpression_2 = null;
                int _size = sectionNames.size();
                boolean bl2 = _greaterThan = _size > 10;
                if (_greaterThan) {
                    String _join = IterableExtensions.join(sectionNames.subList(0, 10), (CharSequence)", ");
                    String _plus = " Sections : " + _join;
                    _xifexpression_2 = String.valueOf(_plus) + ", ...";
                } else {
                    String _join_1 = IterableExtensions.join(sectionNames, (CharSequence)", ");
                    _xifexpression_2 = " Sections : " + _join_1;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            String sectionsString = _xifexpression_1;
            String _name_2 = null;
            if ((PhysicalSectionMapping)object != null) {
                _name_2 = ((PhysicalSectionMapping)object).getName();
            }
            String s0 = CustomItemProviderService.ppName(_name_2, "<name>");
            return String.valueOf(s0) + " : (" + sectionsString + ")" + " --> (" + memoryString + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getPhysicalSectionMappingItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(PhysicalSectionMapping.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_2 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_2, true, false);
        }
        return null;
    }

    public static String getOsDataConsistencyItemProviderText(Object object, String defaultText) {
        if (object instanceof OsDataConsistency) {
            OsDataConsistencyMode mode = ((OsDataConsistency)object).getMode();
            String _xifexpression = null;
            _xifexpression = mode == null || Objects.equal((Object)mode, (Object)OsDataConsistencyMode._UNDEFINED_) ? "?" : mode.getLiteral();
            String s2 = _xifexpression;
            return "OS Data Consistency - " + s2;
        }
        return defaultText;
    }

    public static String getDataStabilityItemProviderText(Object object, String defaultText) {
        if (object instanceof DataStability) {
            String _string = Boolean.valueOf(((DataStability)object).isEnabled()).toString();
            return "OS Data Stability - enabled: " + _string;
        }
        return defaultText;
    }

    public static String getNonAtomicDataCoherencyItemProviderText(Object object, String defaultText) {
        if (object instanceof NonAtomicDataCoherency) {
            String _string = Boolean.valueOf(((NonAtomicDataCoherency)object).isEnabled()).toString();
            return "OS Data Coherency - enabled: " + _string;
        }
        return defaultText;
    }

    public static String getOsInstructionsItemProviderText(Object object, String defaultText) {
        if (object instanceof OsInstructions) {
            String name = ((OsInstructions)object).getName();
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
            _xifexpression = _isNullOrEmpty ? "OS Instructions" : name;
            String s1 = _xifexpression;
            return s1;
        }
        return defaultText;
    }

    public static String getOsAPIInstructionsItemProviderText(Object object, String defaultText) {
        if (object instanceof OsAPIInstructions) {
            return CustomItemProviderService.getContainingFeatureName((EObject)object, "API Instructions", "");
        }
        return defaultText;
    }

    public static String getOsISRInstructionsItemProviderText(Object object, String defaultText) {
        if (object instanceof OsISRInstructions) {
            EStructuralFeature _eContainingFeature = null;
            if ((OsISRInstructions)object != null) {
                _eContainingFeature = ((OsISRInstructions)object).eContainingFeature();
            }
            EStructuralFeature feature = _eContainingFeature;
            String _xifexpression = null;
            _xifexpression = feature == null ? "" : feature.getName();
            String s1 = _xifexpression;
            return s1;
        }
        return defaultText;
    }

    public static String getSchedulingParametersItemProviderText(Object object, String defaultText) {
        if (object instanceof SchedulingParameters) {
            return "Parameters (Scheduling)";
        }
        return defaultText;
    }

    public static String getProcessPrototypeAllocationConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessPrototypeAllocationConstraint) {
            ProcessPrototype _processPrototype = null;
            if ((ProcessPrototypeAllocationConstraint)object != null) {
                _processPrototype = ((ProcessPrototypeAllocationConstraint)object).getProcessPrototype();
            }
            String _name = null;
            if (_processPrototype != null) {
                _name = _processPrototype.getName();
            }
            String name = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
            _xifexpression = _isNullOrEmpty ? "<process prototype>" : "Prototype " + name;
            String s1 = _xifexpression;
            return "Constraint allocation of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessPrototypeAllocationConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessPrototypeAllocationConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getProcessAllocationConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof ProcessAllocationConstraint) {
            boolean _isNullOrEmpty;
            Process _process = null;
            if ((ProcessAllocationConstraint)object != null) {
                _process = ((ProcessAllocationConstraint)object).getProcess();
            }
            Process proc = _process;
            String _xifexpression = null;
            String _name = null;
            if (proc != null) {
                _name = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<process>";
            } else {
                String _name_1 = proc.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "Constraint allocation of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getProcessAllocationConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ProcessAllocationConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableAllocationConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableAllocationConstraint) {
            Runnable _runnable = null;
            if ((RunnableAllocationConstraint)object != null) {
                _runnable = ((RunnableAllocationConstraint)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)runName);
            _xifexpression = _isNullOrEmpty ? "<runnable>" : "Runnable " + runName;
            String s1 = _xifexpression;
            return "Constraint allocation of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableAllocationConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableAllocationConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getCoreClassificationItemProviderText(Object object, String defaultText) {
        if (object instanceof CoreClassification) {
            Condition _condition = null;
            if ((CoreClassification)object != null) {
                _condition = ((CoreClassification)object).getCondition();
            }
            Condition con = _condition;
            GroupingType _grouping = null;
            if ((CoreClassification)object != null) {
                _grouping = ((CoreClassification)object).getGrouping();
            }
            GroupingType grp = _grouping;
            EList _classifiers = null;
            if ((CoreClassification)object != null) {
                _classifiers = ((CoreClassification)object).getClassifiers();
            }
            EList cla = _classifiers;
            String _xifexpression = null;
            _xifexpression = con == null || Objects.equal((Object)con, (Object)Condition._UNDEFINED_) ? "<condition>" : con.getLiteral();
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = grp == null || Objects.equal((Object)grp, (Object)GroupingType._UNDEFINED_) ? "<grouping>" : CustomItemProviderService.ppCamelCase(grp.getLiteral()).toLowerCase();
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)cla);
            if (_isNullOrEmpty) {
                _xifexpression_2 = "<classifiers>";
            } else {
                Functions.Function1 _function = e -> {
                    String _name = null;
                    if (e != null) {
                        _name = e.getName();
                    }
                    return CustomItemProviderService.ppName(_name);
                };
                _xifexpression_2 = IterableExtensions.join((Iterable)ListExtensions.map((List)cla, (Functions.Function1)_function), (CharSequence)", ");
            }
            String s3 = _xifexpression_2;
            return String.valueOf(s1) + " (" + s2 + "): " + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getCoreClassificationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(CoreClassification.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getAbstractElementMappingConstraintItemProviderText(Object object, String defaultText) {
        if (object instanceof AbstractElementMappingConstraint) {
            boolean _isNullOrEmpty;
            AbstractMemoryElement _abstractElement = null;
            if ((AbstractElementMappingConstraint)object != null) {
                _abstractElement = ((AbstractElementMappingConstraint)object).getAbstractElement();
            }
            AbstractMemoryElement elem = _abstractElement;
            String _xifexpression = null;
            String _name = null;
            if (elem != null) {
                _name = elem.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<element>";
            } else {
                String _name_1 = elem.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = elem.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "Constraint mapping of " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getAbstractElementMappingConstraintItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(AbstractElementMappingConstraint.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getMemoryClassificationItemProviderText(Object object, String defaultText) {
        if (object instanceof MemoryClassification) {
            Condition _condition = null;
            if ((MemoryClassification)object != null) {
                _condition = ((MemoryClassification)object).getCondition();
            }
            Condition con = _condition;
            GroupingType _grouping = null;
            if ((MemoryClassification)object != null) {
                _grouping = ((MemoryClassification)object).getGrouping();
            }
            GroupingType grp = _grouping;
            EList _classifiers = null;
            if ((MemoryClassification)object != null) {
                _classifiers = ((MemoryClassification)object).getClassifiers();
            }
            EList cla = _classifiers;
            String _xifexpression = null;
            _xifexpression = con == null || Objects.equal((Object)con, (Object)Condition._UNDEFINED_) ? "<condition>" : con.getLiteral();
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = grp == null || Objects.equal((Object)grp, (Object)GroupingType._UNDEFINED_) ? "<grouping>" : CustomItemProviderService.ppCamelCase(grp.getLiteral()).toLowerCase();
            String s2 = _xifexpression_1;
            String _xifexpression_2 = null;
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)cla);
            if (_isNullOrEmpty) {
                _xifexpression_2 = "<classifiers>";
            } else {
                Functions.Function1 _function = e -> {
                    String _name = null;
                    if (e != null) {
                        _name = e.getName();
                    }
                    return CustomItemProviderService.ppName(_name);
                };
                _xifexpression_2 = IterableExtensions.join((Iterable)ListExtensions.map((List)cla, (Functions.Function1)_function), (CharSequence)", ");
            }
            String s3 = _xifexpression_2;
            return String.valueOf(s1) + " (" + s2 + "): " + s3;
        }
        return defaultText;
    }

    public static ViewerNotification getMemoryClassificationItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(MemoryClassification.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeValueListItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeValueList) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + defaultText;
        }
        return defaultText;
    }

    public static String getModeValueDisjunctionItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeValueDisjunction) {
            String _containingFeatureName = CustomItemProviderService.getContainingFeatureName((EObject)object);
            return String.valueOf(_containingFeatureName) + "OR";
        }
        return defaultText;
    }

    public static String getModeValueConjunctionItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeValueConjunction) {
            return "AND";
        }
        return defaultText;
    }

    public static String getModeValueItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeValue) {
            boolean _isNullOrEmpty;
            ModeLabel _valueProvider = null;
            if ((ModeValue)object != null) {
                _valueProvider = ((ModeValue)object).getValueProvider();
            }
            ModeLabel prov = _valueProvider;
            ModeLiteral _value = null;
            if ((ModeValue)object != null) {
                _value = ((ModeValue)object).getValue();
            }
            ModeLiteral value = _value;
            String _xifexpression = null;
            EObject _eContainer = null;
            if ((ModeValue)object != null) {
                _eContainer = ((ModeValue)object).eContainer();
            }
            _xifexpression = _eContainer instanceof ModeValueList ? " <- " : " == ";
            String relation = _xifexpression;
            String _xifexpression_1 = null;
            String _name = null;
            if (prov != null) {
                _name = prov.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression_1 = "<mode label>";
            } else {
                String _name_1 = prov.getName();
                _xifexpression_1 = "Mode Label " + _name_1;
            }
            String s1 = _xifexpression_1;
            String _xifexpression_2 = null;
            _xifexpression_2 = value == null ? "<value>" : value.toString();
            String s2 = _xifexpression_2;
            return String.valueOf(s1) + relation + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getModeValueItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeValueImpl.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getArrivalCurveEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof ArrivalCurveEntry) {
            int _xifexpression = 0;
            _xifexpression = object == null ? 0 : ((ArrivalCurveEntry)object).getNumberOfOccurrences();
            int num = _xifexpression;
            Time _lowerTimeBorder = null;
            if ((ArrivalCurveEntry)object != null) {
                _lowerTimeBorder = ((ArrivalCurveEntry)object).getLowerTimeBorder();
            }
            String s1 = CustomItemProviderService.getTimeText(_lowerTimeBorder);
            Time _upperTimeBorder = null;
            if ((ArrivalCurveEntry)object != null) {
                _upperTimeBorder = ((ArrivalCurveEntry)object).getUpperTimeBorder();
            }
            String s2 = CustomItemProviderService.getTimeText(_upperTimeBorder);
            return "#occurrences: " + Integer.valueOf(num) + " -- interval: " + s1 + ", " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getArrivalCurveEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ArrivalCurveEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched) {
            if (Objects.equal((Object)_featureID, (Object)2)) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
                _matched = true;
            }
            if (_matched) {
                Object _notifier_1 = notification.getNotifier();
                return new ViewerNotification(notification, _notifier_1, true, true);
            }
        }
        return null;
    }

    private static String getRunnableItemText(RunnableItem item) {
        String _switchResult = null;
        boolean _matched = false;
        if (item instanceof LabelAccess) {
            _matched = true;
            _switchResult = CustomItemProviderService.getLabelAccessItemProviderText(item, null);
        }
        if (!_matched && item instanceof RunnableCall) {
            _matched = true;
            _switchResult = CustomItemProviderService.getRunnableCallItemProviderText(item, null);
        }
        if (!_matched && item instanceof ExecutionNeed) {
            _matched = true;
            _switchResult = "Execution Need";
        }
        if (!_matched && item instanceof Group) {
            _matched = true;
            _switchResult = CustomItemProviderService.getGroupItemProviderText(item, null);
        }
        if (!_matched && item instanceof RunnableModeSwitch) {
            _matched = true;
            _switchResult = CustomItemProviderService.getRunnableModeSwitchItemProviderText(item, null);
        }
        if (!_matched && item instanceof RunnableProbabilitySwitch) {
            _matched = true;
            _switchResult = "Probability Switch";
        }
        if (!_matched && item instanceof ModeLabelAccess) {
            _matched = true;
            _switchResult = CustomItemProviderService.getModeLabelAccessItemProviderText(item, null);
        }
        if (!_matched && item instanceof SemaphoreAccess) {
            _matched = true;
            _switchResult = CustomItemProviderService.getSemaphoreAccessItemProviderText(item, null);
        }
        if (!_matched && item instanceof SenderReceiverRead) {
            _matched = true;
            _switchResult = CustomItemProviderService.getSenderReceiverReadItemProviderText(item, null);
        }
        if (!_matched && item instanceof SenderReceiverWrite) {
            _matched = true;
            _switchResult = CustomItemProviderService.getSenderReceiverWriteItemProviderText(item, null);
        }
        if (!_matched && item instanceof AsynchronousServerCall) {
            _matched = true;
            _switchResult = CustomItemProviderService.getAsynchronousServerCallItemProviderText(item, null);
        }
        if (!_matched && item instanceof SynchronousServerCall) {
            _matched = true;
            _switchResult = CustomItemProviderService.getSynchronousServerCallItemProviderText(item, null);
        }
        return _switchResult;
    }

    public static String getAccessPrecedenceSpecItemProviderText(Object object, String defaultText) {
        if (object instanceof AccessPrecedenceSpec) {
            Runnable _origin = null;
            if ((AccessPrecedenceSpec)object != null) {
                _origin = ((AccessPrecedenceSpec)object).getOrigin();
            }
            String _name = null;
            if (_origin != null) {
                _name = _origin.getName();
            }
            String originName = _name;
            Runnable _target = null;
            if ((AccessPrecedenceSpec)object != null) {
                _target = ((AccessPrecedenceSpec)object).getTarget();
            }
            String _name_1 = null;
            if (_target != null) {
                _name_1 = _target.getName();
            }
            String targetName = _name_1;
            Label _label = null;
            if ((AccessPrecedenceSpec)object != null) {
                _label = ((AccessPrecedenceSpec)object).getLabel();
            }
            String _name_2 = null;
            if (_label != null) {
                _name_2 = _label.getName();
            }
            String labelName = _name_2;
            AccessPrecedenceType _orderType = null;
            if ((AccessPrecedenceSpec)object != null) {
                _orderType = ((AccessPrecedenceSpec)object).getOrderType();
            }
            AccessPrecedenceType accessType = _orderType;
            String s1 = CustomItemProviderService.ppName(originName, "<runnable>");
            String s2 = CustomItemProviderService.ppName(targetName, "<runnable>");
            String s3 = CustomItemProviderService.ppName(labelName, "<label>");
            String _xifexpression = null;
            _xifexpression = accessType == null || Objects.equal((Object)accessType, (Object)AccessPrecedenceType._UNDEFINED_) ? "<access>" : accessType.getLiteral();
            String s4 = _xifexpression;
            return "Spec: " + s1 + " --> " + s2 + " (" + s3 + " : " + s4 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getAccessPrecedenceSpecItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(AccessPrecedenceSpec.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)4)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getOrderPrecedenceSpecItemProviderText(Object object, String defaultText) {
        if (object instanceof OrderPrecedenceSpec) {
            Runnable _origin = null;
            if ((OrderPrecedenceSpec)object != null) {
                _origin = ((OrderPrecedenceSpec)object).getOrigin();
            }
            String _name = null;
            if (_origin != null) {
                _name = _origin.getName();
            }
            String originName = _name;
            Runnable _target = null;
            if ((OrderPrecedenceSpec)object != null) {
                _target = ((OrderPrecedenceSpec)object).getTarget();
            }
            String _name_1 = null;
            if (_target != null) {
                _name_1 = _target.getName();
            }
            String targetName = _name_1;
            OrderType _orderType = null;
            if ((OrderPrecedenceSpec)object != null) {
                _orderType = ((OrderPrecedenceSpec)object).getOrderType();
            }
            OrderType order = _orderType;
            String s1 = CustomItemProviderService.ppName(originName, "<runnable>");
            String s2 = CustomItemProviderService.ppName(targetName, "<runnable>");
            String _xifexpression = null;
            _xifexpression = order == null || Objects.equal((Object)order, (Object)OrderType._UNDEFINED_) ? "<order>" : order.getLiteral();
            String s3 = _xifexpression;
            return "Spec: " + s1 + " --> " + s2 + " (" + s3 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getOrderPrecedenceSpecItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(OrderPrecedenceSpec.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getAsynchronousServerCallItemProviderText(Object object, String defaultText) {
        if (object instanceof AsynchronousServerCall) {
            Runnable _serverRunnable = null;
            if ((AsynchronousServerCall)object != null) {
                _serverRunnable = ((AsynchronousServerCall)object).getServerRunnable();
            }
            String _name = null;
            if (_serverRunnable != null) {
                _name = _serverRunnable.getName();
            }
            String serverRun = _name;
            Runnable _resultRunnable = null;
            if ((AsynchronousServerCall)object != null) {
                _resultRunnable = ((AsynchronousServerCall)object).getResultRunnable();
            }
            String _name_1 = null;
            if (_resultRunnable != null) {
                _name_1 = _resultRunnable.getName();
            }
            String resultRun = _name_1;
            String s1 = CustomItemProviderService.ppName(serverRun, "<runnable>");
            String s2 = CustomItemProviderService.ppName(resultRun, "<runnable>");
            return "call server: " + s1 + " (async - result: " + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getAsynchronousServerCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(AsynchronousServerCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSynchronousServerCallItemProviderText(Object object, String defaultText) {
        if (object instanceof SynchronousServerCall) {
            Runnable _serverRunnable = null;
            if ((SynchronousServerCall)object != null) {
                _serverRunnable = ((SynchronousServerCall)object).getServerRunnable();
            }
            String _name = null;
            if (_serverRunnable != null) {
                _name = _serverRunnable.getName();
            }
            String serverRun = _name;
            WaitingBehaviour _waitingBehaviour = null;
            if ((SynchronousServerCall)object != null) {
                _waitingBehaviour = ((SynchronousServerCall)object).getWaitingBehaviour();
            }
            WaitingBehaviour waiting = _waitingBehaviour;
            String s1 = CustomItemProviderService.ppName(serverRun, "<runnable>");
            String _xifexpression = null;
            _xifexpression = waiting == null || Objects.equal((Object)waiting, (Object)WaitingBehaviour._UNDEFINED_) ? "undefined" : waiting.getLiteral();
            String s2 = _xifexpression;
            return "call server: " + s1 + " (sync - " + s2 + " waiting)";
        }
        return defaultText;
    }

    public static ViewerNotification getSynchronousServerCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SynchronousServerCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getGetResultServerCallItemProviderText(Object object, String defaultText) {
        if (object instanceof GetResultServerCall) {
            Runnable _serverRunnable = null;
            if ((GetResultServerCall)object != null) {
                _serverRunnable = ((GetResultServerCall)object).getServerRunnable();
            }
            String _name = null;
            if (_serverRunnable != null) {
                _name = _serverRunnable.getName();
            }
            String serverRun = _name;
            BlockingType _blockingType = null;
            if ((GetResultServerCall)object != null) {
                _blockingType = ((GetResultServerCall)object).getBlockingType();
            }
            BlockingType blocking = _blockingType;
            String s1 = CustomItemProviderService.ppName(serverRun, "<runnable>");
            String _xifexpression = null;
            _xifexpression = blocking == null || Objects.equal((Object)blocking, (Object)BlockingType._UNDEFINED_) ? "undefined" : blocking.getLiteral().replace("_", " ");
            String s2 = _xifexpression;
            return "call server: " + s1 + " (get result - " + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getGetResultServerCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(GetResultServerCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getChainedProcessPrototypeItemProviderText(Object object, String defaultText) {
        if (object instanceof ChainedProcessPrototype) {
            ProcessPrototype _prototype = null;
            if ((ChainedProcessPrototype)object != null) {
                _prototype = ((ChainedProcessPrototype)object).getPrototype();
            }
            String _name = null;
            if (_prototype != null) {
                _name = _prototype.getName();
            }
            String proto = _name;
            int _xifexpression = 0;
            _xifexpression = object == null ? 0 : ((ChainedProcessPrototype)object).getApply();
            int apply = _xifexpression;
            int _xifexpression_1 = 0;
            _xifexpression_1 = object == null ? 0 : ((ChainedProcessPrototype)object).getOffset();
            int offset = _xifexpression_1;
            String s1 = CustomItemProviderService.ppName(proto, "<process prototype>");
            return "Chained Prototype " + s1 + " ( apply: " + Integer.valueOf(apply) + " offset: " + Integer.valueOf(offset) + " )";
        }
        return defaultText;
    }

    public static ViewerNotification getChainedProcessPrototypeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ChainedProcessPrototype.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getGroupItemProviderText(Object object, String defaultText) {
        if (object instanceof Group) {
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)((Group)object).getName());
            _xifexpression = _isNullOrEmpty ? null : ((Group)object).getName();
            String name = _xifexpression;
            boolean _xifexpression_1 = false;
            _xifexpression_1 = object == null ? false : ((Group)object).isOrdered();
            boolean ordered = _xifexpression_1;
            String _xifexpression_2 = null;
            _xifexpression_2 = ordered ? "(Sequence)" : "(Set)";
            String result = _xifexpression_2;
            String _xifexpression_3 = null;
            _xifexpression_3 = name == null ? result : String.valueOf(result) + " " + name;
            return _xifexpression_3;
        }
        return null;
    }

    public static String getGroupItemProviderImageName(Object object, String defaultName) {
        if (object instanceof Group) {
            boolean _xifexpression = false;
            _xifexpression = object == null ? false : ((Group)object).isOrdered();
            boolean ordered = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = ordered ? "ordered" : "unordered";
            return "Group_" + _xifexpression_1;
        }
        return defaultName;
    }

    public static String getInterProcessTriggerItemProviderText(Object object, String defaultText) {
        if (object instanceof InterProcessTrigger) {
            InterProcessStimulus _stimulus = null;
            if ((InterProcessTrigger)object != null) {
                _stimulus = ((InterProcessTrigger)object).getStimulus();
            }
            String _name = null;
            if (_stimulus != null) {
                _name = _stimulus.getName();
            }
            String stimulusName = _name;
            String s1 = CustomItemProviderService.ppName(stimulusName, "<stimulus>");
            return "trigger " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getInterProcessTriggerItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(InterProcessTrigger.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static ViewerNotification getModeItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Mode.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, true);
        }
        return null;
    }

    public static String getModeLiteralItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLiteral) {
            return ((ModeLiteral)object).toString();
        }
        return defaultText;
    }

    public static String getModeLabelItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLabel) {
            String name = ((ModeLabel)object).getName();
            Mode _mode = ((ModeLabel)object).getMode();
            String _name = null;
            if (_mode != null) {
                _name = _mode.getName();
            }
            String modeName = _name;
            String s1 = CustomItemProviderService.ppName(name, "<mode label>");
            String s2 = CustomItemProviderService.ppName(modeName, "<mode>");
            return String.valueOf(s1) + " (" + s2 + ")";
        }
        return defaultText;
    }

    public static ViewerNotification getModeLabelItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeLabel.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)7)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)8)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeSwitchItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeSwitch) {
            return "Mode Switch";
        }
        return defaultText;
    }

    public static ViewerNotification getModeSwitchItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeSwitch.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, false);
        }
        return null;
    }

    public static String getRunnableModeSwitchItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableModeSwitch) {
            return "Mode Switch";
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableModeSwitchItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableModeSwitch.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, false);
        }
        return null;
    }

    public static String getModeSwitchEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeSwitchEntry) {
            String _name = null;
            if ((ModeSwitchEntry)object != null) {
                _name = ((ModeSwitchEntry)object).getName();
            }
            String entryName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)entryName);
            _xifexpression = _isNullOrEmpty ? "_" : "\"" + entryName + "\"";
            String s1 = _xifexpression;
            return "case: " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getModeSwitchEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeSwitchEntry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, true, false);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, false, true);
        }
        return null;
    }

    public static String getModeSwitchDefaultItemProviderText(Object object, String defaultText) {
        return "default";
    }

    public static String getTaskRunnableCallItemProviderText(Object object, String defaultText) {
        if (object instanceof TaskRunnableCall) {
            Runnable _runnable = null;
            if ((TaskRunnableCall)object != null) {
                _runnable = ((TaskRunnableCall)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String s1 = CustomItemProviderService.ppName(runName, "<runnable>");
            return "call " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getTaskRunnableCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TaskRunnableCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getLabelAccessItemProviderText(Object object, String defaultText) {
        if (object instanceof LabelAccess) {
            LabelAccessEnum _access = null;
            if ((LabelAccess)object != null) {
                _access = ((LabelAccess)object).getAccess();
            }
            LabelAccessEnum access = _access;
            Label _data = null;
            if ((LabelAccess)object != null) {
                _data = ((LabelAccess)object).getData();
            }
            String _name = null;
            if (_data != null) {
                _name = _data.getName();
            }
            String labelName = _name;
            String _xifexpression = null;
            _xifexpression = access == null || Objects.equal((Object)access, (Object)LabelAccessEnum._UNDEFINED_) ? "<access>" : access.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.ppName(labelName, "<label>");
            return String.valueOf(s1) + " " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getLabelAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(LabelAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static ViewerNotification getChannelAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ChannelAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)3)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getChannelReceiveItemProviderText(Object object, String defaultText) {
        if (object instanceof ChannelReceive) {
            Channel _data = null;
            if ((ChannelReceive)object != null) {
                _data = ((ChannelReceive)object).getData();
            }
            String _name = null;
            if (_data != null) {
                _name = _data.getName();
            }
            String data = _name;
            String s1 = CustomItemProviderService.ppName(data, "<channel>");
            return "receive from " + s1;
        }
        return defaultText;
    }

    public static String getChannelSendItemProviderText(Object object, String defaultText) {
        if (object instanceof ChannelSend) {
            Channel _data = null;
            if ((ChannelSend)object != null) {
                _data = ((ChannelSend)object).getData();
            }
            String _name = null;
            if (_data != null) {
                _name = _data.getName();
            }
            String data = _name;
            String s1 = CustomItemProviderService.ppName(data, "<channel>");
            return "send to " + s1;
        }
        return defaultText;
    }

    public static String getSemaphoreAccessItemProviderText(Object object, String defaultText) {
        if (object instanceof SemaphoreAccess) {
            SemaphoreAccessEnum _access = null;
            if ((SemaphoreAccess)object != null) {
                _access = ((SemaphoreAccess)object).getAccess();
            }
            SemaphoreAccessEnum access = _access;
            Semaphore _semaphore = null;
            if ((SemaphoreAccess)object != null) {
                _semaphore = ((SemaphoreAccess)object).getSemaphore();
            }
            String _name = null;
            if (_semaphore != null) {
                _name = _semaphore.getName();
            }
            String semName = _name;
            String _xifexpression = null;
            _xifexpression = access == null || Objects.equal((Object)access, (Object)SemaphoreAccessEnum._UNDEFINED_) ? "<access>" : access.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.ppName(semName, "<semaphore>");
            return String.valueOf(s1) + " " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getSemaphoreAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SemaphoreAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getModeLabelAccessItemProviderText(Object object, String defaultText) {
        if (object instanceof ModeLabelAccess) {
            LabelAccessEnum _access = null;
            if ((ModeLabelAccess)object != null) {
                _access = ((ModeLabelAccess)object).getAccess();
            }
            LabelAccessEnum access = _access;
            ModeLabel _data = null;
            if ((ModeLabelAccess)object != null) {
                _data = ((ModeLabelAccess)object).getData();
            }
            String _name = null;
            if (_data != null) {
                _name = _data.getName();
            }
            String label = _name;
            String _xifexpression = null;
            _xifexpression = access == null || Objects.equal((Object)access, (Object)LabelAccessEnum._UNDEFINED_) ? "<access>" : access.getLiteral();
            String s1 = _xifexpression;
            String s2 = CustomItemProviderService.ppName(label, "<mode label>");
            return String.valueOf(s1) + " " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getModeLabelAccessItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(ModeLabelAccess.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
        }
        if (_matched) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getExecutionNeedExtendedItemProviderText(Object object, String defaultText) {
        if (object instanceof ExecutionNeedExtendedImpl) {
            ProcessingUnitDefinition _key = null;
            if ((ExecutionNeedExtendedImpl)object != null) {
                _key = ((ExecutionNeedExtendedImpl)object).getKey();
            }
            String _name = null;
            if (_key != null) {
                _name = _key.getName();
            }
            String typeName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)typeName);
            _xifexpression = _isNullOrEmpty ? "<core type>" : typeName;
            String s1 = _xifexpression;
            return String.valueOf(s1) + " -- " + "Needs (Map)";
        }
        return defaultText;
    }

    public static ViewerNotification getExecutionNeedExtendedItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getNeedEntryItemProviderText(Object object, String defaultText) {
        if (object instanceof NeedEntryImpl) {
            String _key = null;
            if ((NeedEntryImpl)object != null) {
                _key = ((NeedEntryImpl)object).getKey();
            }
            String featureName = _key;
            Need _value = null;
            if ((NeedEntryImpl)object != null) {
                _value = ((NeedEntryImpl)object).getValue();
            }
            Need need = _value;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)featureName);
            _xifexpression = _isNullOrEmpty ? "<feature>" : "Feature \"" + featureName + "\"";
            String s1 = _xifexpression;
            String _xifexpression_1 = null;
            _xifexpression_1 = need == null ? "<need>" : CustomItemProviderService.getNeedText(need);
            String s2 = _xifexpression_1;
            return String.valueOf(s1) + " -- " + s2;
        }
        return defaultText;
    }

    public static ViewerNotification getNeedEntryItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(Map.Entry.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)0)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, true);
        }
        return null;
    }

    public static String getRunnableCallItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableCall) {
            Runnable _runnable = null;
            if ((RunnableCall)object != null) {
                _runnable = ((RunnableCall)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String s1 = CustomItemProviderService.ppName(runName, "<runnable>");
            return "call " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableCallItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableCall.class);
        boolean _matched = false;
        if (Objects.equal((Object)_featureID, (Object)1)) {
            _matched = true;
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        if (!_matched && Objects.equal((Object)_featureID, (Object)2)) {
            _matched = true;
            Object _notifier_1 = notification.getNotifier();
            return new ViewerNotification(notification, _notifier_1, true, false);
        }
        return null;
    }

    public static String getCustomEventTriggerItemProviderText(Object object, String defaultText) {
        if (object instanceof CustomEventTrigger) {
            CustomEvent _event = null;
            if ((CustomEventTrigger)object != null) {
                _event = ((CustomEventTrigger)object).getEvent();
            }
            String _name = null;
            if (_event != null) {
                _name = _event.getName();
            }
            String eventName = _name;
            String s1 = CustomItemProviderService.ppName(eventName, "<custom event>");
            return "trigger " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getCustomEventTriggerItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(CustomEventTrigger.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSenderReceiverReadItemProviderText(Object object, String defaultText) {
        if (object instanceof SenderReceiverRead) {
            Label _label = null;
            if ((SenderReceiverRead)object != null) {
                _label = ((SenderReceiverRead)object).getLabel();
            }
            String _name = null;
            if (_label != null) {
                _name = _label.getName();
            }
            String labelName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)labelName);
            _xifexpression = _isNullOrEmpty ? "<label>" : "Label " + labelName;
            String s1 = _xifexpression;
            return "Sender Receiver - Read " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSenderReceiverReadItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SenderReceiverRead.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSenderReceiverWriteItemProviderText(Object object, String defaultText) {
        if (object instanceof SenderReceiverWrite) {
            Label _label = null;
            if ((SenderReceiverWrite)object != null) {
                _label = ((SenderReceiverWrite)object).getLabel();
            }
            String _name = null;
            if (_label != null) {
                _name = _label.getName();
            }
            String labelName = _name;
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)labelName);
            _xifexpression = _isNullOrEmpty ? "<label>" : "Label " + labelName;
            String s1 = _xifexpression;
            return "Sender Receiver - Write " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSenderReceiverWriteItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SenderReceiverWrite.class);
        if (Objects.equal((Object)_featureID, (Object)2)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getSetEventItemProviderText(Object object, String defaultText) {
        if (object instanceof SetEvent) {
            boolean _isNullOrEmpty;
            Process _process = null;
            if ((SetEvent)object != null) {
                _process = ((SetEvent)object).getProcess();
            }
            Process proc = _process;
            String _xifexpression = null;
            String _name = null;
            if (proc != null) {
                _name = proc.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                _xifexpression = "<process>";
            } else {
                String _name_1 = proc.eClass().getName();
                String _plus = String.valueOf(_name_1) + " ";
                String _name_2 = proc.getName();
                _xifexpression = String.valueOf(_plus) + _name_2;
            }
            String s1 = _xifexpression;
            return "SetEvent " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getSetEventItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(SetEvent.class);
        if (Objects.equal((Object)_featureID, (Object)3)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getWaitEventItemProviderText(Object object, String defaultText) {
        if (object instanceof WaitEvent) {
            WaitingBehaviour _waitingBehaviour = null;
            if ((WaitEvent)object != null) {
                _waitingBehaviour = ((WaitEvent)object).getWaitingBehaviour();
            }
            WaitingBehaviour waiting = _waitingBehaviour;
            String _xifexpression = null;
            _xifexpression = waiting == null || Objects.equal((Object)waiting, (Object)WaitingBehaviour._UNDEFINED_) ? "<waiting>" : waiting.getLiteral();
            String s1 = _xifexpression;
            return "WaitEvent " + s1;
        }
        return defaultText;
    }

    public static String getClearEventItemProviderText(Object object, String defaultText) {
        if (object instanceof ClearEvent) {
            return "ClearEvent";
        }
        return defaultText;
    }

    public static String getBaseTypeDefinitionItemProviderText(Object object, String defaultText) {
        if (object instanceof BaseTypeDefinition) {
            String _name = null;
            if ((BaseTypeDefinition)object != null) {
                _name = ((BaseTypeDefinition)object).getName();
            }
            String name = _name;
            String s1 = CustomItemProviderService.ppName(name, "<type definition>");
            return "BaseType " + s1;
        }
        return defaultText;
    }

    public static String getTypeDefinitionItemProviderText(Object object, String defaultText) {
        if (object instanceof TypeDefinition) {
            String _name = null;
            if ((TypeDefinition)object != null) {
                _name = ((TypeDefinition)object).getName();
            }
            String name = _name;
            String s1 = CustomItemProviderService.ppName(name, "<type definition>");
            return "Type " + s1;
        }
        return defaultText;
    }

    public static String getTypeRefItemProviderText(Object object, String defaultText) {
        if (object instanceof TypeRef) {
            TypeDefinition _typeDef = null;
            if ((TypeRef)object != null) {
                _typeDef = ((TypeRef)object).getTypeDef();
            }
            String _name = null;
            if (_typeDef != null) {
                _name = _typeDef.getName();
            }
            String typeName = _name;
            String s1 = CustomItemProviderService.ppName(typeName, "<type definition>");
            return "TypeRef " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getTypeRefItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TypeRef.class);
        if (Objects.equal((Object)_featureID, (Object)1)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getDataPlatformMappingItemProviderText(Object object, String defaultText) {
        if (object instanceof DataPlatformMapping) {
            String _platformName = null;
            if ((DataPlatformMapping)object != null) {
                _platformName = ((DataPlatformMapping)object).getPlatformName();
            }
            String name = _platformName;
            String _platformType = null;
            if ((DataPlatformMapping)object != null) {
                _platformType = ((DataPlatformMapping)object).getPlatformType();
            }
            String typeName = _platformType;
            String s1 = CustomItemProviderService.ppName(name, "<platform>");
            String s2 = CustomItemProviderService.ppName(typeName, "<type>");
            return "Platform Mapping: " + s1 + " --> " + s2;
        }
        return defaultText;
    }

    public static String getDataTypeDefinitionItemProviderText(Object object, String defaultText) {
        if (object instanceof DataTypeDefinition) {
            String _name = null;
            if ((DataTypeDefinition)object != null) {
                _name = ((DataTypeDefinition)object).getName();
            }
            String name = _name;
            String s1 = CustomItemProviderService.ppName(name);
            return "DataType " + s1;
        }
        return defaultText;
    }

    public static String getTaskMeasurementItemProviderText(Object object, String defaultText) {
        if (object instanceof TaskMeasurement) {
            Task _task = null;
            if ((TaskMeasurement)object != null) {
                _task = ((TaskMeasurement)object).getTask();
            }
            String _name = null;
            if (_task != null) {
                _name = _task.getName();
            }
            String taskName = _name;
            String s1 = CustomItemProviderService.ppName(taskName, "<task>");
            return "Measurement -- Task " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getTaskMeasurementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(TaskMeasurement.class);
        if (Objects.equal((Object)_featureID, (Object)3)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getRunnableMeasurementItemProviderText(Object object, String defaultText) {
        if (object instanceof RunnableMeasurement) {
            Runnable _runnable = null;
            if ((RunnableMeasurement)object != null) {
                _runnable = ((RunnableMeasurement)object).getRunnable();
            }
            String _name = null;
            if (_runnable != null) {
                _name = _runnable.getName();
            }
            String runName = _name;
            String s1 = CustomItemProviderService.ppName(runName, "<runnable>");
            return "Measurement -- Runnable " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getRunnableMeasurementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(RunnableMeasurement.class);
        if (Objects.equal((Object)_featureID, (Object)3)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }

    public static String getEventChainMeasurementItemProviderText(Object object, String defaultText) {
        if (object instanceof EventChainMeasurement) {
            EventChain _eventChain = null;
            if ((EventChainMeasurement)object != null) {
                _eventChain = ((EventChainMeasurement)object).getEventChain();
            }
            String _name = null;
            if (_eventChain != null) {
                _name = _eventChain.getName();
            }
            String ecName = _name;
            String s1 = CustomItemProviderService.ppName(ecName, "<event chain>");
            return "Measurement -- Event Chain " + s1;
        }
        return defaultText;
    }

    public static ViewerNotification getEventChainMeasurementItemProviderNotification(Notification notification) {
        int _featureID = notification.getFeatureID(EventChainMeasurement.class);
        if (Objects.equal((Object)_featureID, (Object)3)) {
            Object _notifier = notification.getNotifier();
            return new ViewerNotification(notification, _notifier, false, true);
        }
        return null;
    }
}

