/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryMapping;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.emf.common.util.EList;

public class DeploymentUtil {
    public static Set<Process> getProcessesMappedToCore(ProcessingUnit core, Amalthea model) {
        HashSet<Process> result = new HashSet<Process>();
        result.addAll(DeploymentUtil.getTasksMappedToCore(core, model));
        result.addAll(DeploymentUtil.getISRsMappedToCore(core, model));
        return result;
    }

    public static Set<Task> getTasksMappedToCore(ProcessingUnit core, Amalthea model) {
        HashSet<Task> tasks = new HashSet<Task>();
        HashSet<TaskScheduler> schedulers = new HashSet<TaskScheduler>();
        if (model.getMappingModel() != null && model.getMappingModel().getSchedulerAllocation() != null && !model.getMappingModel().getSchedulerAllocation().isEmpty()) {
            for (SchedulerAllocation schedAllocRun : model.getMappingModel().getSchedulerAllocation()) {
                if (!(schedAllocRun.getScheduler() instanceof TaskScheduler) || !schedAllocRun.getResponsibility().contains((Object)core)) continue;
                schedulers.add((TaskScheduler)schedAllocRun.getScheduler());
            }
        }
        if (model.getMappingModel().getTaskAllocation() != null && !model.getMappingModel().getTaskAllocation().isEmpty()) {
            for (TaskAllocation taskAllocation : model.getMappingModel().getTaskAllocation()) {
                if (!schedulers.contains(taskAllocation.getScheduler())) continue;
                if (taskAllocation.getAffinity().isEmpty()) {
                    tasks.add(taskAllocation.getTask());
                    continue;
                }
                if (!taskAllocation.getAffinity().contains((Object)core)) continue;
                tasks.add(taskAllocation.getTask());
            }
        }
        return tasks;
    }

    public static Set<ISR> getISRsMappedToCore(ProcessingUnit core, Amalthea model) {
        HashSet<ISR> result = new HashSet<ISR>();
        if (core == null || model.getSwModel() == null || model.getSwModel().getIsrs() == null || model.getMappingModel() == null || model.getMappingModel().getIsrAllocation() == null) {
            return result;
        }
        EList<ISRAllocation> isrAlloc = model.getMappingModel().getIsrAllocation();
        EList<SchedulerAllocation> schedulerAllocs = model.getMappingModel().getSchedulerAllocation();
        for (ISR isr : model.getSwModel().getIsrs()) {
            for (ISRAllocation ia : isrAlloc) {
                if (!ia.getIsr().equals(isr)) continue;
                for (SchedulerAllocation coreAlloc : schedulerAllocs) {
                    if (!coreAlloc.getResponsibility().contains((Object)core) || coreAlloc.getScheduler() != ia.getController()) continue;
                    result.add(isr);
                }
            }
        }
        return result;
    }

    public static List<TaskAllocation> getTaskAllocations(Task task, Amalthea model) {
        ArrayList<TaskAllocation> allocs = new ArrayList<TaskAllocation>();
        if (model.getMappingModel().getTaskAllocation() != null && !model.getMappingModel().getTaskAllocation().isEmpty()) {
            for (TaskAllocation ta : model.getMappingModel().getTaskAllocation()) {
                if (!ta.getTask().equals(task)) continue;
                allocs.add(ta);
            }
        }
        return allocs;
    }

    public static boolean isMapped(Label label) {
        return !DeploymentUtil.getLabelMapping(label).isEmpty();
    }

    public static Set<Memory> getLabelMapping(Label label) {
        HashSet<Memory> locations = new HashSet<Memory>();
        if (label.getMappings() != null) {
            for (MemoryMapping map : label.getMappings()) {
                locations.add(map.getMemory());
            }
        }
        return locations;
    }

    public static MemoryMapping setLabelMapping(Label label, Memory mem, Amalthea model) {
        MemoryMapping result = AmaltheaFactory.eINSTANCE.createMemoryMapping();
        if (mem == null || label == null) {
            return result;
        }
        result.setAbstractElement(label);
        result.setMemory(mem);
        ModelUtil.getOrCreateMappingModel(model).getMemoryMapping().add((Object)result);
        return result;
    }

    public static SchedulerAllocation getSchedulerAllocations(Scheduler scheduler, MappingModel mappingModel) {
        if (mappingModel.getSchedulerAllocation() != null) {
            for (SchedulerAllocation sa : mappingModel.getSchedulerAllocation()) {
                if (!sa.getScheduler().equals(scheduler)) continue;
                return sa;
            }
        }
        return null;
    }

    public static Set<TaskAllocation> getTaskAllocationsForScheduler(TaskScheduler taskScheduler, MappingModel mappingmodel) {
        HashSet<TaskAllocation> taskAllocations = new HashSet<TaskAllocation>();
        if (mappingmodel.getTaskAllocation() != null && !mappingmodel.getTaskAllocation().isEmpty()) {
            for (TaskAllocation taRun : mappingmodel.getTaskAllocation()) {
                if (taRun.getScheduler() == null || !taRun.getScheduler().equals(taskScheduler)) continue;
                taskAllocations.add(taRun);
            }
        }
        return taskAllocations;
    }

    public static Set<ProcessingUnit> getAssignedCoreForProcess(Process process, Amalthea model) {
        HashSet<ProcessingUnit> result = new HashSet<ProcessingUnit>();
        if (process == null && model.getMappingModel() == null) {
            return result;
        }
        HashSet<TaskAllocation> taskAllocations = new HashSet<TaskAllocation>();
        if (model.getMappingModel().getTaskAllocation() != null && process instanceof Task && !model.getMappingModel().getTaskAllocation().isEmpty()) {
            for (TaskAllocation taskAlloc : model.getMappingModel().getTaskAllocation()) {
                if (!taskAlloc.getTask().equals(process)) continue;
                taskAllocations.add(taskAlloc);
            }
            if (model.getMappingModel().getSchedulerAllocation() != null && !model.getMappingModel().getSchedulerAllocation().isEmpty()) {
                for (SchedulerAllocation schedAlloc : model.getMappingModel().getSchedulerAllocation()) {
                    for (TaskAllocation taskAlloc : taskAllocations) {
                        if (!schedAlloc.getScheduler().equals(taskAlloc.getScheduler())) continue;
                        if (taskAlloc.getAffinity() != null && !taskAlloc.getAffinity().isEmpty()) {
                            for (ProcessingUnit core : taskAlloc.getAffinity()) {
                                if (!schedAlloc.getResponsibility().contains((Object)core)) continue;
                                result.add(core);
                            }
                            continue;
                        }
                        result.addAll((Collection<ProcessingUnit>)schedAlloc.getResponsibility());
                    }
                }
            }
            return result;
        }
        if (model.getMappingModel().getIsrAllocation() != null && process instanceof ISR && !model.getMappingModel().getIsrAllocation().isEmpty()) {
            for (ISRAllocation isrAlloc : model.getMappingModel().getIsrAllocation()) {
                if (!isrAlloc.getIsr().equals(process) || model.getMappingModel().getSchedulerAllocation() == null || model.getMappingModel().getSchedulerAllocation().isEmpty()) continue;
                for (SchedulerAllocation coreAlloc : model.getMappingModel().getSchedulerAllocation()) {
                    if (!coreAlloc.getScheduler().equals(isrAlloc.getController())) continue;
                    result.addAll((Collection<ProcessingUnit>)coreAlloc.getResponsibility());
                }
            }
        }
        return result;
    }

    public List<HwFeatureCategory> getFeatureCategories(ProcessingUnitDefinition procUnitDef) {
        ArrayList<HwFeatureCategory> result = new ArrayList<HwFeatureCategory>();
        for (HwFeature feature : procUnitDef.getFeatures()) {
            if (result.contains(feature.getContainingCategory())) continue;
            result.add(feature.getContainingCategory());
        }
        return result;
    }

    public List<ProcessingUnitDefinition> getProcessingUnitDefinitionsForHwCategories(HwFeatureCategory hwFeatureCat, List<ProcessingUnitDefinition> procUnitDefinitons) {
        ArrayList<ProcessingUnitDefinition> result = new ArrayList<ProcessingUnitDefinition>();
        for (ProcessingUnitDefinition procUnitDef : procUnitDefinitons) {
            for (HwFeature feature : hwFeatureCat.getFeatures()) {
                if (!procUnitDef.getFeatures().contains((Object)feature)) continue;
                result.add(procUnitDef);
            }
        }
        return result;
    }

    public List<ProcessingUnitDefinition> getProcessingUnitDefinitionsForHwFeature(HwFeature feature, List<ProcessingUnitDefinition> procUnitDefinitons) {
        ArrayList<ProcessingUnitDefinition> result = new ArrayList<ProcessingUnitDefinition>();
        for (ProcessingUnitDefinition procUnitDef : procUnitDefinitons) {
            if (!procUnitDef.getFeatures().contains((Object)feature)) continue;
            result.add(procUnitDef);
        }
        return result;
    }
}

