/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Cache;
import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwLatency;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.LatencyConstant;
import org.eclipse.app4mc.amalthea.model.LatencyDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.amalthea.model.util.TimeUtil;

public class HardwareUtil {
    public static <T extends HwModule> List<T> getModulesFromHWStructure(Class<T> targetClass, HwStructure structure) {
        ArrayList<HwModule> results = new ArrayList<HwModule>();
        if (targetClass.equals(Cache.class)) {
            for (HwModule module : structure.getModules()) {
                if (module instanceof Cache) {
                    results.add(module);
                    continue;
                }
                if (!(module instanceof ProcessingUnit)) continue;
                for (Cache containedCache : ((ProcessingUnit)module).getCaches()) {
                    results.add(containedCache);
                }
            }
        } else {
            for (HwModule module : structure.getModules()) {
                if (targetClass.equals(ProcessingUnit.class)) {
                    if (!(module instanceof ProcessingUnit)) continue;
                    results.add(module);
                    continue;
                }
                if (targetClass.equals(Memory.class)) {
                    if (!(module instanceof Memory)) continue;
                    results.add(module);
                    continue;
                }
                if (!(module instanceof ConnectionHandler)) continue;
                results.add(module);
            }
        }
        for (HwStructure hwStruct : structure.getStructures()) {
            results.addAll(HardwareUtil.getModulesFromHWStructure(targetClass, hwStruct));
        }
        return results;
    }

    public static <T extends HwModule> List<T> getModulesFromHWModel(Class<T> targetClass, Amalthea model) {
        ArrayList<T> modules = new ArrayList<T>();
        for (HwStructure structure : model.getHwModel().getStructures()) {
            modules.addAll(HardwareUtil.getModulesFromHWStructure(targetClass, structure));
        }
        return modules;
    }

    public static List<ProcessingUnit> getAllProcessingUnitsForProcessingUnitDefinition(Amalthea model, ProcessingUnitDefinition puDef) {
        ArrayList<ProcessingUnit> pusWithGivenPUDefinition = new ArrayList<ProcessingUnit>();
        List<ProcessingUnit> pusInModel = HardwareUtil.getModulesFromHWModel(ProcessingUnit.class, model);
        if (puDef == null) {
            return new ArrayList<ProcessingUnit>();
        }
        for (ProcessingUnit pu : pusInModel) {
            if (!puDef.equals(pu.getDefinition())) continue;
            pusWithGivenPUDefinition.add(pu);
        }
        return pusWithGivenPUDefinition;
    }

    public static Map<Memory, Long> getMemoryAccessLatenciesCycles(Amalthea model, RuntimeUtil.TimeType timeType) {
        HashMap<Memory, Long> result = new HashMap<Memory, Long>();
        List<Memory> mems = HardwareUtil.getModulesFromHWModel(Memory.class, model);
        for (Memory mem : mems) {
            result.put(mem, HardwareUtil.calculateLatency(mem.getDefinition().getAccessLatency(), timeType));
        }
        return result;
    }

    public static Map<Memory, Time> getMemoryAccessLatencyTime(Amalthea model, RuntimeUtil.TimeType timeType) {
        HashMap<Memory, Time> result = new HashMap<Memory, Time>();
        Map<Memory, Long> memoryMap = HardwareUtil.getMemoryAccessLatenciesCycles(model, timeType);
        for (Memory key : memoryMap.keySet()) {
            Time time = FactoryUtil.createTime(memoryMap.get(key), 1.0, HardwareUtil.getFrequencyOfModuleInHz(key));
            result.put(key, time);
        }
        return result;
    }

    public static List<HwAccessElement> getAccessElementsToDestination(HwDestination dest, Amalthea model) {
        ArrayList<HwAccessElement> result = new ArrayList<HwAccessElement>();
        List<ProcessingUnit> pus = HardwareUtil.getModulesFromHWModel(ProcessingUnit.class, model);
        for (ProcessingUnit pu : pus) {
            for (HwAccessElement element : pu.getAccessElements()) {
                if (!element.getDestination().equals(dest)) continue;
                result.add(element);
            }
        }
        return result;
    }

    public static Map<ProcessingUnit, HashMap<HwDestination, Time>> getAccessTimes(Amalthea model, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        HashMap<ProcessingUnit, HashMap<HwDestination, Time>> coreMemoryLatency = new HashMap<ProcessingUnit, HashMap<HwDestination, Time>>();
        List<ProcessingUnit> pus = HardwareUtil.getModulesFromHWModel(ProcessingUnit.class, model);
        for (ProcessingUnit pu : pus) {
            HashMap<HwDestination, Time> MemAccessTime = new HashMap<HwDestination, Time>();
            for (HwAccessElement accessElement : pu.getAccessElements()) {
                Time latency = null;
                latency = accessElement.getAccessPath() != null ? HardwareUtil.calculateHwAccessPathTime(accessElement, timeType, direction) : HardwareUtil.calculateLatencyPathTime(accessElement, timeType, direction);
                if (MemAccessTime.containsKey(accessElement.getDestination()) && TimeUtil.compareTime((Time)MemAccessTime.get(accessElement.getDestination()), latency) >= 0L) continue;
                MemAccessTime.put(accessElement.getDestination(), latency);
            }
            coreMemoryLatency.put(pu, MemAccessTime);
        }
        return coreMemoryLatency;
    }

    public static Time calculateLatencyPathTime(HwAccessElement accessElement, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        HwLatency latency = null;
        switch (direction) {
            case READ: {
                if (accessElement.getReadLatency() == null) break;
                latency = accessElement.getReadLatency();
                break;
            }
            case WRITE: {
                if (accessElement.getWriteLatency() == null) break;
                latency = accessElement.getWriteLatency();
                break;
            }
        }
        return FactoryUtil.createTime(HardwareUtil.calculateLatency(latency, timeType), 1.0, HardwareUtil.getFrequencyOfModuleInHz(accessElement.getSource()));
    }

    public static Time calculateHwAccessPathTime(HwAccessElement accessElement, RuntimeUtil.TimeType timeType, RuntimeUtil.AccessDirection direction) {
        Time result = AmaltheaFactory.eINSTANCE.createTime();
        Frequency frequency = null;
        HwLatency latency = null;
        if (accessElement.getAccessPath() != null) {
            for (HwPathElement element : accessElement.getAccessPath().getPathElements()) {
                if (element instanceof ConnectionHandler) {
                    latency = direction.equals((Object)RuntimeUtil.AccessDirection.READ) ? ((ConnectionHandler)element).getDefinition().getReadLatency() : ((ConnectionHandler)element).getDefinition().getWriteLatency();
                    frequency = HardwareUtil.getFrequencyOfModule((ConnectionHandler)element);
                } else if (element instanceof Cache) {
                    latency = ((Cache)element).getDefinition().getAccessLatency();
                    frequency = HardwareUtil.getFrequencyOfModule((Cache)element);
                } else if (element instanceof HwConnection) {
                    latency = direction.equals((Object)RuntimeUtil.AccessDirection.READ) ? ((HwConnection)element).getReadLatency() : ((HwConnection)element).getWriteLatency();
                    if (frequency == null) {
                        frequency = HardwareUtil.getFrequencyOfModule(accessElement.getSource());
                    }
                } else if (element instanceof ProcessingUnit) {
                    frequency = HardwareUtil.getFrequencyOfModule((ProcessingUnit)element);
                }
                result = TimeUtil.addTimes(result, FactoryUtil.createTime(HardwareUtil.calculateLatency(latency, timeType), 1.0, AmaltheaServices.convertToHertz(frequency).longValue()));
            }
        }
        return result;
    }

    public static Long calculateLatency(HwLatency latency, RuntimeUtil.TimeType timeType) {
        Long result = 0L;
        if (latency instanceof LatencyConstant) {
            result = ((LatencyConstant)latency).getCycles();
        } else if (latency instanceof LatencyDeviation) {
            Deviation<LongObject> deviation = ((LatencyDeviation)latency).getCycles();
            if (timeType == null) {
                result = RuntimeUtil.getMean(deviation.getDistribution(), deviation.getLowerBound().getValue(), deviation.getUpperBound().getValue());
            } else {
                switch (timeType) {
                    case ACET: {
                        result = RuntimeUtil.getMean(deviation.getDistribution(), deviation.getLowerBound().getValue(), deviation.getUpperBound().getValue());
                        break;
                    }
                    case BCET: {
                        result = deviation.getLowerBound().getValue();
                        break;
                    }
                    case WCET: {
                        result = deviation.getUpperBound().getValue();
                        break;
                    }
                }
            }
        }
        return result;
    }

    public static DataRate getMinDataRateOfHwAccessPath(HwAccessPath path) {
        DataRate minimum = null;
        if (path != null) {
            for (HwPathElement element : path.getPathElements()) {
                DataRate temp = null;
                if (element instanceof ConnectionHandler) {
                    temp = ((ConnectionHandler)element).getDefinition().getDataRate();
                } else if (element instanceof HwConnection) {
                    temp = ((HwConnection)element).getDataRate();
                }
                if (temp == null || minimum != null && AmaltheaServices.compareDataRates(temp, minimum) >= 0) continue;
                minimum = temp;
            }
        }
        return minimum;
    }

    public static Frequency getFrequencyOfModule(HwModule module) {
        return module.getFrequencyDomain().getDefaultValue();
    }

    public static long getFrequencyOfModuleInHz(HwModule module) {
        return AmaltheaServices.convertToHertz(HardwareUtil.getFrequencyOfModule(module)).longValue();
    }
}

