/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Need;
import org.eclipse.app4mc.amalthea.model.NeedConstant;
import org.eclipse.app4mc.amalthea.model.NeedDeviation;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;

public class InstructionsUtil {
    public static final String INSTRUCTIONS_CATEGORY_NAME = "Instructions";

    public static HwFeatureCategory getOrCreateInstructionsCategory(Amalthea model) {
        HWModel hwModel = ModelUtil.getOrCreateHwModel(model);
        for (HwFeatureCategory category : hwModel.getFeatureCategories()) {
            if (category.getName() != INSTRUCTIONS_CATEGORY_NAME) continue;
            return category;
        }
        HwFeatureCategory newCategory = AmaltheaFactory.eINSTANCE.createHwFeatureCategory();
        newCategory.setName(INSTRUCTIONS_CATEGORY_NAME);
        hwModel.getFeatureCategories().add((Object)newCategory);
        return newCategory;
    }

    public static ExecutionNeed createDefaultExecutionNeed(long instructions) {
        return InstructionsUtil.createDefaultExecutionNeed(INSTRUCTIONS_CATEGORY_NAME, instructions);
    }

    public static ExecutionNeed createDefaultExecutionNeed(Deviation<LongObject> instructions) {
        return InstructionsUtil.createDefaultExecutionNeed(INSTRUCTIONS_CATEGORY_NAME, instructions);
    }

    public static Need getDefaultNeed(ExecutionNeed execNeed) {
        return (Need)execNeed.getDefault().get((Object)INSTRUCTIONS_CATEGORY_NAME);
    }

    public static long getDefaultNeedConstant(ExecutionNeed execNeed) {
        return InstructionsUtil.getDefaultNeedConstant(execNeed, INSTRUCTIONS_CATEGORY_NAME);
    }

    public static Deviation<LongObject> getDefaultNeedDeviation(ExecutionNeed execNeed) {
        return InstructionsUtil.getDefaultNeedDeviation(execNeed, INSTRUCTIONS_CATEGORY_NAME);
    }

    public static double getIPC(Amalthea model, ProcessingUnit pu) {
        List<Double> values = InstructionsUtil.getFeatureValuesOfCategory(pu.getDefinition(), InstructionsUtil.getOrCreateInstructionsCategory(model));
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return 1.0;
    }

    private static ExecutionNeed createDefaultExecutionNeed(String category, long instructions) {
        NeedConstant need = AmaltheaFactory.eINSTANCE.createNeedConstant();
        need.setValue(instructions);
        ExecutionNeed execNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        execNeed.getDefault().put((Object)category, (Object)need);
        return execNeed;
    }

    private static ExecutionNeed createDefaultExecutionNeed(String category, Deviation<LongObject> instructions) {
        NeedDeviation need = AmaltheaFactory.eINSTANCE.createNeedDeviation();
        need.setDeviation(instructions);
        ExecutionNeed execNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        execNeed.getDefault().put((Object)category, (Object)need);
        return execNeed;
    }

    private static long getDefaultNeedConstant(ExecutionNeed execNeed, String category) {
        if (execNeed == null || category == null) {
            return 0L;
        }
        Need need = (Need)execNeed.getDefault().get((Object)category);
        if (need instanceof NeedConstant) {
            return ((NeedConstant)need).getValue();
        }
        return 0L;
    }

    private static Deviation<LongObject> getDefaultNeedDeviation(ExecutionNeed execNeed, String category) {
        if (execNeed == null || category == null) {
            return null;
        }
        Need need = (Need)execNeed.getDefault().get((Object)category);
        if (need instanceof NeedDeviation) {
            return ((NeedDeviation)need).getDeviation();
        }
        return null;
    }

    public static List<HwFeature> getFeaturesOfCategory(ProcessingUnitDefinition puDefinition, HwFeatureCategory category) {
        if (puDefinition == null || category == null) {
            return Collections.emptyList();
        }
        return puDefinition.getFeatures().stream().filter(i -> i.getContainingCategory() == category).collect(Collectors.toList());
    }

    public static List<Double> getFeatureValuesOfCategory(ProcessingUnitDefinition puDefinition, HwFeatureCategory category) {
        if (puDefinition == null || category == null) {
            return Collections.emptyList();
        }
        return puDefinition.getFeatures().stream().filter(i -> i.getContainingCategory() == category).map(i -> i.getValue()).collect(Collectors.toList());
    }
}

