/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelStaticCacheBuilder {
    private final Map<String, Map<String, List<EObject>>> cacheMap = new HashMap<String, Map<String, List<EObject>>>();
    private Object inputSource;

    public ModelStaticCacheBuilder(Amalthea root) {
        this.inputSource = root;
        this.buildCache();
    }

    public ModelStaticCacheBuilder(ResourceSet resourceSet) {
        this.inputSource = resourceSet;
        this.buildCache();
    }

    private void buildCache() {
        this.cacheMap.clear();
        TreeIterator allContents = null;
        allContents = this.inputSource instanceof EObject ? EcoreUtil.getAllContents((EObject)((EObject)this.inputSource), (boolean)true) : EcoreUtil.getAllContents((ResourceSet)((ResourceSet)this.inputSource), (boolean)true);
        TreeIterator iter = allContents;
        while (iter.hasNext()) {
            HashMap hashMap;
            EObject element = (EObject)iter.next();
            Class<?> elementsClass = element.getClass();
            if (!IReferable.class.isAssignableFrom(elementsClass)) continue;
            if (!this.cacheMap.containsKey(element.eClass().getName())) {
                hashMap = new HashMap();
                this.cacheMap.put(element.eClass().getName(), hashMap);
            }
            if (!this.cacheMap.get(element.eClass().getName()).containsKey(((IReferable)element).getName())) {
                hashMap = (HashMap)this.cacheMap.get(element.eClass().getName());
                hashMap.put(((IReferable)element).getName(), new BasicEList());
            }
            this.cacheMap.get(element.eClass().getName()).get(((IReferable)element).getName()).add(element);
        }
    }

    public <T> List<T> getElementsBasedOnName(String name, Class<T> targetClass) {
        Map<String, List<EObject>> map = this.cacheMap.get(targetClass.getSimpleName());
        if (map != null) {
            List<EObject> eObject = map.get(name);
            return eObject;
        }
        return new ArrayList();
    }

    public <T extends EObject> List<T> getElementsBasedOnRegex(String regularExpression, Class<T> targetClass) {
        Map<String, List<EObject>> map = this.cacheMap.get(targetClass.getSimpleName());
        if (map != null) {
            Pattern regexPattern = Pattern.compile(regularExpression);
            List matchingKeys = map.keySet().stream().filter(s -> regexPattern.matcher((CharSequence)s).matches()).collect(Collectors.toList());
            if (matchingKeys != null) {
                ArrayList result = new ArrayList();
                for (String key : matchingKeys) {
                    result.addAll(map.get(key));
                }
                return result;
            }
        }
        return new ArrayList();
    }

    public <T> List<T> getElementsBasedOnType(Class<T> targetClass) {
        ArrayList<EObject> resultElements = new ArrayList<EObject>();
        Map<String, List<EObject>> map = this.cacheMap.get(targetClass.getSimpleName());
        if (map != null) {
            int i = 0;
            while (i < map.keySet().size()) {
                List<EObject> eObjects = map.get(i);
                if (eObjects != null) {
                    resultElements.addAll(eObjects);
                }
                ++i;
            }
        }
        return resultElements;
    }
}

