/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.ModelSearchResult;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultTreeContentProvider
extends TreeNodeContentProvider {
    private ModelSearchResult searchResult;
    private final Set<TreeNode> elements = new LinkedHashSet<TreeNode>();
    private final Map<String, TreeNode> types = new HashMap<String, TreeNode>();
    private boolean groupByTypes = false;

    public void dispose() {
    }

    public void clear() {
        this.elements.clear();
        this.types.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ModelSearchResult) {
            this.searchResult = (ModelSearchResult)((Object)newInput);
            this.elements.clear();
            this.updateElements(this.searchResult.getElements());
        } else {
            this.searchResult = null;
            this.elements.clear();
        }
    }

    public void updateElements(Object[] newElements) {
        Object[] objectArray = newElements;
        int n = newElements.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Object element = objectArray[n2];
            boolean toAdd = false;
            Object[] objectArray2 = this.searchResult.getElements();
            int n3 = objectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object elem = objectArray2[n4];
                if (elem.equals(element)) {
                    toAdd = true;
                    break;
                }
                ++n4;
            }
            if (toAdd) {
                this.elements.add(new TreeNode(element));
                name = ((EObject)element).eClass().getName();
                if (!this.types.containsKey(name)) {
                    this.types.put(name, new TreeNode((Object)((EObject)element).eClass()));
                }
                TreeNode node = this.types.get(name);
                ArrayList<Object> children = null;
                children = node.hasChildren() ? new ArrayList<TreeNode>(Arrays.asList(node.getChildren())) : new ArrayList<TreeNode>();
                children.add(new TreeNode(element));
                node.setChildren(children.toArray(new TreeNode[children.size()]));
            } else {
                this.elements.remove(new TreeNode(element));
                name = ((EObject)element).eClass().getName();
                if (this.types.containsKey(name)) {
                    TreeNode node = this.types.get(name);
                    ArrayList<TreeNode> children = null;
                    if (node.hasChildren()) {
                        children = new ArrayList<TreeNode>(Arrays.asList(node.getChildren()));
                        children.remove(new TreeNode(element));
                        if (children.size() > 0) {
                            node.setChildren(children.toArray(new TreeNode[children.size()]));
                        } else {
                            this.types.remove(name);
                        }
                    }
                }
            }
            ++n2;
        }
        ArrayList<TreeNode> tmp = new ArrayList<TreeNode>(this.elements);
        Collections.sort(tmp, new ObjectComparator());
        this.elements.clear();
        this.elements.addAll(tmp);
        for (TreeNode node : this.types.values()) {
            if (!node.hasChildren()) continue;
            ArrayList<TreeNode> childs = new ArrayList<TreeNode>(Arrays.asList(node.getChildren()));
            Collections.sort(childs, new ObjectComparator());
            node.setChildren(childs.toArray(new TreeNode[childs.size()]));
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this.searchResult) {
            if (!this.groupByTypes) {
                return this.elements.toArray();
            }
            ArrayList<TreeNode> tmp = new ArrayList<TreeNode>(this.types.values());
            Collections.sort(tmp, new ObjectComparator());
            return tmp.toArray(new TreeNode[tmp.size()]);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        Object[] tmp = super.getChildren(parentElement);
        if (tmp != null) {
            return tmp;
        }
        return new Object[0];
    }

    public boolean isGroupByTypes() {
        return this.groupByTypes;
    }

    public void setGroupByTypes(boolean groupByTypes) {
        this.groupByTypes = groupByTypes;
    }

    private class ObjectComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            EObject eo1 = (EObject)((TreeNode)o1).getValue();
            EObject eo2 = (EObject)((TreeNode)o2).getValue();
            EStructuralFeature feature1 = eo1.eClass().getEStructuralFeature("name");
            EStructuralFeature feature2 = eo2.eClass().getEStructuralFeature("name");
            String name1 = null;
            String name2 = null;
            if (feature1 != null && feature2 != null) {
                name1 = (String)eo1.eGet(feature1);
                name2 = (String)eo2.eGet(feature2);
            }
            if (name1 != null && name2 != null) {
                return name1.compareTo(name2);
            }
            return 0;
        }
    }
}

