/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.wizards.handlers;

import org.eclipse.app4mc.multicore.dialogs.DialogsPlugin;
import org.eclipse.app4mc.multicore.dialogs.wizards.AbstractWizardPage;
import org.eclipse.app4mc.multicore.dialogs.wizards.MulticoreWizard;
import org.eclipse.app4mc.multicore.sharelibs.SelectionUtil;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class MulticoreWizardHandler
extends AbstractHandler {
    protected MulticoreWizard wizard;
    protected WizardDialog dialog;
    private static final IPreferenceStore store = DialogsPlugin.getDefaultPreferenceStore();
    private final IPropertyChangeListener firstPageSelection = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            MulticoreWizardHandler.this.updateNextButton();
        }
    };
    private final IPageChangedListener pageChanged = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            AbstractWizardPage currPage = (AbstractWizardPage)((Object)event.getSelectedPage());
            MulticoreWizardHandler.this.wizard.store();
            currPage.doAction();
        }
    };

    public static IPreferenceStore getPreferenceStore() {
        return store;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UniversalHandler.getInstance().setPluginId(DialogsPlugin.getPluginId());
        UniversalHandler.getInstance().setLog(DialogsPlugin.getDefault().getLog());
        try {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            IStructuredSelection selection = SelectionUtil.getSelection((ExecutionEvent)event);
            this.wizard = new MulticoreWizard();
            this.wizard.init(window.getWorkbench(), selection);
            this.dialog = new WizardDialog(window.getShell(), (IWizard)this.wizard);
            this.dialog.addPageChangedListener(this.pageChanged);
            this.dialog.create();
            this.updateNextButton();
            store.addPropertyChangeListener(this.firstPageSelection);
            this.dialog.open();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            store.removePropertyChangeListener(this.firstPageSelection);
            return null;
        }
        store.removePropertyChangeListener(this.firstPageSelection);
        return null;
    }

    protected void updateNextButton() {
        boolean canFlip;
        if (this.wizard == null) {
            return;
        }
        boolean bl = canFlip = this.wizard.getPageCount() > 1;
        if (this.wizard.getStartingPage() != null) {
            ((WizardPage)this.wizard.getStartingPage()).setPageComplete(canFlip);
            this.dialog.updateButtons();
        }
    }
}

