/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.btf.fsm;

import org.eclipse.app4mc.multicore.execution.logic.btf.fsm.BtfTaskEvent;
import org.eclipse.app4mc.multicore.execution.logic.btf.fsm.BtfTaskState;

public class BtfTaskFSM {
    private static final BtfTaskState[][] multi = new BtfTaskState[8][12];
    private BtfTaskState currentState;

    static {
        BtfTaskFSM.makeTransition(BtfTaskState.POLLING, BtfTaskEvent.RUN, BtfTaskState.RUNNING);
        BtfTaskFSM.makeTransition(BtfTaskState.POLLING, BtfTaskEvent.PARK, BtfTaskState.PARKING);
        BtfTaskFSM.makeTransition(BtfTaskState.RUNNING, BtfTaskEvent.TERMINATE, BtfTaskState.TERMINATED);
        BtfTaskFSM.makeTransition(BtfTaskState.RUNNING, BtfTaskEvent.PREEMPT, BtfTaskState.READY);
        BtfTaskFSM.makeTransition(BtfTaskState.RUNNING, BtfTaskEvent.POLL, BtfTaskState.POLLING);
        BtfTaskFSM.makeTransition(BtfTaskState.RUNNING, BtfTaskEvent.WAIT, BtfTaskState.WAITING);
        BtfTaskFSM.makeTransition(BtfTaskState.NOT_INITIALIZED, BtfTaskEvent.ACTIVATE, BtfTaskState.ACTIVE);
        BtfTaskFSM.makeTransition(BtfTaskState.ACTIVE, BtfTaskEvent.START, BtfTaskState.RUNNING);
        BtfTaskFSM.makeTransition(BtfTaskState.READY, BtfTaskEvent.RESUME, BtfTaskState.RUNNING);
        BtfTaskFSM.makeTransition(BtfTaskState.PARKING, BtfTaskEvent.RELEASE_PARKING, BtfTaskState.READY);
        BtfTaskFSM.makeTransition(BtfTaskState.PARKING, BtfTaskEvent.POLL_PARKING, BtfTaskState.POLLING);
        BtfTaskFSM.makeTransition(BtfTaskState.WAITING, BtfTaskEvent.RELEASE, BtfTaskState.READY);
    }

    private static void makeTransition(BtfTaskState oldState, BtfTaskEvent e, BtfTaskState newState) {
        BtfTaskFSM.multi[oldState.val()][e.val()] = newState;
    }

    public BtfTaskFSM(BtfTaskState start) {
        this.currentState = start;
    }

    public void setState(BtfTaskState state) {
        this.currentState = state;
    }

    public BtfTaskState getState() {
        return this.currentState;
    }

    public boolean dispatchEvent(BtfTaskEvent event) {
        BtfTaskState newState = multi[this.currentState.val()][event.val()];
        if (newState != null) {
            this.currentState = newState;
            return true;
        }
        return false;
    }
}

