/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ga.lb;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractGABasedMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.ProblemGraph;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.TimeStep;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.jenetics.Chromosome;
import org.jenetics.Genotype;
import org.jenetics.IntegerChromosome;
import org.jenetics.IntegerGene;
import org.jenetics.Optimize;
import org.jenetics.engine.Engine;
import org.jenetics.engine.EvolutionResult;
import org.jenetics.engine.EvolutionStatistics;
import org.jenetics.engine.EvolutionStream;
import org.jenetics.util.Factory;

public class GABasedLoadBalancing
extends AbstractGABasedMappingAlgorithm {
    private static List<OMTask> taskList = new ArrayList<OMTask>();
    private static List<OMCore> coreList = new ArrayList<OMCore>();
    private static long[][] utilMatrix;

    @Override
    public void calculateMapping() {
        TimeStep timeStep = new TimeStep();
        this.con.appendln("Performing GA based Load Balancing");
        this.con.appendln("Preparing Models...");
        if (!this.initModels()) {
            this.con.appendln("Error during Model initialization, exiting.");
            return;
        }
        timeStep.update();
        this.con.appendln("Generating ProblemGraph...");
        ProblemGraph pg = new ProblemGraph(this.getMergedModel());
        if (!pg.initialize()) {
            this.con.appendln("Error during ProblemGraph initialization, exiting.");
            return;
        }
        taskList = pg.getTaskList();
        coreList = pg.getCoreList();
        this.con.appendln(" Success! (" + timeStep.getTimeStep() / 1000000L + "ms)");
        this.con.appendln("Step 4: Creating Mapping...");
        if (!this.performMappingAlgorithm()) {
            this.con.appendln("Error during performMappingAlgorithm, exiting.");
            return;
        }
        this.con.appendln("Success after " + timeStep.getTimeStep() / 1000000L + "ms.");
        this.con.appendln("Leaving mapping algorithm.");
    }

    private boolean performMappingAlgorithm() {
        int noCores = coreList.size();
        int noTasks = taskList.size();
        if (noCores == 1) {
            return this.mapToFirstCore();
        }
        utilMatrix = new long[noCores][noTasks];
        for (OMCore core : coreList) {
            int indexCore = coreList.indexOf(core);
            for (OMTask task : taskList) {
                int indexTask = taskList.indexOf(task);
                GABasedLoadBalancing.utilMatrix[indexCore][indexTask] = new OMAllocation(task, core).calculateProcessingTime();
            }
        }
        Genotype gtf = Genotype.of((Chromosome)IntegerChromosome.of((int)0, (int)(noCores - 1), (int)noTasks), (Chromosome[])new Chromosome[0]);
        Engine engine = Engine.builder(GABasedLoadBalancing::evaluate, (Factory)gtf).optimize(Optimize.MINIMUM).populationSize(noTasks).build();
        Throwable throwable = null;
        Object var6_8 = null;
        try (EvolutionStream stream = engine.stream();){
            EvolutionStatistics statistics = EvolutionStatistics.ofNumber();
            Stream stream2 = stream.limit(1000L).peek(statistics);
            Genotype result = (Genotype)stream2.collect(EvolutionResult.toBestGenotype());
            this.con.appendln(statistics.toString());
            this.con.appendln(result.toString());
            OMMapping mapping = this.generateOMMapping((Genotype<IntegerGene>)result);
            this.updateModel(mapping);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    @Override
    protected OMMapping generateOMMapping(Genotype<IntegerGene> mappingResult) {
        OMMapping mapping = new OMMapping();
        Chromosome chromosome = mappingResult.getChromosome(0);
        if (mappingResult.length() != 1) {
            this.con.appendln("Invalid number of Genes");
            return null;
        }
        int taskIndex = 0;
        for (IntegerGene gene : chromosome) {
            int coreIndex = (Integer)gene.getAllele();
            OMCore core = coreList.get(coreIndex);
            OMTask task = taskList.get(taskIndex);
            OMAllocation alloc = new OMAllocation(task, core);
            mapping.addAllocation(alloc);
            ++taskIndex;
        }
        return mapping;
    }

    public static Long evaluate(Genotype<IntegerGene> gt) {
        long max = 0L;
        long[] tmpCoreLoad = new long[coreList.size()];
        int taskIndex = 0;
        Chromosome chromosome = gt.getChromosome(0);
        for (IntegerGene gene : chromosome) {
            int coreIndex = (Integer)gene.getAllele();
            tmpCoreLoad[((Integer)gene.getAllele()).intValue()] = tmpCoreLoad[(Integer)gene.getAllele()] + utilMatrix[coreIndex][taskIndex];
            ++taskIndex;
        }
        int i = 0;
        while (i < coreList.size()) {
            if (tmpCoreLoad[i] > max) {
                max = tmpCoreLoad[i];
            }
            ++i;
        }
        return max;
    }
}

