/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.openmapping.model.OMRunnable;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;

public class OMProcessPrototype {
    private final ProcessPrototype refProcessPrototype;
    private final String name;
    private final DirectedGraph<OMRunnable, DefaultEdge> runnableGraph = new DirectedAcyclicGraph(DefaultEdge.class);

    public OMProcessPrototype(ProcessPrototype refProcessPrototype) {
        this.refProcessPrototype = refProcessPrototype;
        this.name = refProcessPrototype.getName();
    }

    public boolean createRunnableGraph() {
        if (this.refProcessPrototype.getRunnableCalls().size() <= 0) {
            UniversalHandler.getInstance().logWarn("Invalid SWModel. There are no TaskRunnableCalls in ProcessPrototype '" + this.name + "'. No RunnableGraph created.");
            return false;
        }
        if (this.refProcessPrototype.getFirstRunnable() == null || this.refProcessPrototype.getLastRunnable() == null) {
            UniversalHandler.getInstance().logWarn("Unexpected SWModel. First- or LastRunnable in ProcessPrototype '" + this.name + "' unset. Ignoring.");
            return false;
        }
        Stream stRunnableCalls = this.refProcessPrototype.getRunnableCalls().stream();
        stRunnableCalls.forEach(r -> this.processRunnableCall((TaskRunnableCall)r));
        return this.runnableGraph.vertexSet().size() > 0;
    }

    private void processRunnableCall(TaskRunnableCall r) {
        if (r.getRunnable() == null) {
            return;
        }
        OMRunnable or = new OMRunnable(r.getRunnable());
        this.runnableGraph.addVertex((Object)or);
    }

    public ProcessPrototype getProcessPrototype() {
        return this.refProcessPrototype;
    }

    public Set<OMRunnable> getRunnableList() {
        return this.runnableGraph.vertexSet();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String out = "ProcessPrototype: " + this.name;
        return out;
    }
}

