/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AffinityConstraint;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableOrderType;
import org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.PartitioningPlugin;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CPP;
import org.eclipse.app4mc.multicore.partitioning.algorithms.ESSP;
import org.eclipse.app4mc.multicore.partitioning.handlers.WriteAppletHandler;
import org.eclipse.app4mc.multicore.partitioning.utils.CreateTAInput;
import org.eclipse.app4mc.multicore.partitioning.utils.CycleElimination;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.sharelibs.OutputPathParser;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;

public class PerformPartitioning {
    public static final String PART_ESSP = "essp";
    public static final String PART_CPP = "cpp";

    public void execute(IFile file, IProgressMonitor monitor, IPreferenceStore store) {
        UniversalHandler uh = UniversalHandler.getInstance();
        PartLog.getInstance().setLogName("PartitioningHandler");
        OutputPathParser outputParser = new OutputPathParser("org.eclipse.app4mc.multicore.partitioning.locRadio", "org.eclipse.app4mc.multicore.partitioning.loc", store);
        String append = "";
        if (!file.getName().endsWith("_PrePartitioned.amxmi")) {
            append = "_PrePartitioned";
        }
        uh.dropCache();
        uh.readModels(outputParser.parseOutputFileURI(file, append), true);
        if (uh.getSwModel() == null) {
            PartLog.getInstance().log("No SWModel found at " + outputParser.parseOutputFileURI(file, append).toString(), null);
            return;
        }
        AmaltheaFactory af = AmaltheaFactory.eINSTANCE;
        Amalthea amodels = af.createAmalthea();
        assert (uh.getSwModel() != null);
        if ((amodels = new Helper().setAllModels(amodels, uh)).getSwModel().getProcessPrototypes().size() == 0) {
            PartLog.getInstance().log("!!No ProcessPrototypes present. Creating one containing all RunnableCalls.");
            amodels.setSwModel(this.createPPs(amodels.getSwModel()));
        }
        switch (store.getString("org.eclipse.app4mc.multicore.partitioning.partAlgorithm")) {
            case "essp": {
                PartLog.getInstance().logSimple("**Starting earliest start schedule partitioning**");
                ESSP essp = new ESSP(amodels.getSwModel(), amodels.getConstraintsModel(), Integer.parseInt(store.getString("org.eclipse.app4mc.multicore.partitioning.intThreads")));
                essp.build(monitor);
                if (essp.swm.getProcessPrototypes().size() < Integer.parseInt(store.getString("org.eclipse.app4mc.multicore.partitioning.intThreads"))) {
                    PartLog.getInstance().log("ESSP could not generate " + Integer.parseInt(store.getString("org.eclipse.app4mc.multicore.partitioning.intThreads")) + " partitions since the softwaremodel's graph does not feature enough parallel runnables (though possibly sequences). " + essp.swm.getProcessPrototypes().size() + " partitions could be generated.");
                }
                amodels.setConstraintsModel(essp.cm);
                amodels.setSwModel(essp.swm);
                amodels = this.retainAffntyCnstrnts(file, amodels, monitor);
                PartLog.getInstance().log(new Helper().writePPs((EList<ProcessPrototype>)amodels.getSwModel().getProcessPrototypes()));
                PartLog.getInstance().logSimple("**Earliest start schedule partitioning finished**");
                Helper.writeModelFile(file, outputParser.parseOutputFileURI(file, "_ESSP"), amodels);
                break;
            }
            case "cpp": {
                PartLog.getInstance().logSimple("**Starting critical path partitioning**");
                CPP cpp = new CPP(amodels.getSwModel(), amodels.getConstraintsModel());
                cpp.bglobalCP = store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolGCP");
                cpp.build(monitor);
                amodels.setConstraintsModel(cpp.cm);
                amodels.setSwModel(cpp.swm);
                amodels = this.retainAffntyCnstrnts(file, amodels, monitor);
                PartLog.getInstance().log(new Helper().writePPs((EList<ProcessPrototype>)amodels.getSwModel().getProcessPrototypes()));
                PartLog.getInstance().logSimple("**Critical path partitioning finished**");
                Helper.writeModelFile(file, outputParser.parseOutputFileURI(file, "_CPP"), amodels);
                break;
            }
        }
        if (store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolTA")) {
            PartLog.getInstance().logSimple("**Starting generating a runnable sequencing constraints alternative**");
            CreateTAInput ctai = new CreateTAInput();
            ctai.setCm(amodels.getConstraintsModel());
            ctai.combineSimilarRSCs();
            amodels.setConstraintsModel(ctai.getCm());
            Helper.writeModelFile(file, outputParser.parseOutputFileURI(file, "_TAInput"), amodels);
            PartLog.getInstance().logSimple("**Generating a runnable sequencing constraints alternative finished**");
        }
        if (store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolVis")) {
            PartLog.getInstance().logSimple("**Generating Applet**");
            WriteAppletHandler wa = new WriteAppletHandler();
            wa.write(amodels.getSwModel(), amodels.getConstraintsModel(), file.getLocation().toString());
            PartLog.getInstance().logSimple("**Applet generation finished**");
        }
        long tmp = (long)((float)this.getMaxPPLength(amodels.getSwModel()) / (float)this.getSWMInstructions(amodels.getSwModel()) * 100.0f);
        PartLog.getInstance().logSimple("Sequential runtime of " + this.getSWMInstructions(amodels.getSwModel()) + " by " + amodels.getSwModel().getRunnables().size() + " Runnables were split into " + amodels.getSwModel().getProcessPrototypes().size() + " ProcessPrototypes with maximal " + this.getMaxPPLength(amodels.getSwModel()) + " Instructions to reduce overall execution time to " + tmp + "% and by " + (100L - tmp) + "%.");
    }

    public Amalthea retainAffntyCnstrnts(IFile file, Amalthea amodels, IProgressMonitor monitor) {
        UniversalHandler uh = UniversalHandler.getInstance();
        uh.dropCache();
        if (file.getFullPath().toString().startsWith("/platform:/resource")) {
            uh.readModels(URI.createPlatformResourceURI((String)file.getFullPath().toString().substring(19), (boolean)true), true);
        } else {
            uh.readModels(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
        }
        if (uh.getConstraintsModel() != null && uh.getConstraintsModel().getAffinityConstraints() != null && uh.getConstraintsModel().getAffinityConstraints().size() > 0) {
            EList rsclo = amodels.getConstraintsModel().getRunnableSequencingConstraints();
            amodels.setConstraintsModel(uh.getConstraintsModel());
            amodels.getConstraintsModel().getRunnableSequencingConstraints().addAll((Collection)rsclo);
            BasicEList cumuRuns = new BasicEList();
            for (Runnable r : amodels.getSwModel().getRunnables()) {
                if (!r.getName().contains("CumulatedRunnable")) continue;
                cumuRuns.add((Object)r);
            }
            amodels.setSwModel(this.addOrgRunsUpdateRunCalls((EList<AffinityConstraint>)amodels.getConstraintsModel().getAffinityConstraints(), amodels.getSwModel(), (EList<Runnable>)cumuRuns));
            amodels.setConstraintsModel(this.updateRSCs(amodels, (EList<Runnable>)cumuRuns));
            BasicEList rrsc = new BasicEList();
            for (RunnableSequencingConstraint rsc : amodels.getConstraintsModel().getRunnableSequencingConstraints()) {
                if (rsc.getRunnableGroups().size() <= 0 || ((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().size() <= 0 || !cumuRuns.contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) && !cumuRuns.contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
                rrsc.add((Object)rsc);
            }
            amodels.getConstraintsModel().getRunnableSequencingConstraints().removeAll((Collection)rrsc);
            amodels.getSwModel().getRunnables().removeAll((Collection)cumuRuns);
            for (ProcessPrototype pp : amodels.getSwModel().getProcessPrototypes()) {
                if (pp.getAccessPrecedenceSpec().size() <= 0) continue;
                Iterator it = pp.getAccessPrecedenceSpec().iterator();
                while (it.hasNext()) {
                    AccessPrecedenceSpec aps = (AccessPrecedenceSpec)it.next();
                    if (!aps.getOrigin().getName().contains("CumulatedRunnable") && !aps.getTarget().getName().contains("CumulatedRunnable")) continue;
                    it.remove();
                }
            }
            CycleElimination ce = new CycleElimination(amodels.getSwModel(), amodels.getConstraintsModel());
            IPreferenceStore store = PartitioningPlugin.getDefault().getPreferenceStore();
            ce.setparams(store);
            while (!ce.run(monitor).isOK()) {
            }
            amodels.setConstraintsModel(ce.getCm());
            amodels.setSwModel(ce.getSwm());
        }
        amodels.setSwModel(new Helper().updatePPsFirstLastActParams(amodels.getSwModel()));
        amodels.setConstraintsModel(new Helper().updateRSCs(amodels.getConstraintsModel(), amodels.getSwModel()));
        return amodels;
    }

    private SWModel addOrgRunsUpdateRunCalls(EList<AffinityConstraint> ac, SWModel swm, EList<Runnable> cumuRuns) {
        for (Runnable cr : cumuRuns) {
            int crindex = Integer.parseInt(cr.getName().substring(17, cr.getName().length()));
            if (!(ac.get(crindex) instanceof RunnablePairingConstraint)) continue;
            RunnableEntityGroup reg = (RunnableEntityGroup)((RunnablePairingConstraint)ac.get(crindex)).getGroup();
            swm.getRunnables().addAll((Collection)reg.getRunnables());
            for (ProcessPrototype pp : swm.getProcessPrototypes()) {
                BasicEList trcrem = new BasicEList();
                BasicEList trcs = new BasicEList();
                int index = 0;
                for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                    if (!cr.equals(trc.getRunnable())) continue;
                    index = pp.getRunnableCalls().indexOf((Object)trc);
                    AmaltheaFactory af = AmaltheaFactory.eINSTANCE;
                    for (Runnable or : reg.getRunnables()) {
                        TaskRunnableCall ntrc = af.createTaskRunnableCall();
                        ntrc.setRunnable(or);
                        trcs.add((Object)ntrc);
                    }
                    trcrem.add((Object)trc);
                }
                pp.getRunnableCalls().addAll(index, (Collection)trcs);
                pp.getRunnableCalls().removeAll((Collection)trcrem);
            }
        }
        return swm;
    }

    private ConstraintsModel updateRSCs(Amalthea am, EList<Runnable> cumuRuns) {
        for (Runnable cr : cumuRuns) {
            int crindex = Integer.parseInt(cr.getName().substring(17, cr.getName().length()));
            if (!(am.getConstraintsModel().getAffinityConstraints().get(crindex) instanceof RunnablePairingConstraint) || ((RunnablePairingConstraint)am.getConstraintsModel().getAffinityConstraints().get(crindex)).getTarget() != null) continue;
            RunnableEntityGroup reg = (RunnableEntityGroup)((RunnablePairingConstraint)am.getConstraintsModel().getAffinityConstraints().get(crindex)).getGroup();
            for (Runnable or : reg.getRunnables()) {
                for (RunnableItem ri : or.getRunnableItems()) {
                    RunnableSequencingConstraint rsc;
                    if (!(ri instanceof LabelAccess)) continue;
                    LabelAccess la = (LabelAccess)ri;
                    Label l = la.getData();
                    if (la.getAccess().equals((Object)LabelAccessEnum.READ)) {
                        EList<Runnable> wrs = this.getAccessingRunnables(l, LabelAccessEnum.WRITE, am.getSwModel());
                        for (Runnable rr : wrs) {
                            if (rr.getName().contains("CumulatedRunnable")) continue;
                            rsc = this.createRSC(rr, or, am.getSwModel());
                            if (this.CMcontains(am.getConstraintsModel(), rsc) || rsc == null) continue;
                            am.getConstraintsModel().getRunnableSequencingConstraints().add((Object)rsc);
                        }
                        continue;
                    }
                    if (!la.getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
                    EList<Runnable> rrs = this.getAccessingRunnables(l, LabelAccessEnum.READ, am.getSwModel());
                    for (Runnable rr : rrs) {
                        if (rr.getName().contains("CumulatedRunnable")) continue;
                        rsc = this.createRSC(or, rr, am.getSwModel());
                        if (this.CMcontains(am.getConstraintsModel(), rsc) || rsc == null) continue;
                        am.getConstraintsModel().getRunnableSequencingConstraints().add((Object)rsc);
                    }
                }
            }
        }
        return am.getConstraintsModel();
    }

    private EList<Runnable> getAccessingRunnables(Label l, LabelAccessEnum lae, SWModel swm) {
        BasicEList rl = new BasicEList();
        for (Runnable r : swm.getRunnables()) {
            for (RunnableItem ri : r.getRunnableItems()) {
                if (!(ri instanceof LabelAccess)) continue;
                LabelAccess la = (LabelAccess)ri;
                if (la.getData() == null) {
                    PartLog.getInstance().log("label access with no data found! at Runnable " + r.getName(), null);
                }
                if (la.getData().equals(l) && la.getAccess() == lae) {
                    rl.add((Object)r);
                    continue;
                }
                if (!la.getData().getName().equals(l.getName()) || la.getAccess() != lae) continue;
                rl.add((Object)r);
            }
        }
        return rl;
    }

    private boolean CMcontains(ConstraintsModel cm, RunnableSequencingConstraint rsc) {
        for (RunnableSequencingConstraint orsc : cm.getRunnableSequencingConstraints()) {
            if (rsc.getRunnableGroups().size() > 0 && ((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().size() > 0 && orsc.getRunnableGroups().size() > 0 && ((RunnableEntityGroup)orsc.getRunnableGroups().get(0)).getRunnables().size() > 0) {
                if (!((Runnable)((RunnableEntityGroup)orsc.getRunnableGroups().get(0)).getRunnables().get(0)).equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || !((Runnable)((RunnableEntityGroup)orsc.getRunnableGroups().get(1)).getRunnables().get(0)).equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
                return true;
            }
            if (rsc.getName() == null) continue;
            PartLog.getInstance().log("RSC empty entries: " + rsc.getName(), null);
        }
        return false;
    }

    private RunnableSequencingConstraint createRSC(Runnable source, Runnable target, SWModel swm) {
        if (target == null || source == null) {
            PartLog.getInstance().log("RSC cannot be created for null Runnable");
            return null;
        }
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        RunnableSequencingConstraint rsc = factory.createRunnableSequencingConstraint();
        rsc.setName(String.valueOf(source.getName()) + "-->" + target.getName());
        RunnableEntityGroup prg1 = factory.createRunnableEntityGroup();
        RunnableEntityGroup prg2 = factory.createRunnableEntityGroup();
        ProcessPrototype sourcePP = new Helper().getPPfromR(source, swm);
        rsc.getProcessScope().add((Object)sourcePP);
        prg1.getRunnables().add((Object)source);
        prg2.getRunnables().add((Object)target);
        rsc.getRunnableGroups().add((Object)prg1);
        rsc.getRunnableGroups().add((Object)prg2);
        rsc.setOrderType(RunnableOrderType.SUCCESSOR);
        return rsc;
    }

    private long getMaxPPLength(SWModel swm) {
        long ret = 0L;
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            long temp = 0L;
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                temp += new Helper().getInstructions(trc.getRunnable());
            }
            if (temp <= ret) continue;
            ret = temp;
        }
        return ret;
    }

    private long getSWMInstructions(SWModel swm) {
        long ret = 0L;
        for (Runnable r : swm.getRunnables()) {
            ret += new Helper().getInstructions(r);
        }
        return ret;
    }

    private SWModel createPPs(SWModel swm) {
        AmaltheaFactory af = AmaltheaFactory.eINSTANCE;
        ProcessPrototype pp = af.createProcessPrototype();
        if (((Runnable)swm.getRunnables().get(0)).getFirstActivation() != null) {
            pp.setActivation(((Runnable)swm.getRunnables().get(0)).getFirstActivation());
        }
        pp.setName("PPTemp");
        for (Runnable r : swm.getRunnables()) {
            TaskRunnableCall trc = af.createTaskRunnableCall();
            trc.setRunnable(r);
            pp.getRunnableCalls().add((Object)trc);
        }
        swm.getProcessPrototypes().add((Object)pp);
        return swm;
    }
}

