/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs.modelchecker.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpecAmountOperation;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpecAmountType;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecAmount
extends ModelSpec {
    private final ModelSpecAmountType type;
    private ModelSpecAmountOperation op;
    private int amount;
    private int compareTo;
    private String objectName;

    public ModelSpecAmount(ModelSpecAmountType type) {
        this.type = type;
        this.severity = EntrySeverityLevel.ERROR;
        this.specType = "Amount missmatch";
        this.name = "amount missmatch of " + type.toString().toLowerCase() + "s";
    }

    private boolean parseElements(Amalthea model) {
        switch (this.type) {
            case CORE: {
                this.objectName = "cores";
                this.amount = 0;
                break;
            }
            case PROCESS_PROTOTYPE: {
                this.objectName = "process prototypes";
                this.amount = model.getSwModel().getProcessPrototypes().size();
                break;
            }
            case RUNNABLE: {
                this.objectName = "runnables";
                this.amount = model.getSwModel().getRunnables().size();
                break;
            }
            case TASK: {
                this.objectName = "tasks";
                this.amount = model.getSwModel().getTasks().size();
                break;
            }
            case ACTIVATION: {
                this.objectName = "activations";
                this.amount = model.getSwModel().getActivations().size();
                break;
            }
            default: {
                this.log("Unknown object to parse from model");
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkSpec(Amalthea model) throws Exception {
        boolean cond = this.parseElements(model);
        if (!cond) {
            return false;
        }
        String loggingMessage = "Amount of " + this.objectName + " missmatch. ";
        switch (this.op) {
            case EQUAL: {
                cond = this.amount == this.compareTo;
                loggingMessage = String.valueOf(loggingMessage) + "Actual: " + this.amount + " Expected: " + this.compareTo;
                break;
            }
            case GREATER: {
                cond = this.amount > this.compareTo;
                loggingMessage = String.valueOf(loggingMessage) + "Actual: " + this.amount + " Expected: > " + this.compareTo;
                break;
            }
            case GREATER_EQUAL: {
                cond = this.amount >= this.compareTo;
                loggingMessage = String.valueOf(loggingMessage) + "Actual: " + this.amount + " Expected: >= " + this.compareTo;
                break;
            }
            case LESS: {
                cond = this.amount < this.compareTo;
                loggingMessage = String.valueOf(loggingMessage) + "Actual: " + this.amount + " Expected: < " + this.compareTo;
                break;
            }
            case LESS_EQUAL: {
                cond = this.amount <= this.compareTo;
                loggingMessage = String.valueOf(loggingMessage) + "Actual: " + this.amount + " Expected: <= " + this.compareTo;
                break;
            }
            case NOT_EQUAL: {
                cond = this.amount != this.compareTo;
                loggingMessage = String.valueOf(loggingMessage) + "Actual: " + this.amount + " Expected: != " + this.compareTo;
                break;
            }
            default: {
                return false;
            }
        }
        if (!cond) {
            this.log(loggingMessage);
        }
        return cond;
    }

    public ModelSpecAmount compareWith(ModelSpecAmountOperation op, int compareTo) {
        this.op = op;
        this.compareTo = compareTo;
        return this;
    }

    public ModelSpecAmount setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

