/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters070.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters070.utils.HelperUtils_111_070;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HwConverter
implements IConverter {
    private final HelperUtils_111_070 helper = HelperUtils_111_070.getInstance();
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from itea.111 to 0.7.0 : Executing HW converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_ComplexPort_isMaster(rootElement);
        this.update_ComplexNode_attributes(rootElement);
        this.update_ComplexNode_features(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_ComplexNode_attributes(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//hwModel//attribute[(@xsi:type=\"hw:BoolValue\") or (@xsi:type=\"hw:CharValue\") or (@xsi:type=\"hw:DoubleValue\")  or (@xsi:type=\"hw:IntValue\")  or (@xsi:type=\"hw:LongValue\")  or (@xsi:type=\"hw:StrValue\")  or (@xsi:type=\"hw:FeatureTypes\") ]");
        xpathBuffer.append("|");
        xpathBuffer.append("/hw:HWModel//attribute[(@xsi:type=\"hw:BoolValue\") or (@xsi:type=\"hw:CharValue\") or (@xsi:type=\"hw:DoubleValue\")  or (@xsi:type=\"hw:IntValue\")  or (@xsi:type=\"hw:LongValue\")  or (@xsi:type=\"hw:StrValue\")  or (@xsi:type=\"hw:FeatureTypes\") ]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Element element : elements) {
            this.createCustomProperty_Attrib_Feature(element, "attribute#");
        }
    }

    private void update_ComplexNode_features(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//hwModel//features[(@xsi:type=\"hw:BoolValue\") or (@xsi:type=\"hw:CharValue\") or (@xsi:type=\"hw:DoubleValue\")  or (@xsi:type=\"hw:IntValue\")  or (@xsi:type=\"hw:LongValue\")  or (@xsi:type=\"hw:StrValue\")  or (@xsi:type=\"hw:FeatureTypes\") ]");
        xpathBuffer.append("|");
        xpathBuffer.append("/hw:HWModel//features[(@xsi:type=\"hw:BoolValue\") or (@xsi:type=\"hw:CharValue\") or (@xsi:type=\"hw:DoubleValue\")  or (@xsi:type=\"hw:IntValue\")  or (@xsi:type=\"hw:LongValue\")  or (@xsi:type=\"hw:StrValue\")  or (@xsi:type=\"hw:FeatureTypes\") ]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Element element : elements) {
            this.createCustomProperty_Attrib_Feature(element, "feature#");
        }
    }

    private void createCustomProperty_Attrib_Feature(Element element, String prefix) {
        String type = element.getAttributeValue("type", this.helper.getGenericNS("xsi"));
        String name = element.getAttributeValue("name");
        String value = element.getAttributeValue("value");
        Element customPropertyElement = new Element("customProperties");
        customPropertyElement.setAttribute("key", String.valueOf(prefix) + name);
        Element valueElement = new Element("value");
        customPropertyElement.addContent((Content)valueElement);
        if (type.equals("hw:BoolValue")) {
            valueElement.setAttribute("type", "am:BooleanObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                valueElement.setAttribute("value", value);
            }
        } else if (type.equals("hw:CharValue")) {
            valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                try {
                    int intValue = Integer.parseInt(value);
                    char[] chars = Character.toChars(intValue);
                    valueElement.setAttribute("value", String.copyValueOf(chars));
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception occured during coversion of String :" + value + " to Integer"), (Throwable)e);
                    throw e;
                }
            }
        } else if (type.equals("hw:DoubleValue")) {
            valueElement.setAttribute("type", "am:DoubleObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                valueElement.setAttribute("value", value);
            }
        } else if (type.equals("hw:IntValue")) {
            valueElement.setAttribute("type", "am:IntegerObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                valueElement.setAttribute("value", value);
            }
        } else if (type.equals("hw:LongValue")) {
            valueElement.setAttribute("type", "am:LongObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                valueElement.setAttribute("value", value);
            }
        } else if (type.equals("hw:StrValue")) {
            valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                valueElement.setAttribute("value", value);
            }
        } else if (type.equals("hw:FeatureTypes")) {
            customPropertyElement.setAttribute("key", String.valueOf(prefix) + "FeatureTypes#" + name);
            valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
            if (value != null) {
                valueElement.setAttribute("value", value);
            }
        }
        element.getParent().addContent((Content)customPropertyElement);
        element.detach();
    }

    private void update_ComplexPort_isMaster(Element rootElement) {
        List attributes = this.helper.getXpathResult(rootElement, ".//hwModel//ports[(@xsi:type=\"hw:ComplexPort\")]/@isMaster|/hw:HWModel//ports[(@xsi:type=\"hw:ComplexPort\")]/@isMaster", Attribute.class, new Namespace[]{this.helper.getNS_111("hw"), this.helper.getGenericNS("xsi")});
        for (Attribute isMasterAttribute : attributes) {
            isMasterAttribute.setName("master");
        }
    }
}

