/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters110.impl;

import com.google.common.collect.BiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.HrefElement;
import org.eclipse.app4mc.amalthea.converters.common.utils.Tags;
import org.eclipse.app4mc.amalthea.converters110.utils.HelperUtils_103_110;
import org.eclipse.app4mc.amalthea.converters110.utils.ProcessCacheBuilder;
import org.eclipse.app4mc.amalthea.converters110.utils.ProcessCacheEnum;
import org.eclipse.app4mc.amalthea.converters110.utils.SchedulerCacheBuilder;
import org.eclipse.app4mc.amalthea.converters110.utils.SchedulerCacheEnum;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MappingConverter
implements IConverter {
    private final HelperUtils_103_110 helper;
    private String workingDirectoryLocation;
    private List<ICache> caches;
    private final Logger logger;
    private final Map<Element, Element> os_defaultInterruptControllerMap = new HashMap<Element, Element>();
    private int interruptControllerCount = 1;

    public MappingConverter() {
        this.helper = HelperUtils_103_110.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from itea.103 to itea.110 : Executing Mapping converter for model file : " + targetFile.getName()));
        this.caches = caches;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        this.workingDirectoryLocation = targetFile.getParentFile().getCanonicalPath();
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_110(rootElement);
        this.helper.addAdditionalNameSpace(rootElement, new Namespace[]{this.helper.getNS_110("os"), this.helper.getNS_110("sw")});
        this.updateProcessAllocations(targetFile, rootElement, fileName_documentsMap);
        this.updateRunnableAllocations(targetFile, rootElement, fileName_documentsMap);
        fileName_documentsMap.put(this.getFile(fileName_documentsMap, targetFile.getName()), root);
    }

    private void updateRunnableAllocations(File targetFile, Element rootElement, Map<File, Document> fileName_documentsMap) {
        List xpathResult = this.helper.getXpathResult(rootElement, ".//executableAllocation[@xsi:type=\"mapping:RunnableAllocation\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_110("mapping")});
        for (Element element : xpathResult) {
            Attribute typeAttribute;
            element.setName(Tags.runnableAllocation.getValue());
            Element refScheduler = element.getChild("scheduler");
            if (refScheduler == null || (typeAttribute = refScheduler.getAttribute("type", this.helper.getGenericNS("xsi"))) != null) continue;
            refScheduler.setAttribute("type", "os:TaskScheduler", this.helper.getGenericNS("xsi"));
        }
    }

    private void updateProcessAllocations(File targetFile, Element rootElement, Map<File, Document> fileName_documentsMap) throws Exception {
        List processAllocationElements = this.helper.getXpathResult(rootElement, ".//executableAllocation[@xsi:type=\"mapping:ProcessAllocation\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_110("mapping")});
        for (Element processAllocationElement : processAllocationElements) {
            List<Element> schedulers;
            Attribute attribute;
            processAllocationElement.setName(Tags.processAllocation.getValue());
            Attribute schedulerIDAttrribute = processAllocationElement.getAttribute(Tags.scheduler.getValue());
            Attribute processIDAttribute = processAllocationElement.getAttribute(Tags.process.getValue());
            Element refSchedulerElement = processAllocationElement.getChild(Tags.scheduler.getValue());
            Element refProcessElement = processAllocationElement.getChild(Tags.process.getValue());
            HrefElement schedulerHRef = null;
            HrefElement processHRef = null;
            String schedulerID = null;
            String processID = null;
            String schedulerRefFile = null;
            String processRefFile = null;
            if (schedulerIDAttrribute == null && refSchedulerElement != null) {
                attribute = refSchedulerElement.getAttribute("href");
                schedulerHRef = this.helper.getHrefElement(attribute.getValue());
                schedulerRefFile = schedulerHRef.getFileName();
                schedulerID = schedulerHRef.getXmiID();
            } else if (schedulerIDAttrribute != null) {
                schedulerID = schedulerIDAttrribute.getValue();
            }
            if (processIDAttribute == null && refProcessElement != null) {
                attribute = refProcessElement.getAttribute("href");
                processHRef = this.helper.getHrefElement(attribute.getValue());
                processRefFile = processHRef.getFileName();
                processID = processHRef.getXmiID();
            } else if (processIDAttribute != null) {
                processID = processIDAttribute.getValue();
            }
            if (schedulerID != null && processID != null) {
                schedulers = this.getScheduler(targetFile, schedulerID, schedulerRefFile, schedulerHRef, rootElement, fileName_documentsMap);
                List<Element> processs = this.getProcess(targetFile, processID, processRefFile, processHRef, rootElement, fileName_documentsMap);
                if (schedulers.size() == 0 || processs.size() == 0) {
                    if (schedulers.size() == 0) {
                        System.err.println("Unable to find the Scheduler having ID : " + schedulerID);
                    }
                    if (processs.size() != 0) continue;
                    System.err.println("Unable to find the Process having ID : " + processID);
                    continue;
                }
                Element processElement = processs.get(0);
                Element schedulerElement = schedulers.get(0);
                boolean isInterruptControllerAssigned = false;
                String processElementName = processElement.getName();
                if (processElementName.equals(Tags.isrs.getValue())) {
                    Attribute attribute2 = processAllocationElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                    attribute2.setValue("mapping:ISRAllocation");
                    isInterruptControllerAssigned = true;
                    Element interrupControllerElement = this.createDefaultInterruptController(schedulerElement);
                    if (schedulerIDAttrribute != null) {
                        schedulerIDAttrribute.setValue(interrupControllerElement.getAttributeValue("id", this.helper.getGenericNS("xmi")));
                    } else if (refSchedulerElement != null && schedulerHRef != null) {
                        refSchedulerElement.getAttribute("href").setValue(String.valueOf(schedulerHRef.getFileName()) + "#" + interrupControllerElement.getAttributeValue("id", this.helper.getGenericNS("xmi")));
                    }
                } else if (processElementName.equals(Tags.tasks.getValue())) {
                    Attribute processAllocationTypeAttribute = processAllocationElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                    processAllocationTypeAttribute.setValue("mapping:TaskAllocation");
                }
                if (refSchedulerElement == null) continue;
                if (schedulerElement.getName().equals("taskSchedulers")) {
                    if (isInterruptControllerAssigned) {
                        refSchedulerElement.setAttribute("type", "os:InterruptController", this.helper.getGenericNS("xsi"));
                        continue;
                    }
                    refSchedulerElement.setAttribute("type", "os:TaskScheduler", this.helper.getGenericNS("xsi"));
                    continue;
                }
                if (!schedulerElement.getName().equals("interruptControllers")) continue;
                refSchedulerElement.setAttribute("type", "os:InterruptController", this.helper.getGenericNS("xsi"));
                continue;
            }
            if (schedulerID == null && processID != null) {
                List<Element> processs = this.getProcess(targetFile, processID, processRefFile, processHRef, rootElement, fileName_documentsMap);
                if (processs.size() == 0) {
                    System.err.println("Unable to find the Process having ID : " + processID);
                    continue;
                }
                Element processElement = processs.get(0);
                String processElementName = processElement.getName();
                if (processElementName.equals(Tags.isrs.getValue())) {
                    Attribute attribute3 = processAllocationElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                    attribute3.setValue("mapping:ISRAllocation");
                    continue;
                }
                if (!processElementName.equals(Tags.tasks.getValue())) continue;
                Attribute processAllocationTypeAttribute = processAllocationElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                processAllocationTypeAttribute.setValue("mapping:TaskAllocation");
                continue;
            }
            if (schedulerID != null && processID == null) {
                schedulers = this.getScheduler(targetFile, schedulerID, schedulerRefFile, schedulerHRef, rootElement, fileName_documentsMap);
                if (schedulers.size() == 0) {
                    if (schedulers.size() != 0) continue;
                    System.err.println("Unable to find the Scheduler having ID : " + schedulerID);
                    continue;
                }
                Element schedulerElement = schedulers.get(0);
                Attribute processAllocationTypeAttribute = processAllocationElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                processAllocationTypeAttribute.setValue("mapping:TaskAllocation");
                if (refSchedulerElement == null) continue;
                if (schedulerElement.getName().equals("taskSchedulers")) {
                    refSchedulerElement.setAttribute("type", "os:TaskScheduler", this.helper.getGenericNS("xsi"));
                    continue;
                }
                if (!schedulerElement.getName().equals("interruptControllers")) continue;
                refSchedulerElement.setAttribute("type", "os:InterruptController", this.helper.getGenericNS("xsi"));
                continue;
            }
            System.err.println("unable to find both : Scheduler and Process attributes for element : " + processAllocationElement.toString());
        }
    }

    private Element createDefaultInterruptController(Element schedulerElement) {
        Element schedulersParent = schedulerElement.getParentElement();
        if (this.os_defaultInterruptControllerMap.containsKey(schedulersParent)) {
            return this.os_defaultInterruptControllerMap.get(schedulersParent);
        }
        Element interrupControllerElement = new Element("interruptControllers");
        String interruptControllerID = EcoreUtil.generateUUID();
        interrupControllerElement.setAttribute("id", interruptControllerID, this.helper.getGenericNS("xmi"));
        interrupControllerElement.setAttribute("name", "interruptController" + this.interruptControllerCount++ + "_migration_generated");
        Element schedulingAlgorithmElement = new Element("schedulingAlgorithm");
        schedulingAlgorithmElement.setAttribute("type", "os:PriorityBased", this.helper.getGenericNS("xsi"));
        String schedulingAlgorithmID = EcoreUtil.generateUUID();
        schedulingAlgorithmElement.setAttribute("id", schedulingAlgorithmID, this.helper.getGenericNS("xmi"));
        interrupControllerElement.addContent((Content)schedulingAlgorithmElement);
        schedulersParent.addContent(schedulersParent.indexOf((Content)schedulerElement), (Content)interrupControllerElement);
        this.os_defaultInterruptControllerMap.put(schedulersParent, interrupControllerElement);
        return interrupControllerElement;
    }

    private List<Element> getScheduler(File targetFile, String schedulerID, String refFileName, HrefElement schedulerHRef, Element rootElement, Map<File, Document> fileName_documentsMap) throws Exception {
        List<Object> schedulerElements = new ArrayList();
        if (schedulerID.contains("/")) {
            if (schedulerHRef != null) {
                schedulerID = String.valueOf(schedulerHRef.getFileName()) + "#" + schedulerHRef.getXmiID();
            }
            for (ICache cache : this.getFilteredCaches(this.caches, new Class[]{SchedulerCacheBuilder.class})) {
                Element element;
                Map map = (Map)cache.getCacheMap().get(targetFile);
                if (map == null) continue;
                BiMap urifragment_new_old_map = (BiMap)map.get(SchedulerCacheEnum.URI_FRAGMENT_NEW_OLD.name());
                if (urifragment_new_old_map != null) {
                    schedulerID = (String)urifragment_new_old_map.get((Object)schedulerID);
                }
                Map uriFragment_SchedulerMap = null;
                uriFragment_SchedulerMap = schedulerID.contains("#") ? (Map)map.get(SchedulerCacheEnum.HREF_URIFRAGMENT_SCHEDULER_ELEMENT.name()) : (Map)map.get(SchedulerCacheEnum.URIFRAGMENT_SCHEDULER_ELEMENT.name());
                if (uriFragment_SchedulerMap == null || (element = (Element)uriFragment_SchedulerMap.get(schedulerID)) == null) continue;
                schedulerElements.add(element);
                break;
            }
            return schedulerElements;
        }
        if (refFileName != null) {
            String referencedFilePath = String.valueOf(this.workingDirectoryLocation) + File.separator + refFileName;
            File referenceFile = new File(referencedFilePath).getCanonicalFile();
            Document document = fileName_documentsMap.get(referenceFile);
            schedulerElements = this.getSchedulerObject(schedulerID, referenceFile, document);
        } else {
            schedulerElements = this.getSchedulerObject(schedulerID, targetFile, rootElement.getDocument());
        }
        return schedulerElements;
    }

    private List<Element> getProcess(File targetFile, String processID, String refFileName, HrefElement processHRef, Element rootElement, Map<File, Document> fileName_documentsMap) throws Exception {
        List<Object> processElements = new ArrayList();
        if (processID.contains("/")) {
            if (processHRef != null) {
                processID = String.valueOf(processHRef.getFileName()) + "#" + processHRef.getXmiID();
            }
            for (ICache cache : this.caches) {
                Element element;
                Map map = (Map)cache.getCacheMap().get(targetFile);
                if (map == null) continue;
                Map uriFragment_ProcessMap = null;
                uriFragment_ProcessMap = processID.contains("#") ? (Map)map.get(ProcessCacheEnum.HREF_URIFRAGMENT_PROCESS_ELEMENT.name()) : (Map)map.get(ProcessCacheEnum.URIFRAGMENT_PROCESS_ELEMENT.name());
                if (uriFragment_ProcessMap == null || (element = (Element)uriFragment_ProcessMap.get(processID)) == null) continue;
                processElements.add(element);
                break;
            }
            return processElements;
        }
        if (refFileName != null) {
            String referencedFilePath = new File(String.valueOf(this.workingDirectoryLocation) + File.separator + refFileName).getCanonicalPath();
            File referenceFile = new File(referencedFilePath);
            Document document = fileName_documentsMap.get(referenceFile);
            processElements = this.getProcessObject(processID, referenceFile, document);
        } else {
            processElements = this.getProcessObject(processID, targetFile, rootElement.getDocument());
        }
        return processElements;
    }

    private List<Element> getProcessObject(String processID, File targetFile, Document document) {
        for (ICache iCache : this.getFilteredCaches(this.caches, new Class[]{ProcessCacheBuilder.class})) {
            Element element;
            Map map = (Map)iCache.getCacheMap().get(targetFile);
            if (map == null) {
                System.err.println("Target file can't be found : " + targetFile.getName());
                continue;
            }
            Map uuid_process_map = (Map)map.get(ProcessCacheEnum.UUID_PROCESS_ELEMENT.name());
            if (uuid_process_map == null || (element = (Element)uuid_process_map.get(processID)) == null) continue;
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(element);
            return elements;
        }
        List processElements = this.helper.getXpathResult(document, ".//swModel/tasks[@xmi:id=\"" + processID + "\"  ] ", Element.class, new Namespace[]{this.helper.getGenericNS("xmi"), this.helper.getNS_110("sw")});
        if (processElements.size() == 0) {
            processElements = this.helper.getXpathResult(document, ".//sw:SWModel/tasks[@xmi:id=\"" + processID + "\"  ] ", Element.class, new Namespace[]{this.helper.getGenericNS("xmi"), this.helper.getNS_110("sw")});
        }
        if (processElements.size() == 0) {
            processElements = this.helper.getXpathResult(document, ".//swModel/isrs[@xmi:id=\"" + processID + "\"  ] ", Element.class, new Namespace[]{this.helper.getGenericNS("xmi"), this.helper.getNS_110("sw")});
        }
        if (processElements.size() == 0) {
            processElements = this.helper.getXpathResult(document, ".//sw:SWModel/isrs[@xmi:id=\"" + processID + "\"  ] ", Element.class, new Namespace[]{this.helper.getGenericNS("xmi"), this.helper.getNS_110("sw")});
        }
        return processElements;
    }

    private List<Element> getSchedulerObject(String schedulerID, File targetFile, Document document) {
        for (ICache iCache : this.caches) {
            Element element;
            if (!(iCache instanceof SchedulerCacheBuilder)) continue;
            Map map = (Map)iCache.getCacheMap().get(targetFile);
            if (map == null) {
                System.err.println("Target file can't be found : " + targetFile.getName());
                continue;
            }
            Map uuid_scheduler_map = (Map)map.get(SchedulerCacheEnum.UUID_SCHEDULER_ELEMENT.name());
            if (uuid_scheduler_map == null || (element = (Element)uuid_scheduler_map.get(schedulerID)) == null) continue;
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(element);
            return elements;
        }
        List schedulerElements = this.helper.getXpathResult(document, ".//osModel/operatingSystems/taskSchedulers[@xmi:id=\"" + schedulerID + "\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xmi")});
        if (schedulerElements.size() == 0) {
            schedulerElements = this.helper.getXpathResult(document, ".//os:OSModel/operatingSystems/taskSchedulers[@xmi:id=\"" + schedulerID + "\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xmi"), this.helper.getNS_110("os")});
        }
        return schedulerElements;
    }

    public List<ICache> getCaches() {
        return this.caches;
    }

    public void setCaches(List<ICache> caches) {
        this.caches = caches;
    }
}

