/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.messages.Messages;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.ModelSearchResult;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.SearchMatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.ui.IEditorInput;

public class ModelHitCollector
implements ISearchQuery {
    private final ModelSearchResult searchResult = new ModelSearchResult(this);
    private final IEditorInput editorInput;
    private final String query;
    private final EObject model;

    public ModelHitCollector(String query, EObject model, IEditorInput input) {
        this.query = query;
        this.model = model;
        this.editorInput = input;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        block4: {
            this.searchResult.removeAll();
            if (this.query == null) break block4;
            if (this.query.startsWith("i:")) {
                String modQuery = this.query.substring(2);
                Pattern pattern = Pattern.compile("(?i).*" + Pattern.quote(modQuery) + ".*");
                Set resultSet = AmaltheaIndex.getElements((Notifier)this.model, (Pattern)pattern, INamed.class);
                for (INamed element : resultSet) {
                    this.searchResult.addMatch(new SearchMatch(element, 0, 0, this.editorInput));
                }
            } else {
                TreeIterator iterator = EcoreUtil.getAllContents((EObject)this.model, (boolean)true);
                while (iterator.hasNext()) {
                    String name;
                    EObject element = (EObject)iterator.next();
                    EStructuralFeature feature = element.eClass().getEStructuralFeature("name");
                    if (feature == null || (name = (String)element.eGet(feature)) == null || name.toLowerCase().indexOf(this.query.toLowerCase()) < 0) continue;
                    this.searchResult.addMatch(new SearchMatch(element, 0, 0, this.editorInput));
                }
            }
        }
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return Messages.ModelHitCollector_label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }
}

