/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.Collections;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Cache;
import org.eclipse.app4mc.amalthea.model.ConnectionHandler;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwDestination;
import org.eclipse.app4mc.amalthea.model.HwModule;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryDefinition;
import org.eclipse.app4mc.amalthea.model.PortInterface;
import org.eclipse.app4mc.amalthea.model.PortType;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class HardwareModelCheckValidatorImpl
extends AbstractValidatorImpl {
    public HardwareModelCheckValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public HardwareModelCheckValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkSystemStructure(HWModel hwModel) {
    }

    public void checkHwConnection(HwConnection connection) {
        boolean continueChecks = true;
        HwPort port1 = connection.getPort1();
        HwPort port2 = connection.getPort2();
        if (port1 == null) {
            this.issueCreator.issue((EObject)connection, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwConnection_Port1(), new Object[]{connection.getName(), "Port 1 is missing"});
            continueChecks = false;
        }
        if (port2 == null) {
            this.issueCreator.issue((EObject)connection, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwConnection_Port2(), new Object[]{connection.getName(), "Port 2 is missing"});
            continueChecks = false;
        }
        if (port1 != null && port1 == port2) {
            this.issueCreator.issue((EObject)connection, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwConnection_Port1(), new Object[]{connection.getName(), "Port 1 equals port 2"});
            continueChecks = false;
        }
        if (!continueChecks) {
            return;
        }
        if (!connection.isInternal() && port1.getPortInterface() != PortInterface._UNDEFINED_ && port2.getPortInterface() != PortInterface._UNDEFINED_ && port1.getPortInterface() != port2.getPortInterface()) {
            this.issueCreator.issue((EObject)connection, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwConnection_Port1(), new Object[]{connection.getName(), "Port interfaces do not match"});
        }
        if (port1.getPortType() == PortType.INITIATOR && port2.getPortType() == PortType.INITIATOR || port1.getPortType() == PortType.RESPONDER && port2.getPortType() == PortType.RESPONDER) {
            this.issueCreator.issue((EObject)connection, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwConnection_Port1(), new Object[]{connection.getName(), "Port types do not fulfill initiator -> responder"});
        }
    }

    public void checkHwPort(HwPort port) {
        if (port.isDelegated()) {
            return;
        }
        EList connections = port.getConnections();
        if (connections.size() > 1) {
            int counter = 0;
            for (HwConnection con : connections) {
                if (con.isInternal()) continue;
                ++counter;
            }
            if (counter > 1) {
                this.issueCreator.issue((EObject)port, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwPort_Connections(), new Object[]{port.getName(), "Port has " + counter + " connections, only 1 is allowed"});
            }
        }
    }

    public void checkAccessPath(HwAccessPath path) {
        EList pathElements;
        boolean performRangeCheck = true;
        Memory memory = null;
        MemoryDefinition memoryDef = null;
        long addressRange = path.getEndAddress() - path.getStartAddress();
        long requiredSize = path.getMemOffset() + addressRange;
        if (addressRange <= 0L) {
            this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_EndAddress(), new Object[]{path.getName(), "Start address >= End address"});
            performRangeCheck = false;
        }
        if (path.getDestination() instanceof Memory) {
            memory = (Memory)path.getDestination();
            memoryDef = memory.getDefinition();
            if (memoryDef == null) {
                this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwPath_Destination(), new Object[]{path.getName(), "Destination (Memory) size is undefined"});
                performRangeCheck = false;
            }
        } else {
            performRangeCheck = false;
        }
        if (performRangeCheck && requiredSize > memoryDef.getSize().getNumberBytes()) {
            this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_EndAddress(), new Object[]{path.getName(), "Address range > Memory size"});
        }
        if ((pathElements = path.getPathElements()).isEmpty()) {
            return;
        }
        ProcessingUnit source = path.getSource();
        HwDestination destination = path.getDestination();
        HwPathElement first = (HwPathElement)pathElements.get(0);
        HwPathElement last = (HwPathElement)pathElements.get(pathElements.size() - 1);
        if (first instanceof HwConnection) {
            if (Collections.disjoint(source.getPorts(), first.getPorts())) {
                this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_PathElements(), new Object[]{path.getName(), "No common port at the beginning of the path"});
            }
        } else {
            this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_PathElements(), new Object[]{path.getName(), "First path element must be a connection"});
        }
        if (last instanceof HwConnection) {
            if (destination == null) {
                this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwPath_Destination(), new Object[]{path.getName(), "Destination is undefined"});
            } else if (Collections.disjoint(destination.getPorts(), last.getPorts())) {
                this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_PathElements(), new Object[]{path.getName(), "No common port at the end of the path"});
            }
        } else {
            this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_PathElements(), new Object[]{path.getName(), "Last path element must be a connection"});
        }
        if (pathElements.size() < 2) {
            return;
        }
        int i = 0;
        while (i < pathElements.size() - 1) {
            HwPathElement item1 = (HwPathElement)pathElements.get(i);
            HwPathElement item2 = (HwPathElement)pathElements.get(i + 1);
            if (Collections.disjoint(item1.getPorts(), item2.getPorts())) {
                this.issueCreator.issue((EObject)path, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwAccessPath_PathElements(), new Object[]{path.getName(), "No common port between element[" + i + "] and element[" + (i + 1) + "]"});
            }
            ++i;
        }
    }

    public void checkPortForUndefined(HwPort port) {
        if (port.getPortType() == PortType._UNDEFINED_) {
            this.issueCreator.issue((EObject)port, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwPort_PortType(), new Object[]{"Port \"" + port.getName() + "\" - undefined port type"});
        }
        if (port.getPortInterface() == PortInterface._UNDEFINED_) {
            this.issueCreator.issue((EObject)port, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getHwPort_PortInterface(), new Object[]{"Port \"" + port.getName() + "\" - undefined port interface"});
        }
    }

    public void checkModuleForMissingDefinition(HwModule module) {
        if (module instanceof Memory && ((Memory)module).getDefinition() == null) {
            this.issueCreator.issue((EObject)module, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getMemory_Definition(), new Object[]{"Memory \"" + module.getName() + "\" - missing definition"});
        }
        if (module instanceof ProcessingUnit && ((ProcessingUnit)module).getDefinition() == null) {
            this.issueCreator.issue((EObject)module, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getProcessingUnit_Definition(), new Object[]{"ProcessingUnit \"" + module.getName() + "\" - missing definition"});
        }
        if (module instanceof ConnectionHandler && ((ConnectionHandler)module).getDefinition() == null) {
            this.issueCreator.issue((EObject)module, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getConnectionHandler_Definition(), new Object[]{"ConnectionHandler \"" + module.getName() + "\" - missing definition"});
        }
        if (module instanceof Cache && ((Cache)module).getDefinition() == null) {
            this.issueCreator.issue((EObject)module, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCache_Definition(), new Object[]{"Cache \"" + module.getName() + "\" - missing definition"});
        }
    }
}

