/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.btf.test;

import java.util.Iterator;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfComputer;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfException;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEntityType;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEvent;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfTrace;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMCore;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTask;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskHistState;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskState;
import org.junit.Assert;
import org.junit.Test;

public class BtfStateComputerTests {
    @Test
    public void testBtfStateComputer() throws BtfException {
        BtfTrace t = new BtfTrace();
        t.setName("BTF-Test");
        t.setTimeScale(EMTimeType.MS);
        BtfEvent e = new BtfEvent();
        e.setEvent("activate");
        e.setSource("Task1");
        e.setTarget("Task1");
        e.setTargetType(BtfEntityType.TASK);
        e.setTargetInstance(0);
        e.setSourceInstance(0);
        e.setTime(10L);
        t.getEvents().add(e);
        e = new BtfEvent();
        e.setEvent("start");
        e.setSource("Core1");
        e.setTarget("Task1");
        e.setTargetType(BtfEntityType.TASK);
        e.setTargetInstance(0);
        e.setSourceInstance(0);
        e.setTime(12L);
        t.getEvents().add(e);
        t.getEntityTypeTable().put("Core1", BtfEntityType.CORE);
        t.getEntityTypeTable().put("Task1", BtfEntityType.TASK);
        ExecutionModel m = new ExecutionModel();
        BtfComputer tc = new BtfComputer(t, m);
        tc.compute();
        Assert.assertEquals((long)1L, (long)m.getTasks().size());
        Assert.assertEquals((long)1L, (long)m.getCores().size());
        EMTask hist = (EMTask)m.getTasks().get("Task1");
        Assert.assertNotEquals(null, (Object)hist);
        Assert.assertEquals((long)3L, (long)hist.getStateHistory().size());
        Assert.assertEquals((long)m.getCores().size(), (long)1L);
        Assert.assertEquals((Object)((EMCore)m.getCores().get("Core1")).getName(), (Object)"Core1");
        Iterator it = hist.getStateHistory().iterator();
        EMTaskHistState histEnt = (EMTaskHistState)it.next();
        Assert.assertNotEquals(null, (Object)histEnt);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)histEnt.getStart());
        Assert.assertEquals((long)10L, (long)histEnt.getEnd());
        histEnt = (EMTaskHistState)it.next();
        Assert.assertNotEquals((Object)histEnt, null);
        Assert.assertEquals((long)10L, (long)histEnt.getStart());
        Assert.assertEquals((long)12L, (long)histEnt.getEnd());
        histEnt = (EMTaskHistState)it.next();
        Assert.assertNotEquals((Object)histEnt, null);
        Assert.assertEquals((Object)EMTaskState.RUNNING, (Object)histEnt.getState());
        Assert.assertEquals((long)12L, (long)histEnt.getStart());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)histEnt.getEnd());
    }
}

