/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters083.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters083.utils.HelperUtils_082_083;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ComponentModelConverter
extends AbstractConverter {
    public ComponentModelConverter() {
        this.helper = HelperUtils_082_083.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.2 to 0.8.3  : Executing Component model converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateInterfacePort(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateInterfacePort(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./componentsModel/components/ports");
        List portElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element portElement : portElements) {
            String value;
            Attribute typeAttribute = portElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (typeAttribute == null || !(value = typeAttribute.getValue()).equals("am:FInterfacePort")) continue;
            typeAttribute.setValue("am:InterfacePort");
        }
        StringBuffer xpathBufferForReferences = new StringBuffer();
        xpathBufferForReferences.append("./componentsModel/components/groundedPorts");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/components/connectors/sourcePort");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/components/connectors/targetPort");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/systems/groundedPorts");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/systems/connectors/sourcePort");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./componentsModel/systems/connectors/targetPort");
        List elementsReferringPorts = this.helper.getXpathResult(rootElement, xpathBufferForReferences.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element elementReferringPort : elementsReferringPorts) {
            Attribute portAttribute = elementReferringPort.getAttribute("port");
            if (portAttribute == null) {
                Attribute hrefAttribute;
                String value;
                Element portElement = elementReferringPort.getChild("port");
                if (portElement == null) continue;
                Attribute typeAttribute = portElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                if (typeAttribute != null && (value = typeAttribute.getValue()).equals("am:FInterfacePort")) {
                    typeAttribute.setValue("am:InterfacePort");
                }
                if ((hrefAttribute = portElement.getAttribute("href")) == null) continue;
                String value2 = hrefAttribute.getValue();
                value2 = value2.replace("=FInterfacePort", "=InterfacePort");
                hrefAttribute.setValue(value2);
                continue;
            }
            String value = portAttribute.getValue();
            value = value.replace("=FInterfacePort", "=InterfacePort");
            portAttribute.setValue(value);
        }
    }
}

