/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.utils;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractHelper;
import org.eclipse.app4mc.amalthea.converters090.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class UpdateCustomPropsPostProcessor
implements IPostProcessor {
    private HWTransformationCache hwTransformationCache;
    private List<ICache> caches;

    public void addCaches(List<ICache> caches) {
        this.caches = caches;
    }

    public void process(Map<File, Document> fileName_documentsMap, AbstractHelper helper) throws Exception {
        List<String> hwTypes_083 = this.initializeHwTypesList();
        Collection<Document> values = fileName_documentsMap.values();
        for (Document document : values) {
            Element rootElement = document.getRootElement();
            List value_customPropertyElements = helper.getXpathResult(rootElement, ".//customProperties//*[@xsi:type=\"am:ReferenceObject\"]", Element.class, new Namespace[]{helper.getGenericNS("xsi")});
            for (Element value_customPropertyElement : value_customPropertyElements) {
                Map.Entry entry = helper.getSingleElementsNameandTypeFromAttributeOrChildeElement("value", value_customPropertyElement);
                if (entry == null || !hwTypes_083.contains(entry.getValue())) continue;
                value_customPropertyElement.removeAttribute("value");
                value_customPropertyElement.removeChild("value");
                String updatedTypeAfterMigration = this.getUpdatedType((String)entry.getKey(), (String)entry.getValue());
                if (values.size() > 1) {
                    Element valueElement = new Element("value");
                    valueElement.setAttribute("type", "am:" + updatedTypeAfterMigration, helper.getGenericNS("xsi"));
                    valueElement.setAttribute("href", "amlt:/#" + (String)entry.getKey() + "?" + "type=" + updatedTypeAfterMigration);
                    value_customPropertyElement.addContent((Content)valueElement);
                    continue;
                }
                value_customPropertyElement.setAttribute("value", String.valueOf((String)entry.getKey()) + "?type=" + updatedTypeAfterMigration);
            }
        }
    }

    private List<String> initializeHwTypesList() {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("HWModel");
        ls.add("ComplexNode");
        ls.add("HwSystem");
        ls.add("ECU");
        ls.add("Microcontroller");
        ls.add("Core");
        ls.add("Memory");
        ls.add("Network");
        ls.add("Quartz");
        ls.add("HwComponent");
        ls.add("HardwareTypeDescription");
        ls.add("AbstractionType");
        ls.add("SystemType");
        ls.add("ECUType");
        ls.add("MicrocontrollerType");
        ls.add("CoreType");
        ls.add("MemoryType");
        ls.add("NetworkType");
        ls.add("HwPort");
        ls.add("Pin");
        ls.add("ComplexPort");
        ls.add("ComplexPin");
        ls.add("Prescaler");
        ls.add("CrossbarSwitch");
        ls.add("Bus");
        ls.add("Bridge");
        ls.add("LatencyAccessPath");
        ls.add("HwAccessPath");
        ls.add("AccessPathRef");
        ls.add("LatencyConstant");
        ls.add("LatencyDeviation");
        ls.add("HwAccessPathRef");
        ls.add("HwElementRef");
        return ls;
    }

    private String getUpdatedType(String name, String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("MemoryType")) {
            if (this.getHWTransformationCache().new_cache_Types_Definition_Map.containsKey(name)) {
                value = "CacheDefinition";
            } else if (this.getHWTransformationCache().new_memories_Map.containsKey(name)) {
                value = "MemoryDefinition";
            }
        } else if (value.equals("Memory")) {
            if (this.getHWTransformationCache().new_caches_Map.containsKey(name)) {
                value = "Cache";
            } else if (this.getHWTransformationCache().new_memories_Map.containsKey(name)) {
                value = "Memory";
            }
        } else if (value.equals("CoreType")) {
            value = "ProcessingUnit";
        } else if (value.equals("NetworkType")) {
            value = "ConnectionHandler";
        } else if (value.equals("HwSystem")) {
            value = "HwStructure";
        } else if (value.equals("ECU")) {
            value = "HwStructure";
        } else if (value.equals("Microcontroller")) {
            value = "HwStructure";
        } else if (value.equals("Core")) {
            value = "ProcessingUnitDefinition";
        } else if (value.equals("Network")) {
            value = "ConnectionHandlerDefinition";
        } else if (value.equals("Quartz")) {
            value = "FrequencyDomain";
        }
        return value;
    }

    private HWTransformationCache getHWTransformationCache() {
        if (this.hwTransformationCache == null) {
            boolean isHWCacheAvailable = false;
            if (this.caches == null) {
                this.caches = new ArrayList<ICache>();
            }
            for (ICache cache : this.caches) {
                Map map;
                if (!(cache instanceof HWCacheBuilder)) continue;
                isHWCacheAvailable = true;
                Map cacheMap = cache.getCacheMap();
                if (cacheMap == null || cacheMap.size() <= 0 || (map = (Map)Iterables.get(cacheMap.values(), (int)0)) == null) continue;
                Object object = map.get("globalCache");
                return (HWTransformationCache)object;
            }
            if (!isHWCacheAvailable) {
                return new HWTransformationCache();
            }
        }
        return this.hwTransformationCache;
    }
}

