/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.DataRate;
import org.eclipse.app4mc.amalthea.model.DataRateUnit;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.GaussDistribution;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.LatencyConstant;
import org.eclipse.app4mc.amalthea.model.LatencyDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Need;
import org.eclipse.app4mc.amalthea.model.NeedConstant;
import org.eclipse.app4mc.amalthea.model.NeedDeviation;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TypeDefinition;
import org.eclipse.app4mc.amalthea.model.TypeRef;
import org.eclipse.app4mc.amalthea.model.Voltage;
import org.eclipse.app4mc.amalthea.model.VoltageUnit;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.model.util.TimeUtil;

public class FactoryUtil {
    public static DataSize createDataSize(long value, DataSizeUnit unit) {
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        size.setValue(BigInteger.valueOf(value));
        size.setUnit(unit);
        return size;
    }

    public static DataRate createDataRate(long value, DataRateUnit unit) {
        DataRate rate = AmaltheaFactory.eINSTANCE.createDataRate();
        rate.setValue(BigInteger.valueOf(value));
        rate.setUnit(unit);
        return rate;
    }

    public static Frequency createFrequency(double value, FrequencyUnit unit) {
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        frequency.setValue(value);
        frequency.setUnit(unit);
        return frequency;
    }

    public static Voltage createVoltage(double value, VoltageUnit unit) {
        Voltage voltage = AmaltheaFactory.eINSTANCE.createVoltage();
        voltage.setValue(value);
        voltage.setUnit(unit);
        return voltage;
    }

    public static Time createTime(long value, TimeUnit unit) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(BigInteger.valueOf(value));
        time.setUnit(unit);
        return time;
    }

    public static TypeRef createTypeRef(TypeDefinition typeDefinition) {
        TypeRef refObj = AmaltheaFactory.eINSTANCE.createTypeRef();
        refObj.setTypeDef(typeDefinition);
        return refObj;
    }

    public static LatencyConstant createLatency(long cycles) {
        LatencyConstant latency = AmaltheaFactory.eINSTANCE.createLatencyConstant();
        latency.setCycles(cycles);
        return latency;
    }

    public static LatencyDeviation createLatency(Deviation<LongObject> cycles) {
        LatencyDeviation latency = AmaltheaFactory.eINSTANCE.createLatencyDeviation();
        latency.setCycles(cycles);
        return latency;
    }

    public static Deviation<LongObject> createDeviation(Distribution<LongObject> dist) {
        Deviation<LongObject> result = AmaltheaFactory.eINSTANCE.createDeviation();
        result.setDistribution(dist);
        return result;
    }

    public static Deviation<LongObject> createDeviation(Distribution<LongObject> dist, long min, long max) {
        Deviation<LongObject> result = AmaltheaFactory.eINSTANCE.createDeviation();
        result.setDistribution(dist);
        LongObject upperBound = AmaltheaFactory.eINSTANCE.createLongObject();
        upperBound.setValue(max);
        LongObject lowerBound = AmaltheaFactory.eINSTANCE.createLongObject();
        lowerBound.setValue(min);
        result.setUpperBound(upperBound);
        result.setLowerBound(lowerBound);
        return result;
    }

    public static GaussDistribution<LongObject> createGaussDistribution(long mean, long sd) {
        GaussDistribution<LongObject> result = AmaltheaFactory.eINSTANCE.createGaussDistribution();
        LongObject meanObj = AmaltheaFactory.eINSTANCE.createLongObject();
        meanObj.setValue(mean);
        result.setMean(meanObj);
        LongObject sdObj = AmaltheaFactory.eINSTANCE.createLongObject();
        sdObj.setValue(sd);
        result.setSd(sdObj);
        return result;
    }

    public static Time createTime(int value, String unit) {
        TimeUnit tu = null;
        if (unit.toLowerCase().equals("ps")) {
            tu = TimeUnit.PS;
        }
        if (unit.toLowerCase().equals("ns")) {
            tu = TimeUnit.NS;
        }
        if (unit.toLowerCase().equals("us")) {
            tu = TimeUnit.US;
        }
        if (unit.toLowerCase().equals("ms")) {
            tu = TimeUnit.MS;
        }
        if (unit.toLowerCase().equals("s")) {
            tu = TimeUnit.S;
        }
        if (tu == null) {
            tu = TimeUnit.MS;
        }
        return TimeUtil.adjustTimeUnit(BigInteger.valueOf(value), tu);
    }

    public static Time createTime(BigInteger value, String unit) {
        TimeUnit tu = null;
        if (unit.toLowerCase().equals("ps")) {
            tu = TimeUnit.PS;
        }
        if (unit.toLowerCase().equals("ns")) {
            tu = TimeUnit.NS;
        }
        if (unit.toLowerCase().equals("us")) {
            tu = TimeUnit.US;
        }
        if (unit.toLowerCase().equals("ms")) {
            tu = TimeUnit.MS;
        }
        if (unit.toLowerCase().equals("s")) {
            tu = TimeUnit.S;
        }
        if (tu == null) {
            tu = TimeUnit.MS;
        }
        return TimeUtil.adjustTimeUnit(new BigInteger(value.toByteArray()), tu);
    }

    public static Time createTime(String timeString) {
        Pattern p = Pattern.compile("(\\d+)\\s?(s|ms|us|ns|ps)");
        Matcher m = p.matcher(timeString);
        if (m.matches()) {
            String value = m.group(1);
            String unit = m.group(2);
            return FactoryUtil.createTime(Integer.parseInt(value), unit);
        }
        return null;
    }

    public static Time createTime(Time inputTime) {
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(inputTime.getValue());
        time.setUnit(inputTime.getUnit());
        return time;
    }

    public static Time createTime(long executionNeedCount, double scaleFactor, long frequency) {
        double cycles = (double)executionNeedCount / scaleFactor;
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int timeUnitIndex = units.indexOf((Object)TimeUnit.S);
        while (frequency % 1000L == 0L && frequency > 0L) {
            ++timeUnitIndex;
            frequency /= 1000L;
        }
        double runtime = cycles / (double)frequency;
        return TimeUtil.adjustTimeUnit(runtime, units.get(timeUnitIndex));
    }

    public static Deviation<LongObject> createWeibullDeviation(long min, long avg, long max, float promille) {
        Deviation<LongObject> result = AmaltheaFactory.eINSTANCE.createDeviation();
        result.setDistribution(FactoryUtil.createWeibullEstimator(avg, promille));
        LongObject uB = AmaltheaFactory.eINSTANCE.createLongObject();
        uB.setValue(max);
        LongObject lB = AmaltheaFactory.eINSTANCE.createLongObject();
        lB.setValue(min);
        result.setUpperBound(uB);
        result.setLowerBound(lB);
        return result;
    }

    public static WeibullEstimators<LongObject> createWeibullEstimator(long avgR, float promille) {
        WeibullEstimators<LongObject> weibull = AmaltheaFactory.eINSTANCE.createWeibullEstimators();
        LongObject mean = AmaltheaFactory.eINSTANCE.createLongObject();
        mean.setValue(avgR);
        weibull.setMean(mean);
        if (promille > 0.0f) {
            weibull.setPRemainPromille(promille);
        }
        return weibull;
    }

    public static NeedDeviation createNeedWeibullDeviation(long min, long avg, long max, float promille) {
        NeedDeviation needDev = AmaltheaFactory.eINSTANCE.createNeedDeviation();
        needDev.setDeviation(FactoryUtil.createWeibullDeviation(min, avg, max, promille));
        return needDev;
    }

    public static NeedConstant createNeedConstant(long value) {
        NeedConstant needConst = AmaltheaFactory.eINSTANCE.createNeedConstant();
        needConst.setValue(value);
        return needConst;
    }

    public static NeedDeviation createNeedDeviation(Deviation<LongObject> deviation) {
        NeedDeviation needDeviation = AmaltheaFactory.eINSTANCE.createNeedDeviation();
        needDeviation.setDeviation(deviation);
        return needDeviation;
    }

    public static ExecutionNeed createExecutionNeed(String featureCategory, Need need) {
        ExecutionNeed exeNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        exeNeed.getDefault().put((Object)featureCategory, (Object)need);
        return exeNeed;
    }

    public static ExecutionNeed createExecutionNeed(HwFeature feature, Need need) {
        ExecutionNeed exeNeed = AmaltheaFactory.eINSTANCE.createExecutionNeed();
        exeNeed.getDefault().put((Object)feature.getContainingCategory().getName(), (Object)need);
        return exeNeed;
    }
}

