/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.provider.HWModelItemProvider;
import org.eclipse.app4mc.amalthea.sphinx.ui.ExtendedSphinxTransientItemProvider;
import org.eclipse.app4mc.amalthea.sphinx.ui.hw.container.HwDefinitionContainerIP;
import org.eclipse.app4mc.amalthea.sphinx.ui.hw.container.HwDomainContainerIP;
import org.eclipse.app4mc.amalthea.sphinx.ui.hw.container.HwFeatureContainerIP;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ExtendedHWModelItemProvider
extends HWModelItemProvider {
    protected HwFeatureContainerIP hwFeatureCIP;
    protected HwDefinitionContainerIP hwDefinitionCIP;
    protected HwDomainContainerIP hwDomainCIP;

    public ExtendedHWModelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public HwFeatureContainerIP getHwFeaturesContainerIP(HWModel hwModel) {
        if (this.hwFeatureCIP == null) {
            this.hwFeatureCIP = new HwFeatureContainerIP(this.adapterFactory, hwModel);
        }
        return this.hwFeatureCIP;
    }

    public HwDefinitionContainerIP getHwDefinitionsContainerIP(HWModel hwModel) {
        if (this.hwDefinitionCIP == null) {
            this.hwDefinitionCIP = new HwDefinitionContainerIP(this.adapterFactory, hwModel);
        }
        return this.hwDefinitionCIP;
    }

    public HwDomainContainerIP getHwDomainsContainerIP(HWModel hwModel) {
        if (this.hwDomainCIP == null) {
            this.hwDomainCIP = new HwDomainContainerIP(this.adapterFactory, hwModel);
        }
        return this.hwDomainCIP;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        super.getChildrenFeatures(object);
        this.childrenFeatures.remove(AmaltheaPackage.eINSTANCE.getHWModel_FeatureCategories());
        this.childrenFeatures.remove(AmaltheaPackage.eINSTANCE.getHWModel_Definitions());
        this.childrenFeatures.remove(AmaltheaPackage.eINSTANCE.getHWModel_Domains());
        return this.childrenFeatures;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<ExtendedSphinxTransientItemProvider> children = new ArrayList<ExtendedSphinxTransientItemProvider>(super.getChildren(object));
        HWModel hwModel = (HWModel)object;
        if (!hwModel.getFeatureCategories().isEmpty()) {
            children.add(0, this.getHwFeaturesContainerIP(hwModel));
        }
        if (!hwModel.getDomains().isEmpty()) {
            children.add(0, this.getHwDomainsContainerIP(hwModel));
        }
        if (!hwModel.getDefinitions().isEmpty()) {
            children.add(0, this.getHwDefinitionsContainerIP(hwModel));
        }
        return children;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner, feature);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner, feature);
    }

    protected Command createWrappedCommand(Command command, final EObject owner, final EStructuralFeature feature) {
        if (feature.getFeatureID() == 2 || feature.getFeatureID() == 1 || feature.getFeatureID() == 4) {
            return new CommandWrapper(command){

                public Collection<?> getAffectedObjects() {
                    Set<ExtendedSphinxTransientItemProvider> affected = super.getAffectedObjects();
                    if (affected.contains(owner)) {
                        if (feature.getFeatureID() == 2) {
                            affected = Collections.singleton(ExtendedHWModelItemProvider.this.getHwFeaturesContainerIP((HWModel)owner));
                        } else if (feature.getFeatureID() == 1) {
                            affected = Collections.singleton(ExtendedHWModelItemProvider.this.getHwDefinitionsContainerIP((HWModel)owner));
                        } else if (feature.getFeatureID() == 4) {
                            affected = Collections.singleton(ExtendedHWModelItemProvider.this.getHwDomainsContainerIP((HWModel)owner));
                        }
                    }
                    return affected;
                }
            };
        }
        return command;
    }

    public void dispose() {
        if (this.hwFeatureCIP != null) {
            this.hwFeatureCIP.dispose();
        }
        if (this.hwDefinitionCIP != null) {
            this.hwDefinitionCIP.dispose();
        }
        if (this.hwDomainCIP != null) {
            this.hwDomainCIP.dispose();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(HWModel.class)) {
            case 1: 
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }
}

