/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.BetaDistribution;
import org.eclipse.app4mc.amalthea.model.Boundaries;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.GaussDistribution;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.UniformDistribution;
import org.eclipse.app4mc.amalthea.model.WeibullDistribution;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.model.WeibullParameters;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AmaltheaModelValidatorImpl
extends AbstractValidatorImpl {
    public AmaltheaModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public AmaltheaModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    private double getSecondsFromTimeUnit(Time time) {
        double value = 0.0;
        if (time != null) {
            value = time.getValue().doubleValue();
            if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.PS.getLiteral())) {
                value *= Math.pow(10.0, -12.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.NS.getLiteral())) {
                value *= Math.pow(10.0, -9.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.US.getLiteral())) {
                value *= Math.pow(10.0, -6.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.MS.getLiteral())) {
                value *= Math.pow(10.0, -3.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.S.getLiteral())) {
                value *= Math.pow(10.0, 0.0);
            }
        }
        return value;
    }

    public void checkUniqueName(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashMap<String, IReferable> names = new HashMap<String, IReferable>();
        HashSet<IReferable> ambiguousObjects = new HashSet<IReferable>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof IReferable)) continue;
            IReferable referable = (IReferable)elem;
            String name = referable.getUniqueName();
            if (names.containsKey(name)) {
                ambiguousObjects.add(referable);
                ambiguousObjects.add((IReferable)names.get(name));
                continue;
            }
            names.put(name, referable);
        }
        for (IReferable object : ambiguousObjects) {
            this.issueCreator.issue((EObject)object, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_UniqueName(), new Object[]{object.getUniqueName()});
        }
    }

    public void checkDeviation(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            double upperValue;
            LongObject upperBound;
            LongObject lowerBound;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Deviation)) continue;
            Deviation deviation = (Deviation)elem;
            Distribution distribution = deviation.getDistribution();
            if (distribution == null) {
                this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[0]);
            } else if (!(distribution instanceof UniformDistribution || distribution instanceof GaussDistribution || distribution instanceof WeibullDistribution || distribution instanceof Boundaries)) {
                this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[0]);
            }
            Object object1 = deviation.getLowerBound();
            Object object2 = deviation.getUpperBound();
            if (object1 == null && object2 != null || object2 == null && object1 != null) {
                if (object1 == null) {
                    this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_LowerBound(), new Object[0]);
                }
                if (object2 != null) continue;
                this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
                continue;
            }
            if (object1 == null || object2 == null) continue;
            if (object1.getClass() != object2.getClass()) {
                this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
                continue;
            }
            if (object1 instanceof LongObject) {
                lowerBound = (LongObject)object1;
                upperBound = (LongObject)object2;
                if (lowerBound.getValue() <= upperBound.getValue()) continue;
                this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
                continue;
            }
            if (!(object1 instanceof Time)) continue;
            lowerBound = (Time)object1;
            upperBound = (Time)object2;
            double lowerValue = this.getSecondsFromTimeUnit((Time)lowerBound);
            if (!(lowerValue > (upperValue = this.getSecondsFromTimeUnit((Time)upperBound)))) continue;
            this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        }
    }

    public void checkUniformDistribution(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Deviation deviation;
            Distribution distribution;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Deviation) || (distribution = (deviation = (Deviation)elem).getDistribution()) == null || !(distribution instanceof UniformDistribution)) continue;
            Object object1 = deviation.getLowerBound();
            Object object2 = deviation.getUpperBound();
            if (object1 != null || object2 != null) continue;
            this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_LowerBound(), new Object[0]);
            this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_UpperBound(), new Object[0]);
        }
    }

    public void checkBetaDistribution(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            double beta;
            Deviation deviation;
            Distribution distribution;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Deviation) || (distribution = (deviation = (Deviation)elem).getDistribution()) == null || !(distribution instanceof BetaDistribution)) continue;
            double alpha = ((BetaDistribution)distribution).getAlpha();
            if (!(0.0 < alpha)) {
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getBetaDistribution_Alpha(), new Object[0]);
            }
            if (0.0 < (beta = ((BetaDistribution)distribution).getBeta())) continue;
            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getBetaDistribution_Beta(), new Object[0]);
        }
    }

    public void checkGaussDistribution(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Time upperTime;
            Deviation deviation;
            Distribution distribution;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Deviation) || (distribution = (deviation = (Deviation)elem).getDistribution()) == null || !(distribution instanceof GaussDistribution)) continue;
            GaussDistribution gauss = (GaussDistribution)distribution;
            Object mean = gauss.getMean();
            Object sd = gauss.getSd();
            if (mean == null || sd == null) {
                if (mean == null) {
                    this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                }
                if (sd != null) continue;
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Sd(), new Object[0]);
                continue;
            }
            if (!mean.getClass().equals(sd.getClass())) {
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Sd(), new Object[0]);
            }
            Object lowerBound = deviation.getLowerBound();
            Object upperBound = deviation.getUpperBound();
            if (mean instanceof Time) {
                Time meanTime = (Time)mean;
                double meanValue = this.getSecondsFromTimeUnit(meanTime);
                if (!(lowerBound instanceof Time)) {
                    this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                } else {
                    Time lowerTime = (Time)lowerBound;
                    double lowerValue = this.getSecondsFromTimeUnit(lowerTime);
                    if (meanValue < lowerValue) {
                        this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                    }
                }
                if (!(upperBound instanceof Time)) {
                    this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                    continue;
                }
                upperTime = (Time)upperBound;
                double upperValue = this.getSecondsFromTimeUnit(upperTime);
                if (!(meanValue > upperValue)) continue;
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                continue;
            }
            if (!(mean instanceof LongObject)) continue;
            LongObject meanLong = (LongObject)mean;
            long meanValue = meanLong.getValue();
            if (!(lowerBound instanceof LongObject)) {
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
            } else {
                LongObject lowerLong = (LongObject)lowerBound;
                long lowerValue = lowerLong.getValue();
                if (meanValue < lowerValue) {
                    this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                }
            }
            if (!(upperBound instanceof LongObject)) {
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
                continue;
            }
            upperTime = (LongObject)upperBound;
            long upperValue = upperTime.getValue();
            if (meanValue <= upperValue) continue;
            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getGaussDistribution_Mean(), new Object[0]);
        }
    }

    public void checkWeibullParameters(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Deviation deviation;
            Distribution distribution;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Deviation) || (distribution = (deviation = (Deviation)elem).getDistribution()) == null || !(distribution instanceof WeibullParameters)) continue;
            WeibullParameters weibull = (WeibullParameters)distribution;
            double kappa = weibull.getKappa();
            double lambda = weibull.getLambda();
            if (!(0.0 > kappa) && !(0.0 > lambda)) continue;
            if (0.0 > kappa) {
                this.issueCreator.issue((EObject)weibull, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullParameters_Kappa(), new Object[0]);
            }
            if (!(0.0 > lambda)) continue;
            this.issueCreator.issue((EObject)weibull, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullParameters_Lambda(), new Object[0]);
        }
    }

    public void checkWeibullEstimators(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Deviation deviation;
            Distribution distribution;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Deviation) || (distribution = (deviation = (Deviation)elem).getDistribution()) == null || !(distribution instanceof WeibullEstimators)) continue;
            WeibullEstimators weibull = (WeibullEstimators)distribution;
            Object mean = weibull.getMean();
            if (mean == null) {
                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
            } else {
                Object lowerBound = deviation.getLowerBound();
                Object upperBound = deviation.getUpperBound();
                if (lowerBound != null && upperBound != null) {
                    Time upperTime;
                    if (mean instanceof Time) {
                        Time meanTime = (Time)mean;
                        double meanValue = this.getSecondsFromTimeUnit(meanTime);
                        if (!(lowerBound instanceof Time)) {
                            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                        } else {
                            Time lowerTime = (Time)lowerBound;
                            double lowerValue = this.getSecondsFromTimeUnit(lowerTime);
                            if (meanValue < lowerValue) {
                                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                            }
                        }
                        if (!(upperBound instanceof Time)) {
                            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                        } else {
                            upperTime = (Time)upperBound;
                            double upperValue = this.getSecondsFromTimeUnit(upperTime);
                            if (meanValue > upperValue) {
                                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                            }
                        }
                    } else if (mean instanceof LongObject) {
                        LongObject meanLong = (LongObject)mean;
                        long meanValue = meanLong.getValue();
                        if (!(lowerBound instanceof LongObject)) {
                            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                        } else {
                            LongObject lowerLong = (LongObject)lowerBound;
                            long lowerValue = lowerLong.getValue();
                            if (meanValue < lowerValue) {
                                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                            }
                        }
                        if (!(upperBound instanceof LongObject)) {
                            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                        } else {
                            upperTime = (LongObject)upperBound;
                            long upperValue = upperTime.getValue();
                            if (meanValue > upperValue) {
                                this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_Mean(), new Object[0]);
                            }
                        }
                    }
                }
            }
            double pRemainPromille = weibull.getPRemainPromille();
            if (!(0.0 > pRemainPromille)) continue;
            this.issueCreator.issue((EObject)distribution, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getWeibullEstimators_PRemainPromille(), new Object[0]);
        }
    }
}

