/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.openmapping;

import org.eclipse.app4mc.multicore.dialogs.AbstractGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OMSolverSettingsGroup
extends AbstractGroup {
    BooleanFieldEditor genMPS;
    private final StringFieldEditor maxGap;
    private final IntegerFieldEditor[] integerFields;
    private static final int MAX_IT_ABORT = 0;
    private static final int MAX_TIME_ABORT = 1;
    private static final int MAX_IT_SUFFICE = 2;
    private static final int MAX_TIME_SUFFICE = 3;

    public OMSolverSettingsGroup(Composite parent, IPreferenceStore store) {
        super(parent, store);
        GridLayout layout2row = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        this.integerFields = new IntegerFieldEditor[4];
        this.group.setText("Solver Settings");
        this.group.setLayoutData((Object)gridData);
        this.group.setLayout((Layout)layout2row);
        this.genMPS = new BooleanFieldEditor("org.eclipse.app4mc.multicore.openmapping.generateMpsFile", "Generate MPS file of ILP problem ", (Composite)this.group);
        this.genMPS.fillIntoGrid((Composite)this.group, 2);
        this.addField((FieldEditor)this.genMPS);
        this.maxGap = new StringFieldEditor("org.eclipse.app4mc.multicore.openmapping.MaxGap", "Max. Gap ", (Composite)this.group);
        this.maxGap.getTextControl((Composite)this.group).setToolTipText("Valid values: 0.0 (best accuracy) - 1.0 (worst accuracy)");
        this.maxGap.fillIntoGrid((Composite)this.group, 2);
        this.addField((FieldEditor)this.maxGap);
        this.integerFields[0] = new IntegerFieldEditor("org.eclipse.app4mc.multicore.openmapping.MaxItAbort", "Max. Iterations (Abort) ", (Composite)this.group);
        this.integerFields[0].setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.integerFields[0]);
        this.integerFields[1] = new IntegerFieldEditor("org.eclipse.app4mc.multicore.openmapping.MaxTimeAbort", "Max. Time (Abort) ", (Composite)this.group);
        this.integerFields[1].setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.integerFields[1]);
        this.integerFields[2] = new IntegerFieldEditor("org.eclipse.app4mc.multicore.openmapping.MaxItSuffice", "Max. Iterations (Suffice) ", (Composite)this.group);
        this.integerFields[2].setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.integerFields[2]);
        this.integerFields[3] = new IntegerFieldEditor("org.eclipse.app4mc.multicore.openmapping.MaxTimeSuffice", "Max. Time (Suffice) ", (Composite)this.group);
        this.integerFields[3].setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.integerFields[3]);
        IntegerFieldEditor[] integerFieldEditorArray = this.integerFields;
        int n = this.integerFields.length;
        int n2 = 0;
        while (n2 < n) {
            IntegerFieldEditor field = integerFieldEditorArray[n2];
            field.fillIntoGrid((Composite)this.group, 2);
            field.getTextControl((Composite)this.group).setToolTipText("Hint: Entering 0 will disable the constraint (i.e. set the value to INT_MAX).");
            ++n2;
        }
    }

    @Override
    public boolean store() {
        this.genMPS.store();
        IntegerFieldEditor[] integerFieldEditorArray = this.integerFields;
        int n = this.integerFields.length;
        int n2 = 0;
        while (n2 < n) {
            IntegerFieldEditor integerField = integerFieldEditorArray[n2];
            if (!integerField.isValid()) {
                MessageDialog.openError((Shell)this.group.getShell(), (String)"Error", (String)("Incorrect values in Solver Settings section:\n" + integerField.getLabelText() + "accepts values between 0 and " + Integer.MAX_VALUE));
                return false;
            }
            integerField.store();
            ++n2;
        }
        try {
            double fMaxGap = Double.parseDouble(this.maxGap.getStringValue());
            if (fMaxGap < 0.0 || fMaxGap > 1.0) {
                throw new NumberFormatException("Max. Gap must have a double value between 0.0 and 1.0");
            }
            this.maxGap.store();
        }
        catch (NumberFormatException e) {
            MessageDialog.openError((Shell)this.group.getShell(), (String)"Error", (String)("Incorrect values in Solver Settings section:\n" + e.getMessage()));
            return false;
        }
        return true;
    }
}

