/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.openmapping.handlers;

import org.eclipse.app4mc.multicore.dialogs.DialogsPlugin;
import org.eclipse.app4mc.multicore.dialogs.openmapping.handlers.PerformMappingJob;
import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.model.description.OMModelDescriptionBuilder;
import org.eclipse.app4mc.multicore.sharelibs.OutputPathParser;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelDescription;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;

public class PerformMappingJobHandler {
    private final IPreferenceStore store;
    private final IPreferenceStore OMstore;
    private String pathSWModel;
    private String pathHWModel;

    public PerformMappingJobHandler(IPreferenceStore OMstore) {
        this.OMstore = OMstore;
        this.store = DialogsPlugin.getDefaultPreferenceStore();
    }

    public boolean scheduleJob(ExecutionEvent event) {
        UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
        UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
        UniversalHandler.getInstance().clearModelCheckerView();
        if (this.OMstore.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole")) {
            UniversalHandler.getInstance().enableVerboseOutput();
        }
        AbstractMappingAlgorithm mappingAlgorithm = AbstractMappingAlgorithm.of((IPreferenceStore)this.OMstore);
        UniversalHandler.getInstance().dropCache();
        this.pathSWModel = this.store.getString("org.eclipse.app4mc.multicore.dialogs.sw_model_location");
        this.pathHWModel = this.store.getString("org.eclipse.app4mc.multicore.dialogs.hw_model_location");
        URI uriSwModel = URI.createFileURI((String)this.pathSWModel);
        URI uriHwModel = URI.createFileURI((String)this.pathHWModel);
        ModelDescription modelChecker = OMModelDescriptionBuilder.ofMappingSWInput(null);
        boolean modelOk = modelChecker.checkModel(uriSwModel);
        if (!modelOk) {
            modelChecker.logToView();
            modelChecker.openMessageBox();
            return false;
        }
        modelChecker = OMModelDescriptionBuilder.ofMappingHWInput(null).concatLog(modelChecker);
        modelOk = modelChecker.checkModel(uriHwModel);
        if (!modelOk) {
            modelChecker.logToView();
            modelChecker.openMessageBox();
            return false;
        }
        modelChecker.logToView();
        modelChecker.openMessageBox();
        OutputPathParser outputParser = new OutputPathParser("org.eclipse.app4mc.multicore.openmapping.outputLocation", "org.eclipse.app4mc.multicore.openmapping.outputLocationString", this.OMstore);
        PerformMappingJob job = new PerformMappingJob(mappingAlgorithm, uriSwModel, null, uriHwModel, outputParser.parseOutputFileURI(this.getSelectedFile(), "_mapping"));
        job.schedule();
        return true;
    }

    private IFile getSelectedFile() {
        Path ResourcePath = new Path(this.pathSWModel);
        if (!ResourcePath.isAbsolute()) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile ifile = workspace.getRoot().getFileForLocation((IPath)ResourcePath);
        return ifile;
    }
}

