/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.btf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.app4mc.multicore.execution.logic.btf.BtfException;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEntityType;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfEvent;
import org.eclipse.app4mc.multicore.execution.logic.btf.model.BtfTrace;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;

public class BtfTraceParser {
    private File file;
    private RandomAccessFile fileInput;
    private BtfTrace trace;
    long filePosBefore = 0L;
    long lineCount = 0L;

    public BtfTraceParser(File file) {
        this.file = file;
    }

    public void parseTrace() throws BtfException {
        this.lineCount = 0L;
        this.filePosBefore = 0L;
        this.trace = new BtfTrace();
        this.trace.setName(this.file.getName());
        try {
            this.fileInput = new RandomAccessFile(this.file, "r");
            this.parseHeader();
            this.parseBody();
        }
        catch (FileNotFoundException e) {
            throw new BtfException(e.getMessage());
        }
    }

    private String readLine() throws IOException {
        ++this.lineCount;
        this.filePosBefore = this.fileInput.getFilePointer();
        return this.fileInput.readLine();
    }

    private void lineBack() throws IOException {
        if (this.lineCount > 0L) {
            this.fileInput.seek(this.filePosBefore);
            --this.lineCount;
        }
    }

    private void parseHeader() throws BtfException {
        try {
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    throw new BtfException("Trace do not contain data!");
                }
                if (line.charAt(0) != '#') {
                    this.lineBack();
                    break;
                }
                if (line.startsWith("#timeScale")) {
                    String[] data = line.split(" ");
                    if (data.length != 2) {
                        throw new BtfException("#timeScale not well formed!");
                    }
                    EMTimeType tt = EMTimeType.valueOf((String)data[1].toUpperCase());
                    if (tt == null) {
                        throw new BtfException("#timeScale not well formed!");
                    }
                    this.trace.setTimeScale(tt);
                    continue;
                }
                if (!line.startsWith("#entityTypeTable")) continue;
                this.parseEntityTypeTable();
            }
        }
        catch (IOException e) {
            throw new BtfException(e.getMessage());
        }
    }

    private void parseEntityTypeTable() throws IOException, BtfException {
        String line = this.readLine();
        while (line.startsWith("#-")) {
            String[] data = line.split(" ");
            if (data.length != 2) {
                throw new BtfException("Entity type line not valid: " + line + " line-number: " + this.lineCount);
            }
            String type = data[0].substring(2);
            BtfEntityType t = BtfEntityType.byTypeID(type.toUpperCase());
            if (t == null) {
                throw new BtfException(String.valueOf(type) + " (line " + this.lineCount + ") is no valid btf type!");
            }
            this.trace.getEntityTypeTable().put(data[1], t);
            line = this.readLine();
        }
        this.lineBack();
    }

    private void parseBody() throws BtfException {
        try {
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    return;
                }
                this.parseEventLine(this.lineCount, line);
            }
        }
        catch (IOException e) {
            throw new BtfException(e.getMessage());
        }
    }

    private void parseEventLine(long lineNum, String line) throws BtfException {
        String[] data = line.split(",");
        if (data.length != 7 && data.length != 8) {
            throw new BtfException("Miss formed line: " + line);
        }
        BtfEvent e = new BtfEvent();
        try {
            e.setLineNum(lineNum);
            e.setTime(Long.parseLong(data[0]));
            e.setSource(data[1]);
            e.setSourceInstance(Integer.parseInt(data[2]));
            BtfEntityType et = BtfEntityType.byTypeID(data[3].toUpperCase());
            e.setTargetType(et);
            e.setTarget(data[4]);
            e.setTargetInstance(Integer.parseInt(data[5]));
            e.setEvent(data[6]);
            if (data.length == 8) {
                e.setNote(data[7]);
            }
            this.trace.getEvents().add(e);
        }
        catch (Exception ex) {
            throw new BtfException(ex.getMessage());
        }
    }

    public BtfTrace getTrace() {
        return this.trace;
    }
}

