/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core;

import java.util.function.Consumer;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerAlgorithm;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.IStepScheduler;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.AbstractScheduler;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.Barrier;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.SchedulerTask;

public class StepScheduler
extends AbstractScheduler
implements IStepScheduler {
    private boolean startedIdle = false;
    private ScheduleState currentState = ScheduleState.UNINIT;

    public StepScheduler(ISchedulerAlgorithm m) {
        super(m);
    }

    @Override
    public void init() {
        if (this.currentState == ScheduleState.UNINIT) {
            for (String task : this.getTasks().keySet()) {
                this.notifyObserver(x -> x.onTaskAdded(task));
                this.notifyObserver(x -> x.onActivateTask(task, 0L));
            }
        } else {
            throw new IllegalStateException("Init the scheduler once before start");
        }
        this.currentState = ScheduleState.EXECUTED_INIT;
    }

    @Override
    public void updateTaskSynchronisation() {
        if (this.currentState != ScheduleState.EXECUTED_RUN) {
            throw new IllegalStateException("Wrong method sequencing!");
        }
        this.updateTaskSynchronisationIntern();
        this.currentState = ScheduleState.EXECUTED_UPDATESYNC;
    }

    private void updateTaskSynchronisationIntern() {
        this.getTasks().values().forEach(SchedulerTask::updateOwnedBarriers);
    }

    @Override
    public void updateTaskSet() {
        if (this.currentState != ScheduleState.EXECUTED_UPDATESYNC) {
            throw new IllegalStateException("Wrong method sequencing!");
        }
        this.updateTaskSetIntern();
        this.currentState = ScheduleState.EXECUTED_UPDATESET;
    }

    private void updateTaskSetIntern() {
        this.getTasks().values().forEach(((Consumer<SchedulerTask>)this::updateTaskActivate).andThen(this::updateTaskRelease));
    }

    private void updateTaskActivate(SchedulerTask t) {
        if (this.getSimTime() >= t.getNextActivationTime()) {
            if (t.reachedWCET()) {
                if (t.ev_activate() ? !$assertionsDisabled && !t.isReady() : !$assertionsDisabled) {
                    throw new AssertionError();
                }
            } else {
                assert (t.remainingExecutionTime() > 0L);
                this.notifyObserver(x -> x.onTaskMissedDeadline(t.getName(), this.getSimTime(), t.remainingExecutionTime()));
                t.hardResetFSM();
            }
            assert (t.isReady());
            t.resetForNextPeriod();
            this.notifyObserver(x -> x.onActivateTask(t.getName(), this.getSimTime()));
        }
    }

    protected void updateTaskRelease(SchedulerTask t) {
        if (!t.hasBlockingBarrier() && t.ev_release()) {
            assert (t.isReady());
            this.notifyObserver(x -> x.onReleaseTask(t.getName(), this.getSimTime()));
        }
    }

    @Override
    public void runTaskOrIdleStep() {
        if (this.currentState != ScheduleState.EXECUTED_UPDATESET && this.currentState != ScheduleState.EXECUTED_INIT) {
            throw new IllegalStateException("Wrong method sequencing!");
        }
        this.runTaskOrIdleStepIntern();
        this.currentState = ScheduleState.EXECUTED_RUN;
    }

    protected void runTaskOrIdleStepIntern() {
        this.updatePreemptCurrentTask();
        do {
            if (this.currentTask == null) {
                this.currentTask = this.getReadyPriorityTask();
            }
            if (this.currentTask == null) {
                if (!this.startedIdle) {
                    this.startedIdle = true;
                    this.notifyObserver(x -> x.onStartIdleCore(this.getSimTime()));
                }
                this.timeStep();
                return;
            }
            if (this.currentTask != null && this.startedIdle) {
                this.notifyObserver(x -> x.onStopIdleCore(this.getSimTime()));
                this.startedIdle = false;
            }
            assert (this.currentTask != null);
            assert (this.currentTask.isReady() || this.currentTask.isRunning());
            if (this.currentTask.ev_start()) {
                this.notifyObserver(x -> x.onStartTask(this.currentTask.getName(), this.getSimTime()));
            }
            assert (this.currentTask.isRunning());
            if (!this.currentTask.hasBlockingBarrier()) continue;
            if (this.currentTask.ev_wait()) {
                Barrier m = this.currentTask.getFirstBlockingMutex();
                this.notifyObserver(x -> x.onWaitTask(this.currentTask.getName(), this.getSimTime(), m.getName(), m.getHolder()));
            }
            assert (this.currentTask.isWaiting());
            this.currentTask = null;
        } while (this.currentTask == null);
        assert (this.currentTask != null);
        assert (!this.currentTask.hasBlockingBarrier());
        assert (this.currentTask.isRunning());
        this.currentTask.run();
        this.timeStep();
        this.updateCurrenTaskSuspension();
    }

    private void updatePreemptCurrentTask() {
        if (this.currentTask != null && this.isPreemptiveScheduling()) {
            assert (this.currentTask.isRunning());
            SchedulerTask t = this.getReadyPriorityTask();
            if (t != null && this.compare(t, this.currentTask) < 0) {
                if (this.currentTask.ev_preempt()) {
                    this.notifyObserver(x -> x.onPreemptTask(this.currentTask.getName(), this.getSimTime()));
                }
                assert (this.currentTask.isReady());
                this.currentTask = null;
            }
        }
    }

    private void updateCurrenTaskSuspension() {
        if (this.currentTask != null && this.currentTask.reachedWCET()) {
            if (this.currentTask.ev_terminate()) {
                this.notifyObserver(x -> x.onTerminateTask(this.currentTask.getName(), this.getSimTime()));
            }
            assert (this.currentTask.isSuspended());
            this.currentTask = null;
        }
    }

    private static enum ScheduleState {
        EXECUTED_RUN,
        EXECUTED_UPDATESYNC,
        EXECUTED_UPDATESET,
        UNINIT,
        EXECUTED_INIT;

    }
}

