/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core;

public class TaskFSM {
    private TState currentState;
    private TState previousState;
    private final TState startState;

    public TaskFSM(TState startState) {
        this.startState = startState;
        this.currentState = startState;
        this.previousState = TState.NONE;
    }

    public void hardResetFSM() {
        this.previousState = this.currentState;
        this.currentState = TState.READY;
    }

    public boolean isReady() {
        return this.currentState == TState.READY;
    }

    public boolean isSuspended() {
        return this.currentState == TState.SUSPENDED;
    }

    public boolean isWaiting() {
        return this.currentState == TState.WAITING;
    }

    public boolean isRunning() {
        return this.currentState == TState.RUNNING;
    }

    public boolean ev_preempt() {
        if (this.isRunning()) {
            this.setState(TState.READY);
            return true;
        }
        return false;
    }

    public boolean ev_terminate() {
        if (this.isRunning()) {
            this.setState(TState.SUSPENDED);
            return true;
        }
        return false;
    }

    public boolean ev_start() {
        if (this.isReady()) {
            this.setState(TState.RUNNING);
            return true;
        }
        return false;
    }

    public boolean ev_wait() {
        if (this.isRunning()) {
            this.setState(TState.WAITING);
            return true;
        }
        return false;
    }

    public boolean ev_release() {
        if (this.isWaiting()) {
            this.setState(TState.READY);
            return true;
        }
        return false;
    }

    public boolean ev_activate() {
        if (this.isSuspended()) {
            this.setState(TState.READY);
            return true;
        }
        return false;
    }

    protected void setState(TState newState) {
        this.previousState = this.currentState;
        this.currentState = newState;
    }

    public TState getCurrentState() {
        return this.currentState;
    }

    public TState getPreviousState() {
        return this.previousState;
    }

    public static enum TState {
        NONE,
        WAITING,
        RUNNING,
        READY,
        SUSPENDED;

    }
}

