/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.handlers;

import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuWizard;
import org.eclipse.app4mc.multicore.execution.ui.traceview.TraceViewUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.IEMTraceWidget;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class SimMenuHandler
extends AbstractHandler {
    IEMTraceWidget tw;
    OMMapping ommodel;
    private ConstraintsModel cmmodel;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        UniversalHandler uh = UniversalHandler.getInstance();
        IFile file = UniversalHandler.getSelectedFile((ExecutionEvent)event);
        if (!this.readModels(file)) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Task Exec Visualization", (String)"No Mapping- or Constraints-Model available! Select file with Mapping-Model.");
            return null;
        }
        this.tw = TraceViewUtil.showEMTraceView();
        if (this.tw == null) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Task Exec Visualization", (String)"Can't display TraceView!");
            return null;
        }
        this.showWizard(window.getShell());
        return null;
    }

    private void showWizard(Shell shell) {
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)new TaskVisuWizard(this.tw, this.ommodel, this.cmmodel));
        if (wizardDialog.open() == 0) {
            System.out.println("Ok pressed");
        } else {
            System.out.println("Cancel pressed");
        }
    }

    private boolean readModels(IFile file) {
        if (file == null) {
            return false;
        }
        UniversalHandler uh = UniversalHandler.getInstance();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        uh.dropCache();
        if (uri == null) {
            return false;
        }
        uh.readModels(uri, true);
        this.cmmodel = uh.getConstraintsModel();
        MappingModel m = uh.getMappingModel();
        if (m == null) {
            return false;
        }
        this.ommodel = OMUtil.createOMMapping((MappingModel)m);
        return true;
    }
}

