/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.SWTAllocationTable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class TaskVisuOverviewPage
extends WizardPage {
    private Composite container;
    private TableViewer tv_allocations;
    private TableViewer tv_coreoverview;
    private final OMMapping model;

    public TaskVisuOverviewPage(OMMapping model) {
        super("Task Visualisation: Overview");
        this.setTitle("Task Visualisation: Overview");
        this.setDescription("This page gives an overview of the visualisation input.");
        this.model = model;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.setupAllocsOverview();
        this.setupCoreOverview();
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private void setupCoreOverview() {
        Label label1 = new Label(this.container, 0);
        label1.setText("Cores");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        this.tv_coreoverview = new TableViewer(this.container, 68354);
        Table table = this.tv_coreoverview.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)gridData);
        final Map tmpmodel = OMUtil.getCoreTaskMap((List)this.model.getAllocationList());
        this.tv_coreoverview.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tv_coreoverview.setInput(tmpmodel.keySet());
        TableViewerColumn colCore = new TableViewerColumn(this.tv_coreoverview, 0);
        colCore.getColumn().setWidth(100);
        colCore.getColumn().setText("Core");
        colCore.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMCore core = (OMCore)element;
                return core.getCoreRef().getName();
            }
        });
        TableViewerColumn colIPs = new TableViewerColumn(this.tv_coreoverview, 0);
        colIPs.getColumn().setWidth(100);
        colIPs.getColumn().setText("IPS");
        colIPs.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMCore core = (OMCore)element;
                try {
                    return "" + core.getInstructionsPerSecond();
                }
                catch (MalformedModelException e) {
                    e.printStackTrace();
                    return "Malformed Model";
                }
            }
        });
        TableViewerColumn colUtilization = new TableViewerColumn(this.tv_coreoverview, 0);
        colUtilization.getColumn().setWidth(100);
        colUtilization.getColumn().setText("Utilization");
        colUtilization.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                OMCore core = (OMCore)element;
                try {
                    double util = OMUtil.getUtilization((OMCore)core, (List)((List)tmpmodel.get(core)));
                    return String.format("%1$,.4f", util);
                }
                catch (MalformedModelException e) {
                    e.printStackTrace();
                    return "Malformed model";
                }
            }
        });
        this.tv_coreoverview.refresh();
    }

    private void setupAllocsOverview() {
        Label label1 = new Label(this.container, 0);
        label1.setText("Allocations");
        this.tv_allocations = new SWTAllocationTable(this.container, this.model.getAllocationList());
    }
}

