/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;

public class Util {
    public static Collection<OMEdge> getConsideredEdges(List<OMTask> tasklist) {
        List allEdges = tasklist.parallelStream().map(OMTask::getPosts).flatMap(Collection::stream).filter(x -> x.getPre() != x.getPost() && x.getPre().getPeriod() == x.getPost().getPeriod()).collect(Collectors.toList());
        HashMap<String, OMEdge> considered = new HashMap<String, OMEdge>();
        for (OMEdge edge : allEdges) {
            String name = String.valueOf(edge.getPre().getTaskRef().getUniqueName()) + edge.getPost().getTaskRef().getUniqueName();
            if (considered.containsKey(name)) {
                OMEdge oldedge = (OMEdge)considered.get(name);
                if (oldedge.getReleaseInstruction() >= edge.getReleaseInstruction()) continue;
                considered.put(name, edge);
                continue;
            }
            considered.put(name, edge);
        }
        return considered.values();
    }
}

