/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.AdvancedRunnable;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.ExtendedCore;

public class AdvancedCore
extends ExtendedCore {
    private static long minAvailableTime = 0L;
    private static long maxAvailableTime = 0L;
    private long availableTime = 0L;
    private final List<AdvancedRunnable> lRunnables = new LinkedList<AdvancedRunnable>();
    private long psPerInstruction = -1L;

    AdvancedCore(ProcessingUnit core, boolean debug) {
        super(core, debug);
    }

    private long calcPsPerInstruction() {
        return Math.round(1.0 / this.getCyclesPerSecond() * Math.pow(10.0, 12.0));
    }

    public void setAvailTime(long at) {
        if (AdvancedCore.getMaxAvailTime() < at) {
            maxAvailableTime = at;
        }
        this.availableTime = at;
    }

    public long getAvailTime() {
        return this.availableTime;
    }

    public void addRunnable(AdvancedRunnable ar) {
        this.lRunnables.add(ar);
    }

    public List<AdvancedRunnable> getRunnables() {
        return this.lRunnables;
    }

    public long getPsPerInstruction() {
        if (this.psPerInstruction < 0L) {
            this.psPerInstruction = this.calcPsPerInstruction();
        }
        return this.psPerInstruction;
    }

    public static void setMinAvailTime(long minAvailTime) {
        minAvailableTime = minAvailTime;
    }

    public static void resetMaxAvailTime() {
        maxAvailableTime = 0L;
    }

    public static long getMinAvailTime() {
        return minAvailableTime;
    }

    public static long getMaxAvailTime() {
        return maxAvailableTime;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\nps per Instruction:\t" + this.getPsPerInstruction() + "(" + 1.0 / this.getCyclesPerSecond() * Math.pow(10.0, 12.0) + ") / (" + Math.round(1.0 / this.getCyclesPerSecond() * Math.pow(10.0, 12.0)) + ")";
    }
}

