/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.ConfigurationException;
import org.eclipse.app4mc.multicore.openmapping.OMPreferenceInitializer;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public class GenerateMapping
extends WorkflowComponent {
    public static final String MAPPING_DFG = "dfg";
    public static final String MAPPING_ILP_LB = "ilp_lb";
    public static final String MAPPING_ILP_ENERGY = "ilp_energy";
    public static final String MAPPING_GA_LB = "ga_lb";
    public static final String MAPPING_GA_CONSTRAINTS = "ga_constraints";
    private String resultSlot = "mapping";
    private IPreferenceStore store = new PreferenceStore();

    public GenerateMapping() {
        OMPreferenceInitializer init = new OMPreferenceInitializer(this.store);
        init.initializeDefaultPreferences();
    }

    protected void runInternal(Context ctx) {
        assert (this.getAmaltheaModel(ctx).getHwModel() != null && this.getAmaltheaModel(ctx).getSwModel() != null);
        if (this.isEnableLog()) {
            UniversalHandler.getInstance().enableVerboseOutput();
        }
        AbstractMappingAlgorithm mappingAlg = AbstractMappingAlgorithm.of(this.store);
        Amalthea modelCopy = this.getAmaltheaModelCopy(ctx);
        mappingAlg.setAmaltheaMergedModel(modelCopy);
        mappingAlg.calculateMapping();
        assert (mappingAlg.getAmaltheaOutputModel().getOsModel() != null && mappingAlg.getAmaltheaOutputModel().getMappingModel() != null);
        this.log.info((Object)("Setting result model in slot: " + this.getResultSlot()));
        ctx.set(this.getResultSlot(), (Object)mappingAlg.getAmaltheaOutputModel());
    }

    protected void checkInternal() throws ConfigurationException {
        if (this.getMappingAlg() == null || this.getMappingAlg().isEmpty() || !this.getMappingAlg().equals(MAPPING_DFG) && !this.getMappingAlg().equals(MAPPING_ILP_LB) && !this.getMappingAlg().equals(MAPPING_ILP_ENERGY) && !this.getMappingAlg().equals(MAPPING_GA_LB) && !this.getMappingAlg().equals(MAPPING_GA_CONSTRAINTS)) {
            throw new ConfigurationException("No proper mapping algorithm defined! Please define one of the following values: dfg,ilp_lb,ilp_energy,ga_lb");
        }
    }

    public String getResultSlot() {
        return this.resultSlot;
    }

    public void setResultSlot(String resultSlot) {
        this.resultSlot = resultSlot;
    }

    public String getMappingAlg() {
        String mapAlg = this.store.getString("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
        return GenerateMapping.mapAlgPreferenceToWorkflow(mapAlg);
    }

    public void setMappingAlg(String mappingAlg) {
        this.store.setValue("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm", GenerateMapping.mapAlgWorkflowToPreference(mappingAlg));
    }

    public boolean isEnableLog() {
        return this.store.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole");
    }

    public void setEnableLog(boolean enableLog) {
        this.store.setValue("org.eclipse.app4mc.multicore.openmapping.logToConsole", enableLog);
    }

    public void setStore(IPreferenceStore store) {
        this.store = store;
    }

    public static String mapAlgWorkflowToPreference(String workFlowMean) {
        String mapAlg = "";
        switch (workFlowMean) {
            case "dfg": {
                mapAlg = "0";
                break;
            }
            case "ilp_lb": {
                mapAlg = "1";
                break;
            }
            case "ilp_energy": {
                mapAlg = "2";
                break;
            }
            case "ga_lb": {
                mapAlg = "3";
                break;
            }
            case "ga_constraints": {
                mapAlg = "4";
                break;
            }
            default: {
                mapAlg = "1";
            }
        }
        return mapAlg;
    }

    public static String mapAlgPreferenceToWorkflow(String preferenceMean) {
        String mapAlg = "";
        switch (preferenceMean) {
            case "2": {
                mapAlg = MAPPING_ILP_ENERGY;
                break;
            }
            case "4": {
                mapAlg = MAPPING_GA_CONSTRAINTS;
                break;
            }
            case "0": {
                mapAlg = MAPPING_DFG;
                break;
            }
            case "3": {
                mapAlg = MAPPING_GA_LB;
                break;
            }
            case "1": {
                mapAlg = MAPPING_ILP_LB;
                break;
            }
            default: {
                mapAlg = MAPPING_ILP_LB;
            }
        }
        return mapAlg;
    }
}

