/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.handlers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.sharelibs.SelectionUtil;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class WriteGraphvizHandler
extends AbstractHandler {
    private IFile file = null;

    public void write(SWModel swm, ConstraintsModel cm) {
        boolean validRSCs = new Helper().AllRSCsHave2ValidEntries((EList<RunnableSequencingConstraint>)cm.getRunnableSequencingConstraints());
        HashSet<RunnableSequencingConstraint> writtenRSCs = new HashSet<RunnableSequencingConstraint>();
        String filename = this.file.getName().substring(0, this.file.getName().lastIndexOf("."));
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(new File(this.file.getRawLocation().toString().substring(0, this.file.getRawLocation().toString().lastIndexOf("/")), String.valueOf(filename) + ".dot")));
            output.write("digraph G { \n");
            for (ProcessPrototype pp : swm.getProcessPrototypes()) {
                output.write("subgraph cluster_" + swm.getProcessPrototypes().indexOf((Object)pp) + " { \n style=filled; \n color=lightgrey; \n node [style=filled,color=white];\n");
                for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                    output.write(String.valueOf(trc.getRunnable().getName()) + ";\n");
                }
                if (validRSCs) {
                    for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
                        if (writtenRSCs.contains(rsc) || !new Helper().runnablesContainedinSamePP((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0), (Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
                        output.write(String.valueOf(((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)).getName()) + " -> " + ((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)).getName() + ";\n");
                        writtenRSCs.add(rsc);
                    }
                }
                output.write(" label = \"" + pp.getName() + (pp.getActivation() == null ? Character.valueOf('\"') : "; Activation: " + pp.getActivation().getName() + '\"') + ";}\n");
            }
            if (swm.getProcessPrototypes().size() == 0) {
                for (Runnable r : swm.getRunnables()) {
                    output.write(String.valueOf(r.getName()) + ";\n");
                }
            }
            if (validRSCs) {
                for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
                    if (writtenRSCs.contains(rsc) || new Helper().runnablesContainedinSamePP((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0), (Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
                    output.write(String.valueOf(((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)).getName()) + " -> " + ((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)).getName() + "[color=red];\n");
                    writtenRSCs.add(rsc);
                }
            }
            output.write("}");
            output.close();
            PartLog.getInstance().log("Graphviz saved: " + this.file.getRawLocation().toString().substring(0, this.file.getRawLocation().toString().lastIndexOf("/")) + "/" + filename + ".dot");
            this.file.getProject().refreshLocal(2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UniversalHandler uh = UniversalHandler.getInstance();
        uh.enableVerboseOutput();
        uh.dropCache();
        PartLog.getInstance().setEnableTargetConsoleLog(true);
        PartLog.getInstance().setLogName("WriteGraphviz");
        this.file = SelectionUtil.getSelectedFile((ExecutionEvent)event);
        uh.dropCache();
        uh.readModels(URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true), true);
        this.write(UniversalHandler.getInstance().getSwModel(), UniversalHandler.getInstance().getConstraintsModel());
        return null;
    }
}

