/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.alg.cycle.SzwarcfiterLauerSimpleCycles;

public class Cycle<V, E>
extends SzwarcfiterLauerSimpleCycles<V, E> {
    private final DirectedGraph<V, E> graph;
    private final Set<E> removedEdges = new HashSet();

    public Set<E> getRemovedEdges() {
        return this.removedEdges;
    }

    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    public Cycle(DirectedGraph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Null graph argument.");
        }
        this.graph = graph;
    }

    public List<List<V>> findSimpleCycles() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        List<Set<V>> sccs = null;
        do {
            sccs = this.getSCC();
            for (Set<V> scc : sccs) {
                this.deleteRSC(scc);
            }
        } while (sccs.size() > 0);
        return null;
    }

    private void deleteRSC(Set<V> scc) {
        Set edgeSet = this.graph.outgoingEdgesOf(scc.toArray()[0]);
        for (Object e : edgeSet) {
            if (!scc.contains(((RunnableEntityGroup)((RunnableSequencingConstraint)e).getRunnableGroups().get(1)).getRunnables().get(0))) continue;
            this.removedEdges.add(e);
            this.graph.removeEdge(e);
            break;
        }
    }

    private List<Set<V>> getSCC() {
        StrongConnectivityInspector inspector = new StrongConnectivityInspector(this.graph);
        List sccs = inspector.stronglyConnectedSets();
        Iterator i = sccs.iterator();
        while (i.hasNext()) {
            if (((Set)i.next()).size() != 1) continue;
            i.remove();
        }
        return sccs;
    }
}

