/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.Iterator;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.DirectedGraph;

public class RemoveGraphEdges {
    private EList<RunnableSequencingConstraint> RSCs;

    public void setRSCs(EList<RunnableSequencingConstraint> rSCs) {
        this.RSCs = rSCs;
    }

    public EList<RunnableSequencingConstraint> getRSCs() {
        return this.RSCs;
    }

    public void removeAPSRSCs(Object obj, SWModel swm) {
        Iterator it = null;
        BasicEList rsclist = new BasicEList();
        if (obj instanceof EList) {
            EList list = (EList)obj;
            it = list.iterator();
        } else if (obj instanceof DirectedGraph) {
            DirectedGraph graph = (DirectedGraph)obj;
            it = graph.edgeSet().iterator();
        }
        while (it != null && it.hasNext()) {
            Object rscit = it.next();
            if (!(rscit instanceof RunnableSequencingConstraint)) continue;
            rsclist.add((Object)((RunnableSequencingConstraint)rscit));
        }
        this.setRSCs((EList<RunnableSequencingConstraint>)rsclist);
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            if (pp.getAccessPrecedenceSpec() == null || pp.getAccessPrecedenceSpec().size() <= 0) continue;
            for (AccessPrecedenceSpec aps : pp.getAccessPrecedenceSpec()) {
                RunnableSequencingConstraint rscrem = this.getRSCfromAPS(aps);
                if (rscrem == null) continue;
                rsclist.remove((Object)rscrem);
                PartLog.getInstance().log("Removed RSC " + rscrem.getName() + " due to APS");
            }
        }
        this.setRSCs((EList<RunnableSequencingConstraint>)rsclist);
        new Helper().checkTRCsVsAllRunnables(swm);
    }

    private RunnableSequencingConstraint getRSCfromAPS(AccessPrecedenceSpec aps) {
        assert (this.RSCs != null);
        if (this.RSCs == null) {
            return null;
        }
        for (RunnableSequencingConstraint rsc : this.RSCs) {
            if (!new Helper().AllRSCsHave2ValidEntries(this.RSCs) || !aps.getOrigin().equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || !aps.getTarget().equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
            return rsc;
        }
        return null;
    }
}

