/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.ConfigurationException;
import org.eclipse.app4mc.multicore.partitioning.PartitioningPlugin;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PerformPartitioning;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public class GeneratePartitioning
extends WorkflowComponent {
    public static final String PARTITIONING_CPP = "cpp";
    public static final String PARTITIONING_ESSP = "essp";
    private final String resultSlot = "partitioning";
    private String partitioningAlg;
    private String numberOfPartitions;
    private String modelLoc = "";
    private final boolean enableLog = false;

    public void setModelLoc(String modelLoc) {
        this.modelLoc = modelLoc;
    }

    protected void runInternal(Context ctx) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        Amalthea modelCopy = this.getAmaltheaModelCopy(ctx);
        assert (modelCopy.getSwModel() != null && modelCopy.getConstraintsModel() != null);
        if (this.isEnableLog()) {
            PartLog.getInstance().setEnableSourceConsoleLog(true);
        }
        Path path = new Path(this.modelLoc);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        PerformPartitioning partitioning = new PerformPartitioning();
        IPreferenceStore store = PartitioningPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.app4mc.multicore.partitioning.partAlgorithm", this.getPartitioningAlg());
        store.setValue("org.eclipse.app4mc.multicore.partitioning.intThreads", this.numberOfPartitions);
        partitioning.execute(file, (IProgressMonitor)monitor, store);
        modelCopy = partitioning.retainAffntyCnstrnts(file, modelCopy, (IProgressMonitor)monitor);
        PartLog.getInstance().log("Setting result model in slot: " + this.getResultSlot());
        ctx.set(this.getResultSlot(), (Object)modelCopy);
    }

    protected void checkInternal() throws ConfigurationException {
        if (this.getPartitioningAlg() == null || this.getPartitioningAlg().isEmpty()) {
            throw new ConfigurationException("No proper partitioning defined! Please define one of the following values: numberOfPartitions, globalCP, partitioningAlg");
        }
    }

    public String getPartitioningAlg() {
        return this.partitioningAlg;
    }

    public void setPartitioningAlg(String partitioningAlg) {
        this.partitioningAlg = partitioningAlg;
    }

    public String getResultSlot() {
        return "partitioning";
    }

    public boolean isEnableLog() {
        return false;
    }

    public String getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(String numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }
}

