/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs.modelchecker;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpecAmountType;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpecModelType;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverity;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.LoggerEntry;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.ModelSpecLogger;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.specs.ModelSpecAmount;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.specs.ModelSpecHasModelType;

public abstract class ModelSpec {
    protected EntrySeverityLevel severity;
    private ModelSpecLogger logger;
    protected String specType;
    protected String currResource;
    protected String name;

    public static ModelSpecAmount ofAmount(ModelSpecAmountType type) {
        return new ModelSpecAmount(type);
    }

    public static ModelSpecHasModelType ofHasModel(ModelSpecModelType type) {
        return new ModelSpecHasModelType(type);
    }

    public EntrySeverity checkSpec(String resourceName, Amalthea model) throws Exception {
        this.currResource = resourceName;
        boolean modelOk = this.checkSpec(model);
        EntrySeverity ret = modelOk ? EntrySeverity.of(EntrySeverityLevel.OK) : EntrySeverity.of(this.severity);
        this.currResource = "";
        return ret;
    }

    protected abstract boolean checkSpec(Amalthea var1) throws Exception;

    protected ModelSpecLogger getLogger() {
        return this.logger;
    }

    protected void setLogger(ModelSpecLogger logger) {
        this.logger = logger;
    }

    protected void log(String message) {
        assert (this.logger != null) : "ERROR: Spec without error logger";
        if (this.severity.ordinal() <= EntrySeverityLevel.OK.ordinal()) {
            return;
        }
        this.logger.addEntry(LoggerEntry.builder().setSeverity(EntrySeverity.of(this.severity)).setMessage(message).setResource(this.currResource).setType(this.specType));
    }

    protected String getName() {
        return this.name;
    }

    protected EntrySeverityLevel getSeverityLevel() {
        return this.severity;
    }
}

