/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.CategoryTreeNodeInfo;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.LoggerEntry;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.labelproviders.DescriptionLabelProvider;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.labelproviders.ResourceLabelProvider;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.labelproviders.TypeLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class TreeViewerLog
extends TreeViewer {
    private static final Image WRN_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
    private static final Image ERROR_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private final TreeNode errorNode = new TreeNode((Object)new CategoryTreeNodeInfo("Errors", ERROR_ICON));
    private final TreeNode warningNode = new TreeNode((Object)new CategoryTreeNodeInfo("Warnings", WRN_ICON));

    public TreeViewerLog(Composite parent) {
        super(parent);
        TreeViewerColumn viewerColumn = new TreeViewerColumn((TreeViewer)this, 522);
        viewerColumn.getColumn().setWidth(500);
        viewerColumn.getColumn().setText("Description");
        viewerColumn.getColumn().setResizable(true);
        viewerColumn.getColumn().setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new DescriptionLabelProvider());
        viewerColumn = new TreeViewerColumn((TreeViewer)this, 514);
        viewerColumn.getColumn().setWidth(300);
        viewerColumn.getColumn().setText("Resource");
        viewerColumn.getColumn().setResizable(true);
        viewerColumn.getColumn().setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new ResourceLabelProvider());
        viewerColumn = new TreeViewerColumn((TreeViewer)this, 514);
        viewerColumn.getColumn().setWidth(200);
        viewerColumn.getColumn().setText("Type");
        viewerColumn.getColumn().setResizable(true);
        viewerColumn.getColumn().setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new TypeLabelProvider());
        this.getTree().setHeaderVisible(true);
        this.getTree().setLinesVisible(true);
        this.getTree().setLayoutData((Object)new GridData(1808));
        this.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        ArrayList<TreeNode> categories = new ArrayList<TreeNode>();
        categories.add(this.errorNode);
        categories.add(this.warningNode);
        this.setInput(categories.toArray(new TreeNode[categories.size()]));
    }

    public void setLog(ArrayList<LoggerEntry> log) {
        for (LoggerEntry entry : log) {
            this.addEntry(entry);
        }
    }

    private void addEntry(LoggerEntry entry) {
        TreeNode category;
        switch (entry.getSeverity().getSeverityLevel()) {
            case ERROR: {
                category = this.errorNode;
                break;
            }
            case WARNING: {
                category = this.warningNode;
                break;
            }
            default: {
                category = this.warningNode;
            }
        }
        CategoryTreeNodeInfo info = (CategoryTreeNodeInfo)category.getValue();
        ArrayList<Object> children = category.getChildren() != null ? new ArrayList<TreeNode>(Arrays.asList(category.getChildren())) : new ArrayList();
        TreeNode newNode = new TreeNode((Object)entry);
        newNode.setParent(category);
        children.add(newNode);
        category.setChildren(children.toArray(new TreeNode[children.size()]));
        info.setCount(children.size());
        this.refresh(category, true);
    }

    public void flush() {
        this.errorNode.setChildren(null);
        this.warningNode.setChildren(null);
        ((CategoryTreeNodeInfo)this.errorNode.getValue()).setCount(0);
        ((CategoryTreeNodeInfo)this.warningNode.getValue()).setCount(0);
        this.refresh(this.errorNode, true);
        this.refresh(this.warningNode, true);
    }
}

