/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters081.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MappingConverter
extends AbstractConverter {
    public MappingConverter() {
        this.helper = HelperUtils_080_081.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.0 to 0.8.1  : Executing Mapping converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateMappingModel_coreAllocation(rootElement);
        this.updateMappingModel_schedulerAllocation(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateMappingModel_schedulerAllocation(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./mappingModel/taskAllocation");
        List taskAllocationElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        boolean priorityAddedAsSchedulingParameter = false;
        for (Element taskAllocationElement : taskAllocationElements) {
            Attribute priorityAttribute = taskAllocationElement.getAttribute("priority");
            if (priorityAttribute == null) continue;
            String value = priorityAttribute.getValue();
            taskAllocationElement.removeAttribute(priorityAttribute);
            if (value.equals("0")) continue;
            priorityAddedAsSchedulingParameter = true;
            Element schedulingParametersElement = new Element("schedulingParameters");
            schedulingParametersElement.setAttribute("priority", value);
            taskAllocationElement.addContent((Content)schedulingParametersElement);
        }
        if (priorityAddedAsSchedulingParameter) {
            this.logger.info((Object)"Priority is removed from TaskAllocation elements and added as a attribute in corresponding SchedulingParameters element");
        }
    }

    private void updateMappingModel_coreAllocation(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./mappingModel/coreAllocation");
        List coreAllocationElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element coreAllocationElement : coreAllocationElements) {
            coreAllocationElement.setName("schedulerAllocation");
            Attribute coreAttribute = coreAllocationElement.getAttribute("core");
            Element coreElement = coreAllocationElement.getChild("core");
            if (coreAttribute != null) {
                coreAttribute.setName("responsibility");
                continue;
            }
            if (coreElement == null) continue;
            coreElement.setName("responsibility");
        }
    }
}

