/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters083.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters083.utils.HelperUtils_082_083;
import org.eclipse.app4mc.amalthea.converters083.utils.PeriodicStimulusCacheBuilder;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class StimuliConverter
extends AbstractConverter {
    private List<ICache> caches;
    private PeriodicStimulusCacheBuilder periodicStimulusCacheBuilder;

    public StimuliConverter() {
        this.helper = HelperUtils_082_083.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.2 to 0.8.3  : Executing Stimulus model converter for model file : " + targetFile.getName()));
        this.caches = caches;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateVariableRateStimulus(rootElement);
        this.migrateSyntheticStimulus(rootElement);
        this.migrateSporadicStimulus(rootElement);
        this.migrateArrivalCurveStimulus(rootElement);
        this.migrateSingleStimulus(rootElement);
        this.migrateRemainingStimulusTypes(rootElement);
        this.migratePeriodicStimulus(rootElement);
        this.migrateStimulusReferences(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private PeriodicStimulusCacheBuilder getPeriodicStimulusCacheBuilder() {
        if (this.periodicStimulusCacheBuilder == null) {
            for (ICache cache : this.caches) {
                if (!(cache instanceof PeriodicStimulusCacheBuilder)) continue;
                this.periodicStimulusCacheBuilder = (PeriodicStimulusCacheBuilder)cache;
                return this.periodicStimulusCacheBuilder;
            }
        }
        return this.periodicStimulusCacheBuilder;
    }

    private void migrateStimulusReferences(Element rootElement) {
        StringBuffer xpathBufferForReferences = new StringBuffer();
        xpathBufferForReferences.append("./swModel/isrs");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./swModel/tasks");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./eventModel/events");
        List stimulusReferenceContainers = this.helper.getXpathResult(rootElement, xpathBufferForReferences.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element stimulusReferenceContainer : stimulusReferenceContainers) {
            this.migrate_references_PeriodicStimulus(stimulusReferenceContainer);
            this.migrate_references_SporadicStimulus(stimulusReferenceContainer);
            this.migrate_references_SyntheticStimulus(stimulusReferenceContainer);
        }
    }

    private void migratePeriodicStimulus(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:PeriodicStimulus\"]");
        List stimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element stimulusElement : stimulusElements) {
            Element clockElement = stimulusElement.getChild("clock");
            Attribute clockAttribute = stimulusElement.getAttribute("clock");
            if (clockElement == null && clockAttribute == null) {
                Element stimulusDeviationElement = stimulusElement.getChild("stimulusDeviation");
                if (stimulusDeviationElement == null) continue;
                stimulusDeviationElement.setName("jitter");
                continue;
            }
            Attribute typeAttribute = stimulusElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            typeAttribute.setValue("am:VariableRateStimulus");
            Element recurrenceElement = stimulusElement.getChild("recurrence");
            Element offsetElement = stimulusElement.getChild("offset");
            Element scenarioElement = new Element("scenario");
            if (recurrenceElement != null) {
                recurrenceElement.detach();
                scenarioElement.addContent((Content)recurrenceElement);
            }
            if (clockElement != null) {
                clockElement.detach();
                scenarioElement.addContent((Content)clockElement);
            } else if (clockAttribute != null) {
                clockAttribute.detach();
                scenarioElement.setAttribute(clockAttribute);
            }
            stimulusElement.addContent((Content)scenarioElement);
            if (offsetElement != null) {
                Element customPropertiesElement = new Element("customProperties");
                customPropertiesElement.setAttribute("key", "offset");
                offsetElement.detach();
                offsetElement.setName("value");
                offsetElement.setAttribute("type", "am:TimeObject", this.helper.getGenericNS("xsi"));
                customPropertiesElement.addContent((Content)offsetElement);
                scenarioElement.addContent((Content)customPropertiesElement);
            }
            stimulusElement.removeChild("offset");
            stimulusElement.removeChild("stimulusDeviation");
        }
    }

    private boolean canPeriodicStimulusTypeBeChangedForHref(String href) {
        int end;
        int start = href.indexOf("#");
        if (start != -1 & (end = href.lastIndexOf("?")) != -1) {
            String elementName = href.substring(start + 1, end);
            boolean result = this.isPeriodicStimulusPresentInCache(elementName);
            return result;
        }
        return false;
    }

    private boolean isPeriodicStimulusPresentInCache(String elementName) {
        Map<File, Map<String, Object>> cacheMap = this.getPeriodicStimulusCacheBuilder().getCacheMap();
        if (cacheMap != null) {
            Set<File> keySet = cacheMap.keySet();
            for (File file : keySet) {
                List periodicStimulus_with_clock;
                Object object;
                Map<String, Object> map = cacheMap.get(file);
                if (map == null || (object = map.get("PeriodicStimulus_Containing_Clock")) == null || !(periodicStimulus_with_clock = (List)object).contains(elementName)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkAndUpdatePeriodicStimulusReference(String reference) {
        String elementName;
        boolean result;
        int index = reference.lastIndexOf("?");
        if (index != -1 && (result = this.isPeriodicStimulusPresentInCache(elementName = reference.substring(0, index)))) {
            elementName = reference.replace("?type=PeriodicStimulus", "?type=VariableRateStimulus");
            return elementName;
        }
        return reference;
    }

    private void migrateRemainingStimulusTypes(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:CustomStimulus\" or @xsi:type=\"am:InterProcessStimulus\" or @xsi:type=\"am:EventStimulus\"]");
        List stimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
        }
    }

    private void migrateSingleStimulus(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SingleStimulus\"]");
        List stimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
            Element activationElement = stimulusElement.getChild("activation");
            if (activationElement == null) continue;
            activationElement.setName("occurrence");
        }
    }

    private void migrateArrivalCurveStimulus(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:ArrivalCurveStimulus\"]");
        List stimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
            List entriesElements = stimulusElement.getChildren("entries");
            for (Element entriesElement : entriesElements) {
                Attribute attribute = entriesElement.getAttribute("numberOfEvents");
                if (attribute == null) continue;
                attribute.setName("numberOfOccurrences");
            }
        }
    }

    private void migrateSporadicStimulus(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SporadicStimulus\"]");
        List sporadicStimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element sporadicStimulusElement : sporadicStimulusElements) {
            Attribute typeAttribute = sporadicStimulusElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            typeAttribute.setValue("am:RelativePeriodicStimulus");
            sporadicStimulusElement.removeAttribute("description");
            Element stimulusDeviationElement = sporadicStimulusElement.getChild("stimulusDeviation");
            if (stimulusDeviationElement == null) continue;
            stimulusDeviationElement.setName("nextOccurrence");
        }
    }

    private void migrateVariableRateStimulus(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]");
        List stimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
        }
    }

    private void migrateSyntheticStimulus(Element rootElement) {
        StringBuffer xpathBufferForDefinition = new StringBuffer();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SyntheticStimulus\"]");
        List syntheticStimulusElements = this.helper.getXpathResult(rootElement, xpathBufferForDefinition.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
        for (Element syntheticStimulusElement : syntheticStimulusElements) {
            Element triggerTimesElement;
            Attribute typeAttribute = syntheticStimulusElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            typeAttribute.setValue("am:PeriodicSyntheticStimulus");
            syntheticStimulusElement.removeChild("stimulusDeviation");
            Element periodElement = syntheticStimulusElement.getChild("period");
            if (periodElement != null) {
                periodElement.setName("recurrence");
            }
            if ((triggerTimesElement = syntheticStimulusElement.getChild("triggerTimes")) == null) continue;
            List timeStampsElements = this.helper.getXpathResult(triggerTimesElement, ".//timestamps", Element.class, new Namespace[]{this.helper.getGenericNS("xsi"), this.helper.getNS_083("am")});
            for (Element timeStampsElement : timeStampsElements) {
                timeStampsElement.setName("occurrenceTimes");
                timeStampsElement.detach();
                syntheticStimulusElement.addContent((Content)timeStampsElement);
            }
            syntheticStimulusElement.removeContent((Content)triggerTimesElement);
        }
    }

    private void migrate_references_SporadicStimulus(Element stimulusReferenceContainer) {
        String containerTagName = stimulusReferenceContainer.getName();
        if (containerTagName.equals("isrs") || containerTagName.equals("tasks")) {
            List stimuliElements = stimulusReferenceContainer.getChildren("stimuli");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("stimuli");
            for (Element stimuliElement : stimuliElements) {
                Attribute hrefAttribute;
                if (stimuliElement == null) continue;
                Attribute typeAttribute = stimuliElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SporadicStimulus")) {
                    typeAttribute.setValue("am:RelativePeriodicStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) == null) continue;
                String value = hrefAttribute.getValue();
                value = value.replace("?type=SporadicStimulus", "?type=RelativePeriodicStimulus");
                hrefAttribute.setValue(value);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replaceAll("\\?type\\=SporadicStimulus", "?type=RelativePeriodicStimulus");
                stimuliAttribute.setValue(value);
            }
        } else if (containerTagName.equals("events")) {
            Element stimuliElement = stimulusReferenceContainer.getChild("entity");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("entity");
            if (stimuliElement != null) {
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SporadicStimulus")) {
                    typeAttribute.setValue("am:RelativePeriodicStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) != null) {
                    String value = hrefAttribute.getValue();
                    value = value.replace("?type=SporadicStimulus", "?type=RelativePeriodicStimulus");
                    hrefAttribute.setValue(value);
                }
            } else if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace("?type=SporadicStimulus", "?type=RelativePeriodicStimulus");
                stimuliAttribute.setValue(value);
            }
        }
    }

    private void migrate_references_SyntheticStimulus(Element syntheticStimulusReferenceContainer) {
        String containerTagName = syntheticStimulusReferenceContainer.getName();
        if (containerTagName.equals("isrs") || containerTagName.equals("tasks")) {
            List stimuliElements = syntheticStimulusReferenceContainer.getChildren("stimuli");
            Attribute stimuliAttribute = syntheticStimulusReferenceContainer.getAttribute("stimuli");
            for (Element stimuliElement : stimuliElements) {
                Attribute hrefAttribute;
                if (stimuliElement == null) continue;
                Attribute typeAttribute = stimuliElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SyntheticStimulus")) {
                    typeAttribute.setValue("am:PeriodicSyntheticStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) == null) continue;
                String value = hrefAttribute.getValue();
                value = value.replace("?type=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                hrefAttribute.setValue(value);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replaceAll("\\?type\\=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                stimuliAttribute.setValue(value);
            }
        } else if (containerTagName.equals("events")) {
            Element stimuliElement = syntheticStimulusReferenceContainer.getChild("entity");
            Attribute stimuliAttribute = syntheticStimulusReferenceContainer.getAttribute("entity");
            if (stimuliElement != null) {
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SyntheticStimulus")) {
                    typeAttribute.setValue("am:PeriodicSyntheticStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) != null) {
                    String value = hrefAttribute.getValue();
                    value = value.replace("?type=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                    hrefAttribute.setValue(value);
                }
            } else if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace("?type=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                stimuliAttribute.setValue(value);
            }
        }
    }

    private void migrate_references_PeriodicStimulus(Element stimulusReferenceContainer) {
        String containerTagName = stimulusReferenceContainer.getName();
        if (containerTagName.equals("isrs") || containerTagName.equals("tasks")) {
            List stimuliElements = stimulusReferenceContainer.getChildren("stimuli");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("stimuli");
            for (Element stimuliElement : stimuliElements) {
                String hrefValue;
                Attribute hrefAttribute;
                Attribute typeAttribute;
                if (stimuliElement == null || (typeAttribute = stimuliElement.getAttribute("type", this.helper.getGenericNS("xsi"))) == null || !typeAttribute.getValue().equals("am:PeriodicStimulus") || (hrefAttribute = stimuliElement.getAttribute("href")) == null || !this.canPeriodicStimulusTypeBeChangedForHref(hrefValue = hrefAttribute.getValue())) continue;
                typeAttribute.setValue("am:VariableRateStimulus");
                hrefValue = hrefValue.replace("?type=PeriodicStimulus", "?type=VariableRateStimulus");
                hrefAttribute.setValue(hrefValue);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                String[] split = value.split("\\s+");
                StringBuffer updatedRefsBuffer = new StringBuffer();
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String reference = stringArray[n2];
                    if (reference.contains("?type=PeriodicStimulus")) {
                        updatedRefsBuffer.append(String.valueOf(this.checkAndUpdatePeriodicStimulusReference(reference)) + " ");
                    } else {
                        updatedRefsBuffer.append(String.valueOf(reference) + " ");
                    }
                    ++n2;
                }
                value = updatedRefsBuffer.toString().trim();
                stimuliAttribute.setValue(value);
            }
        } else if (containerTagName.equals("events")) {
            Element stimuliElement = stimulusReferenceContainer.getChild("entity");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("entity");
            if (stimuliElement != null) {
                String hrefValue;
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:PeriodicStimulus") && (hrefAttribute = stimuliElement.getAttribute("href")) != null && this.canPeriodicStimulusTypeBeChangedForHref(hrefValue = hrefAttribute.getValue())) {
                    typeAttribute.setValue("am:VariableRateStimulus");
                    hrefValue = hrefValue.replace("?type=PeriodicStimulus", "?type=VariableRateStimulus");
                    hrefAttribute.setValue(hrefValue);
                }
            } else if (stimuliAttribute != null) {
                String reference = stimuliAttribute.getValue();
                if (reference.contains("?type=PeriodicStimulus")) {
                    reference = this.checkAndUpdatePeriodicStimulusReference(reference);
                }
                stimuliAttribute.setValue(reference);
            }
        }
    }
}

