/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.ExecutionNeed;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableModeSwitch;
import org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ServerCall;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class SoftwareUtil {
    public static EList<CallSequenceItem> collectCalls(Process process) {
        return SoftwareUtil.collectCalls(process, null, CallSequenceItem.class, null);
    }

    public static EList<CallSequenceItem> collectCalls(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, CallSequenceItem.class, null);
    }

    public static EList<CallSequenceItem> collectCalls(Process process, EMap<ModeLabel, ModeLiteral> modes, Function<CallSequenceItem, Boolean> filter) {
        return SoftwareUtil.collectCalls(process, modes, CallSequenceItem.class, filter);
    }

    public static <T extends CallSequenceItem> EList<T> collectCalls(Process process, EMap<ModeLabel, ModeLiteral> modes, Class<T> targetClass) {
        return SoftwareUtil.collectCalls(process, modes, targetClass, null);
    }

    public static <T extends CallSequenceItem> EList<T> collectCalls(Process process, EMap<ModeLabel, ModeLiteral> modes, Class<T> targetClass, Function<T, Boolean> filter) {
        BasicEList itemList = new BasicEList();
        if (process.getCallGraph() != null) {
            SoftwareUtil.collectCallSequenceItems(process.getCallGraph().getGraphEntries(), modes, targetClass, filter, itemList);
        }
        return itemList;
    }

    private static <T extends CallSequenceItem> void collectCallSequenceItems(EList<GraphEntryBase> input, EMap<ModeLabel, ModeLiteral> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        for (GraphEntryBase entry : input) {
            if (entry instanceof ProbabilitySwitch) {
                ProbabilitySwitch propSwitch = (ProbabilitySwitch)entry;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectCallSequenceItems(pse.getItems(), modes, targetClass, filter, itemList);
                }
                continue;
            }
            if (entry instanceof ModeSwitch) {
                ModeSwitch modeSwitch = (ModeSwitch)entry;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, targetClass, filter, itemList);
                        continue;
                    }
                    if (!mse.getCondition().isSatisfiedBy(modes)) continue;
                    SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, targetClass, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectCallSequenceItems(modeSwitch.getDefaultEntry().getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (!(entry instanceof CallSequence)) continue;
            for (CallSequenceItem item : ((CallSequence)entry).getCalls()) {
                if (!targetClass.isInstance(item)) continue;
                CallSequenceItem castedItem = (CallSequenceItem)targetClass.cast(item);
                if (filter != null && !filter.apply(castedItem).booleanValue()) continue;
                itemList.add(castedItem);
            }
        }
    }

    public static EList<RunnableItem> collectRunnableItems(Runnable runnable) {
        return SoftwareUtil.collectRunnableItems(runnable, null, RunnableItem.class, null);
    }

    public static EList<RunnableItem> collectRunnableItems(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, RunnableItem.class, null);
    }

    public static EList<RunnableItem> collectRunnableItems(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes, Function<RunnableItem, Boolean> filter) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, RunnableItem.class, filter);
    }

    public static <T extends RunnableItem> EList<T> collectRunnableItems(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes, Class<T> targetClass) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, targetClass, null);
    }

    public static <T extends RunnableItem> EList<T> collectRunnableItems(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes, Class<T> targetClass, Function<T, Boolean> filter) {
        BasicEList itemList = new BasicEList();
        SoftwareUtil.collectRunnableItems(runnable.getRunnableItems(), modes, targetClass, filter, itemList);
        return itemList;
    }

    private static <T extends RunnableItem> void collectRunnableItems(EList<RunnableItem> input, EMap<ModeLabel, ModeLiteral> modes, Class<T> targetClass, Function<T, Boolean> filter, List<T> itemList) {
        for (RunnableItem item : input) {
            if (item instanceof Group) {
                SoftwareUtil.collectRunnableItems(((Group)item).getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (item instanceof RunnableProbabilitySwitch) {
                RunnableProbabilitySwitch propSwitch = (RunnableProbabilitySwitch)item;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectRunnableItems(pse.getItems(), modes, targetClass, filter, itemList);
                }
                continue;
            }
            if (item instanceof RunnableModeSwitch) {
                RunnableModeSwitch modeSwitch = (RunnableModeSwitch)item;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectRunnableItems(mse.getItems(), modes, targetClass, filter, itemList);
                        continue;
                    }
                    if (!mse.getCondition().isSatisfiedBy(modes)) continue;
                    SoftwareUtil.collectRunnableItems(mse.getItems(), modes, targetClass, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectRunnableItems(modeSwitch.getDefaultEntry().getItems(), modes, targetClass, filter, itemList);
                continue;
            }
            if (!targetClass.isInstance(item)) continue;
            RunnableItem castedItem = (RunnableItem)targetClass.cast(item);
            if (filter != null && !filter.apply(castedItem).booleanValue()) continue;
            itemList.add(castedItem);
        }
    }

    public static Set<Label> getAccessedLabelSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class).stream().map(la -> la.getData()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Label> getReadLabelSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ).stream().map(la -> la.getData()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Label> getWriteLabelSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE).stream().map(la -> la.getData()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static List<LabelAccess> getLabelAccessList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class);
    }

    public static List<LabelAccess> getReadLabelAccessList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.READ);
    }

    public static List<LabelAccess> getWriteLabelAccessList(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getAccess() == LabelAccessEnum.WRITE);
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getData() != null).stream().collect(Collectors.groupingBy(LabelAccess::getData));
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null && la.getAccess() == LabelAccessEnum.READ).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, LabelAccess.class, la -> la.getData() != null && la.getStatistic() != null && la.getAccess() == LabelAccessEnum.WRITE).stream().collect(Collectors.groupingBy(LabelAccess::getData, Collectors.mapping(LabelAccess::getStatistic, Collectors.toList())));
    }

    public static Set<Label> getAccessedLabelSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getAccessedLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getReadLabelSet(r, modes));
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getWriteLabelSet(r, modes));
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getLabelAccessList(r, modes));
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccess>> labelToLabelAccessMap = SoftwareUtil.getLabelToLabelAccessMap(r, modes);
            for (Label key : labelToLabelAccessMap.keySet()) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                result.get(key).addAll((Collection<LabelAccess>)labelToLabelAccessMap.get(key));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getLabelAccessStatisticsMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> labelToLabelAccessMap = SoftwareUtil.getLabelAccessStatisticsMap(r, modes);
            for (Label key : labelToLabelAccessMap.keySet()) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                result.get(key).addAll((Collection<LabelAccessStatistic>)labelToLabelAccessMap.get(key));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getReadLabelAccessStatisticsMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> readLabelAccessStatisticsMap = SoftwareUtil.getReadLabelAccessStatisticsMap(r, modes);
            for (Label key : readLabelAccessStatisticsMap.keySet()) {
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                result.get(key).addAll((Collection<LabelAccessStatistic>)readLabelAccessStatisticsMap.get(key));
            }
        }
        return result;
    }

    public static Map<Label, List<LabelAccessStatistic>> getWriteLabelAccessStatisticsMap(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashMap<Label, List<LabelAccessStatistic>> result = new HashMap<Label, List<LabelAccessStatistic>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            Map<Label, List<LabelAccessStatistic>> writeLabelAcessStatisticsMap = SoftwareUtil.getWriteLabelAccessStatisticsMap(r, modes);
            for (Label l : writeLabelAcessStatisticsMap.keySet()) {
                if (!result.containsKey(l)) {
                    result.put(l, new ArrayList());
                }
                result.get(l).addAll((Collection<LabelAccessStatistic>)writeLabelAcessStatisticsMap.get(l));
            }
        }
        return result;
    }

    public static float getLabelReadCount(Label label, Process process, EMap<ModeLabel, ModeLiteral> modes, RuntimeUtil.TimeType timeType) {
        float reads = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            List<LabelAccess> readLabelAccessesOfRunnable = SoftwareUtil.getReadLabelAccessList(r, modes);
            for (LabelAccess la : readLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    reads += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        reads += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        reads += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        reads += (float)stat.getMax();
                    }
                }
            }
        }
        return reads;
    }

    public static float getLabelWriteCount(Label label, Process process, EMap<ModeLabel, ModeLiteral> modes, RuntimeUtil.TimeType timeType) {
        float writes = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modes)) {
            List<LabelAccess> writeLabelAccessesOfRunnable = SoftwareUtil.getWriteLabelAccessList(r, modes);
            for (LabelAccess la : writeLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    writes += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        writes += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        writes += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        writes += (float)stat.getMax();
                    }
                }
            }
        }
        return writes;
    }

    public static List<Runnable> getRunnableList(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, TaskRunnableCall.class).stream().map(call -> call.getRunnable()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Set<Runnable> getRunnableSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getRunnableList(process, modes));
    }

    public static float getLabelAccessCountFromStatistics(LabelAccess labelAcc, RuntimeUtil.TimeType accType) {
        float accesses = 1.0f;
        if (labelAcc.getStatistic() == null) {
            return 1.0f;
        }
        if (labelAcc.getStatistic().getValue() instanceof SingleValueStatistic) {
            accesses = ((SingleValueStatistic)labelAcc.getStatistic().getValue()).getValue();
        } else if (labelAcc.getStatistic().getValue() instanceof MinAvgMaxStatistic) {
            switch (accType) {
                case ACET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                    break;
                }
                case BCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMin();
                    break;
                }
                case WCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMax();
                    break;
                }
                default: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                }
            }
        }
        return accesses;
    }

    public static List<Runnable> getReaderListOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (la.getAccess() != LabelAccessEnum.READ) continue;
            Runnable run = AmaltheaServices.getContainerOfType(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectRunnableItems(run, modes).contains((Object)la)) continue;
            result.add(AmaltheaServices.getContainerOfType(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getReadersSetOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getReaderListOfLabel(label, modes));
    }

    public static List<Runnable> getWriterListOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            Runnable run = AmaltheaServices.getContainerOfType(la, Runnable.class);
            if (modes != null && !modes.isEmpty() && !SoftwareUtil.collectRunnableItems(run, modes).contains((Object)la)) continue;
            result.add(AmaltheaServices.getContainerOfType(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getWriterSetOfLabel(Label label, EMap<ModeLabel, ModeLiteral> modes) {
        return new HashSet<Runnable>(SoftwareUtil.getWriterListOfLabel(label, modes));
    }

    public static List<SetEvent> collectSetEvents(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, SetEvent.class);
    }

    public static List<ClearEvent> collectClearEvents(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, ClearEvent.class);
    }

    public static List<WaitEvent> collectWaitEvents(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, WaitEvent.class);
    }

    public static List<CallSequenceItem> collectEventsOfProcess(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, (CallSequenceItem call) -> call instanceof ClearEvent || call instanceof SetEvent || call instanceof WaitEvent);
    }

    public static List<Label> getInterTaskCommunication(Process sender, Process receiver, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Label> result = new ArrayList<Label>();
        result.addAll(SoftwareUtil.getWriteLabelSet(sender, modes));
        result.retainAll(SoftwareUtil.getReadLabelSet(receiver, modes));
        return result;
    }

    public static List<Process> getProcesses(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Process> result = new ArrayList<Process>();
        for (TaskRunnableCall trc : runnable.getTaskRunnableCalls()) {
            Process proc = trc.getContainingProcess();
            if (proc == null) continue;
            if (modes != null && !modes.isEmpty()) {
                if (!SoftwareUtil.getRunnableList(proc, modes).contains(runnable)) continue;
                result.add(proc);
                continue;
            }
            result.add(proc);
        }
        return result;
    }

    public static List<Runnable> getRunnableCallParents(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (RunnableCall rc : runnable.getRunnableCalls()) {
            Runnable run = rc.getContainingRunnable();
            if (run == null) continue;
            if (modes != null && !modes.isEmpty()) {
                EList<RunnableItem> runItems = SoftwareUtil.collectRunnableItems(run, modes);
                if (runItems == null || !runItems.isEmpty()) continue;
                for (RunnableItem runItem : runItems) {
                    if (!(runItem instanceof RunnableCall) || !((RunnableCall)runItem).getRunnable().equals(runnable)) continue;
                    result.add(run);
                }
                continue;
            }
            result.add(run);
        }
        return result;
    }

    public static List<Runnable> getCalledRunnables(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, RunnableCall.class).stream().map(rc -> rc.getRunnable()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ExecutionNeed> getExecutionNeeds(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, ExecutionNeed.class);
    }

    public static List<ExecutionNeed> getExecutionNeeds(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<ExecutionNeed> result = new ArrayList<ExecutionNeed>();
        List<Runnable> runnableList = SoftwareUtil.getRunnableList(process, modes);
        for (Runnable run : runnableList) {
            result.addAll(SoftwareUtil.getExecutionNeeds(run, modes));
        }
        return result;
    }

    public static List<Ticks> getTicks(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, Ticks.class);
    }

    public static List<Ticks> getTicks(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        ArrayList<Ticks> result = new ArrayList<Ticks>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getTicks(run, modes));
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Runnable runnable, EMap<ModeLabel, ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, ServerCall.class).stream().collect(Collectors.toSet());
    }

    public static Set<ServerCall> getServerCallSet(Process process, EMap<ModeLabel, ModeLiteral> modes) {
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (Runnable run : SoftwareUtil.getRunnableList(process, modes)) {
            result.addAll(SoftwareUtil.getServerCallSet(run, modes));
        }
        return result;
    }
}

