/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AmaltheaModelValidatorImpl
extends AbstractValidatorImpl {
    public AmaltheaModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public AmaltheaModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    private double getSecondsFromTimeUnit(Time time) {
        double value = 0.0;
        if (time != null) {
            value = time.getValue().doubleValue();
            if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.PS.getLiteral())) {
                value *= Math.pow(10.0, -12.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.NS.getLiteral())) {
                value *= Math.pow(10.0, -9.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.US.getLiteral())) {
                value *= Math.pow(10.0, -6.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.MS.getLiteral())) {
                value *= Math.pow(10.0, -3.0);
            } else if (time.getUnit().getLiteral().equalsIgnoreCase(TimeUnit.S.getLiteral())) {
                value *= Math.pow(10.0, 0.0);
            }
        }
        return value;
    }

    public void checkUniqueName(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashMap<String, IReferable> names = new HashMap<String, IReferable>();
        HashSet<IReferable> ambiguousObjects = new HashSet<IReferable>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof IReferable)) continue;
            IReferable referable = (IReferable)elem;
            String name = referable.getUniqueName();
            if (names.containsKey(name)) {
                ambiguousObjects.add(referable);
                ambiguousObjects.add((IReferable)names.get(name));
                continue;
            }
            names.put(name, referable);
        }
        for (IReferable object : ambiguousObjects) {
            this.issueCreator.issue((EObject)object, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_UniqueName(), new Object[]{object.getUniqueName()});
        }
    }

    public void checkDeviation(Amalthea amalthea) {
        amalthea.eAllContents();
    }

    public void checkUniformDistribution(Amalthea amalthea) {
        amalthea.eAllContents();
    }

    public void checkBetaDistribution(Amalthea amalthea) {
        amalthea.eAllContents();
    }

    public void checkGaussDistribution(Amalthea amalthea) {
        amalthea.eAllContents();
    }

    public void checkWeibullEstimators(Amalthea amalthea) {
        amalthea.eAllContents();
    }
}

