/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters081.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;

public class HwConverter
extends AbstractConverter {
    public HwConverter() {
        this.helper = HelperUtils_080_081.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.0 to 0.8.1  : Executing Hardware converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.removeXAccessPattern(rootElement);
        this.updateQuartz(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateQuartz(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./hwModel/system//quartzes");
        List hwSystemElements = this.helper.getXpathResult(rootElement, "./hwModel/system", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        List quartzElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        Element hwSystemElement = null;
        if (hwSystemElements.size() > 0) {
            hwSystemElement = (Element)hwSystemElements.get(0);
        }
        for (Element quartzElement : quartzElements) {
            boolean removedQuartzes;
            boolean removedPrescalers;
            boolean removedPorts;
            boolean removedNetworks;
            boolean removedMemories;
            Parent parent = quartzElement.getParent();
            if (parent != null) {
                parent.removeContent((Content)quartzElement);
            }
            quartzElement.setName("quartzes");
            hwSystemElement.addContent((Content)quartzElement);
            Attribute nameAttribute = quartzElement.getAttribute("name");
            String quartzName = nameAttribute != null ? nameAttribute.getValue() : "";
            this.logger.info((Object)("Moved Quartz element" + quartzName + " as a child element of HwSystem"));
            boolean removedComponents = quartzElement.removeChild("components");
            if (removedComponents) {
                this.logger.warn((Object)("-- Removed all HwComponent objects defined inside Quartz : " + quartzName));
            }
            if (removedMemories = quartzElement.removeChild("memories")) {
                this.logger.warn((Object)("-- Removed all Memory objects defined inside Quartz : " + quartzName));
            }
            if (removedNetworks = quartzElement.removeChild("networks")) {
                this.logger.warn((Object)("-- Removed all Network objects defined inside Quartz : " + quartzName));
            }
            if (removedPorts = quartzElement.removeChild("ports")) {
                this.logger.warn((Object)("-- Removed all HwPort objects defined inside Quartz : " + quartzName));
            }
            if (removedPrescalers = quartzElement.removeChild("prescaler")) {
                this.logger.warn((Object)("-- Removed all Prescaler objects defined inside Quartz : " + quartzName));
            }
            if (!(removedQuartzes = quartzElement.removeChild("quartzes"))) continue;
            this.logger.warn((Object)("-- Moved all Quartz objects defined inside Quartz : " + quartzName + " as elements inside HwSystem"));
        }
    }

    private void removeXAccessPattern(Element rootElement) {
        List memoryTypeElements = this.helper.getXpathResult(rootElement, "./hwModel/memoryTypes", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element memoryTypeElement : memoryTypeElements) {
            memoryTypeElement.removeAttribute("xAccessPattern");
            this.logger.info((Object)("xAccessPattern attribute and its value are removed from MemoryType: " + memoryTypeElement.getAttributeValue("name")));
        }
    }
}

