/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.utils;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.utils.HrefElement;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_070;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_071;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_072;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_080;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_081;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_082;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_083;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_090;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_091;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_092;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_093;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_094;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_103;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_110;
import org.eclipse.app4mc.amalthea.converters.common.utils.NameSpace_111;
import org.eclipse.app4mc.amalthea.converters.common.utils.SchemaUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public abstract class AbstractHelper {
    public final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void addAdditionalNameSpace(Element rootElement, Namespace ... namespaces) {
        Namespace[] namespaceArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            Namespace namespace2 = namespaceArray[n2];
            List additionalNamespaces = rootElement.getAdditionalNamespaces();
            if (!additionalNamespaces.contains(namespace2) || !this.isNameSpacePrefixExisting(additionalNamespaces, namespace2)) {
                rootElement.addNamespaceDeclaration(namespace2);
            }
            ++n2;
        }
    }

    private boolean isNameSpacePrefixExisting(List<Namespace> namespaces, Namespace targetNameSpace) {
        for (Namespace namespace : namespaces) {
            if (!namespace.getPrefix().equals(targetNameSpace.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public boolean isNS_AvailableIn_094(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn094(ns_prefix) && ns_uri.equals(NameSpace_094.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_093(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn093(ns_prefix) && ns_uri.equals(NameSpace_093.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_092(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn092(ns_prefix) && ns_uri.equals(NameSpace_092.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_091(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn091(ns_prefix) && ns_uri.equals(NameSpace_091.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_090(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn090(ns_prefix) && ns_uri.equals(NameSpace_090.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_083(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn083(ns_prefix) && ns_uri.equals(NameSpace_083.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_082(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn082(ns_prefix) && ns_uri.equals(NameSpace_082.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_081(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn081(ns_prefix) && ns_uri.equals(NameSpace_081.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_080(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn080(ns_prefix) && ns_uri.equals(NameSpace_080.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_072(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn072(ns_prefix) && ns_uri.equals(NameSpace_072.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_071(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn071(ns_prefix) && ns_uri.equals(NameSpace_071.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_070(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn070(ns_prefix) && ns_uri.equals(NameSpace_070.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_111(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn111(ns_prefix) && ns_uri.equals(NameSpace_111.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_110(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn110(ns_prefix) && ns_uri.equals(NameSpace_110.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public boolean isNS_AvailableIn_103(Namespace namespace) {
        if (namespace != null) {
            String ns_prefix = namespace.getPrefix();
            String ns_uri = namespace.getURI();
            if (this.enumTypeContainsIn103(ns_prefix) && ns_uri.equals(NameSpace_103.valueOf(ns_prefix).getNSValue())) {
                return true;
            }
        }
        return false;
    }

    public Namespace getNS_111(String prefix) {
        if (this.enumTypeContainsIn111(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_111.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_110(String prefix) {
        if (this.enumTypeContainsIn110(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_110.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_103(String prefix) {
        if (this.enumTypeContainsIn103(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_103.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_070(String prefix) {
        if (this.enumTypeContainsIn070(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_070.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_071(String prefix) {
        if (this.enumTypeContainsIn071(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_071.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_072(String prefix) {
        if (this.enumTypeContainsIn072(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_072.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_080(String prefix) {
        if (this.enumTypeContainsIn080(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_080.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_081(String prefix) {
        if (this.enumTypeContainsIn081(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_081.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_082(String prefix) {
        if (this.enumTypeContainsIn082(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_082.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_083(String prefix) {
        if (this.enumTypeContainsIn083(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_083.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_090(String prefix) {
        if (this.enumTypeContainsIn090(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_090.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_091(String prefix) {
        if (this.enumTypeContainsIn091(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_091.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_092(String prefix) {
        if (this.enumTypeContainsIn092(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_092.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_093(String prefix) {
        if (this.enumTypeContainsIn093(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_093.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public Namespace getNS_094(String prefix) {
        if (this.enumTypeContainsIn094(prefix)) {
            return Namespace.getNamespace((String)prefix, (String)NameSpace_094.valueOf(prefix).getNSValue());
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public boolean enumTypeContainsIn110(String s) {
        try {
            NameSpace_110.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn103(String s) {
        try {
            NameSpace_103.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn111(String s) {
        try {
            NameSpace_111.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn070(String s) {
        try {
            NameSpace_070.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn071(String s) {
        try {
            NameSpace_071.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn072(String s) {
        try {
            NameSpace_072.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn080(String s) {
        try {
            NameSpace_080.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn081(String s) {
        try {
            NameSpace_081.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn082(String s) {
        try {
            NameSpace_082.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn083(String s) {
        try {
            NameSpace_083.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn090(String s) {
        try {
            NameSpace_090.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn091(String s) {
        try {
            NameSpace_091.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn092(String s) {
        try {
            NameSpace_092.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn093(String s) {
        try {
            NameSpace_093.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean enumTypeContainsIn094(String s) {
        try {
            NameSpace_094.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public Namespace getGenericNS(String prefix) {
        if ("xsi".equals(prefix)) {
            return Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        }
        if ("xmi".equals(prefix)) {
            return Namespace.getNamespace((String)"xmi", (String)"http://www.omg.org/XMI");
        }
        return Namespace.getNamespace((String)"", (String)"");
    }

    public void copyAllNameSpaces(Element source, Element target) {
        Namespace namespace = source.getNamespace();
        target.setNamespace(namespace);
        List additionalNamespaces = source.getAdditionalNamespaces();
        for (Namespace additionalNS : additionalNamespaces) {
            target.addNamespaceDeclaration(additionalNS);
        }
    }

    public <T> List<T> getXpathResult(Document document, String xpath, Class<T> expectedType, Namespace ... nameSpaces) {
        XPathFactory xpfac = XPathFactory.instance();
        if (Attribute.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.attribute(), null, nameSpaces);
            return xp.evaluate((Object)document);
        }
        if (Element.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.element(), null, nameSpaces);
            return xp.evaluate((Object)document);
        }
        return null;
    }

    public <T> List<T> getXpathResult(Element element, String xpath, Class<T> expectedType, Namespace ... nameSpaces) {
        XPathFactory xpfac = XPathFactory.instance();
        if (Attribute.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.attribute(), null, nameSpaces);
            return xp.evaluate((Object)element);
        }
        if (Element.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.element(), null, nameSpaces);
            return xp.evaluate((Object)element);
        }
        return null;
    }

    public Document loadFile(String path) throws Exception {
        Document doc;
        long start = System.currentTimeMillis();
        File file = new File(path);
        SAXBuilder sax = new SAXBuilder();
        try {
            doc = sax.build(file);
        }
        catch (IOException | JDOMException e) {
            if (e instanceof JDOMException) {
                throw new JDOMException("Error occured while parsing file : " + path, e);
            }
            throw e;
        }
        long end = System.currentTimeMillis();
        this.logger.info((Object)("Total time taken to load file :" + path + " : " + (end - start) + " milli seconds"));
        return doc;
    }

    public void printContentsOnConsole(Document doc) throws Exception {
        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
        xout.output(doc, (OutputStream)System.out);
    }

    public void saveFile(Document doc, String outputFilePath, boolean prettyPrintXml) throws Exception {
        this.saveFile(doc, outputFilePath, prettyPrintXml, false);
    }

    public void saveFile(Document doc, String outputFilePath, boolean prettyPrintXml, boolean force) throws Exception {
        XMLOutputter xout = prettyPrintXml ? new XMLOutputter(Format.getPrettyFormat()) : new XMLOutputter();
        File file = new File(outputFilePath);
        if (force && !file.exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                xout.output(doc, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error occured during saving file : " + file), (Throwable)e);
            throw e;
        }
    }

    public void saveFile(Document doc, File outputFile, boolean prettyPrintXml) throws Exception {
        this.saveFile(doc, outputFile, prettyPrintXml, false);
    }

    public void saveFile(Document doc, File outputFile, boolean prettyPrintXml, boolean force) throws Exception {
        XMLOutputter xout = prettyPrintXml ? new XMLOutputter(Format.getPrettyFormat()) : new XMLOutputter();
        if (force && !outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream out = new FileOutputStream(outputFile);){
                xout.output(doc, (OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error occured during saving file : " + outputFile.getAbsolutePath()), (Throwable)e);
            throw e;
        }
    }

    public void removeDefaultAttribs(Element element) {
        element.setNamespace(null);
        element.removeNamespaceDeclaration(Namespace.getNamespace((String)"http://www.omg.org/XMI"));
        element.removeNamespaceDeclaration(Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        element.removeAttribute("version", Namespace.getNamespace((String)"xmi", (String)"http://www.omg.org/XMI"));
    }

    public void buildXMLDocumentsMap(File targetFile, Map<File, Document> map) throws Exception {
        if (map.containsKey(targetFile.getCanonicalFile())) {
            return;
        }
        if (!targetFile.exists()) {
            this.logger.error((Object)("Referred file does not exists : " + targetFile.getAbsolutePath()));
            return;
        }
        if (!Files.getFileExtension((String)targetFile.getAbsolutePath()).contains("amxmi")) {
            this.logger.info((Object)"Non amalthea files will not be considered for model migration");
            return;
        }
        Document xmlDoc = this.loadFile(targetFile.getAbsolutePath());
        map.put(targetFile.getCanonicalFile(), xmlDoc);
        List<Attribute> hrefs = this.getXpathResult(xmlDoc.getRootElement(), ".//@href", Attribute.class, new Namespace[0]);
        HashSet<String> referredFilePaths = new HashSet<String>();
        for (Attribute attribute : hrefs) {
            String value = attribute.getValue();
            if (value.startsWith("amlt:/")) {
                File[] allFilesInDirectory;
                File[] fileArray = allFilesInDirectory = targetFile.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File arg0, String arg1) {
                        return arg1.endsWith(".amxmi");
                    }
                });
                int n = allFilesInDirectory.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.buildXMLDocumentsMap(file, map);
                    ++n2;
                }
                continue;
            }
            int index = value.lastIndexOf("#");
            if (index == -1) continue;
            String fileName = value.substring(0, index);
            referredFilePaths.add(fileName);
        }
        for (String relativePath : referredFilePaths) {
            if (relativePath == null || relativePath.length() <= 0) continue;
            this.buildXMLDocumentsMap(new File(String.valueOf(targetFile.getParent()) + File.separator + relativePath), map);
        }
    }

    public Document getDocument(Map<File, Document> map, String workingDirectory, String relativeFilePath) throws Exception {
        File file = new File(String.valueOf(workingDirectory) + File.separator + relativeFilePath);
        if (file.exists()) {
            return map.get(file.getCanonicalFile());
        }
        return null;
    }

    public HrefElement getHrefElement(String href) {
        int index = href.lastIndexOf("#");
        if (index != -1) {
            String fileName = href.substring(0, index);
            String xmiID = href.substring(index + 1);
            return new HrefElement(fileName, xmiID);
        }
        return null;
    }

    private int getIndexOfElementForURIFragment(Element parent, Element targetElement) {
        List childElements = parent.getContent((Filter)new ElementFilter());
        HashMap map = new HashMap();
        for (Element element : childElements) {
            String tagName = element.getName();
            if (!map.containsKey(tagName)) {
                map.put(tagName, new ArrayList());
            }
            ((List)map.get(tagName)).add(element);
        }
        if (map.containsKey(targetElement.getName())) {
            List list = (List)map.get(targetElement.getName());
            return list.indexOf(targetElement);
        }
        return -1;
    }

    public String getURIFragment(Element element, ModelVersion modelVersion) {
        Stack<Object> stack = new Stack<Object>();
        Element parent = element.getParentElement();
        String uriFragment = "//";
        if (parent != null) {
            int indexOf;
            String elementSuffix = "";
            if (SchemaUtils.isMultiOccuranceElement(element.getName(), modelVersion)) {
                indexOf = this.getIndexOfElementForURIFragment(parent, element);
                elementSuffix = "." + indexOf;
            }
            if (parent.getQualifiedName().equals("xmi:XMI")) {
                indexOf = this.getIndexOfElementForURIFragment(parent, element);
                uriFragment = "/" + indexOf;
            } else {
                stack.push(String.valueOf(element.getName()) + elementSuffix);
                this.populateStack(parent, stack, modelVersion);
            }
        }
        while (!stack.empty()) {
            uriFragment = String.valueOf(uriFragment) + "@" + stack.pop() + "/";
        }
        if (uriFragment.endsWith("/")) {
            uriFragment = uriFragment.substring(0, uriFragment.lastIndexOf("/"));
        }
        return uriFragment;
    }

    private void populateStack(Element element, Stack<Object> st, ModelVersion modelVersion) {
        Element parentElement = element.getParentElement();
        if (parentElement != null) {
            String elementSuffix = "";
            if (SchemaUtils.isMultiOccuranceElement(element.getName(), modelVersion)) {
                int indexOf = this.getIndexOfElementForURIFragment(parentElement, element);
                elementSuffix = "." + indexOf;
            }
            st.push(String.valueOf(element.getName()) + elementSuffix);
            this.populateStack(parentElement, st, modelVersion);
        }
    }

    public String encodeName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = name;
        }
        return result;
    }

    public String decodeName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLDecoder.decode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = name;
        }
        return result;
    }

    public void addCustomProperty(Element parentElement, String key, String value) {
        if (value == null) {
            return;
        }
        Element customPropertiesElement = new Element("customProperties");
        customPropertiesElement.setAttribute("key", key);
        Element valueElement = new Element("value");
        valueElement.setAttribute("type", "am:StringObject", this.getGenericNS("xsi"));
        valueElement.setAttribute("value", value);
        customPropertiesElement.addContent((Content)valueElement);
        parentElement.addContent((Content)customPropertiesElement);
    }

    public String encodeNameForReference(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = name;
        }
        return result;
    }

    public Map<String, String> getMultipleElementsNameandTypeFromAttributeOrChildeElement(String attributeOrTagName, Element element) {
        String attributeValue = element.getAttributeValue(attributeOrTagName);
        if (attributeValue != null) {
            String[] references;
            HashMap<String, String> map = new HashMap<String, String>();
            String[] stringArray = references = attributeValue.split("\\s");
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                String reference = stringArray[n2];
                String name = this.getElementNameFromReference(reference);
                String type = this.getElementTypeFromReference(reference);
                map.put(name, type);
                ++n2;
            }
            return map;
        }
        List children = element.getChildren(attributeOrTagName);
        if (children.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Element child : children) {
                String hrefValue = child.getAttributeValue("href");
                if (hrefValue == null) continue;
                String name = this.getElementNameFromReference(hrefValue);
                String type = this.getElementTypeFromReference(hrefValue);
                map.put(name, type);
            }
            return map;
        }
        return new HashMap<String, String>();
    }

    public Map.Entry<String, String> getSingleElementsNameandTypeFromAttributeOrChildeElement(String attributeOrTagName, Element element) {
        String hrefValue;
        String attributeValue = element.getAttributeValue(attributeOrTagName);
        if (attributeValue != null) {
            String name = this.getElementNameFromReference(attributeValue);
            String type = this.getElementTypeFromReference(attributeValue);
            return new AbstractMap.SimpleEntry<String, String>(name, type);
        }
        Element child = element.getChild(attributeOrTagName);
        if (child != null && (hrefValue = child.getAttributeValue("href")) != null) {
            String name = this.getElementNameFromReference(hrefValue);
            String type = this.getElementTypeFromReference(hrefValue);
            return new AbstractMap.SimpleEntry<String, String>(name, type);
        }
        return null;
    }

    public String getSingleElementNameFromAttributeOrChildeElement(String attributeOrTagName, Element element) {
        String hrefValue;
        String attributeValue = element.getAttributeValue(attributeOrTagName);
        if (attributeValue != null) {
            return this.getElementNameFromReference(attributeValue);
        }
        Element child = element.getChild(attributeOrTagName);
        if (child != null && (hrefValue = child.getAttributeValue("href")) != null) {
            return this.getElementNameFromReference(hrefValue);
        }
        return null;
    }

    public String getElementTypeFromReference(String reference) {
        if (reference == null || reference.length() == 0) {
            return "";
        }
        int startIndex = reference.indexOf("?type=");
        if (startIndex != -1) {
            String type = reference.substring(startIndex + 6);
            return type;
        }
        return reference;
    }

    public String getElementNameFromReference(String reference) {
        if (reference == null || reference.length() == 0) {
            return "";
        }
        int startIndex = reference.indexOf("?type=");
        if (startIndex != -1) {
            String name = reference.substring(0, startIndex);
            if (name.startsWith("amlt:/#")) {
                name = name.replaceFirst("amlt\\:\\/\\#", "");
                return name;
            }
            return name;
        }
        return reference;
    }

    public void copyElement_Attribute_or_Element(Element sourceElement, Element targetElement, String childNodeOrAttributeName) {
        Attribute attribute = sourceElement.getAttribute(childNodeOrAttributeName);
        Element childElement = sourceElement.getChild(childNodeOrAttributeName);
        if (attribute != null) {
            targetElement.setAttribute(attribute.clone());
        } else if (childElement != null) {
            targetElement.setContent((Content)childElement.clone());
        }
    }

    public Element getParentElementWithName(Element currentElement, String parentName) {
        Element parentElement = currentElement.getParentElement();
        if (parentElement != null) {
            if (parentElement.getName().equals(parentName)) {
                return parentElement;
            }
            return this.getParentElementWithName(parentElement, parentName);
        }
        return null;
    }

    public Element getParentElementOfName(Element currentElement, String ... parentNames) {
        Element parentElement = currentElement.getParentElement();
        if (parentElement != null) {
            boolean contains = Arrays.stream(parentNames).anyMatch(parentElement.getName()::equals);
            if (contains) {
                return parentElement;
            }
            return this.getParentElementOfName(parentElement, parentNames);
        }
        return null;
    }

    public String getValueFromChildElement(Element element, String childElementName, String childElementAttributeName) {
        Element child = element.getChild(childElementName);
        if (child != null) {
            return child.getAttributeValue(childElementAttributeName);
        }
        return null;
    }
}

