/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaCrossReferenceAdapter;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;

public final class AmaltheaIndex {
    private static final String ARG_OBJECT_MESSAGE = "Object argument is null, expected: EObject";
    private static final String ARG_COLLECTION_MESSAGE = "Collection argument is null,  expected: Collection<? extends EObject>";
    private static final String ARG_NOTIFIER_MESSAGE = "Context argument is null, expected: Notifier";
    private static final String ARG_NAME_MESSAGE = "Name argument is null, expected: String";
    private static final String ARG_PATTERN_MESSAGE = "Pattern argument is null, expected: Pattern";
    private static final String ARG_CLASS_MESSAGE = "Class argument is null, expected: Class<T extends INamed>";
    private static final String ARG_RESULT_REFERENCE_MESSAGE = "Result reference argument is null, expected: EReference";
    private static final String ARG_TARGET_REFERENCES_MESSAGE = "Target references argument is null, expected: Set<EReference>";

    private AmaltheaIndex() {
    }

    public static <T> EList<T> getInverseReferences(@NonNull EObject eObject, @NonNull EReference resultEReference, @NonNull Set<@NonNull EReference> targetEReferences) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        Preconditions.checkArgument((resultEReference != null ? 1 : 0) != 0, (Object)ARG_RESULT_REFERENCE_MESSAGE);
        Preconditions.checkArgument((targetEReferences != null ? 1 : 0) != 0, (Object)ARG_TARGET_REFERENCES_MESSAGE);
        AmaltheaCrossReferenceAdapter amaltheaAdapter = AmaltheaIndex.getOrCreateAmaltheaAdapter(eObject);
        ArrayList<EObject> result = new ArrayList<EObject>();
        Collection nonNavigableInverseReferences = amaltheaAdapter.getNonNavigableInverseReferences(eObject);
        for (EStructuralFeature.Setting setting : nonNavigableInverseReferences) {
            if (!targetEReferences.contains(setting.getEStructuralFeature())) continue;
            EObject targetEObject = setting.getEObject();
            result.add(targetEObject);
        }
        int size = result.size();
        Object[] values = result.toArray();
        return new EcoreEList.UnmodifiableEList((InternalEObject)eObject, (EStructuralFeature)resultEReference, size, values);
    }

    public static void delete(@NonNull EObject eObject) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(eObject);
        AmaltheaIndex.deleteAll(list, true);
    }

    public static void deleteAll(@NonNull Collection<? extends EObject> eObjects) {
        Preconditions.checkArgument((eObjects != null ? 1 : 0) != 0, (Object)ARG_COLLECTION_MESSAGE);
        AmaltheaIndex.deleteAll(eObjects, true);
    }

    public static void deleteAll(@NonNull Collection<? extends EObject> eObjects, boolean recursive) {
        Preconditions.checkArgument((eObjects != null ? 1 : 0) != 0, (Object)ARG_COLLECTION_MESSAGE);
        Set<@NonNull T> objectsToDelete = eObjects.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Notifier target = null;
        for (EObject eObject : objectsToDelete) {
            Notifier notifier = AmaltheaIndex.getRootContext(eObject);
            if (target == null) {
                target = notifier;
                continue;
            }
            if (target == notifier) continue;
            throw new IllegalArgumentException("Objects don't share a common context");
        }
        if (target == null) {
            return;
        }
        HashSet<Object> eAllObjects = new HashSet<Object>();
        if (recursive) {
            for (EObject eObject : objectsToDelete) {
                TreeIterator j = eObject.eAllContents();
                while (j.hasNext()) {
                    InternalEObject childEObject = (InternalEObject)j.next();
                    eAllObjects.add(childEObject);
                }
            }
        }
        eAllObjects.addAll(objectsToDelete);
        AmaltheaCrossReferenceAdapter amaltheaAdapter = AmaltheaIndex.getOrCreateAmaltheaAdapter(target);
        for (EObject eObject : eAllObjects) {
            Collection inverseReferences = amaltheaAdapter.getInverseReferences(eObject);
            for (EStructuralFeature.Setting settingObject : inverseReferences) {
                if (!settingObject.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)settingObject, (Object)eObject);
            }
            EcoreUtil.remove((EObject)eObject);
        }
    }

    public static <T extends INamed> Set<? extends T> getElements(@NonNull Notifier context, @NonNull String name, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)ARG_NAME_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        Notifier rootContext = AmaltheaIndex.getRootContext(context);
        @NonNull Set<@NonNull T> elements = AmaltheaIndex.getOrCreateAmaltheaAdapter(rootContext).getElements(name, targetClass);
        Resource resource = AmaltheaIndex.getResource(context);
        if (rootContext instanceof ResourceSet && resource != null) {
            URI folderUri = resource.getURI().trimSegments(1);
            return elements.stream().filter(e -> e.eResource().getURI().trimSegments(1).equals(folderUri)).collect(Collectors.toSet());
        }
        return elements;
    }

    public static <T extends INamed> Set<? extends T> getElements(@NonNull Notifier context, @NonNull Pattern namePattern, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        Preconditions.checkArgument((namePattern != null ? 1 : 0) != 0, (Object)ARG_PATTERN_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        Notifier rootContext = AmaltheaIndex.getRootContext(context);
        @NonNull Set<@NonNull T> elements = AmaltheaIndex.getOrCreateAmaltheaAdapter(rootContext).getElements(namePattern, targetClass);
        Resource resource = AmaltheaIndex.getResource(context);
        if (rootContext instanceof ResourceSet && resource != null) {
            URI folderUri = resource.getURI().trimSegments(1);
            return elements.stream().filter(e -> e.eResource().getURI().trimSegments(1).equals(folderUri)).collect(Collectors.toSet());
        }
        return elements;
    }

    private static @NonNull AmaltheaCrossReferenceAdapter getOrCreateAmaltheaAdapter(@NonNull EObject eObject) {
        Notifier target = AmaltheaIndex.getRootContext(eObject);
        return AmaltheaIndex.getOrCreateAmaltheaAdapter(target);
    }

    private static synchronized @NonNull AmaltheaCrossReferenceAdapter getOrCreateAmaltheaAdapter(@NonNull Notifier target) {
        EList adapters = target.eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof AmaltheaCrossReferenceAdapter)) continue;
            return (AmaltheaCrossReferenceAdapter)adapter;
        }
        AmaltheaCrossReferenceAdapter amaltheaAdapter = new AmaltheaCrossReferenceAdapter();
        adapters.add((Object)amaltheaAdapter);
        return amaltheaAdapter;
    }

    private static @NonNull Notifier getRootContext(@NonNull EObject eObject) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObject);
        Resource resource = rootContainer.eResource();
        if (resource != null) {
            return AmaltheaIndex.getRootContext(resource);
        }
        return rootContainer;
    }

    private static @NonNull Notifier getRootContext(@NonNull Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet != null) {
            return resourceSet;
        }
        return resource;
    }

    private static @NonNull Notifier getRootContext(@NonNull Notifier notifier) {
        if (notifier instanceof EObject) {
            return AmaltheaIndex.getRootContext((EObject)notifier);
        }
        if (notifier instanceof Resource) {
            return AmaltheaIndex.getRootContext((Resource)notifier);
        }
        return notifier;
    }

    private static Resource getResource(Notifier notifier) {
        if (notifier instanceof EObject) {
            return ((EObject)notifier).eResource();
        }
        if (notifier instanceof Resource) {
            return (Resource)notifier;
        }
        return null;
    }
}

